/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.Serializable;

class ClockHand
implements Serializable {
    protected int bodyLength;
    protected int bodyWidth;
    protected int arrowHeadLength;
    protected int arrowHeadWidth;
    protected int locX;
    protected int locY;
    protected Polygon hand;
    protected double degreesToRotate;

    public ClockHand(int x, int y, int blength, int bwidth, int alength, int awidth) {
        this.locX = x;
        this.locY = y;
        this.bodyLength = blength;
        this.bodyWidth = bwidth;
        this.arrowHeadLength = alength;
        this.arrowHeadWidth = awidth;
        this.degreesToRotate = 0.0;
        this.createPolygon();
    }

    protected void createPolygon() {
        this.hand = new Polygon();
        this.hand.addPoint((int)((double)this.locX + (double)this.bodyWidth / 2.0), this.locY);
        this.hand.addPoint((int)((double)this.locX - (double)this.bodyWidth / 2.0), this.locY);
        this.hand.addPoint((int)((double)this.locX - (double)this.bodyWidth / 2.0), this.locY - this.bodyLength);
        this.hand.addPoint((int)((double)this.locX - (double)this.arrowHeadWidth / 2.0), this.locY - this.bodyLength);
        this.hand.addPoint(this.locX, this.locY - this.bodyLength - this.arrowHeadLength);
        this.hand.addPoint((int)((double)this.locX + (double)this.arrowHeadWidth / 2.0), this.locY - this.bodyLength);
        this.hand.addPoint((int)((double)this.locX + (double)this.bodyWidth / 2.0), this.locY - this.bodyLength);
    }

    public void draw(Graphics g) {
        Polygon p = new Polygon();
        double[] cord = new double[6];
        PathIterator path = this.hand.getPathIterator(AffineTransform.getRotateInstance(Math.toRadians(this.degreesToRotate), this.locX, this.locY));
        while (!path.isDone() && path.currentSegment(cord) != 4) {
            p.addPoint((int)cord[0], (int)cord[1]);
            path.next();
        }
        g.fillPolygon(p);
    }

    public void setDegreesToRotate(double degrees) {
        this.degreesToRotate = degrees;
    }
}

