/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditListItemDialog;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import pact.CommWidgets.JCommWidget;

public class JCommChooser
extends JCommWidget
implements ActionListener,
MouseListener {
    protected JList leftList = new JList();
    protected JList rightList;
    protected JScrollPane leftScrollPane;
    protected JScrollPane rightScrollPane;
    protected String newValue;
    protected Vector initialListStrings;
    protected Vector listStringsStatus;
    protected Vector listStringsColor;
    protected Vector listStringIds;
    protected int sizeOfInitialListStrings;
    protected int sizeOfLeftList;
    protected int sizeOfRightList;
    protected String LEFTSIDE = "Left";
    protected String RIGHTSIDE = "Right";
    protected Vector leftListIds;
    protected Vector rightListIds;
    protected int valueIndex;
    protected JButton toRightButton;
    protected Font startFont;
    protected boolean locked;
    protected boolean objectsAdded = false;
    protected Dimension widgetDimension;
    protected Rectangle currentRectangle;

    public JCommChooser() {
        this.leftList.addMouseListener(this);
        this.leftScrollPane = new JScrollPane(this.leftList);
        this.toRightButton = new JButton(">>");
        this.rightList = new JList();
        this.rightScrollPane = new JScrollPane(this.rightList);
        this.leftList.setCellRenderer(new MyCellRenderer());
        this.rightList.setCellRenderer(new MyCellRenderer());
        this.initialListStrings = new Vector();
        this.listStringsStatus = new Vector();
        this.listStringsColor = new Vector();
        this.listStringIds = new Vector();
        this.actionName = "UpdateChooser";
        this.backgroundNormalColor = this.leftList.getBackground();
        DefaultListModel m = new DefaultListModel();
        this.leftList.setModel(m);
        m = new DefaultListModel();
        this.rightList.setModel(m);
        this.toRightButton.addActionListener(this);
        this.widgetDimension = new Dimension(350, 120);
        this.setSize(this.widgetDimension);
        this.locked = false;
        this.addFocusListener(this);
    }

    @Override
    public Dimension getSize() {
        return this.widgetDimension;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.createWidget();
    }

    @Override
    public void setSize(Dimension d) {
        if (d.width == 0 || d.height == 0) {
            return;
        }
        trace.out(5, this, "setSize() is called");
        trace.out(5, this, "d = " + d.toString());
        super.setSize(d);
        this.createWidget();
    }

    private void createWidget() {
        Rectangle bounds = this.getBounds();
        Dimension d = this.widgetDimension = bounds.getSize();
        trace.out(5, this, "widgetDimension = " + this.widgetDimension.toString());
        int spacing = 6;
        this.setLayout(null);
        if (!this.objectsAdded) {
            this.objectsAdded = true;
            this.add(this.leftScrollPane);
            this.add(this.toRightButton);
            this.add(this.rightScrollPane);
        }
        this.leftScrollPane.setSize(2 * d.width / spacing, d.height);
        this.leftScrollPane.setPreferredSize(new Dimension(2 * d.width / spacing, d.height));
        this.rightScrollPane.setSize(2 * d.width / spacing, d.height);
        this.rightScrollPane.setPreferredSize(new Dimension(2 * d.width / spacing, d.height));
        int buttonWidth = Math.min(50, d.width / spacing - 10);
        this.toRightButton.setSize(buttonWidth, 20);
        this.leftScrollPane.setLocation(0, 0);
        this.leftScrollPane.setVisible(true);
        this.toRightButton.setLocation(2 * d.width / spacing + (d.width / spacing - buttonWidth) / 2, d.height / 2 - 10);
        this.toRightButton.setVisible(true);
        this.rightScrollPane.setLocation(3 * d.width / spacing, 0);
        this.rightScrollPane.setVisible(true);
        this.setVisible(true);
        this.validate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selectedItem;
        this.removeHighlight("");
        if (e.getSource() == this.toRightButton && !this.locked && (selectedItem = (String)this.leftList.getSelectedValue()) != null) {
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "JCChooser.actionPerformed(" + e.paramString() + "): isDefiningStartState() " + this.getController().isDefiningStartState());
            }
            this.newValue = selectedItem;
            if (this.getController().isDefiningStartState()) {
                this.doInterfaceAction("", "UpdateChooser", selectedItem);
            } else {
                this.locked = true;
            }
            this.dirty = true;
            this.sendValue();
        }
    }

    public void setValues(String values) {
        StringTokenizer st = new StringTokenizer(values, ",");
        this.initialListStrings = new Vector();
        this.listStringsStatus = new Vector();
        this.listStringsColor = new Vector();
        this.listStringIds = new Vector();
        this.sizeOfInitialListStrings = 0;
        while (st.hasMoreElements()) {
            String itemString = (String)st.nextElement();
            if (itemString == null || (itemString = itemString.trim()).length() <= 0) continue;
            this.initialListStrings.addElement(itemString);
            this.listStringsStatus.addElement(this.LEFTSIDE);
            this.listStringsColor.addElement(this.startColor);
            this.listStringIds.addElement(new Integer(this.sizeOfInitialListStrings));
            ++this.sizeOfInitialListStrings;
        }
        this.setListsStrings();
    }

    public String getValues() {
        String initialListValuesString = "";
        if (this.sizeOfInitialListStrings > 0) {
            initialListValuesString = (String)this.initialListStrings.elementAt(0);
            if (this.sizeOfInitialListStrings > 1) {
                for (int i = 1; i < this.sizeOfInitialListStrings; ++i) {
                    initialListValuesString = initialListValuesString + "," + (String)this.initialListStrings.elementAt(i);
                }
            }
        }
        return initialListValuesString;
    }

    @Override
    public void setFont(Font f) {
        if (f != null) {
            this.startFont = f;
            super.setFont(f);
        } else {
            this.startFont = super.getFont();
        }
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public void setFocus(String subWidgetName) {
        this.leftList.requestFocus();
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setProperty("WidgetType", "JCommChooser");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        mo.setProperty("ChooserItems", this.getValues());
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate chooser (slot name) (slot value) (multislot left-values) (multislot right-values))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String valuesStr = "";
        for (int i = 0; i < this.initialListStrings.size(); ++i) {
            valuesStr = valuesStr + " \"" + this.initialListStrings.elementAt(i) + "\"";
        }
        String instanceStr = "(assert (chooser (name " + this.commName + ") (left-values " + valuesStr + ")))";
        instances.add(instanceStr);
        return instances;
    }

    void setValueLeftStatus(String value, Color setColor) {
        String tempItem;
        int i;
        for (i = 0; i < this.sizeOfInitialListStrings; ++i) {
            tempItem = (String)this.initialListStrings.elementAt(i);
            if (!tempItem.equals(value)) continue;
            this.listStringsStatus.setElementAt(this.LEFTSIDE, i);
            this.listStringsColor.setElementAt(setColor, i);
            this.valueIndex = i;
            break;
        }
        if (i == this.sizeOfInitialListStrings) {
            trace.out(5, this, "value = " + value + " is not in the original list.");
        } else {
            boolean tryAddFlag = true;
            for (i = 0; i < this.sizeOfLeftList && tryAddFlag; ++i) {
                Integer tempInteger = (Integer)this.leftListIds.elementAt(i);
                if (this.valueIndex == tempInteger) {
                    this.leftList.repaint();
                    tryAddFlag = false;
                    continue;
                }
                if (this.valueIndex >= tempInteger) continue;
                ((DefaultListModel)this.leftList.getModel()).insertElementAt(value, i);
                this.leftListIds.insertElementAt(new Integer(this.valueIndex), i);
                ++this.sizeOfLeftList;
                for (int j = 0; j < this.sizeOfLeftList; ++j) {
                }
                tryAddFlag = false;
            }
            if (tryAddFlag) {
                ((DefaultListModel)this.leftList.getModel()).addElement(value);
                this.leftListIds.addElement(new Integer(this.valueIndex));
                ++this.sizeOfLeftList;
            }
        }
        boolean flagUpdateList = true;
        for (i = 0; i < this.sizeOfLeftList; ++i) {
            tempItem = (String)((DefaultListModel)this.leftList.getModel()).elementAt(i);
            if (!tempItem.equals(value)) continue;
            flagUpdateList = false;
            break;
        }
        if (flagUpdateList) {
            this.setListsStrings();
        } else {
            this.leftList.repaint();
        }
    }

    void setValueRightStatus(String value, Color setColor) {
        this.doInterfaceAction("", "", value);
    }

    @Override
    public void doInterfaceDescription(MessageObject mo) {
        super.doInterfaceDescription(mo);
        Object chooserItems = mo.getProperty("ChooserItems");
        if (!(chooserItems instanceof String)) {
            return;
        }
        this.setValues(chooserItems.toString());
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        this.doCorrectOrInterfaceAction(selection, action, input, this.correctColor);
    }

    private void doCorrectOrInterfaceAction(String selection, String action, String input, Color rightSideColor) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            String tempItem;
            int i;
            boolean findFlag = false;
            for (i = 0; i < this.sizeOfInitialListStrings; ++i) {
                tempItem = (String)this.initialListStrings.elementAt(i);
                if (!tempItem.equals(input)) continue;
                this.listStringsStatus.setElementAt(this.RIGHTSIDE, i);
                this.listStringsColor.setElementAt(rightSideColor, i);
                findFlag = true;
                break;
            }
            if (!findFlag) {
                trace.out(5, "doCorrectAction in Chooser", input + " is not in the original list");
                this.locked = false;
                return;
            }
            for (i = 0; i < this.sizeOfLeftList; ++i) {
                tempItem = (String)((DefaultListModel)this.leftList.getModel()).getElementAt(i);
                if (!tempItem.equals(input)) continue;
                ((DefaultListModel)this.leftList.getModel()).removeElementAt(i);
                --this.sizeOfLeftList;
                ((DefaultListModel)this.rightList.getModel()).addElement(input);
                ++this.sizeOfRightList;
                break;
            }
            this.locked = false;
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        for (int i = 0; i < this.sizeOfInitialListStrings; ++i) {
            String tempItem = (String)this.initialListStrings.elementAt(i);
            if (!tempItem.equals(input)) continue;
            this.listStringsColor.setElementAt(this.LISPCheckColor, i);
            break;
        }
        this.leftList.repaint();
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        for (int i = 0; i < this.sizeOfInitialListStrings; ++i) {
            String tempItem = (String)this.initialListStrings.elementAt(i);
            if (!tempItem.equals(input)) continue;
            this.listStringsColor.setElementAt(this.incorrectColor, i);
            break;
        }
        this.leftList.repaint();
        this.locked = false;
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        boolean findFlag = false;
        String tempItem = "";
        if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
            return;
        }
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
            return;
        }
        if ("UpdateChooser".equalsIgnoreCase(action)) {
            this.doCorrectOrInterfaceAction(selection, action, input, this.startColor);
        }
    }

    public void setProperty(MessageObject o) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.leftList.clearSelection();
        this.leftList.repaint();
        this.rightList.clearSelection();
        this.rightList.repaint();
        super.focusLost(e);
    }

    @Override
    public Object getValue() {
        if (this.getActionName().equalsIgnoreCase("UpdateInVisible")) {
            return this.isVisible();
        }
        return this.newValue;
    }

    public String getText() {
        return "";
    }

    public void setText(String text) {
    }

    public Vector getCurrentState() {
        Vector<MessageObject> v = new Vector<MessageObject>();
        if (this.getController().isStartStateModified()) {
            v.addElement(this.getCurrentStateMessage());
        } else {
            for (int i = 0; i < this.sizeOfInitialListStrings; ++i) {
                String tempStatus = (String)this.listStringsStatus.elementAt(i);
                if (!tempStatus.equals(this.RIGHTSIDE)) continue;
                this.newValue = (String)this.initialListStrings.elementAt(i);
                v.addElement(this.getCurrentStateMessage());
            }
        }
        return v;
    }

    @Override
    public boolean isChangedFromResetState() {
        boolean changedFlag = false;
        if (this.getController().isStartStateModified()) {
            changedFlag = true;
            return changedFlag;
        }
        for (int i = 0; i < this.sizeOfInitialListStrings; ++i) {
            String tempStatus = (String)this.listStringsStatus.elementAt(i);
            if (!tempStatus.equals(this.RIGHTSIDE)) continue;
            changedFlag = true;
            break;
        }
        return changedFlag;
    }

    void setListsStrings() {
        if (this.sizeOfLeftList != 0) {
            ((DefaultListModel)this.leftList.getModel()).removeAllElements();
        }
        if (this.sizeOfRightList != 0) {
            ((DefaultListModel)this.rightList.getModel()).removeAllElements();
        }
        this.sizeOfLeftList = 0;
        this.sizeOfRightList = 0;
        for (int i = 0; i < this.sizeOfInitialListStrings; ++i) {
            String tempItem = (String)this.initialListStrings.elementAt(i);
            String tempStatus = (String)this.listStringsStatus.elementAt(i);
            if (tempStatus.equals(this.LEFTSIDE)) {
                ((DefaultListModel)this.leftList.getModel()).addElement(tempItem);
                ++this.sizeOfLeftList;
                continue;
            }
            ((DefaultListModel)this.rightList.getModel()).addElement(tempItem);
            ++this.sizeOfRightList;
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize(controller);
        for (int i = 0; i < this.sizeOfInitialListStrings; ++i) {
            this.listStringsStatus.setElementAt(this.LEFTSIDE, i);
            this.listStringsColor.setElementAt(this.startColor, i);
        }
        this.setListsStrings();
        this.locked = false;
    }

    @Override
    public boolean getLock(String selection) {
        return this.sizeOfLeftList == this.sizeOfInitialListStrings;
    }

    @Override
    public void setBackground(Color c) {
        if (this.leftList != null) {
            this.leftList.setBackground(c);
        }
        if (this.rightList != null) {
            this.rightList.setBackground(c);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isControlDown() && this.getController().isDefiningStartState()) {
            JFrame frame = new JFrame("Edit List Items");
            String[] items = new String[this.sizeOfLeftList];
            for (int i = 0; i < this.sizeOfLeftList; ++i) {
                items[i] = (String)((DefaultListModel)this.leftList.getModel()).elementAt(i);
            }
            String title = "Please set the Values for widget " + this.commName + " : ";
            EditListItemDialog t = new EditListItemDialog(frame, title, true, items, this.isInvisible());
            ((DefaultListModel)this.leftList.getModel()).removeAllElements();
            String tempItem = "";
            String tempValues = "";
            for (int i = 0; i < t.getList().getModel().getSize(); ++i) {
                tempItem = (String)t.getList().getModel().getElementAt(i);
                ((DefaultListModel)this.leftList.getModel()).addElement(tempItem);
                tempItem = tempItem.trim();
                if (tempItem.equals("")) continue;
                tempValues = tempValues.equals("") ? tempItem : tempValues + "," + tempItem;
            }
            this.dirty = true;
            this.setValues(tempValues);
            this.sendValue();
            if (this.isInvisible() != t.isInvisible()) {
                this.setInvisible(t.isInvisible());
                this.setVisible(!this.isInvisible());
                this.dirty = true;
                this.setActionName("UpdateInVisible");
                this.sendValue();
            }
            this.setActionName("UpdateChooser");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String valueString = value.toString();
            this.setText(valueString);
            this.setBackground(isSelected ? Color.lightGray : Color.white);
            for (int i = 0; i < JCommChooser.this.sizeOfInitialListStrings; ++i) {
                String tempItem = (String)JCommChooser.this.initialListStrings.elementAt(i);
                if (!tempItem.equals(valueString)) continue;
                Color cellColor = (Color)JCommChooser.this.listStringsColor.elementAt(i);
                if (cellColor == JCommChooser.this.startColor) {
                    this.setFont(JCommChooser.this.startFont);
                } else if (cellColor == JCommChooser.this.correctColor) {
                    if (JCommChooser.this.correctFont != null) {
                        this.setFont(JCommChooser.this.correctFont);
                    } else {
                        this.setFont(JCommChooser.this.startFont);
                    }
                } else if (JCommChooser.this.correctFont != null) {
                    this.setFont(JCommChooser.this.incorrectFont);
                } else {
                    this.setFont(JCommChooser.this.startFont);
                }
                this.setForeground(cellColor);
                break;
            }
            return this;
        }
    }
}

