/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditListItemDialog;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import pact.CommWidgets.JCommWidget;

public class JCommList
extends JCommWidget {
    public static final String UpdateList = "UpdateList";
    private static final String UPDATE_INVISIBLE = "UpdateInVisible";
    protected JList list;
    protected JScrollPane scrollPane;
    protected String previousValue = "";
    protected String resetValue = "";
    protected String values = "";
    protected String newValue = "";
    protected Vector listStrings;
    protected Vector listStringColors;
    protected int sizeOfListStrings;
    protected Font startFont;
    protected JPanel container;
    protected Vector selectedList = new Vector();

    public JCommList() {
        this.list = new JList();
        this.scrollPane = new JScrollPane(this.list);
        this.add(this.scrollPane);
        GridLayout g = new GridLayout(1, 1);
        this.setLayout(g);
        this.setActionName(UpdateList);
        this.backgroundNormalColor = this.list.getBackground();
        DefaultListModel m = new DefaultListModel();
        this.list.setModel(m);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JCommList.this.newValue = (String)JCommList.this.list.getSelectedValue();
                    JCommList.this.dirty = !JCommList.this.isAlreadySelected(JCommList.this.newValue);
                    JCommList.this.sendValue();
                    JCommList.this.list.clearSelection();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (trace.getDebugCode("dw")) {
                    trace.out("dw", "Enter ModifyListsListener mousePressed");
                }
                if (e.isControlDown() && JCommList.this.getController().isDefiningStartState() && JCommList.this.list.getModel().getSize() > 0) {
                    int i;
                    JFrame frame = new JFrame("Modify List Items");
                    String[] items = new String[JCommList.this.list.getModel().getSize()];
                    for (int i2 = 0; i2 < JCommList.this.list.getModel().getSize(); ++i2) {
                        items[i2] = (String)JCommList.this.list.getModel().getElementAt(i2);
                        if (!trace.getDebugCode("dw")) continue;
                        trace.out("dw", "items[" + i2 + "] =" + items[i2]);
                    }
                    String title = "Please set the Values for widget " + JCommList.this.commName + " : ";
                    EditListItemDialog t = new EditListItemDialog(frame, title, true, items, JCommList.this.isInvisible());
                    JCommList.this.values = "";
                    for (i = 0; i < t.getList().getModel().getSize(); ++i) {
                        String tempItem = (String)t.getList().getModel().getElementAt(i);
                        if ((tempItem = tempItem.trim()).equals("")) continue;
                        JCommList.this.values = JCommList.this.values.equals(JCommList.this.resetValue) ? tempItem : JCommList.this.values + "," + tempItem;
                    }
                    JCommList.this.dirty = true;
                    JCommList.this.setValues(JCommList.this.values);
                    JCommList.this.getUniversalToolProxy().sendMessage(JCommList.this.getDescriptionMessage());
                    JCommList.this.sendValue();
                    for (i = 0; i < JCommList.this.list.getModel().getSize(); ++i) {
                        if (!trace.getDebugCode("dw")) continue;
                        trace.out("dw", "AfterModified --- List[" + i + "] =" + JCommList.this.list.getModel().getElementAt(i));
                    }
                    if (JCommList.this.isInvisible() != t.isInvisible()) {
                        JCommList.this.setInvisible(t.isInvisible());
                        JCommList.this.setVisible(!JCommList.this.isInvisible());
                        JCommList.this.dirty = true;
                        JCommList.this.setActionName(JCommList.UPDATE_INVISIBLE);
                        JCommList.this.sendValue();
                    }
                    JCommList.this.setActionName(JCommList.UpdateList);
                }
            }
        });
        this.addFocusListener(this);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.list != null) {
            this.list.addMouseListener(l);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        if (this.list != null) {
            this.list.addMouseMotionListener(l);
        }
    }

    @Override
    public MouseListener[] getMouseListeners() {
        if (this.list != null) {
            return this.list.getMouseListeners();
        }
        return null;
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        if (this.list != null) {
            return this.list.getMouseMotionListeners();
        }
        return null;
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        if (this.list != null) {
            this.list.removeMouseMotionListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.list != null) {
            this.list.removeMouseListener(l);
        }
    }

    public void setValues(String values) {
        trace.out(5, this, "values: " + values);
        this.values = values;
        int sizeOfList = this.list.getModel().getSize();
        if (sizeOfList != 0) {
            ((DefaultListModel)this.list.getModel()).removeAllElements();
        }
        this.list.setCellRenderer(new MyCellRenderer());
        this.listStrings = new Vector();
        this.listStringColors = new Vector();
        this.sizeOfListStrings = 0;
        StringTokenizer st = new StringTokenizer(values, ",");
        trace.out(5, this, "start construct list");
        while (st.hasMoreElements()) {
            String tempString = (String)st.nextElement();
            if (tempString == null || (tempString = tempString.trim()).equals("")) continue;
            ((DefaultListModel)this.list.getModel()).addElement(tempString);
            this.listStrings.addElement(tempString);
            this.listStringColors.addElement(this.startColor);
            ++this.sizeOfListStrings;
        }
        trace.out(5, this, "construct list done");
    }

    public void removeSelectedIndex() {
        ((DefaultListModel)this.list.getModel()).remove(this.list.getSelectedIndex());
    }

    @Override
    public void setFont(Font f) {
        this.startFont = f != null ? f : super.getFont();
        super.setFont(this.startFont);
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setProperty("WidgetType", "JCommList");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        mo.setProperty("Values", this.getValues());
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate list (slot name) (slot value) (multislot values))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String valuesStr = "";
        if (this.values != null) {
            valuesStr = "";
            StringTokenizer st = new StringTokenizer(this.values, ",");
            while (st.hasMoreTokens()) {
                valuesStr = valuesStr + " \"" + st.nextToken() + "\"";
            }
        }
        String instanceStr = "(assert (list (name " + this.commName + ") (values " + valuesStr + ")))";
        instances.add(instanceStr);
        return instances;
    }

    public String getValues() {
        return this.values;
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.list.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.list.setBorder(this.originalBorder);
    }

    @Override
    public boolean getLock(String selection) {
        return false;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.setValueColor(input, this.correctColor);
            this.setSelectedList(input);
            if (this.getUniversalToolProxy().lockWidget()) {
                this.locked = true;
            }
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.setValueColor(input, this.LISPCheckColor);
        if (this.getUniversalToolProxy().lockWidget()) {
            this.locked = true;
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.setValueColor(input, this.incorrectColor);
        this.locked = false;
    }

    private void setValueColor(String value, Color setColor) {
        for (int i = 0; i < this.sizeOfListStrings; ++i) {
            String tempItem = (String)this.listStrings.elementAt(i);
            if (!tempItem.equals(value)) continue;
            this.listStringColors.setElementAt(setColor, i);
            break;
        }
        this.list.repaint();
    }

    @Override
    public void doInterfaceDescription(MessageObject messageObject) {
        super.doInterfaceDescription(messageObject);
        Object prop = messageObject.getProperty("Values");
        if (prop != null) {
            this.setValues(prop.toString());
        }
        this.selectedList.clear();
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        this.setValueColor(input, this.startColor);
        if (action.equalsIgnoreCase(UpdateList)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "UpdateList: " + this.values);
            }
            this.setText(input);
            this.setValues(input);
        } else if (action.equalsIgnoreCase(UPDATE_INVISIBLE)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        } else if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        }
    }

    public void setProperty(MessageObject o) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.list.clearSelection();
        this.list.repaint();
        super.focusLost(e);
    }

    @Override
    public Object getValue() {
        if (this.getActionName().equalsIgnoreCase(UPDATE_INVISIBLE)) {
            return this.isVisible();
        }
        if (this.list.getSelectedIndex() == -1) {
            return this.values;
        }
        return this.newValue;
    }

    public String getText() {
        return "";
    }

    public void setText(String text) {
    }

    @Override
    public boolean isChangedFromResetState() {
        trace.out("mps", "!!! COMM LIST: selectedIndex = " + this.list.getSelectedIndex());
        if (this.getController().isDefiningStartState()) {
            return true;
        }
        return this.list.getSelectedIndex() != -1;
    }

    @Override
    public void reset(TutorController controller) {
        trace.out(5, this, "list here");
        this.initialize(controller);
        this.locked = false;
        for (int i = 0; i < this.sizeOfListStrings; ++i) {
            this.listStringColors.setElementAt(this.startColor, i);
        }
        this.list.setForeground(this.startColor);
        this.list.removeSelectionInterval(0, this.sizeOfListStrings);
        this.list.repaint();
    }

    @Override
    public void setBackground(Color c) {
        if (this.list != null) {
            this.list.setBackground(c);
        }
    }

    public Vector getSelectedList() {
        return this.selectedList;
    }

    public void setSelectedList(String value) {
        this.selectedList.addElement(value);
    }

    public boolean isAlreadySelected(String value) {
        for (int index = 0; index < this.selectedList.size(); ++index) {
            if (this.selectedList.elementAt(index) != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setBackground(isSelected ? Color.lightGray : Color.white);
            for (int i = 0; i < JCommList.this.sizeOfListStrings; ++i) {
                String tempItem = (String)JCommList.this.listStrings.elementAt(i);
                if (!tempItem.equals(value.toString())) continue;
                Color cellColor = (Color)JCommList.this.listStringColors.elementAt(i);
                if (cellColor == JCommList.this.startColor) {
                    this.setFont(JCommList.this.startFont);
                } else if (cellColor == JCommList.this.correctColor) {
                    if (JCommList.this.correctFont != null) {
                        this.setFont(JCommList.this.correctFont);
                    } else {
                        this.setFont(JCommList.this.startFont);
                    }
                } else if (JCommList.this.correctFont != null) {
                    this.setFont(JCommList.this.incorrectFont);
                } else {
                    this.setFont(JCommList.this.startFont);
                }
                this.setForeground(cellColor);
                break;
            }
            return this;
        }
    }
}

