/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import pact.CommWidgets.JCommButton;
import pact.CommWidgets.JCommQuestion;
import pact.CommWidgets.JCommQuestionComboBox;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.event.HelpEvent;
import pact.CommWidgets.event.HelpEventListener;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.ProblemDoneEvent;
import pact.CommWidgets.event.ProblemDoneListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public class JCommPanel
extends JCommWidget
implements ContainerListener,
StudentActionListener,
IncorrectActionListener,
HelpEventListener,
ProblemDoneListener {
    private static int DEFAULT = 1;
    private static int SPECIFIED = 2;
    private int dialogOrder = DEFAULT;
    private static int NODIALOG = -1;
    private int currentComponentNumber = 1;
    private static int counter = 0;
    private boolean dfaPanel = false;
    private JCommButton hintBtn;
    private JCommQuestion currentCommQuestion;

    public JCommPanel() {
        this.setActionName("UpdatePanel");
        this.addContainerListener(this);
    }

    private void setComponentVisible(Component component, boolean b) {
        component.setVisible(b);
        if (b && component instanceof JCommQuestion) {
            this.currentCommQuestion = (JCommQuestion)component;
        }
        if (b) {
            component.requestFocus();
        }
    }

    private void showFirstQuestionComponent() {
        Component component;
        this.addHelpListeners();
        this.addDoneListeners();
        if (this.dialogOrder == DEFAULT) {
            Component component2;
            int i;
            this.currentComponentNumber = 1;
            Component[] components = this.getComponents();
            for (i = 0; i < this.getComponentCount(); ++i) {
                component2 = components[i];
                this.setComponentVisible(component2, true);
                if (!(component2 instanceof JCommQuestion)) continue;
                if (((JCommQuestion)component2).isOriginalQuestion()) {
                    this.getController().getStudentInterface().getHintInterface().setDisplayHint(false);
                    break;
                }
                this.getController().getStudentInterface().getHintInterface().setDisplayHint(true);
                break;
            }
            ++i;
            while (i < this.getComponentCount()) {
                component2 = components[i];
                this.setComponentVisible(component2, false);
                ++i;
            }
        } else if (this.dialogOrder == SPECIFIED && (component = this.getNextComponent(-1, null)) != null) {
            this.setComponentVisible(component, true);
            this.getController().getStudentInterface().getHintInterface().setDisplayHint(false);
            this.hideRest(((JCommQuestion)component).getScaffoldingOrder(), (JCommQuestion)component);
        }
    }

    private void addDoneListeners() {
        JCommButton btn = null;
        for (JCommWidget widget : this.getController().getCommWidgetTable().values()) {
            if (!widget.getCommName().equalsIgnoreCase("done")) continue;
            if (widget instanceof JCommButton) {
                btn = (JCommButton)widget;
                btn.removeAllProblemDoneListeners();
                btn.addProblemDoneListener(this);
            }
            widget.setEnabled(false);
        }
    }

    private void addHelpListeners() {
        JCommButton btn = null;
        for (JCommWidget widget : this.getController().getCommWidgetTable().values()) {
            if (!widget.isHintBtn || !(widget instanceof JCommButton)) continue;
            btn = (JCommButton)widget;
            btn.removeAllHelpListeners();
            btn.addHelpEventListener(this);
        }
    }

    private Component getNextComponent(int current, JCommQuestion currentComp) {
        Component[] components = this.getComponents();
        JCommQuestion component = null;
        int minOrder = 1000;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JCommQuestion)) continue;
            JCommQuestion nextComponent = (JCommQuestion)components[i];
            if (nextComponent.getScaffoldingOrder() > current && nextComponent.getScaffoldingOrder() < minOrder) {
                minOrder = nextComponent.getScaffoldingOrder();
                component = nextComponent;
                continue;
            }
            if (nextComponent.getScaffoldingOrder() != current || currentComp == null || nextComponent.equals(currentComp)) continue;
            minOrder = nextComponent.getScaffoldingOrder();
            component = nextComponent;
            break;
        }
        return component;
    }

    private void hideRest(int current, JCommQuestion comp) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JCommQuestion)) continue;
            JCommQuestion nextComponent = (JCommQuestion)components[i];
            if (nextComponent.getScaffoldingOrder() > current) {
                this.setComponentVisible(nextComponent, false);
                continue;
            }
            if (nextComponent.getScaffoldingOrder() != current || comp == null || nextComponent.equals(comp)) continue;
            this.setComponentVisible(nextComponent, false);
        }
    }

    private void isLastQuestionComponent() {
    }

    @Override
    public void reset(TutorController controller) {
        this.showFirstQuestionComponent();
    }

    @Override
    public void componentAdded(ContainerEvent ce) {
        Component component = ce.getChild();
        String className = component.getClass().getName();
        if (component instanceof JCommQuestion) {
            ((JCommQuestion)component).addStudentActionListener(this);
            ((JCommQuestion)component).addIncorrectActionListener(this);
            ((JCommQuestion)component).addStudentActionListener((StudentActionListener)((Object)this.getController().getStudentInterface().getHintInterface()));
            ((JCommQuestion)component).addIncorrectActionListener((IncorrectActionListener)((Object)this.getController().getStudentInterface().getHintInterface()));
        }
    }

    @Override
    public void componentRemoved(ContainerEvent arg0) {
    }

    @Override
    public void studentActionPerformed(StudentActionEvent sae) {
        Object source = sae.getSource();
        if (!((Component)source).isVisible()) {
            this.setComponentVisible((Component)source, true);
        }
        if (source instanceof JCommQuestion) {
            if (!((JCommQuestion)source).isOriginalQuestion()) {
                this.showNextQuestionComponent(source);
            } else {
                this.fireProblemDoneEvent(new ProblemDoneEvent(this));
            }
        }
        this.hintBtn = this.getHintButton();
        if (this.dfaPanel && this.hintBtn != null) {
            this.hintBtn.setEnabled(false);
        }
    }

    @Override
    public void incorrectActionPerformed(IncorrectActionEvent e) {
        Object source;
        this.hintBtn = this.getHintButton();
        if (this.dfaPanel && this.hintBtn != null) {
            this.hintBtn.setEnabled(true);
        }
        if ((source = e.getSource()) instanceof JCommQuestion) {
            if (((JCommQuestion)source).isOriginalQuestion()) {
                this.fireProblemDoneEvent(new ProblemDoneEvent(this));
            } else if (source instanceof JCommQuestionComboBox) {
                this.transferFocus();
                ((Component)source).getFocusCycleRootAncestor().transferFocusUpCycle();
                this.getHintButton().requestFocus();
            }
        }
    }

    private JCommButton getHintButton() {
        JCommButton btn = null;
        for (JCommWidget widget : this.getController().getCommWidgetTable().values()) {
            if (!widget.isHintBtn || !(widget instanceof JCommButton)) continue;
            btn = (JCommButton)widget;
            break;
        }
        return btn;
    }

    public void init() {
        Component[] components = this.getComponents();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = components[i];
            String className = component.getClass().getName();
            if (!(component instanceof JCommQuestion)) continue;
            ((JCommQuestion)component).addStudentActionListener(this);
            ((JCommQuestion)component).addIncorrectActionListener(this);
        }
        this.showFirstQuestionComponent();
    }

    public synchronized int getDialogOrder() {
        return this.dialogOrder;
    }

    public synchronized void setDialogOrder(int dialogOrder) {
        this.dialogOrder = dialogOrder;
    }

    private void showNextQuestionComponent(Object source) {
        if (this.dialogOrder == DEFAULT) {
            Component comp;
            int count = this.getComponentCount();
            int i = 0;
            while (i < count && !source.equals(comp = this.getComponent(i++))) {
            }
            this.currentComponentNumber = i;
            while (this.currentComponentNumber > 0 && this.currentComponentNumber < count) {
                Component component = this.getComponent(this.currentComponentNumber);
                this.setComponentVisible(component, true);
                ++this.currentComponentNumber;
                component.getFocusCycleRootAncestor().transferFocus();
                if (!(component instanceof JCommQuestion)) continue;
                break;
            }
            if (this.currentComponentNumber == count) {
                this.getController().getStudentInterface().getHintInterface().displaySuccessMessage();
            }
        } else if (this.dialogOrder == SPECIFIED) {
            Component comp = this.getNextComponent(((JCommQuestion)source).getScaffoldingOrder(), (JCommQuestion)source);
            if (comp != null) {
                this.currentComponentNumber = ((JCommQuestion)comp).getScaffoldingOrder();
                this.setComponentVisible(comp, true);
            } else {
                this.getController().getStudentInterface().getHintInterface().displaySuccessMessage();
                this.fireProblemDoneEvent(new ProblemDoneEvent(this));
            }
        }
    }

    @Override
    public MessageObject getDescriptionMessage() {
        if (!this.initialize()) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (this.getUniversalToolProxy() == null) {
            return mo;
        }
        mo.setProperty("WidgetType", "JCommPanel");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector<String> deftemplates = this.createJessDeftemplates();
        Vector<String> instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        this.init();
        return mo;
    }

    public Vector<String> createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate commPanel (slot name))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector<String> createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (commPanel (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    protected boolean initialize() {
        if (!super.initialize(this.getController())) {
            return false;
        }
        if (this.getController().isShowWidgetInfo()) {
            this.setToolTipWidgetInfo();
        }
        return true;
    }

    public void getCommComponents() {
    }

    @Override
    public void helpSeeked(HelpEvent e) {
    }

    @Override
    public void problemDone(ProblemDoneEvent e) {
        Object btn = null;
        for (JCommWidget widget : this.getController().getCommWidgetTable().values()) {
            if (!widget.getCommName().equalsIgnoreCase("done")) continue;
            widget.setEnabled(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

