/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManagerForClient;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import grant.utilities.WebEQUtils;
import grant.widgets.ToolTip.SwingExprToolTip;
import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Highlighter;
import pact.CommWidgets.JCommDocument;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.event.StudentActionEvent;
import webeq3.app.ImageWriter;

public class JCommTable
extends JCommWidget
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = -6167079835123103907L;
    private static final int INITIAL_NO_ROWS = 4;
    private static final int INITIAL_NO_COLS = 4;
    private static final int DEFAULT_CELL_WIDTH = 40;
    private static final int DEFAULT_CELL_HEIGHT = 20;
    private static final int CELL_FORMAT_DO_NONE = 0;
    private static final int CELL_DISPLAY_TOOLTIP_ONLY = 1;
    private static final int CELL_DISPLAY_CELL_IMAGE_ONLY = 2;
    private static final int CELL_FORMAT_DO_BOTH = 3;
    protected boolean tableCreated;
    protected boolean tableInitialized;
    protected TableExpressionCell[][] cells;
    protected int rows;
    protected int columns;
    protected int spacing;
    protected int currentRow;
    protected int currentColumn;
    protected String resetValue = "";
    protected Font startFont;
    protected static int tablesCreated;
    private boolean highlighted;
    private int highlightRow;
    private int highlightCol;
    Vector selectedCellsList = new Vector();
    Vector selectedValues = new Vector();
    JFrame selectedCellsFrame;
    JList nameList;
    JList valuesList;
    DefaultListModel nameModel;
    DefaultListModel valuesModel;
    protected double[] row_heights;
    protected double[] col_widths;
    protected TableLayout tableLayout;
    protected String[] tableCellFeatures;
    private Dimension tableCellSize;
    private boolean insideAdjustSize;

    public TableExpressionCell[][] getCells() {
        return this.cells;
    }

    public static int getTableCount() {
        return tablesCreated;
    }

    public JCommTable() {
        this.actionName = "UpdateTable";
        this.spacing = 1;
        this.setRows(4);
        this.setColumns(4);
        this.addFocusListener(this);
        ++tablesCreated;
        this.constructSelectedCellsFrame();
    }

    public TableCell getCell(int row, int col) {
        return this.cells[row][col];
    }

    private void sendSelectedCells() {
        if (this.getUniversalToolProxy() == null) {
            JOptionPane.showMessageDialog(null, "Warning: The Connection to the Production System should be made before sending the selection elements. \n Open the Behavior Recorder to establish a connection.", "Warning", 2);
        } else {
            MessageObject mo = MessageObject.create("SendSelectedElements");
            mo.setVerb("SendSelectedElements");
            mo.setProperty("SelectedElements", this.selectedCellsList);
            mo.setProperty("SelectedElementsValues", this.selectedValues);
            this.getUniversalToolProxy().sendMessage(mo);
        }
    }

    private void constructSelectedCellsFrame() {
        this.selectedCellsFrame = new JFrame();
        this.nameModel = new DefaultListModel();
        this.valuesModel = new DefaultListModel();
        this.nameList = new JList(this.nameModel);
        this.valuesList = new JList(this.valuesModel);
        this.selectedCellsFrame.getContentPane().setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        namePanel.add((Component)new JLabel("Name"), "North");
        namePanel.add((Component)this.nameList, "Center");
        namePanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel valuesPanel = new JPanel();
        valuesPanel.setLayout(new BorderLayout());
        valuesPanel.add((Component)new JLabel("Value"), "North");
        valuesPanel.add((Component)this.valuesList, "Center");
        valuesPanel.setBorder(BorderFactory.createEtchedBorder());
        JButton okBtn = new JButton("Send");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCommTable.this.sendSelectedCells();
                JCommTable.this.selectedCellsFrame.hide();
            }
        });
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCommTable.this.selectedCellsFrame.hide();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.add(okBtn);
        btnPanel.add(cancelBtn);
        centerPanel.setLayout(new GridLayout(1, 1));
        centerPanel.add(namePanel);
        centerPanel.add(valuesPanel);
        this.selectedCellsFrame.getContentPane().add((Component)centerPanel, "Center");
        this.selectedCellsFrame.getContentPane().add((Component)btnPanel, "South");
    }

    protected boolean initialize() {
        if (!super.initialize(this.getController())) {
            trace.err("can't initializer super");
            return false;
        }
        if (this.tableInitialized) {
            return true;
        }
        for (int j = 0; j < this.columns; ++j) {
            for (int i = 0; i < this.rows; ++i) {
                this.addCommWidgetName(this.commName + "_C" + (j + 1) + "R" + (i + 1));
                this.addCommListener(i, j);
            }
        }
        if (this.getController().isShowWidgetInfo()) {
            this.setToolTipWidgetInfo();
        }
        this.tableInitialized = true;
        return true;
    }

    public void createTextFields() {
        if (this.rows <= 0 || this.columns <= 0) {
            return;
        }
        this.removeAll();
        this.cells = new TableExpressionCell[this.rows][this.columns];
        this.tableCellFeatures = new String[this.rows * this.columns];
        this.row_heights = new double[this.rows];
        this.col_widths = new double[this.columns];
        this.tableCellSize = new Dimension(40, 20);
        this.tableLayout = new TableLayout();
        this.resetTableCellSizes();
        this.setSpacing(this.spacing);
        this.setLayout((LayoutManager)this.tableLayout);
        TableLayoutConstraints cell_constraints = new TableLayoutConstraints(0, 0, 0, 0, 2, 2);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.cells[i][j] = new TableExpressionCell(this, i, j);
                this.tableCellFeatures[i * this.columns + j] = String.valueOf(this.cells[i][j].getCellFormatStatus());
                this.cells[i][j].setFont(this.getFont());
                this.cells[i][j].setToolTipText(this.getToolTipText());
                this.cells[i][j].oldHighlighter = this.cells[i][j].getHighlighter();
                this.cells[i][j].addMouseListener(new MouseListenerClass());
                this.cells[i][j].addKeyListener(this);
                this.cells[i][j].addFocusListener(this);
                cell_constraints.row1 = i;
                cell_constraints.row2 = i;
                cell_constraints.col1 = j;
                cell_constraints.col2 = j;
                this.add((Component)this.cells[i][j], cell_constraints);
            }
        }
        this.tableCreated = true;
        this.originalBorder = this.cells[0][0].getBorder();
        this.adjustPanelSize();
    }

    public void resetTableCellSizes() {
        int i;
        for (i = 0; i < this.row_heights.length; ++i) {
            this.row_heights[i] = this.tableCellSize.height;
        }
        for (i = 0; i < this.col_widths.length; ++i) {
            this.col_widths[i] = this.tableCellSize.width;
        }
        this.tableLayout.setColumn(this.col_widths);
        this.tableLayout.setRow(this.row_heights);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width != 0 && height != 0) {
            if (this.insideAdjustSize) {
                super.setBounds(x, y, width, height);
            } else {
                int columnWidth = (width - (this.columns - 1) * this.tableLayout.getHGap()) / this.columns;
                int rowHeight = (height - (this.rows - 1) * this.tableLayout.getVGap()) / this.rows;
                this.tableCellSize.width = columnWidth;
                this.tableCellSize.height = rowHeight;
                this.resetTableCellSizes();
                Dimension prefSize = this.tableLayout.preferredLayoutSize((Container)this);
                super.setBounds(x, y, prefSize.width, prefSize.height);
                this.tableLayout.layoutContainer((Container)this);
            }
        }
    }

    public void setCellSize(int row, int col, Dimension cellsize) {
        if (this.tableLayout != null && !cellsize.equals(this.getCellSize(row, col))) {
            this.tableLayout.setRow(row, (double)cellsize.height);
            this.tableLayout.setColumn(col, (double)cellsize.width);
            this.tableLayout.layoutContainer((Container)this);
            this.row_heights = this.tableLayout.getRow();
            this.col_widths = this.tableLayout.getColumn();
            this.adjustPanelSize();
            for (int r = 0; r < this.rows; ++r) {
                if (r == row) continue;
                this.cells[r][col].alignImage();
            }
            for (int c = 0; c < this.columns; ++c) {
                if (c == col) continue;
                this.cells[row][c].alignImage();
            }
        }
    }

    public Dimension getCellSize(int row, int col) {
        int width = (int)this.tableLayout.getColumn(col);
        int height = (int)this.tableLayout.getRow(row);
        return new Dimension(width, height);
    }

    public void adjustPanelSize() {
        Dimension prefSize = this.tableLayout.preferredLayoutSize((Container)this);
        this.insideAdjustSize = true;
        this.setSize(prefSize);
        this.insideAdjustSize = false;
        this.tableLayout.layoutContainer((Container)this);
    }

    @Override
    public void addMouseListener(MouseListener m) {
        super.addMouseListener(m);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (this.cells[i][j] == null) continue;
                this.cells[i][j].addMouseListener(m);
            }
        }
    }

    @Override
    public boolean getLock(String selection) {
        Vector v = this.getRowColVector(selection);
        int row = (Integer)v.elementAt(0);
        int col = (Integer)v.elementAt(1);
        if (trace.getDebugCode("table")) {
            trace.printStack("table", "getLock(" + row + "," + col + ") document.locked " + ((JCommDocument)this.cells[row][col].getDocument()).locked);
        }
        return ((JCommDocument)this.cells[row][col].getDocument()).locked;
    }

    public void addCommListener(int row, int col) {
        String componentName = this.commName + "_C" + Integer.toString(col + 1) + "R" + Integer.toString(row + 1);
        this.addCommListener(componentName, this.getController());
    }

    @Override
    public MessageObject getDescriptionMessage(String widgetName) {
        if (trace.getDebugCode("comm")) {
            trace.out("comm", "widget name = " + widgetName + " comm name = " + this.commName);
        }
        if (widgetName == null || !widgetName.equalsIgnoreCase(this.commName)) {
            return null;
        }
        MessageObject mo = MessageObject.create("InterfaceDescription");
        if (!this.initialize()) {
            trace.out("ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommTable");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        mo.setProperty("Rows", new Integer(this.rows));
        mo.setProperty("Columns", new Integer(this.columns));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        trace.out("comm", "mo = " + mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String tableTemplate = "(deftemplate table (slot name) (multislot columns))";
        String columnTemplate = "(deftemplate column (slot name) (multislot cells) (slot position) (slot description))";
        String cellTemplate = "(deftemplate cell (slot name) (slot value) (slot description) (slot row-number) (slot column-number))";
        deftemplates.add(tableTemplate);
        deftemplates.add(columnTemplate);
        deftemplates.add(cellTemplate);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String columns = "";
        for (int j = 1; j <= this.getColumns(); ++j) {
            String cells = "";
            for (int i = 1; i <= this.rows; ++i) {
                String cellName = this.getCommName() + "_C" + j + "R" + i;
                String str = "(bind ?" + cellName + " (assert (cell (name " + cellName + ") (row-number " + i + ") (column-number " + j + "))))";
                cells = cells + "?" + cellName + " ";
                instances.add(str);
            }
            String columnName = this.getCommName() + "_Column" + j;
            String columnStr = "(bind ?" + columnName + "(assert (column (name " + columnName + ") (cells " + cells + ") (position " + j + "))))";
            instances.add(columnStr);
            columns = columns + "?" + columnName + " ";
        }
        String tableName = this.getCommName();
        String tableInstance = "(assert (table (name " + tableName + ") (columns " + columns + ")))";
        instances.add(tableInstance);
        return instances;
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateTable")) {
            Vector v = this.getRowColVector(selection);
            int row = (Integer)v.elementAt(0);
            int col = (Integer)v.elementAt(1);
            ((JCommDocument)this.cells[row][col].getDocument()).locked = false;
            this.cells[row][col].setText(input);
            if (trace.getDebugCode("table")) {
                trace.out("table", "doInterfaceAction(" + row + "," + col + ") input " + input);
            }
            this.cells[row][col].previousValue = this.cells[row][col].getText();
            if (this.getController().isStartStateInterface() || this.getController().isSimStudentMode()) {
                ((JCommDocument)this.cells[row][col].getDocument()).locked = true;
            }
            return;
        }
        if (action.equalsIgnoreCase("SetVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
            return;
        }
        throw new Error("**Error**: don't know interface action " + action);
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "do correct action: input = " + input + " selection = " + selection);
            }
            Vector v = this.getRowColVector(selection);
            int row = (Integer)v.elementAt(0);
            int col = (Integer)v.elementAt(1);
            ((JCommDocument)this.cells[row][col].getDocument()).locked = false;
            if (trace.getDebugCode("table")) {
                trace.out("table", "doCorrectAction(" + row + "," + col + ") setForeground(" + this.correctColor + ")");
            }
            this.cells[row][col].setText(input);
            this.cells[row][col].setForeground(this.correctColor);
            this.cells[row][col].oldHighlighter = this.cells[row][col].getHighlighter();
            this.cells[row][col].setHighlighter(null);
            this.cells[row][col].setBackground(this.backgroundNormalColor);
            if (this.correctFont != null) {
                this.cells[row][col].setFont(this.correctFont);
            }
            if (this.getController().getUniversalToolProxy().lockWidget()) {
                ((JCommDocument)this.cells[row][col].getDocument()).locked = true;
                this.cells[row][col].createImage();
            }
            this.fireStudentAction(new StudentActionEvent(this));
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        Vector v = this.getRowColVector(selection);
        int row = (Integer)v.elementAt(0);
        int col = (Integer)v.elementAt(1);
        this.cells[row][col].setText(input);
        this.cells[row][col].setForeground(this.LISPCheckColor);
        if (this.getController().getUniversalToolProxy().lockWidget()) {
            ((JCommDocument)this.cells[row][col].getDocument()).locked = true;
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        Vector v = this.getRowColVector(selection);
        int row = (Integer)v.elementAt(0);
        int col = (Integer)v.elementAt(1);
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "table.doIncorrectAction(" + selection + "," + input + "): row " + row + ", col " + col + ", incorrect color " + this.incorrectColor);
        }
        this.cells[row][col].setText(input);
        this.cells[row][col].setForeground(this.incorrectColor);
        this.cells[row][col].setEditable(true);
        this.cells[row][col].setHighlighter(this.cells[row][col].oldHighlighter);
        if (this.incorrectFont != null) {
            this.cells[row][col].setFont(this.incorrectFont);
        }
        ((JCommDocument)this.cells[row][col].getDocument()).locked = this.getController().isSimStudentMode();
        if (trace.getDebugCode("table")) {
            trace.out("table", "doIncorrectAction(" + row + "," + col + ") document.locked " + ((JCommDocument)this.cells[row][col].getDocument()).locked);
        }
        this.cells[row][col].doIncorrectAction();
    }

    public boolean getLocked(String selection) {
        Vector v = this.getRowColVector(selection);
        int row = (Integer)v.elementAt(0);
        int col = (Integer)v.elementAt(1);
        if (trace.getDebugCode("table")) {
            trace.printStack("table", "getLocked(" + row + "," + col + ") document.locked " + ((JCommDocument)this.cells[row][col].getDocument()).locked);
        }
        return ((JCommDocument)this.cells[row][col].getDocument()).locked;
    }

    public void setProperty(MessageObject o) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!(e.getComponent() instanceof TableCell)) {
            return;
        }
        if (e.isTemporary()) {
            return;
        }
        TableCell cell = (TableCell)e.getComponent();
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "JCommTable: focusGained; current cell C" + this.currentColumn + "R" + this.currentRow + ", new focus C" + cell.column + "R" + cell.row + ", locked " + ((JCommDocument)this.cells[cell.row][cell.column].getDocument()).locked + "; if unlocked, to setForeground(" + this.startColor + ")");
        }
        if (!((JCommDocument)this.cells[cell.row][cell.column].getDocument()).locked) {
            cell.previousValue = cell.getText();
            if (this.startFont != null) {
                this.cells[cell.row][cell.column].setFont(this.startFont);
            }
            this.currentRow = cell.row + 1;
            this.currentColumn = cell.column + 1;
            super.focusGained(e);
        }
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        TableCell cell = null;
        if (e.getComponent() instanceof TableCell) {
            cell = (TableCell)e.getComponent();
        }
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "JCommTable: focusLost(temp " + e.isTemporary() + "); current cell C" + this.currentColumn + "R" + this.currentRow + ", new focus " + (cell == null ? "null" : "C" + cell.column + "R" + cell.row) + ", locked " + ((JCommDocument)this.cells[cell.row][cell.column].getDocument()).locked);
        }
        if (e.isTemporary()) {
            return;
        }
        if (e.getOppositeComponent() instanceof JButton && ((JButton)e.getOppositeComponent()).getActionCommand().equals("undo")) {
            return;
        }
        if (!(e.getComponent() instanceof TableCell)) {
            return;
        }
        Component oppComponent = e.getOppositeComponent();
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "JCommTable: focusLost oppComponent " + oppComponent);
        }
        if (!this.focusTriggersBackGrading(oppComponent)) {
            return;
        }
        this.currentRow = cell.row + 1;
        this.currentColumn = cell.column + 1;
        if (!((JCommDocument)this.cells[cell.row][cell.column].getDocument()).locked) {
            this.dirty = !cell.getText().trim().equals("");
            this.autoCapitalize(this.cells[cell.row][cell.column]);
            if (cell.getText().trim().equals("")) {
                this.dirty = false;
                if (this.getController().isDefiningStartState()) {
                    this.getController().setStartStateModified(true);
                }
            }
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "JCommTable: focusLost current cell C" + this.currentColumn + "R" + this.currentRow + ", dirty " + this.dirty + ", text " + cell.getText());
            }
            if (this.dirty) {
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "calling JCommWidget.sendValue()");
                }
                this.sendValue();
            }
            this.dirty = false;
        }
        super.focusLost(e);
    }

    private void autoCapitalize(TableCell cell) {
        if (this.getController().getUniversalToolProxy().getAutoCapitalize() || this.getAutoCapitalize()) {
            String text = cell.getText();
            cell.setTextInternal(text.toUpperCase());
        }
    }

    @Override
    public Object getValue() {
        if (this.currentRow < 1 || this.currentColumn < 1 || this.currentRow > this.cells.length || this.currentColumn > this.cells[this.currentRow - 1].length) {
            return null;
        }
        this.cells[this.currentRow - 1][this.currentColumn - 1].setForeground(this.startColor);
        return this.cells[this.currentRow - 1][this.currentColumn - 1].getText().trim();
    }

    public void textValueChanged(TextEvent e) {
        this.dirty = true;
    }

    @Override
    public boolean isChangedFromResetState() {
        LinkedList debugList = null;
        if (trace.getDebugCode("table")) {
            debugList = new LinkedList();
        }
        boolean changedFlag = false;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (this.cells[i][j].getText().equals(this.resetValue)) continue;
                ((JCommDocument)this.cells[i][j].getDocument()).locked = true;
                changedFlag = true;
            }
        }
        return changedFlag;
    }

    public boolean resetStartStateLock(boolean startStateLock) {
        boolean changedFlag = false;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (this.cells[i][j].getText().equals(this.resetValue)) continue;
                ((JCommDocument)this.cells[i][j].getDocument()).locked = startStateLock;
                changedFlag = true;
            }
        }
        return changedFlag;
    }

    public void singleCellReset(String selection) {
        Vector v = this.getRowColVector(selection);
        int row = (Integer)v.elementAt(0);
        int col = (Integer)v.elementAt(1);
        this.cellReset(row, col);
    }

    private void cellReset(int row, int col) {
        if (trace.getDebugCode("table")) {
            trace.printStack("table", "cellReset(" + row + "," + col + ") setForeground(" + this.startColor + ")");
        }
        ((JCommDocument)this.cells[row][col].getDocument()).locked = false;
        this.cells[row][col].setForeground(this.startColor);
        this.cells[row][col].setText(this.resetValue);
        this.cells[row][col].setEditable(true);
        this.cells[row][col].setHighlighter(this.cells[row][col].oldHighlighter);
        this.cells[row][col].setFocusable(true);
        TableExpressionCell r = this.cells[row][col];
        if (r.isDisplayToolTip()) {
            ((SwingExprToolTip)r.exprToolTip).attach();
        }
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.cellReset(i, j);
            }
        }
        this.resetTableCellSizes();
        this.adjustPanelSize();
    }

    public Vector getCurrentState() {
        int oldCurrentRow = this.currentRow;
        int oldCurrentColumn = this.currentColumn;
        Vector<MessageObject> v = new Vector<MessageObject>();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (this.cells[i][j].getText().equals(this.resetValue)) continue;
                this.currentRow = i + 1;
                this.currentColumn = j + 1;
                v.addElement(this.getCurrentStateMessage());
            }
        }
        this.currentRow = oldCurrentRow;
        this.currentColumn = oldCurrentColumn;
        return v;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.dirty = true;
        if (e.getKeyCode() == 10) {
            e.getComponent().transferFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    public void setRows(int rows) {
        if (rows <= 0) {
            return;
        }
        this.rows = rows;
        if (this.columns > 0) {
            this.createTextFields();
        }
    }

    public int getRows() {
        return this.rows;
    }

    public void setJustification(int value) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.cells[i][j].setHorizontalAlignment(value);
            }
        }
    }

    public int getJustification() {
        return 0;
    }

    public void setColumns(int columns) {
        if (columns <= 0) {
            return;
        }
        this.columns = columns;
        if (this.rows > 0) {
            this.createTextFields();
        }
    }

    protected Vector getRowColVector(String selection) {
        Vector<Integer> v = new Vector<Integer>();
        String col = selection.substring(selection.lastIndexOf("_C") + 2, selection.lastIndexOf("R"));
        String row = selection.substring(selection.lastIndexOf("R") + 1, selection.length());
        v.addElement(new Integer(new Integer(row) - 1));
        v.addElement(new Integer(new Integer(col) - 1));
        return v;
    }

    @Override
    public String getCommNameToSend() {
        String s = this.commName + "_C" + this.currentColumn + "R" + this.currentRow;
        return s;
    }

    @Override
    public void setCommName(String name, TutorController controller) {
        super.setCommName(name, controller);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                TableCell cell = this.getCell(i, j);
                this.addCommWidgetName(cell.getCommName());
            }
        }
    }

    @Override
    public void setFocus(String subWidgetName) {
        Vector rowcol = this.getRowColVector(subWidgetName);
        int row = (Integer)rowcol.elementAt(0);
        int col = (Integer)rowcol.elementAt(1);
        this.cells[row][col].requestFocus();
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        if (trace.getDebugCode("mps")) {
            trace.printStack("mps", "set highlight: subElement = " + subElement);
        }
        Vector rowcol = this.getRowColVector(subElement);
        int row = (Integer)rowcol.elementAt(0);
        int col = (Integer)rowcol.elementAt(1);
        this.cells[row][col].setBorder(highlightBorder);
        this.highlighted = true;
        this.highlightRow = row;
        this.highlightCol = col;
    }

    @Override
    public void removeHighlight(String subElement) {
        if (trace.getDebugCode("inter")) {
            trace.printStack("inter", "JCommTable.removeHighlight(" + subElement + ") highlightRow " + this.highlightRow + ", Col " + this.highlightCol);
        }
        this.cells[this.highlightRow][this.highlightCol].setBorder(this.originalBorder);
    }

    public int getColumns() {
        return this.columns;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        if (this.tableLayout != null) {
            this.tableLayout.setVGap(spacing);
            this.tableLayout.setHGap(spacing);
            this.adjustPanelSize();
        }
    }

    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public void setFont(Font f) {
        this.startFont = f;
        super.setFont(f);
        if (this.tableInitialized) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.cells[i][j].setFont(f);
                }
            }
        }
    }

    @Override
    public void mouseDoubleClickedWhenMissActive(MouseEvent me) {
        TableCell cell = (TableCell)me.getComponent();
        this.toggleHighlight(cell);
        this.getController().toggleWidgetFocusForSimSt(cell);
    }

    private void toggleHighlight(TableCell cell) {
        if (cell.isHighlighted()) {
            cell.removeHighlight();
        } else {
            cell.highlight();
        }
    }

    public String[] getTableCellFeatures() {
        return this.tableCellFeatures;
    }

    public void setTableCellFeatures(String[] tableCellFeatures) {
        for (int i = 0; i < tableCellFeatures.length; ++i) {
            if (i >= this.rows * this.columns) continue;
            int row = i / this.columns;
            int col = i % this.columns;
            int newstatus = Integer.parseInt(tableCellFeatures[i]);
            if (newstatus == 3) {
                this.cells[row][col].setDisplayCellImage(true);
                this.cells[row][col].setDisplayToolTip(true);
            } else if (newstatus == 2) {
                this.cells[row][col].setDisplayCellImage(true);
                this.cells[row][col].setDisplayToolTip(false);
            } else if (newstatus == 1) {
                this.cells[row][col].setDisplayCellImage(false);
                this.cells[row][col].setDisplayToolTip(true);
            } else {
                this.cells[row][col].setDisplayCellImage(false);
                this.cells[row][col].setDisplayToolTip(false);
            }
            this.tableCellFeatures[i] = String.valueOf(this.cells[row][col].getCellFormatStatus());
            if (!trace.getDebugCode("mps")) continue;
            trace.out("mps", "setTableCellFeatures[" + row + "][" + col + "] status " + this.tableCellFeatures[i] + ", cell " + this.cells[row][col]);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    public class TableExpressionCell
    extends TableCell {
        private static final int IMAGE_VERTICAL_PADDING = 2;
        private static final int IMAGE_HORIZONTAL_PADDING = 2;
        private boolean displayToolTip;
        private boolean displayCellImage;
        private Object exprToolTip;
        private JComponent parent;
        private Image expression_image;
        private int expr_img_x;
        private int expr_img_y;

        public JCommTable getTable() {
            return (JCommTable)this.parent;
        }

        public TableExpressionCell(JComponent parent, int i, int j) {
            this.parent = parent;
            this.row = i;
            this.column = j;
        }

        @Override
        public void paintComponent(Graphics gr) {
            if (((JCommDocument)this.getDocument()).locked) {
                if (this.exprToolTip != null) {
                    ((SwingExprToolTip)this.exprToolTip).detach();
                }
                if (this.isDisplayCellImage() && this.expression_image != null) {
                    Dimension cellSize = JCommTable.this.getCellSize(this.row, this.column);
                    Color currColor = gr.getColor();
                    gr.setColor(this.getBackground());
                    gr.fillRect(0, 0, cellSize.width, cellSize.height);
                    gr.drawImage(this.expression_image, this.expr_img_x, this.expr_img_y, this);
                    gr.setColor(currColor);
                    return;
                }
            }
            super.paintComponent(gr);
        }

        public void createImage() {
            if (VersionInformation.includesCL() && this.isDisplayCellImage()) {
                if (this.expression_image == null) {
                    ImageWriter imgWriter = new ImageWriter();
                    imgWriter.setPointsize(this.getFont().getSize());
                    imgWriter.setBGColor(this.getBackground().getRed(), this.getBackground().getGreen(), this.getBackground().getBlue());
                    String mathML = WebEQUtils.convertExprToMathML((String)this.getText(), (Font)this.getFont(), (Color)this.getForeground());
                    if (!mathML.equalsIgnoreCase("")) {
                        this.expression_image = WebEQUtils.createWebEQImage((ImageWriter)imgWriter, (String)mathML);
                        if (this.expression_image == null) {
                            return;
                        }
                    } else {
                        this.expression_image = null;
                    }
                }
                Dimension table_cell_size = JCommTable.this.getCellSize(this.row, this.column);
                int imgWidth = this.expression_image.getWidth(JCommTable.this);
                int imgHeight = this.expression_image.getHeight(JCommTable.this);
                while (imgWidth == -1 || imgHeight == -1) {
                    imgWidth = this.expression_image.getWidth(JCommTable.this);
                    imgHeight = this.expression_image.getHeight(JCommTable.this);
                }
                int imgWidthwithPadding = imgWidth + 4;
                int imgHeightwithPadding = imgHeight + 4;
                int newWidth = table_cell_size.getWidth() > (double)imgWidthwithPadding ? (int)table_cell_size.getWidth() : imgWidthwithPadding;
                int newHeight = table_cell_size.getHeight() > (double)imgHeightwithPadding ? (int)table_cell_size.getHeight() : imgHeightwithPadding;
                JCommTable.this.setCellSize(this.row, this.column, new Dimension(newWidth, newHeight));
                this.alignImage();
            }
        }

        public void doIncorrectAction() {
            this.expression_image = null;
        }

        public void alignImage() {
            if (this.expression_image == null) {
                return;
            }
            Dimension table_cell_size = JCommTable.this.getCellSize(this.row, this.column);
            this.expr_img_x = 2;
            this.expr_img_y = (table_cell_size.height - this.expression_image.getHeight(JCommTable.this)) / 2;
            this.repaint();
        }

        public int getCellFormatStatus() {
            if (this.isDisplayCellImage() && this.isDisplayToolTip()) {
                return 3;
            }
            if (this.isDisplayCellImage() && !this.isDisplayToolTip()) {
                return 2;
            }
            if (!this.isDisplayCellImage() && this.isDisplayToolTip()) {
                return 1;
            }
            return 0;
        }

        public boolean isDisplayCellImage() {
            return this.displayCellImage;
        }

        public void setDisplayCellImage(boolean displayCellImage) {
            this.displayCellImage = displayCellImage;
            this.expression_image = null;
        }

        public boolean isDisplayToolTip() {
            return this.displayToolTip;
        }

        public void setDisplayToolTip(boolean displayToolTip) {
            if (!VersionInformation.includesCL()) {
                this.displayToolTip = false;
                this.exprToolTip = null;
                return;
            }
            this.displayToolTip = displayToolTip;
            if (this.displayToolTip) {
                if (this.exprToolTip == null) {
                    SwingExprToolTip ett = new SwingExprToolTip((Component)this.parent, (JTextField)this);
                    this.exprToolTip = ett;
                    ett.attach();
                }
            } else if (this.exprToolTip != null) {
                ((SwingExprToolTip)this.exprToolTip).detach();
                this.exprToolTip = null;
            }
        }
    }

    public class TableCell
    extends JTextField
    implements KeyListener {
        int row;
        int column;
        String previousValue = "";
        boolean selected = false;
        Highlighter oldHighlighter;
        boolean highlighted = false;

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public TableCell() {
            JCommDocument doc = new JCommDocument();
            this.setDocument(doc);
            this.addKeyListener(this);
        }

        @Override
        public void setText(String text) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "TableCell.setText(" + text + ") commName " + this.getCommName());
            }
            this.setTextInternal(text);
            JCommTable.this.dirty = true;
        }

        private void setTextInternal(String string) {
            super.setText(string);
        }

        public String getCommName() {
            return JCommTable.this.commName + "_C" + (this.column + 1) + "R" + (this.row + 1);
        }

        public String getValue() {
            return this.getText();
        }

        boolean isHighlighted() {
            return this.highlighted;
        }

        void setHighlighted(boolean flag) {
            this.highlighted = flag;
        }

        void highlight() {
            this.setBorder(HintMessagesManagerForClient.defaultBorder);
            this.setHighlighted(true);
        }

        public void removeHighlight() {
            this.setBorder(JCommTable.this.originalBorder);
            this.setHighlighted(false);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (!((JCommDocument)this.getDocument()).locked) {
                this.setForeground(JCommTable.this.startColor);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }

    private class MouseListenerClass
    implements MouseListener {
        private MouseListenerClass() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.isControlDown()) {
                TableCell tc = (TableCell)me.getComponent();
                tc.previousValue = tc.getText();
                JCommTable.this.cells[tc.row][tc.column].setForeground(JCommTable.this.startColor);
                if (JCommTable.this.startFont != null) {
                    JCommTable.this.cells[tc.row][tc.column].setFont(JCommTable.this.startFont);
                }
                JCommTable.this.currentRow = tc.row + 1;
                JCommTable.this.currentColumn = tc.column + 1;
                if (trace.getDebugCode("dw")) {
                    trace.out("dw", " current row = " + JCommTable.this.currentRow + " current col = " + JCommTable.this.currentColumn);
                }
                JCommTable.this.repaint();
                if (tc.selected) {
                    tc.setBackground(Color.WHITE);
                    tc.selected = false;
                    JCommTable.this.selectedCellsList.remove(JCommTable.this.getCommNameToSend());
                    JCommTable.this.selectedValues.remove(JCommTable.this.getValue());
                    JCommTable.this.nameModel.removeElement(JCommTable.this.getCommNameToSend());
                    JCommTable.this.valuesModel.removeElement(JCommTable.this.getValue());
                } else {
                    tc.setBackground(Color.PINK);
                    tc.selected = true;
                    this.addToSelectedList(JCommTable.this.getCommNameToSend());
                    this.addToSelectedValues(JCommTable.this.getValue());
                }
                JCommTable.this.selectedCellsFrame.validate();
                JCommTable.this.selectedCellsFrame.pack();
                JCommTable.this.selectedCellsFrame.show();
            }
            if (me.getClickCount() == -2 && JCommTable.this.getController().isSimStudentMode()) {
                this.mouseDoubleClickedWhenMissActive(me);
            }
        }

        public void mouseDoubleClickedWhenMissActive(MouseEvent me) {
            TableCell cell = (TableCell)me.getComponent();
            this.toggleHighlight(cell);
            JCommTable.this.getController().toggleWidgetFocusForSimSt(cell);
        }

        private void toggleHighlight(TableCell cell) {
            if (cell.isHighlighted()) {
                cell.removeHighlight();
            } else {
                cell.highlight();
            }
        }

        private void clearSelectedValues() {
            JCommTable.this.selectedValues.removeAll(JCommTable.this.selectedValues);
        }

        private void addToSelectedValues(Object o) {
            JCommTable.this.selectedValues.add(o);
            JCommTable.this.valuesModel.addElement(o);
        }

        private void clearSelectedList() {
            JCommTable.this.selectedCellsList.removeAll(JCommTable.this.selectedCellsList);
        }

        private void addToSelectedList(String cellName) {
            JCommTable.this.selectedCellsList.add(cellName);
            JCommTable.this.nameModel.addElement(cellName);
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

