/*
 * Decompiled with CFR 0.152.
 */
package pact.EconGraph;

import java.awt.BasicStroke;
import java.awt.Color;
import pact.EconGraph.Point;

public class Line {
    public Point[] point;
    public Color color;
    public String name;
    boolean moving;
    public BasicStroke stroke;

    Line(String lname, Point start, Point end, int handles, Color lcolor, boolean moveable, BasicStroke s) {
        this.name = lname;
        this.point = new Point[handles];
        this.point[0] = start;
        if (handles > 1) {
            this.point[handles - 1] = end;
        }
        this.color = lcolor;
        this.moving = moveable;
        this.stroke = s;
        this.initialize();
        for (int pt = 0; pt < this.point.length; ++pt) {
            this.point[pt].setMoveable(moveable);
            this.point[pt].setColor(lcolor);
        }
    }

    public void reset() {
        for (int i = 0; i < this.point.length; ++i) {
            this.point[i].reset();
        }
    }

    public String getName() {
        return this.name;
    }

    void initialize() {
        for (int pt = 1; pt < this.point.length - 1; ++pt) {
            this.point[pt] = new Point(pt * (this.point[this.point.length - 1].getx() - this.point[0].getx()) / (this.point.length - 1) + this.point[0].getx(), pt * (this.point[this.point.length - 1].gety() - this.point[0].gety()) / (this.point.length - 1) + this.point[0].gety(), this.name, pt);
        }
    }

    boolean getMoving() {
        return this.moving;
    }

    public Color getColor() {
        return this.color;
    }

    public String summary(int id, String delim) {
        String summary = "#L" + delim + id + delim + this.point.length;
        for (int p = 0; p < this.point.length; ++p) {
            summary = summary + delim + this.point[p].getx() + delim + this.point[p].gety();
        }
        return summary;
    }
}

