/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATFileManager;
import edu.cmu.hcii.ctat.CTATGeneralizedIOManager;
import edu.cmu.hcii.ctat.CTATLink;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CTATAppletFileManager
extends CTATGeneralizedIOManager {
    private static final Pattern doubleSlash = Pattern.compile("([^:])//+");

    public CTATAppletFileManager() {
        this.setClassName("CTATAppletFileManager");
        this.debug("CTATAppletFileManager ()");
        this.setOutputDestination(CTATGeneralizedIOManager.IOSource.JAR);
        this.setFileIOManager(this);
    }

    @Override
    public boolean doesFileExist(String aFileURI) {
        this.debug("doesFileExist (" + aFileURI + ")");
        BufferedInputStream is = this.openForRead(aFileURI);
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return is != null;
    }

    @Override
    public boolean createDirectory(String aDirURI) throws UnsupportedOperationException {
        this.debug("createDirectory (" + aDirURI + ")");
        try {
            throw new UnsupportedOperationException("createDirectory (" + aDirURI + ")");
        }
        catch (Exception e) {
            this.debugStack("CTATAppletFileManager: " + e, e);
            return false;
        }
    }

    @Override
    protected void doOutput(String path, byte[] data) {
        this.debug("doOutput (" + path + ")");
        try {
            throw new UnsupportedOperationException("doOutput (" + path + ", " + (data == null ? null : "data[" + data.length + "]") + ")");
        }
        catch (Exception e) {
            this.debugStack("CTATAppletFileManager: " + e, e);
            return;
        }
    }

    @Override
    protected byte[] doInput(String path) throws IOException {
        this.debug("doInput(" + path + ")");
        BufferedInputStream bis = this.openForRead(path);
        if (bis == null) {
            return null;
        }
        ByteArrayOutputStream contents = this.readStreamAndClose(bis, path);
        if (contents == null) {
            return null;
        }
        return contents.toByteArray();
    }

    private ByteArrayOutputStream readStreamAndClose(InputStream bis, String aFileURI) {
        this.debug("readStreamAndClose(" + bis + "," + aFileURI + ")");
        ByteArrayOutputStream baos = null;
        long len = 0L;
        try {
            baos = new ByteArrayOutputStream();
            int c = -1;
            while ((c = bis.read()) >= 0) {
                baos.write(c);
                ++len;
            }
            bis.close();
            bis = null;
        }
        catch (Exception e) {
            this.debugStack("Error reading \"" + aFileURI + "\" after " + len + " bytes:\n  " + e + "; cause " + e.getCause(), e);
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        return baos;
    }

    private BufferedInputStream openForRead(String aFileURI) {
        this.debug("openForRead(" + aFileURI + ")");
        aFileURI = this.removeExtraSlashes(aFileURI);
        BufferedInputStream bis = null;
        try {
            URL url = this.getClass().getResource("/" + aFileURI);
            if (url == null) {
                return null;
            }
            URLConnection uConn = url.openConnection();
            InputStream is = uConn.getInputStream();
            bis = new BufferedInputStream(is);
            return bis;
        }
        catch (Exception e) {
            this.debugStack("Error opening \"" + aFileURI + "\" to read:\n  " + e + "; cause " + e.getCause(), e);
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private String removeExtraSlashes(String aFileURI) {
        Matcher m = doubleSlash.matcher(aFileURI);
        String result = m.replaceAll("$1/");
        this.debug("removeExtraSlashes(" + aFileURI + ") => (" + result + ")");
        return result;
    }

    @Override
    public boolean configureCTATLink() {
        String decrypted;
        this.debug("configureCTATLink (): configFilePath " + CTATLink.configFilePath);
        String cfp = CTATLink.configFilePath;
        if (cfp == null) {
            cfp = "./etc/config.data";
        }
        if (cfp.startsWith("./")) {
            cfp = cfp.substring(2);
        }
        if ((decrypted = this.getContents(cfp)) == null) {
            this.debug("Info: no config file available yet");
            return false;
        }
        return CTATLink.parse(decrypted);
    }

    public static void main(String[] args) {
        CTATAppletFileManager fm = new CTATAppletFileManager();
        for (String arg : args) {
            boolean exists = ((CTATFileManager)fm).doesFileExist(arg);
            String contents = ((CTATFileManager)fm).getContents(arg);
            System.out.printf("\n    getContents(%s) => exists %b, length %d, content:\n%s\n", arg, exists, contents == null ? -1 : contents.length(), contents);
            System.out.printf("    setContents(%s, \"junk\"):\n", arg);
            ((CTATFileManager)fm).setContents(arg, "junk");
        }
    }

    @Override
    public InputStream getInputStream(String aFileURI) {
        this.debug("getInputStream (" + aFileURI + ")");
        return this.openForRead(aFileURI);
    }
}

