/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CTATDeamon
extends CTATBase {
    private Boolean disabled = true;
    private SimpleDateFormat critdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");

    public CTATDeamon(Boolean disable) {
        this.setClassName("CTATDeamon");
        this.debug("CTATDeamon ()");
        this.setDisabled(disable);
    }

    public CTATDeamon() {
        this.setClassName("CTATDeamon");
        this.debug("CTATDeamon ()");
    }

    public void startCriticalLogging() {
        if (!this.getDisabled().booleanValue()) {
            if (!this.getFManager().openStream("logs/critical.txt")) {
                this.setDisabled(true);
            } else {
                this.writeToCritical("System started on: " + this.critdf.format(new Date()));
            }
        }
    }

    protected CTATDesktopFileManager getFManager() {
        if (CTATLink.fManager == null) {
            CTATLink.fManager = new CTATDesktopFileManager();
        }
        return (CTATDesktopFileManager)CTATLink.fManager;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public static CTATDeamon install(String signalName) {
        CTATDeamon diagHandler = new CTATDeamon();
        return diagHandler;
    }

    public void writeToCritical(String aMessage) {
        if (!this.getDisabled().booleanValue()) {
            this.getFManager().writeToStream(aMessage + "\n");
        }
    }

    public void writeToCriticalWithTime(String aMessage) {
        if (!this.getDisabled().booleanValue()) {
            this.getFManager().writeToStream(aMessage + " (on: " + this.critdf.format(new Date()) + ")\n");
        }
    }
}

