/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATCryptoUtils;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATURLFetch;
import edu.cmu.hcii.ctat.OnlineOfflineManager;
import edu.cmu.hcii.ctat.env.CTATEnvironment;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CTATDiagnostics
extends CTATBase {
    private boolean verbose = true;
    public String diagnosis = "All's well -- all required ports are open";
    public ArrayList<String> writableDirs = null;
    private static Thread cc = null;

    public CTATDiagnostics() {
        this.setClassName("CTATDiagnostics");
        this.debug("CTATDiagnostics ()");
        if (CTATLink.crypto == null) {
            CTATLink.crypto = new CTATCryptoUtils();
        }
        this.writableDirs = new ArrayList();
    }

    public ArrayList<String> getWritables() {
        return this.writableDirs;
    }

    public boolean configEnvironment() {
        this.debug("configEnvironment ()");
        if (CTATLink.fManager == null) {
            CTATLink.fManager = new CTATDesktopFileManager();
        }
        if (!CTATLink.fManager.doesFileExist(CTATLink.etc) && !CTATLink.fManager.createDirectory(CTATLink.etc)) {
            this.debug("Error unable to create etc directory");
            return false;
        }
        return true;
    }

    public boolean testSettings(boolean aVerbose) {
        return this.testSettings(aVerbose, true);
    }

    public boolean testSettings(boolean aVerbose, boolean callConfigEnvironment) {
        this.debug("testSettings ()");
        this.verbose = aVerbose;
        if (callConfigEnvironment && !this.configEnvironment()) {
            return false;
        }
        this.getInetInfo();
        this.getEnvInfo();
        CTATLink.tsPort = this.findServerPort(CTATLink.tsPort);
        if (CTATLink.tsPort < 0) {
            this.diagnosis = "Not allowed or not able to launch server on tutoring server port";
            return false;
        }
        if ((CTATLink.tsMonitorPort = this.findServerPort(Math.max(CTATLink.tsMonitorPort, CTATLink.tsPort + 1))) < 0) {
            this.diagnosis = "Not allowed or not able to launch server on tutoring server monitor port";
            return false;
        }
        if (!this.testServerPort(843)) {
            this.diagnosis = "Not allowed or not able to launch server on Flash security port";
        }
        if ((CTATLink.wwwPort = this.findServerPort(CTATLink.wwwPort)) < 0) {
            this.diagnosis = "Not allowed or not able to launch server on http server port";
            return false;
        }
        return true;
    }

    private String getInetInfo() {
        if (this.verbose) {
            this.debug("getInetInfo ()");
        }
        StringBuilder sb = new StringBuilder();
        String newline = System.getProperty("line.separator");
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                if (this.verbose) {
                    this.debug("Net interface: " + ni.getName());
                    sb.append("Net interface: " + ni.getName() + newline);
                }
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ip = e2.nextElement();
                    if (!this.verbose) continue;
                    this.debug("IP address: " + ip.toString());
                    sb.append("IP address: " + ip.toString() + newline);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private void getEnvInfo() {
        if (this.verbose) {
            this.debug("getEnvInfo ()");
        }
        Properties systemProps = System.getProperties();
        Set<Map.Entry<Object, Object>> sets = systemProps.entrySet();
        int index = 0;
        for (Map.Entry<Object, Object> entry : sets) {
            if (this.verbose) {
                this.debug("[" + index + "] name: " + entry.getKey() + ", value: " + entry.getValue());
            }
            ++index;
        }
    }

    private int findServerPort(int portNumber) {
        if (this.verbose) {
            this.debug("testServerPort startint at port " + portNumber);
        }
        int limit = portNumber + 20;
        while (portNumber < limit) {
            if (this.testServerPort(portNumber)) {
                return portNumber;
            }
            ++portNumber;
        }
        this.diagnosis = "Not allowed to open a listening socket on: " + portNumber;
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testServerPort(int portNumber) {
        ServerSocket testSocket = null;
        try {
            testSocket = new ServerSocket(portNumber);
        }
        catch (IOException e) {
            this.error("Exception trying to bind port " + portNumber + ": " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (testSocket != null) {
                    testSocket.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.debug("Success: server port " + portNumber + " accessible for listening");
        return true;
    }

    public String getProperty(String aProp) {
        return System.getProperty(aProp.toLowerCase());
    }

    public String getEnvironment(String aProp) {
        return System.getenv(aProp.toLowerCase());
    }

    public Boolean getWritableDirectory() {
        this.debug("getWritableDirectory ()");
        this.writableDirs = new ArrayList();
        Map<String, String> env = System.getenv();
        String option = "";
        option = System.getProperty("user.home");
        if (option != null) {
            this.writableDirs.add(option);
        }
        if (CTATEnvironment.isLocalWindows()) {
            option = env.get("APPDATA");
            if (option != null) {
                this.writableDirs.add(option);
            }
            if ((option = env.get("ALLUSERSPROFILE")) != null) {
                this.writableDirs.add(option);
            }
            if ((option = env.get("HOMEPATH")) != null) {
                this.writableDirs.add(option);
            }
            if ((option = env.get("ProgramFiles")) != null) {
                this.writableDirs.add(option);
            }
        }
        if (CTATEnvironment.isLocalMac()) {
            option = System.getenv("user.home");
            if (option != null) {
                this.writableDirs.add(option);
            }
            if ((option = System.getenv("HOME")) != null) {
                this.writableDirs.add(option);
            }
            if ((option = "/Applications") != null) {
                this.writableDirs.add(option);
            }
        }
        if (CTATEnvironment.isLocalAndroid() && (option = System.getProperty("java.io.tmpdir")) != null) {
            this.writableDirs.add(option);
        }
        if (CTATEnvironment.isLocalUnix() && (option = System.getenv("HOME")) != null) {
            this.writableDirs.add(option);
        }
        if (CTATEnvironment.isLocalSolaris() && (option = System.getenv("HOME")) != null) {
            this.writableDirs.add(option);
        }
        int i = this.writableDirs.size();
        while (--i >= 0) {
            String s = this.writableDirs.get(i);
            File f = new File(s);
            if (this.isDirWritable(f)) continue;
            this.writableDirs.remove(i);
        }
        return this.writableDirs.size() > 0;
    }

    public static long writableBytes(String path) {
        if (path == null) {
            path = "";
        }
        return CTATDiagnostics.writableBytes(new File(path));
    }

    public static long writableBytes(File path) {
        if (path == null) {
            path = new File("");
        }
        long usableSpace = path.getUsableSpace();
        long freeSpace = path.getFreeSpace();
        return Math.min(usableSpace, (long)(0.1 * (double)freeSpace));
    }

    public static long inMemoryCacheSize() {
        long memory = Runtime.getRuntime().totalMemory();
        return memory / 2L;
    }

    public void dumpDiagnostics(PrintWriter out) {
        File[] roots;
        URL url;
        out.println("Diagnostic output generated at " + new Date());
        out.println();
        this.testSettings(false, false);
        out.println(this.diagnosis);
        out.println("tsPort: " + CTATLink.tsPort);
        out.println("tsMonitorPort: " + CTATLink.tsMonitorPort);
        out.println("wwwPort: " + CTATLink.wwwPort);
        out.println(this.getInetInfo());
        CTATURLFetch fetcher = new CTATURLFetch();
        String host = CTATLink.remoteHost.equals("") || CTATLink.remoteHost.equals("local") ? "www.google.com" : CTATLink.remoteHost;
        try {
            url = new URL("http", host, "/");
        }
        catch (MalformedURLException e) {
            url = null;
        }
        int num = 5;
        out.print("Milliseconds taken to connect to " + host + " on " + num + " attempts (0 or negative indicates failure): ");
        for (int i = 0; i < num; ++i) {
            out.print(fetcher.checkConnectivity(url) + " ");
        }
        out.println();
        out.println();
        if (this.getWritableDirectory().booleanValue()) {
            out.println("Writable directories, in order of decreasing preference:");
            for (String string : this.writableDirs) {
                out.println(string);
            }
        } else {
            out.println("Could not find list of writable directories.");
        }
        out.println();
        out.println("Available filesystem roots, possibly excluding network drives:");
        for (File root : roots = File.listRoots()) {
            out.println("Root \"" + root + "\" " + (root.canWrite() ? "(writable)" : "(NOT directly writable)"));
            out.println("\tTotal space: " + root.getTotalSpace() + " bytes.");
            out.println("\tFree space: " + root.getFreeSpace() + " bytes.");
            out.println("\tUsable space: " + root.getUsableSpace() + " bytes.");
        }
        out.println();
        System.getProperties().list(out);
        out.println();
        out.println("Environment variables:");
        Map<String, String> map = System.getenv();
        Set<Map.Entry<String, String>> entryset = map.entrySet();
        for (Map.Entry<String, String> entry : entryset) {
            out.println(entry.getKey() + ": " + entry.getValue());
        }
        out.println();
        out.println("Cache limits");
        out.println("On-disk cache limit, determined by software based on amount of free space on disk: ");
        for (File root : roots) {
            out.println("\tAssuming root \"" + root + "\": " + CTATDiagnostics.writableBytes(root) + " byte limit.");
        }
        out.println("In-memory cache limit, based on amount of available RAM: " + CTATDiagnostics.inMemoryCacheSize() + " bytes.");
        out.println("Maximum number of cache entries, default or decided by user (configurable in config mode): " + CTATLink.maxCachedFiles);
        out.println();
        out.println("Cache statistics regarding history of cache usage on current machine");
        CTATContentCache cache = CTATLink.cache != null ? CTATLink.cache : (CTATLink.cache = new CTATContentCache(new File("./htdocs/cache"), true));
        Set<CTATContentCache.CacheEntryInfo> infoSet = cache.getInfoOnEntries();
        if (infoSet != null) {
            long totalCacheSize = 0L;
            long totalAccesses = 0L;
            for (CTATContentCache.CacheEntryInfo cei : infoSet) {
                totalCacheSize += (long)cei.size;
                totalAccesses += (long)cei.accessFrequency;
            }
            out.println("Total cache size is " + totalCacheSize + " bytes.");
            ArrayList<CTATContentCache.CacheEntryInfo> sortedByAccessFreq = new ArrayList<CTATContentCache.CacheEntryInfo>(infoSet);
            Collections.sort(sortedByAccessFreq, new Comparator<CTATContentCache.CacheEntryInfo>(){

                @Override
                public int compare(CTATContentCache.CacheEntryInfo t1, CTATContentCache.CacheEntryInfo t2) {
                    return t1.accessFrequency - t2.accessFrequency;
                }
            });
            long topHalfAccesses = 0L;
            long topHalfSize = 0L;
            for (int i = sortedByAccessFreq.size() / 2; i < sortedByAccessFreq.size(); ++i) {
                CTATContentCache.CacheEntryInfo cei = sortedByAccessFreq.get(i);
                topHalfAccesses += (long)cei.accessFrequency;
                topHalfSize += (long)cei.size;
            }
            if (totalCacheSize > 0L && totalAccesses > 0L) {
                out.println("Top 50% most accessed cache entries constitute " + topHalfAccesses * 100L / totalAccesses + "% of all cache hits and take up " + topHalfSize * 100L / totalCacheSize + "% of the total cache size.");
                out.println("Total number of cache entries: " + infoSet.size());
                out.println("Average size of a single cache entry, unweighted: " + totalCacheSize / (long)infoSet.size() + " bytes.");
                long avgSizeWeighted = 0L;
                for (CTATContentCache.CacheEntryInfo cei : infoSet) {
                    avgSizeWeighted += (long)(cei.size * cei.accessFrequency) / totalAccesses;
                }
                out.println("Average size of a single cache entry, weighted by access frequency: " + avgSizeWeighted + " bytes.");
            }
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirWritable(File f) {
        if (!f.isDirectory()) {
            return false;
        }
        File temp = null;
        try {
            temp = File.createTempFile("ctat", null, f);
            String dateString = new Date().toString();
            FileWriter writer = new FileWriter(temp);
            writer.write(dateString);
            ((Writer)writer).close();
            FileReader reader = new FileReader(temp);
            char[] chars = new char[dateString.length()];
            reader.read(chars);
            ((Reader)reader).close();
            if (dateString.equals(new String(chars))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    public void runBackgroundConnectivityChecker() {
        if (cc == null) {
            cc = new ConnectivityChecker();
            cc.setDaemon(true);
            cc.setPriority(1);
            cc.start();
        }
    }

    public static void main(String[] args) {
        JOptionPane.showMessageDialog(null, "Please specify a destination file for diagnostic output when prompted.");
        JFileChooser fc = new JFileChooser();
        int result = fc.showSaveDialog(null);
        if (result == 0) {
            File f = fc.getSelectedFile();
            try {
                f.createNewFile();
                new CTATDiagnostics().dumpDiagnostics(new PrintWriter(f));
                JOptionPane.showMessageDialog(null, "Diagnostics info has been written to " + f);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.toString() + "; " + e.getCause() + "; " + e.getMessage());
                return;
            }
        }
    }

    private class ConnectivityChecker
    extends Thread {
        private ConnectivityChecker() {
        }

        @Override
        public void run() {
            int sleepMillis = 30000;
            int tolerableResponseLatencyMillis = 3000;
            CTATURLFetch fetcher = new CTATURLFetch();
            boolean connectivityLost = false;
            while (true) {
                URL url;
                try {
                    ConnectivityChecker.sleep(30000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                String remoteHost = CTATLink.remoteHost;
                if (remoteHost == null || remoteHost.equals("") || remoteHost.equals("local")) continue;
                try {
                    url = new URL("http", remoteHost, "/");
                }
                catch (MalformedURLException e) {
                    url = null;
                }
                long result = fetcher.checkConnectivity(url);
                if (!connectivityLost) {
                    if (result >= 0L && result <= 3000L) continue;
                    connectivityLost = true;
                    this.lostConnectivity(remoteHost);
                    continue;
                }
                if (result < 0L || result > 3000L) continue;
                connectivityLost = false;
                if (!OnlineOfflineManager.isOffline()) continue;
                this.regainedConnectivity();
            }
        }

        private void lostConnectivity(String remoteHost) {
            JFrame frame = new JFrame();
            frame.setAlwaysOnTop(true);
            frame.setVisible(true);
            frame.setVisible(false);
            int response = JOptionPane.showOptionDialog(frame, "The connection to " + remoteHost + " has been lost or is very slow.\nWould you like to switch to offline mode?", "Local TutorShop -- Bad connection", 0, 2, null, null, null);
            if (response == 0) {
                OnlineOfflineManager.goOffline();
            }
            frame.dispose();
        }

        private void regainedConnectivity() {
            JFrame frame = new JFrame();
            frame.setAlwaysOnTop(true);
            frame.setVisible(true);
            frame.setVisible(false);
            JOptionPane.showMessageDialog(frame, "Connectivity has been regained. Switching back to online mode...");
            OnlineOfflineManager.goOnline();
            frame.dispose();
        }
    }
}

