/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATCurriculum;
import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATHTTPLocalHandler;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATObjectTagDriver;
import edu.cmu.hcii.ctat.CTATProblem;
import edu.cmu.hcii.ctat.CTATProblemSet;
import edu.cmu.hcii.ctat.CTATUserData;
import edu.cmu.hcii.ctat.CTATWebTools;
import edu.cmu.hcii.ctat.OnlineOfflineManager;
import edu.cmu.hcii.ctat.PositionWithinAssignment;
import edu.cmu.hcii.ctat.UserProgressDatabase;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Map;

public class CTATOfflineHTTPHandler
extends CTATHTTPLocalHandler
implements CTATHTTPHandlerInterface {
    private final String filesep;
    private final String templatesPath;

    public CTATOfflineHTTPHandler(String aLogFile, UserProgressDatabase upd, CTATCurriculum aCurriculum) {
        super(aLogFile, upd);
        this.setClassName("CTATOfflineHTTPHandler");
        this.debug("CTATOfflineHTTPHandler ()");
        this.setCurriculum(aCurriculum);
        this.filesep = System.getProperty("file.separator");
        this.templatesPath = CTATLink.htdocs + this.filesep + "templates" + this.filesep;
        if (upd != null) {
            CTATLink.userProgress = upd;
        } else {
            UserProgressDatabase userProgressTemp;
            try {
                userProgressTemp = new UserProgressDatabase();
            }
            catch (IOException e) {
                userProgressTemp = null;
            }
            CTATLink.userProgress = userProgressTemp;
        }
    }

    @Override
    public boolean handle(CTATHTTPExchange exchange, String requestBodyAsString) {
        String details;
        String[] split;
        this.debug("handle ()");
        if (this.getCurriculum() == null) {
            this.debug("Error: this.getCurriculum() object is null");
            return false;
        }
        if (CTATLink.userProgress == null) {
            this.debug("Error: user progress database is null");
            return false;
        }
        String requestMethod = exchange.getRequestMethod();
        URI requestURI = exchange.getRequestURI();
        String path = requestURI.getPath();
        this.debug("Request path: " + path);
        if (path.startsWith("/run_assignment") && !path.endsWith("getpush.cgi")) {
            this.currentAssignment = path.substring(path.lastIndexOf(47) + 1);
        }
        if (path.startsWith("/run_student_assignment") && !path.endsWith("getpush.cgi") && (split = (details = path.substring("run_student_assignment".length())).split("/")).length == 3) {
            String studentAssignment = split[1];
            String problem = split[2];
            CTATUserData ua = CTATLink.userProgress.getUser(CTATLink.userID);
            if (CTATLink.userID == null) {
                exchange.send404("Error: user " + CTATLink.userID + " does not exist");
                return true;
            }
            if (ua == null) {
                exchange.send404("Error: user " + CTATLink.userID + " does not exist");
                return true;
            }
            if (CTATLink.userProgress == null) {
                exchange.send404("Error: internal user database does not exist");
                return true;
            }
            if (this.currentAssignment == null) {
                this.debug("received run_student_assignment request when currentAssignment was null; cannot update userProgressDatabase");
            }
            try {
                CTATLink.userProgress.setCurrentProblem(CTATLink.userID, this.currentAssignment, studentAssignment, Integer.valueOf(problem), true);
            }
            catch (Exception e) {
                exchange.send404(e.getMessage());
                return true;
            }
        }
        boolean handled = false;
        if (requestMethod.equalsIgnoreCase("POST")) {
            BufferedInputStream in;
            this.debug("Processing POST request");
            if (path.startsWith("/process_student_assignment")) {
                int currentProblemNumber;
                in = new BufferedInputStream(exchange.getRequestBody());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    int b;
                    while ((b = ((InputStream)in).read()) != -1) {
                        baos.write(b);
                    }
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    return false;
                }
                byte[] requestBody = baos.toByteArray();
                String currentStudentAssignment = null;
                String[] split2 = path.split("/");
                if (split2.length == 4) {
                    currentStudentAssignment = split2[2];
                    try {
                        currentProblemNumber = Integer.valueOf(split2[3]);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        return false;
                    }
                } else {
                    return false;
                }
                CTATWebTools webTools = new CTATWebTools();
                Map<String, String> map = webTools.parseQuery(new String(requestBody));
                String summary = map.get("summary");
                String skills = map.get("skills");
                String problem_state = map.get("problem_state");
                if (skills != null) {
                    this.debug("We have skills: " + skills);
                }
                try {
                    if (summary != null) {
                        this.debug("We have a problem summary! " + summary);
                        CTATLink.userProgress.setProblemSummary(CTATLink.userID, this.getCurriculum().getAssignment(currentStudentAssignment), currentStudentAssignment, currentProblemNumber, summary, false);
                        CTATLink.userProgress.setProblemState(CTATLink.userID, this.getCurriculum().getAssignment(currentStudentAssignment), currentStudentAssignment, currentProblemNumber, problem_state, false);
                    } else {
                        this.debug("Warning: no problem summary provided by tutor");
                    }
                    CTATLink.userProgress.saveUserProgress(CTATLink.userID);
                }
                catch (IOException e) {
                    this.sendString(exchange, "An error occurred when trying to write user information to disk.");
                }
                boolean problemComplete = false;
                if (summary != null) {
                    try {
                        summary = URLDecoder.decode(summary, "UTF-8");
                        if (summary.contains("CompletionStatus=\"complete\"")) {
                            problemComplete = true;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (!problemComplete) {
                    return this.sendString(exchange, "ok");
                }
                int numProblems = this.getCurriculum().getNumberOfProblemsInProbset(currentStudentAssignment);
                if (currentProblemNumber + 1 <= numProblems) {
                    try {
                        CTATLink.userProgress.setCurrentProblem(CTATLink.userID, this.getCurriculum().getAssignment(currentStudentAssignment), currentStudentAssignment, currentProblemNumber + 1, true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                    handled = this.redirectTo(exchange, "/start_student_assignment/" + currentStudentAssignment);
                } else {
                    CTATUserData aUser = CTATLink.userProgress.getUser(CTATLink.userID);
                    try {
                        CTATLink.userProgress.setCurrentProblem(CTATLink.userID, this.getCurriculum().getAssignment(currentStudentAssignment), currentStudentAssignment, currentProblemNumber + 1, true);
                        if (aUser != null) {
                            aUser.milestoneManager.checkProblemSetMilestone(currentStudentAssignment);
                            this.debug("Checking milestone for completion of problem set " + currentStudentAssignment);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                    String next = this.getCurriculum().getNextStudentAssignment(currentStudentAssignment);
                    if (next == null) {
                        if (aUser != null) {
                            String assignmentName = this.getCurriculum().getAssignment(currentStudentAssignment);
                            aUser.milestoneManager.checkAssignmentMilestone(assignmentName);
                            this.debug("Checking milestone for completion of assignment " + assignmentName);
                        } else {
                            this.debug("Internal error: unable to find user to check off assignment milestone");
                        }
                        next = "completed";
                    }
                    handled = this.redirectTo(exchange, "/start_student_assignment/" + next);
                }
            } else if (path.equals("/log")) {
                if (!CTATLink.remoteHost.isEmpty() && !CTATLink.remoteHost.equalsIgnoreCase("local")) {
                    in = new BufferedInputStream(exchange.getRequestBody());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int b;
                        while ((b = ((InputStream)in).read()) != -1) {
                            baos.write((byte)b);
                        }
                    }
                    catch (IOException e) {
                        return false;
                    }
                    byte[] messageBody = baos.toByteArray();
                    OnlineOfflineManager.sendStuffWhenOnline("http://" + CTATLink.remoteHost + "/log", messageBody);
                    handled = this.sendString(exchange, "ok");
                } else {
                    handled = false;
                }
            }
        } else if (requestMethod.equalsIgnoreCase("GET")) {
            String[] pathSplit;
            String response;
            this.debug("Processing GET request");
            if (path.equals("/student/home")) {
                this.debug("Processing /student/home");
                response = CTATLink.fManager.getContents(this.templatesPath + "home.html");
                handled = this.sendString(exchange, response);
            } else if (path.equals("/student/basics")) {
                this.debug("Processing /student/basics");
                response = CTATLink.fManager.getContents(this.templatesPath + "basics.html");
                handled = this.sendString(exchange, response);
            } else if (path.equals("/student/bug")) {
                this.debug("Processing /student/bug");
                response = CTATLink.fManager.getContents(this.templatesPath + "bug.html");
                handled = this.sendString(exchange, response);
            } else if (path.equals("/student/asteroid")) {
                this.debug("Processing /student/asteroid");
                response = CTATLink.fManager.getContents(this.templatesPath + "asteroid.html");
                handled = this.sendString(exchange, response);
            } else if (path.equals("/student/tutorial")) {
                this.debug("Processing /student/tutorial");
                response = CTATLink.fManager.getContents(this.templatesPath + "tutorial.html");
                handled = this.sendString(exchange, response);
            } else if (path.equals("/student/botsinsync")) {
                this.debug("Processing /student/botsinsync");
                response = CTATLink.fManager.getContents(this.templatesPath + "botsinsync.html");
                handled = this.sendString(exchange, response);
            } else if (path.equals("/active")) {
                this.debug("Processing /active");
                handled = this.sendString(exchange, "true");
            } else if (path.equals("/logout")) {
                this.debug("Processing /logout");
                handled = this.redirectTo(exchange, "/exittutorshop.cgi");
            } else if (path.contains("run_assignment")) {
                String studentAssignmentName;
                this.debug("Processing run_assignment");
                pathSplit = path.split("/");
                String assignmentName = pathSplit[pathSplit.length - 1];
                String template = CTATLink.fManager.getContents(this.templatesPath + "run_assignment.html");
                PositionWithinAssignment pwa = CTATLink.userProgress.getCurrentProblem(CTATLink.userID, assignmentName);
                if (pwa != null) {
                    studentAssignmentName = pwa.problemSet;
                } else {
                    try {
                        studentAssignmentName = this.getCurriculum().getFirstProblemSet(assignmentName);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                if (studentAssignmentName == null) {
                    exchange.sendResponseHeaders(404, 0L);
                    exchange.close();
                    return true;
                }
                String response2 = template.replace("STUDENT_ASSIGNMENT_ID", studentAssignmentName);
                response2 = response2.replace("ASSIGNMENT_NAME", assignmentName);
                String exitURL = exchange.getRequestHeaderConcatenated("Referer");
                if (exitURL == null) {
                    exitURL = "http://" + CTATLink.hostName + ":" + CTATLink.wwwPort + "/";
                }
                response2 = response2.replace("EXIT_URL", exitURL);
                handled = this.sendString(exchange, response2);
            } else if (path.contains("start_student_assignment")) {
                int numProblemsInSet;
                this.debug("Processing start_student_assignment");
                String studentAssignmentName = path.substring(path.lastIndexOf("/") + 1);
                if (studentAssignmentName.equals("completed")) {
                    String response3 = CTATLink.fManager.getContents(this.templatesPath + "student_assignment_completed.html");
                    if (response3 == null) {
                        exchange.send404("Error: template " + this.templatesPath + "student_assignment_completed.html not found");
                        return true;
                    }
                    CTATUserData aUser = CTATLink.userProgress.getUser(CTATLink.userID);
                    boolean milestoneHtmlGenerated = false;
                    boolean milestonesExist = false;
                    if (aUser != null) {
                        this.debug("Completed assignment; getting milestone HTML");
                        String milestoneString = aUser.getMilestoneManager().generateMilestoneHTML();
                        boolean bl = milestonesExist = milestoneString != null;
                        if (milestonesExist) {
                            String milestonesEncoded = CTATObjectTagDriver.encodeHTML(milestoneString);
                            response3 = response3.replace("MILESTONES", milestonesEncoded);
                            milestoneHtmlGenerated = true;
                            this.debug("Generated html: " + response3);
                        }
                    } else {
                        this.debug("Generated html: " + response3);
                    }
                    if (!milestonesExist) {
                        this.debug("No milestones; removing data-milestones tag");
                        response3 = response3.replaceAll("data-milestones='MILESTONES'", "");
                    }
                    handled = this.sendString(exchange, response3);
                    if (milestoneHtmlGenerated && handled && aUser != null) {
                        aUser.milestoneManager.markShown();
                    }
                    return handled;
                }
                int problemNumber = CTATLink.userProgress.getPositionWithinProblemSet(CTATLink.userID, studentAssignmentName);
                if (problemNumber < 0) {
                    problemNumber = 1;
                }
                if ((numProblemsInSet = this.getCurriculum().getNumberOfProblemsInProbset(studentAssignmentName)) == 0) {
                    return this.sendString(exchange, "Problem set " + studentAssignmentName + " does not include any problems. This may be due to a missing XML file.");
                }
                if (problemNumber > numProblemsInSet) {
                    return this.redirectTo(exchange, "/start_student_assignment/completed");
                }
                String template = CTATLink.fManager.getContents(this.templatesPath + "start_student_assignment.html");
                String response4 = template.replace("STUDENT_ASSIGNMENT_ID", studentAssignmentName);
                response4 = response4.replace("PROBLEM_NUMBER", "" + problemNumber);
                response4 = response4.replace("HOST_NAME", CTATLink.hostName);
                response4 = response4.replace("PORT_NUMBER", "" + CTATLink.wwwPort);
                handled = this.sendString(exchange, response4);
            } else if (path.contains("run_student_assignment")) {
                int problemNumber;
                this.debug("Processing run_student_assignment");
                pathSplit = path.split("/");
                String problemSetName = pathSplit[pathSplit.length - 2];
                try {
                    problemNumber = Integer.valueOf(pathSplit[pathSplit.length - 1]);
                }
                catch (NumberFormatException e) {
                    this.debug("NumberFormatException: " + e.getMessage());
                    return false;
                }
                this.debug("The student just finished problem number " + problemNumber + " from problem set: " + problemSetName);
                int highestLegalProblemNumber = CTATLink.userProgress.getPositionWithinProblemSet(CTATLink.userID, problemSetName);
                if (highestLegalProblemNumber <= 0) {
                    highestLegalProblemNumber = 1;
                }
                if (problemNumber > highestLegalProblemNumber) {
                    exchange.send404("Not found");
                    return true;
                }
                String template = CTATLink.fManager.getContents(this.templatesPath + "run_student_assignment.html");
                CTATProblemSet probset = null;
                CTATProblem problem = null;
                String problemSetActivationStatus = this.getCurriculum().getProblemSetActivationStatus(problemSetName);
                if (problemSetActivationStatus == null) {
                    this.sendString(exchange, "<html><body>Error: Problem Set name \"" + problemSetName + "\" is not recognized.<br/><a href=\"http://" + CTATLink.hostName + ":" + CTATLink.wwwPort + "/\">Return to main page</a></body></html>");
                    return true;
                }
                probset = this.getCurriculum().getProblemSet(problemSetName);
                probset.setCurrentIndex(problemNumber - 2);
                problem = probset.getNextProblem();
                probset.deActivate();
                if (problem == null) {
                    String next = this.getCurriculum().getNextStudentAssignment(problemSetName);
                    if (next == null) {
                        next = "completed";
                    }
                    return this.redirectTo(exchange, "/start_student_assignment/" + next);
                }
                problem.setActive(true);
                this.debug("Replacing tags in template: allowWriting " + CTATLink.allowWriting + ", showNavButtons " + CTATLink.showNavButtons);
                String problemMenu = this.directoryToMenu();
                String flashTags = this.fTagGenerator.generateObjectTags(problem, probset, problemNumber, problemSetActivationStatus);
                template = template.replaceFirst("flashtags", flashTags);
                template = template.replaceFirst("ProblemSetTitle", problem.name + " : " + probset.getDescription() + " : " + probset.getName());
                template = template.replaceFirst("directory.txt", problemMenu);
                handled = this.sendString(exchange, template);
            } else if (path.contains("restore_student_assignment")) {
                int problemNumber;
                this.debug("Processing restore_student_assignment");
                pathSplit = path.split("/");
                String studentAssignmentName = pathSplit[pathSplit.length - 2];
                try {
                    problemNumber = Integer.valueOf(pathSplit[pathSplit.length - 1]);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                int highestLegalProblemNumber = CTATLink.userProgress.getPositionWithinProblemSet(CTATLink.userID, studentAssignmentName);
                if (highestLegalProblemNumber <= 0) {
                    highestLegalProblemNumber = 1;
                }
                if (problemNumber > highestLegalProblemNumber) {
                    exchange.send404("Not found");
                    return true;
                }
                String problem_state = CTATLink.userProgress.getProblemState(CTATLink.userID, this.getCurriculum().getAssignment(studentAssignmentName), studentAssignmentName, problemNumber);
                if (problem_state == null) {
                    return false;
                }
                handled = this.sendString(exchange, problem_state);
            }
        } else if (requestMethod.equalsIgnoreCase("HEAD")) {
            this.debug("Processing HEAD request (not implemented)");
            exchange.sendResponseHeaders(501, 0L);
            handled = true;
        } else {
            handled = false;
        }
        this.debug("Handled: " + handled);
        if (!handled) {
            handled = super.handle(exchange, requestBodyAsString);
        } else {
            exchange.close();
        }
        return handled;
    }
}

