/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATProblem;
import edu.cmu.hcii.ctat.CTATSkill;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CTATProblemSet
extends CTATBase {
    private ArrayList<CTATProblem> problems;
    private int current = -1;
    private ArrayList<CTATSkill> skills;
    private int counter = 0;
    private boolean loaded = false;
    private String directory = "";
    private String name = "";
    private String description = "";
    private Element root;
    public Integer initialSequence = -1;

    public CTATProblemSet() {
        this.setClassName("CTATProblemSet");
        this.debug("CTATProblemSet ()");
        this.problems = new ArrayList();
        this.setSkills(new ArrayList<CTATSkill>());
    }

    public void deActivate() {
        this.debug("deActivate (" + this.name + ")");
        for (int i = 0; i < this.problems.size(); ++i) {
            CTATProblem problem = this.problems.get(i);
            problem.setActive(false);
        }
    }

    public void listProblemSet() {
        this.debug("listProblemSet (" + this.name + ")");
        for (int i = 0; i < this.problems.size(); ++i) {
            CTATProblem problem = this.problems.get(i);
            this.debug(problem.index + " : " + problem.description + " : " + problem.name);
        }
    }

    public String listProblemSetHTML() {
        this.debug("listProblemSetHTML (" + this.name + ")");
        StringBuffer formatted = new StringBuffer();
        formatted.append("<ul>");
        for (int i = 0; i < this.problems.size(); ++i) {
            CTATProblem problem = this.problems.get(i);
            if (problem.getActive().booleanValue()) {
                formatted.append("<li><font color=\"#ff0000\">" + problem.name + " : " + problem.description + "</font>");
                continue;
            }
            formatted.append("<li>" + problem.name + " : " + problem.description);
        }
        formatted.append("</ul>");
        return formatted.toString();
    }

    public void reset() {
        this.debug("reset ()");
        this.current = -1;
    }

    public void setLoaded(boolean aVal) {
        this.debug("setLoaded (" + aVal + ")");
        this.loaded = aVal;
    }

    public boolean isLoaded() {
        this.debug("isLoaded ()");
        return this.loaded;
    }

    public int getNextIndex() {
        this.debug("getNextIndex ()");
        return this.current + 2;
    }

    public void setCurrentIndex(int anIndex) {
        this.debug("setCurrentIndex (" + anIndex + ")");
        this.current = anIndex;
    }

    public CTATProblem getNextProblem() {
        ++this.current;
        this.debug("getNextProblem (" + this.current + ")");
        this.listProblemSet();
        try {
            CTATProblem nextProblem = this.problems.get(this.current);
            this.debug("The next problem is: " + nextProblem.name);
            return nextProblem;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getNumProblems() {
        this.debug("getNumProblems ()");
        return this.problems.size();
    }

    public List<CTATProblem> getAllProblems() {
        List<CTATProblem> list;
        if (this.problems == null) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList<CTATProblem>(this.problems.size());
            for (CTATProblem prob : this.problems) {
                list.add(prob);
            }
        }
        return list;
    }

    public boolean processNewProblemXML(Node aProblem) {
        int j;
        this.debug("processNewProblemXML ()");
        CTATProblem newProblem = new CTATProblem();
        newProblem.problem_path = "FlashTutors/" + this.directory + "/";
        NamedNodeMap attr = aProblem.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            Attr attribute = (Attr)attr.item(i);
            this.debug("Attribute: " + attribute.getName() + " = " + attribute.getValue());
            if (attribute.getName().equals("name")) {
                newProblem.name = attribute.getValue();
            }
            if (attribute.getName().equals("tutor_flag")) {
                newProblem.tutor_flag = attribute.getValue();
            }
            if (attribute.getName().equals("problem_file")) {
                newProblem.problem_file = attribute.getValue();
            }
            if (attribute.getName().equals("description")) {
                newProblem.description = attribute.getValue();
            }
            if (!attribute.getName().equals("student_interface")) continue;
            newProblem.student_interface = attribute.getValue();
        }
        NodeList children = aProblem.getChildNodes();
        NodeList skillNodes = null;
        for (j = 0; j < children.getLength(); ++j) {
            Node childNode = children.item(j);
            if (!childNode.getNodeName().equals("Skills")) continue;
            skillNodes = childNode.getChildNodes();
            break;
        }
        if (skillNodes != null) {
            for (j = 0; j < skillNodes.getLength(); ++j) {
                int occurrences;
                String skillName;
                NamedNodeMap skillAttributes;
                Node skillNameNode;
                Node skillNode = skillNodes.item(j);
                if (!skillNode.getNodeName().equals("Skill") || (skillNameNode = (skillAttributes = skillNode.getAttributes()).getNamedItem("name")) == null || (skillName = skillNameNode.getNodeValue()) == null) continue;
                CTATSkill matchingSkill = null;
                for (CTATSkill skill : this.skills) {
                    if (!skill.name.equals(skillName)) continue;
                    matchingSkill = skill;
                    break;
                }
                if (matchingSkill == null) continue;
                Node occurrencesNode = skillAttributes.getNamedItem("occurrences");
                if (occurrencesNode == null) {
                    occurrences = 1;
                } else {
                    try {
                        occurrences = Integer.valueOf(occurrencesNode.getNodeValue());
                    }
                    catch (Exception e) {
                        occurrences = 1;
                    }
                }
                newProblem.addSkill(matchingSkill, occurrences);
            }
        }
        newProblem.index = this.counter++;
        this.problems.add(newProblem);
        return true;
    }

    public boolean loadProblemSet(String aFile) {
        this.debug("loadProblemSet (" + aFile + ")");
        if (this.loaded) {
            this.debug("Already loaded");
            return true;
        }
        if (!this.readProblemSet(aFile)) {
            this.debug("Can't read problem set!");
            return false;
        }
        if (this.root == null) {
            this.debug("Error: can't load: " + aFile);
            return false;
        }
        if (this.root.getNodeName().equals("ProblemSet")) {
            this.debug("Found ProblemSet element");
            NamedNodeMap attr = this.root.getAttributes();
            for (int t = 0; t < attr.getLength(); ++t) {
                Attr attribute = (Attr)attr.item(t);
                this.debug("Attribute: " + attribute.getName() + " = " + attribute.getValue());
                if (!attribute.getName().equals("initial_sequence")) continue;
                this.initialSequence = Integer.parseInt(attribute.getValue());
                this.debug("Initial sequence: " + this.initialSequence);
            }
            ArrayList<Node> problemsToProcess = new ArrayList<Node>();
            NodeList problemSet = this.root.getChildNodes();
            for (int i = 0; i < problemSet.getLength(); ++i) {
                int j;
                Node node = problemSet.item(i);
                if (node.getNodeName().equals("Problems")) {
                    this.debug("Found Problems element");
                    NodeList problems = node.getChildNodes();
                    for (j = 0; j < problems.getLength(); ++j) {
                        Node problem = problems.item(j);
                        if (!problem.getNodeName().equals("Problem")) continue;
                        problemsToProcess.add(problem);
                    }
                }
                if (!node.getNodeName().equals("Skills")) continue;
                this.debug("Found Skills element for problem set.");
                NodeList skillsList = node.getChildNodes();
                for (j = 0; j < skillsList.getLength(); ++j) {
                    Node skillNode = skillsList.item(j);
                    if (!skillNode.getNodeName().equals("Skill")) continue;
                    CTATSkill skill = new CTATSkill(skillNode);
                    this.skills.add(skill);
                }
            }
            for (Node problem : problemsToProcess) {
                this.processNewProblemXML(problem);
            }
        }
        this.loaded = true;
        return true;
    }

    public String buildMenuHTML() {
        this.debug("buildMenuHTML  ()");
        StringBuffer menu = new StringBuffer();
        String encoded = "";
        menu.append("<ul>");
        for (int i = 0; i < this.problems.size(); ++i) {
            CTATProblem problem = this.problems.get(i);
            menu.append("<li><a href=\"http://127.0.0.1:" + CTATLink.wwwPort + "/gotoproblem.cgi?position=" + problem.index + "\">" + problem.description + "</a></li>");
        }
        menu.append("</ul><br style=\"clear: left\" />");
        try {
            encoded = URLEncoder.encode(menu.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
        return encoded;
    }

    public void setSkills(ArrayList<CTATSkill> skills) {
        this.skills = skills;
    }

    public ArrayList<CTATSkill> getSkills() {
        return this.skills;
    }

    public boolean readProblemSet(String aFile) {
        this.debug("readProblemSet (" + aFile + ")");
        this.loaded = false;
        if (CTATLink.problemSetXMLsAreEncrypted) {
            this.debug("Attempting load encrypted problem set ...");
            this.root = CTATLink.fManager.getContentsXMLEncrypted(aFile);
        } else {
            this.debug("Attempting load non-encrypted problem set ...");
            this.root = CTATLink.fManager.getContentsXML(aFile);
        }
        if (this.root == null) {
            this.debug("Error: can't load: " + aFile);
            return false;
        }
        if (this.root.getNodeName().equals("ProblemSet")) {
            this.directory = new File(aFile).getParentFile().getName();
            this.name = this.root.getAttribute("name");
            this.description = this.root.getAttribute("description");
            this.debug("Directory: " + this.directory + "; Name: " + this.name + "; Description: " + this.description);
        }
        return true;
    }

    public String getDirectory() {
        return this.directory;
    }

    void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public String getSkillsXML() {
        StringBuilder returnValue = new StringBuilder("<Skills>");
        for (CTATSkill skill : this.skills) {
            returnValue.append(skill.toString());
        }
        returnValue.append("</Skills>");
        return returnValue.toString();
    }

    public int countRemainingProblems() {
        return this.getNumProblems() - this.current - 1;
    }
}

