/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATLink;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JProgressBar;

public class CTATURLFetch
extends CTATBase
implements PropertyChangeListener {
    private JProgressBar updater = null;
    private byte[] binaryData = null;
    private String internalURLCache = "";

    public CTATURLFetch() {
        this.setClassName("CTATURLFetch");
        this.debug("CTATURLFetch ()");
    }

    public String getObtainedURL() {
        return this.internalURLCache;
    }

    public static String prepURL(String address) {
        CTATLink.debug("CTATURLFetch", "(static) prepURL (String address)");
        String result = null;
        result = address.indexOf("https") == -1 ? "https://" + address : address;
        return result;
    }

    public String fetchURL(String address) throws MalformedURLException, IOException {
        this.debug("fetchURL (" + address + ")");
        this.internalURLCache = CTATURLFetch.prepURL(address);
        this.debug("Fetching prepped url: " + this.internalURLCache);
        URL url = new URL(this.internalURLCache);
        StringBuffer total = new StringBuffer();
        URLConnection conn = url.openConnection();
        conn.setDoInput(true);
        try {
            conn.connect();
        }
        catch (Exception e) {
            CTATLink.lastError = "Cannot obtain: " + address + " : " + e.getMessage();
            this.debug(CTATLink.lastError);
            return "";
        }
        int blocks = 0;
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                System.out.println(inputLine);
                total.append(inputLine);
                ++blocks;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        this.debug("Received (" + blocks + " blocks): " + total.toString());
        return total.toString();
    }

    public String fetchURL(String aServer, String aPath) throws MalformedURLException, IOException {
        this.debug("fetchURL (http , " + aServer + " , " + aPath + ")");
        this.internalURLCache = "http://" + aServer + aPath;
        this.debug("Fetching prepped url: " + this.internalURLCache);
        URL url = new URL(this.internalURLCache);
        StringBuffer total = new StringBuffer();
        URLConnection conn = url.openConnection();
        conn.setDoInput(true);
        try {
            conn.connect();
        }
        catch (Exception e) {
            this.debug("cannot obtain: " + this.internalURLCache);
            return "";
        }
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                total.append(inputLine);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return total.toString();
    }

    public Boolean fetchURLBinary(String aServer, String aPath) throws MalformedURLException, IOException {
        this.internalURLCache = "http://" + aServer + aPath;
        return this.getHTTPBinaryFile(aServer, aPath);
    }

    public Image fetchImage(String address, Component c) throws MalformedURLException, IOException {
        this.debug("fetchImage (" + address + ")");
        URL url = new URL(address);
        return c.createImage((ImageProducer)url.getContent());
    }

    public boolean sendData(String address, String aData) throws MalformedURLException, IOException {
        this.debug("sendData (" + address + ")");
        try {
            URL url = new URL(address);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(aData);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = rd.readLine()) != null) {
            }
            wr.close();
            rd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.debug("propertyChange ()");
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            if (this.updater != null) {
                this.updater.setValue(progress);
            } else {
                this.debug("Error no progress bar object available");
            }
        }
    }

    public Boolean getHTTPBinaryFile(String aURL, String aLocation) {
        this.debug("getHTTPBinaryFile (" + aURL + ")");
        URL u = null;
        try {
            u = new URL(aURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        URLConnection uc = null;
        try {
            uc = u.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        String contentType = uc.getContentType();
        int contentLength = uc.getContentLength();
        if (contentType.startsWith("text/") || contentLength == -1) {
            this.debug("This is not a binary file.");
            return false;
        }
        InputStream raw = null;
        try {
            raw = uc.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        BufferedInputStream in = new BufferedInputStream(raw);
        byte[] data = new byte[contentLength];
        int bytesRead = 0;
        int offset = 0;
        CTATContentCache.UI.setVisualProgress(0);
        while (offset < contentLength) {
            try {
                bytesRead = ((InputStream)in).read(data, offset, data.length - offset);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (bytesRead == -1) break;
            CTATContentCache.UI.setVisualProgress((offset += bytesRead) * 100 / contentLength);
            System.out.print(".");
        }
        System.out.print("\n");
        try {
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (offset != contentLength) {
            this.debug("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            return false;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(aLocation);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            out.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public byte[] getData() {
        return this.binaryData;
    }

    public long checkConnectivity(URL url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("HEAD");
            long start = System.currentTimeMillis();
            conn.connect();
            long end = System.currentTimeMillis();
            conn.disconnect();
            return end - start;
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

