/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.env;

import edu.cmu.hcii.ctat.env.CTATEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CTATProcessRunner
extends CTATEnvironment {
    private boolean verbose = false;

    public CTATProcessRunner() {
        this(false);
    }

    public CTATProcessRunner(boolean verbose) {
        this.setClassName("CTATProcessRunner");
        this.debug("CTATProcessRunner ()");
        this.verbose = verbose;
    }

    public String exec(String[] execCmd) {
        Process cvsProc = null;
        StringBuffer cmd = new StringBuffer();
        try {
            for (int i = 0; i < execCmd.length; ++i) {
                cmd.append(execCmd[i]).append(' ');
            }
            if (this.verbose) {
                System.err.println("execCmd[" + cmd + "]");
            }
            cvsProc = Runtime.getRuntime().exec(execCmd);
        }
        catch (Exception e) {
            System.err.println("Exception on executing: " + execCmd);
            e.printStackTrace();
            return "";
        }
        StreamGobbler errorGobbler = new StreamGobbler(cvsProc.getErrorStream(), "ERROR");
        StringBuffer sb = new StringBuffer();
        StreamGobbler outputGobbler = new StreamGobbler(cvsProc.getInputStream(), "OUTPUT", sb);
        errorGobbler.start();
        outputGobbler.start();
        try {
            if (cvsProc.waitFor() != 0) {
                System.err.println("process " + cmd + " exit value = " + cvsProc.exitValue());
            }
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
        try {
            outputGobbler.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static boolean isLocalWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isLocalAndroid() {
        String os = System.getProperty("java.vendor").toLowerCase();
        return os.indexOf("android") >= 0;
    }

    public static boolean isLocalMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isLocalUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static boolean isLocalSolaris() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("sunos") >= 0;
    }

    public String getLocalProcesses() {
        this.debug("getLocalProcesses ()");
        StringBuffer buffer = new StringBuffer();
        if (CTATProcessRunner.isLocalWindows()) {
            this.debug("Executing Windows version of ps ...");
            try {
                String line;
                Process p = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        } else {
            this.debug("Executing Unix version of ps ...");
            try {
                String line;
                Process p = Runtime.getRuntime().exec("ps -e");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public String getLocalNetstat() {
        this.debug("getLocalNetstat ()");
        StringBuffer buffer = new StringBuffer();
        if (CTATProcessRunner.isLocalWindows()) {
            this.debug("Executing Windows version of netstat ...");
            try {
                String line;
                Process p = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\netstat.exe -anot");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        } else {
            this.debug("Executing Unix version of netstat ...");
            try {
                String line;
                Process p = Runtime.getRuntime().exec("netstat -anop tcp");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        return buffer.toString();
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String label;
        StringBuffer outBuf;

        StreamGobbler(InputStream is, String label) {
            this(is, label, null);
        }

        StreamGobbler(InputStream is, String label, StringBuffer outBuf) {
            this.is = is;
            this.label = label != null && label.length() > 0 ? label + "> " : "";
            this.outBuf = outBuf;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.outBuf == null) {
                        CTATProcessRunner.this.debug(this.label + line);
                        continue;
                    }
                    this.outBuf.append(line);
                    this.outBuf.append('\n');
                }
                if (this.outBuf != null && CTATProcessRunner.this.verbose) {
                    System.err.println("debug " + this.label + ":\n" + this.outBuf);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

