/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATLogSnoopInterface;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CTATStreamedTableDiskLogger
extends CTATBase
implements CTATLogSnoopInterface {
    private String fileID = "undefined";
    private CTATDesktopFileManager fManager = null;
    private String dateCheck = "";
    private Boolean includeDate = true;

    public CTATStreamedTableDiskLogger() {
        this.setClassName("CTATStreamedTableDiskLogger");
        this.debug("CTATStreamedTableDiskLogger ()");
        this.fManager = new CTATDesktopFileManager();
    }

    public Boolean getIncludeDate() {
        return this.includeDate;
    }

    public void setIncludeDate(Boolean includeDate) {
        this.includeDate = includeDate;
    }

    public String getDateCheck() {
        return this.dateCheck;
    }

    public void setDateCheck(String dateCheck) {
        this.debug("setDateCheck (" + dateCheck + ")");
        this.dateCheck = dateCheck;
    }

    public void checkLogging() {
        SimpleDateFormat dateFormatCheck = new SimpleDateFormat("dd");
        Date date = new Date();
        String check = dateFormatCheck.format(date);
        if (!check.equals(this.getDateCheck())) {
            this.debug("Rolling over log file ...");
            this.fManager.closeStream();
            if (this.includeDate.booleanValue()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                this.fManager.openStream(CTATLink.logdir + "/" + this.fileID + "-" + dateFormat.format(date) + ".txt");
            } else {
                this.fManager.openStream(CTATLink.logdir + "/" + this.fileID + ".txt");
            }
            this.setDateCheck(dateFormatCheck.format(date));
        }
    }

    public String getFileID() {
        return this.fileID;
    }

    public void setFileID(String fileID) {
        this.debug("setFileID ()");
        this.fileID = fileID;
        if (!this.fileID.equals("undefined") && !this.fManager.isStreamOpen()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            Date date = new Date();
            SimpleDateFormat dateFormatCheck = new SimpleDateFormat("dd");
            this.setDateCheck(dateFormatCheck.format(date));
            if (this.includeDate.booleanValue()) {
                this.fManager.openStream(CTATLink.logdir + "/" + this.fileID + "-" + dateFormat.format(date) + ".txt");
            } else {
                this.fManager.openStream(CTATLink.logdir + "/" + this.fileID + ".txt");
            }
        }
    }

    @Override
    public void addLine(String aLine) {
        if (aLine.indexOf(10) != -1) {
            this.fManager.writeToStream(aLine);
        } else {
            this.fManager.writeToStream(aLine + "\n");
        }
    }
}

