/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATBase;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CTATXMLBase
extends CTATBase {
    public CTATXMLBase() {
        this.setClassName("CTATXMLBase");
    }

    public void debugSAXException(SAXParseException spe) {
        StringBuffer sb = new StringBuffer(spe.toString());
        sb.append("\n Line number: " + spe.getLineNumber());
        sb.append("\n Column number: " + spe.getColumnNumber());
        sb.append("\n Public ID: " + spe.getPublicId());
        sb.append("\n System ID: " + spe.getSystemId() + "\n");
        this.debug(sb.toString());
    }

    public Document loadXMLFromString(String xml) {
        DocumentBuilder builder;
        this.debug("loadXMLFromString ()");
        xml = xml.trim();
        if (xml.indexOf("<?xml") == -1) {
            xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + xml;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        InputSource is = new InputSource(new StringReader(xml));
        Document result = null;
        try {
            result = builder.parse(is);
        }
        catch (SAXParseException spe) {
            this.debugSAXException(spe);
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    public Boolean fromXML(Element root) {
        this.debug("fromXML ()");
        return true;
    }

    public String toXML() {
        this.debug("toXML ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xml class=\"" + this.getClassName() + "\" instance=\"" + this.getInstanceName() + "\" />");
        return buffer.toString();
    }
}

