/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.widgets;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.widgets.CTATFileListRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class CTATIconJList
extends JPanel
implements DropTargetListener {
    private static final long serialVersionUID = -3120073462367774493L;
    private DefaultListModel<File> listModel = null;
    private DropTarget dropTarget = null;
    private JScrollPane jScrollPane1 = null;
    private JList<File> list = null;
    private ArrayList<String> exclusionList = new ArrayList();

    public CTATIconJList(DefaultListModel<File> aModel) {
        this.listModel = aModel != null ? aModel : new DefaultListModel();
        this.setLayout(new BorderLayout());
        this.list = new JList();
        this.dropTarget = new DropTarget(this.list, this);
        this.list.setModel(this.listModel);
        this.list.setDragEnabled(true);
        CTATFileListRenderer renderer = new CTATFileListRenderer();
        this.list.setCellRenderer(renderer);
        this.jScrollPane1 = new JScrollPane(this.list);
        this.add((Component)this.jScrollPane1, "Center");
    }

    protected void debug(String aMessage) {
        CTATBase.debug("CTATIconJList", aMessage);
    }

    public DefaultListModel<File> getListModel() {
        return this.listModel;
    }

    @Override
    public void dragEnter(DropTargetDragEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent arg0) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent evt) {
        int action = evt.getDropAction();
        evt.acceptDrop(action);
        try {
            Transferable data = evt.getTransferable();
            if (data.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)data.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : files) {
                    this.addEntry(file);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            evt.dropComplete(true);
        }
    }

    public void addExclusion(String aValue) {
        this.debug("addExclusion (" + aValue + ")");
        this.exclusionList.add(aValue);
    }

    public Boolean isExclusion(String aValue) {
        this.debug("isExclusion (" + aValue + ")");
        for (int i = 0; i < this.exclusionList.size(); ++i) {
            if (!this.exclusionList.get(i).equalsIgnoreCase(aValue)) continue;
            this.debug("Entry in exclusion list!");
            return true;
        }
        this.debug("Entry is not in exclusion list");
        return false;
    }

    public Boolean entryExists(File aFile) {
        this.debug("entryExists ()");
        if (this.isExclusion(aFile.getAbsolutePath()).booleanValue()) {
            return true;
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            File testEntry = this.listModel.get(i);
            if (!testEntry.getAbsolutePath().equalsIgnoreCase(aFile.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public Boolean addEntry(File aFile) {
        this.debug("addEntry (" + aFile.getAbsolutePath() + ")");
        if (this.entryExists(aFile).booleanValue()) {
            JOptionPane.showMessageDialog(null, "Error: file or directory was already added");
            return false;
        }
        this.listModel.addElement(aFile);
        return true;
    }

    public void deletEntry() {
        if (this.list.getSelectedValue() != null) {
            this.listModel.remove(this.list.getSelectedIndex());
        } else {
            JOptionPane.showMessageDialog(null, "Please select an entry first.");
        }
    }

    public static void main(String[] args) throws Exception {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CTATIconJList pan = new CTATIconJList(null);
                pan.setBorder(new LineBorder(Color.BLACK));
                JOptionPane.showMessageDialog(null, pan);
            }
        };
        SwingUtilities.invokeLater(r);
    }
}

