/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.wizard.CTATLMSConfiguration;
import edu.cmu.hcii.ctat.wizard.CTATWizardBase;
import edu.cmu.hcii.ctat.wizard.CTATWizardFinishPage;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilitiesMultiple;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.CtatFrameController;
import edu.cmu.pact.ctatview.CtatMenuBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CTATHTMLProjectWizard
extends CTATWizardBase
implements ActionListener,
ItemListener {
    private JPanel welcomePanel = null;
    private BR_Controller controller;
    private JPanel projectLocationPanel = null;
    private JPanel projectConfigurationPanel = null;
    private JPanel projectTemplatePanel = null;
    private JPanel fileNamingPanel = null;
    private JTextField projectNameLabel = null;
    private JTextField packageLocation = null;
    private JLabel totalPath = null;
    private JTextField interfaceNameLabel = null;
    private JTextField brdNameLabel = null;
    private JCheckBox localCSSButton = null;
    private JCheckBox localJQueryButton = null;
    private JCheckBox localCTATButton = null;
    private JCheckBox localLoaderButton = null;
    private JButton aBrowseDirectory = null;
    private JRadioButton goCustom = null;
    private JRadioButton goWorkspace = null;
    private String projectName = "CTAT Package";
    private String outputLocation = null;
    private Boolean localCSS = false;
    private Boolean localJQuery = false;
    private Boolean localCTAT = false;
    private Boolean localLoader = false;
    private String localCSSURL = "Assets/CTAT.css";
    private String localJQueryURL = "Assets/jquery.min.js";
    private String localCTATURL = "Assets/ctat.min.js";
    private String localLoaderURL = "Assets/ctatloader.js";
    private String studentInterfaceFile = "index.html";
    private String studentProblemFile = "problem.brd";
    private String studentProblemTemplate = "pwizard-template1.brd";
    private Boolean studentProblemOverwrite = false;
    private Boolean studentInterfaceOverwrite = false;
    private JLabel picture = null;
    private String chosenTemplate = "pwizard-template1.html";
    private PreferencesModel brPrefs = null;
    private CTATLMSConfiguration LMSConfiguration = null;

    public CTATHTMLProjectWizard(PreferencesModel aPrefs, BR_Controller controller, String ... args) {
        super(args == null || args.length < 1 ? null : args[0]);
        this.setClassName("CTATMoodleMaker");
        this.debug("CTATMoodleMaker ()");
        this.controller = controller;
        this.brPrefs = aPrefs;
        if (this.brPrefs == null) {
            this.debug("Error: brPrefs is null!");
            this.brPrefs = controller != null ? controller.getServer().getPreferencesModel() : new PreferencesModel();
        }
        if (this.brPrefs.getStringValue("workspace") == null) {
            this.debug("Error: no workspace value found in brPrefs");
            this.brPrefs.setStringValue("workspace", System.getProperty("user.home") + "/" + CTATLink.workspaceLocation);
            this.brPrefs.saveToDisk();
        } else {
            this.debug("Setting output path to workspace value from brPrefs: " + this.brPrefs.getStringValue("workspace"));
            this.outputLocation = this.brPrefs.getStringValue("workspace");
            CTATLink.workspaceLocation = this.brPrefs.getStringValue("workspace");
        }
        this.LMSConfiguration = new CTATLMSConfiguration();
    }

    @Override
    public void init() {
        this.debug("init ()");
        this.setTitle(this.singlePage == null ? "CTAT HTML5 Project Wizard" : this.singlePage);
        if (this.singlePage == null) {
            this.welcomePanel = this.createWizardJPanel();
            this.generateWelcomePanel(this.welcomePanel);
            this.addPage("Introduction", this.welcomePanel);
        }
        this.projectLocationPanel = this.createWizardJPanel();
        this.generateProjectLocationPanel(this.projectLocationPanel);
        this.addPage("Package Location", this.projectLocationPanel);
        if (this.singlePage == null) {
            this.projectConfigurationPanel = this.createWizardJPanel();
            this.generateProjectConfigurationPanel(this.projectConfigurationPanel);
            this.addPage("Configuration", this.projectConfigurationPanel);
            this.projectTemplatePanel = this.createWizardJPanel();
            this.generateProjectTemplatePanel(this.projectTemplatePanel);
            this.addPage("Starting Template", this.projectTemplatePanel);
            this.fileNamingPanel = this.createWizardJPanel();
            this.generateFileNamingPanel(this.fileNamingPanel);
            this.addPage("Name Files", this.fileNamingPanel);
            CTATWizardFinishPage finishPage = new CTATWizardFinishPage("<html><body style='width: 390px;'>Click Finish to generate your configured package.<br><br><br></body></html>");
            this.generateFinishPage(finishPage);
            this.addPage("Create", finishPage);
        }
        this.updateTotalProjectPath();
    }

    private void generateWelcomePanel(JPanel aPanel) {
        this.debug("generateWelcomePanel ()");
        JLabel logo = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/CTAT_Logo-TeamViewer.png")));
        JLabel welcomeMessage = new JLabel();
        welcomeMessage.setText("<html>This wizard will help you get started building a CTAT HTML5 tutor.<br><br>We will ask you a few questions about your preferences and generate a package in a format that can be used by the tools to let you easily develop tutors and export them to online learner management systems.</html>");
        aPanel.add(logo);
        aPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        aPanel.add(new JSeparator(0));
        aPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        aPanel.add(welcomeMessage);
    }

    private void generateProjectLocationPanel(JPanel aPanel) {
        Box descBox = new Box(0);
        descBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel desc = new JLabel();
        desc.setText("<html>A package is a folder with a specific layout holding all the files for one or more tutors. Choose a name and location for your new package folder.</html>");
        descBox.add(desc);
        Box nameButtonBox = new Box(0);
        nameButtonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel aProjectName = new JLabel();
        aProjectName.setText("Package Name: ");
        aProjectName.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        nameButtonBox.add(aProjectName);
        this.projectNameLabel = new JTextField();
        this.projectNameLabel.setText(this.projectName);
        this.projectNameLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.projectNameLabel.setMinimumSize(new Dimension(120, 22));
        this.projectNameLabel.setPreferredSize(new Dimension(120, 22));
        this.projectNameLabel.setMaximumSize(new Dimension(120, 22));
        this.projectNameLabel.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CTATHTMLProjectWizard.this.projectName = CTATHTMLProjectWizard.this.projectNameLabel.getText();
                CTATHTMLProjectWizard.this.updateTotalProjectPath();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CTATHTMLProjectWizard.this.projectName = CTATHTMLProjectWizard.this.projectNameLabel.getText();
                CTATHTMLProjectWizard.this.updateTotalProjectPath();
            }
        });
        nameButtonBox.add(this.projectNameLabel);
        nameButtonBox.add(Box.createHorizontalGlue());
        Box goCustomBox = new Box(0);
        goCustomBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.goCustom = new JRadioButton("Custom directory");
        this.goCustom.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.goCustom.setActionCommand("CUSTOMDIR");
        this.goCustom.setMinimumSize(new Dimension(50, 25));
        this.goCustom.setMaximumSize(new Dimension(600, 25));
        this.goCustom.addActionListener(this);
        goCustomBox.add(this.goCustom);
        Box zipButtonBox = new Box(0);
        zipButtonBox.setBorder(new EmptyBorder(3, 20, 3, 3));
        JLabel aLabelZIP = new JLabel();
        aLabelZIP.setText("Package location: ");
        aLabelZIP.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        zipButtonBox.add(aLabelZIP);
        this.packageLocation = new JTextField();
        this.packageLocation.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.packageLocation.setMinimumSize(new Dimension(50, 25));
        this.packageLocation.setMaximumSize(new Dimension(600, 25));
        this.packageLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CTATHTMLProjectWizard.this.outputLocation = CTATHTMLProjectWizard.this.packageLocation.getText();
                CTATHTMLProjectWizard.this.updateTotalProjectPath();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CTATHTMLProjectWizard.this.outputLocation = CTATHTMLProjectWizard.this.packageLocation.getText();
                CTATHTMLProjectWizard.this.updateTotalProjectPath();
            }
        });
        zipButtonBox.add(this.packageLocation);
        this.aBrowseDirectory = new JButton();
        this.aBrowseDirectory.setText("Browse...");
        this.aBrowseDirectory.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.aBrowseDirectory.setPreferredSize(new Dimension(85, 20));
        this.aBrowseDirectory.setActionCommand("aBrowsePackageDirectory");
        this.aBrowseDirectory.addActionListener(this);
        this.aBrowseDirectory.setEnabled(false);
        zipButtonBox.add(this.aBrowseDirectory);
        Box goWorkspaceBox = new Box(0);
        goWorkspaceBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.goWorkspace = new JRadioButton("Use Workspace");
        this.goWorkspace.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.goWorkspace.setMinimumSize(new Dimension(50, 25));
        this.goWorkspace.setMaximumSize(new Dimension(600, 25));
        this.goWorkspace.setActionCommand("WORKSPACEDIR");
        this.goWorkspace.addActionListener(this);
        this.goWorkspace.setSelected(true);
        goWorkspaceBox.add(this.goWorkspace);
        Box workspaceButtonBox = new Box(0);
        workspaceButtonBox.setBorder(new EmptyBorder(3, 20, 3, 3));
        ButtonGroup group = new ButtonGroup();
        group.add(this.goCustom);
        group.add(this.goWorkspace);
        Box totalPathBox = new Box(0);
        totalPathBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel pathLabel = new JLabel();
        pathLabel.setText("Resulting package path:");
        pathLabel.setPreferredSize(new Dimension(120, 22));
        pathLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.totalPath = new JLabel();
        this.totalPath.setText("");
        this.totalPath.setBorder(BorderFactory.createLoweredBevelBorder());
        this.totalPath.setMinimumSize(new Dimension(120, 22));
        this.totalPath.setMaximumSize(new Dimension(520, 22));
        this.totalPath.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        totalPathBox.add(pathLabel);
        totalPathBox.add(this.totalPath);
        aPanel.add(descBox);
        aPanel.add(nameButtonBox);
        aPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        aPanel.add(new JSeparator(0));
        aPanel.add(goWorkspaceBox);
        aPanel.add(workspaceButtonBox);
        aPanel.add(goCustomBox);
        aPanel.add(zipButtonBox);
        aPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        aPanel.add(new JSeparator(0));
        aPanel.add(totalPathBox);
        this.updateTotalProjectPath();
    }

    private void generateProjectConfigurationPanel(JPanel aPanel) {
        Box descBox = new Box(0);
        descBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel desc = new JLabel();
        desc.setText("<html>Every tutor relies on a number of external libraries and files. You can either have links included in your tutor page to the release versions online or have local copies included if you want to make sure you always use the same version.</html>");
        descBox.add(desc);
        this.localCSSButton = new JCheckBox("Include local CTAT CSS file (CTAT.css)");
        this.localJQueryButton = new JCheckBox("Include local JQuery (jquery.min.js)");
        this.localCTATButton = new JCheckBox("Include local ctat libraries (ctat.min.js,ctatloader.js)");
        this.localLoaderButton = new JCheckBox("Include local ctat loader copy (ctatloader.js)");
        this.localCSSButton.addItemListener(this);
        this.localJQueryButton.addItemListener(this);
        this.localCTATButton.addItemListener(this);
        this.localLoaderButton.addItemListener(this);
        aPanel.add(descBox);
        aPanel.add(Box.createRigidArea(new Dimension(0, 25)));
        aPanel.add(this.localCSSButton);
        aPanel.add(this.localJQueryButton);
        aPanel.add(this.localCTATButton);
        aPanel.add(Box.createRigidArea(new Dimension(0, 75)));
    }

    private void generateProjectTemplatePanel(JPanel aPanel) {
        Box descBox = new Box(0);
        descBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel mdesc = new JLabel();
        mdesc.setText("<html>To help you get started you can choose from a number of pre-created tutors. If you want to start with a clean slate then choose the blank tutor page below.</html>");
        descBox.add(mdesc);
        Box vBox = this.generateVerticalBox();
        Box hBox = this.generateHorizontalBox();
        JRadioButton templateBlank = new JRadioButton("Blank html tutor page");
        templateBlank.setActionCommand("TEMPLATEBLANK");
        templateBlank.setSelected(true);
        templateBlank.addActionListener(this);
        JRadioButton templateBasic = new JRadioButton("Basic tutor page");
        templateBasic.setActionCommand("TEMPLATEBASIC");
        templateBasic.addActionListener(this);
        JRadioButton templateMChoiceRadio = new JRadioButton("<html>Quiz Tutor (one correct answer)</html>");
        templateMChoiceRadio.setActionCommand("TEMPLATEMCHOICERADIO");
        templateMChoiceRadio.addActionListener(this);
        JRadioButton templateMChoiceCheck = new JRadioButton("<html>Quiz Tutor (multiple answers apply)</html>");
        templateMChoiceCheck.setActionCommand("TEMPLATEMCHOICECHECKBOX");
        templateMChoiceCheck.addActionListener(this);
        JRadioButton templateMChoiceDnD = new JRadioButton("<html>Interactive (Drag and Drop) tutor</html>");
        templateMChoiceDnD.setActionCommand("TEMPLATEMCHOICEDND");
        templateMChoiceDnD.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(templateBlank);
        group.add(templateBasic);
        group.add(templateMChoiceRadio);
        group.add(templateMChoiceCheck);
        group.add(templateMChoiceDnD);
        vBox.add(templateBlank);
        vBox.add(templateBasic);
        vBox.add(templateMChoiceRadio);
        vBox.add(templateMChoiceCheck);
        vBox.add(templateMChoiceDnD);
        this.picture = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/pwizard-template1.png")));
        hBox.add(vBox);
        hBox.add(this.picture);
        aPanel.add(descBox);
        aPanel.add(hBox);
    }

    private void generateFileNamingPanel(JPanel aPanel) {
        this.debug("actionPerformed ()");
        Box descBox = new Box(0);
        descBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel desc = new JLabel();
        desc.setText("<html>We are going to create and generate a number of files for you within the package you have selected. There are two files you might want to name or rename because you will need a set of files for each problem in the package.</html>");
        descBox.add(desc);
        Box nameButtonBox = new Box(0);
        nameButtonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel aProjectName = new JLabel();
        aProjectName.setText("HTML File Name: ");
        aProjectName.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        nameButtonBox.add(aProjectName);
        this.interfaceNameLabel = new JTextField();
        this.interfaceNameLabel.setText(this.studentInterfaceFile);
        this.interfaceNameLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.interfaceNameLabel.setMinimumSize(new Dimension(120, 22));
        this.interfaceNameLabel.setPreferredSize(new Dimension(120, 22));
        this.interfaceNameLabel.setMaximumSize(new Dimension(120, 22));
        this.interfaceNameLabel.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CTATHTMLProjectWizard.this.studentInterfaceFile = CTATHTMLProjectWizard.this.interfaceNameLabel.getText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CTATHTMLProjectWizard.this.studentInterfaceFile = CTATHTMLProjectWizard.this.interfaceNameLabel.getText();
            }
        });
        nameButtonBox.add(this.interfaceNameLabel);
        nameButtonBox.add(Box.createHorizontalGlue());
        Box brdButtonBox = new Box(0);
        brdButtonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel aBRDName = new JLabel();
        aBRDName.setText("Behavior Graph File Name: ");
        aBRDName.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        brdButtonBox.add(aBRDName);
        this.brdNameLabel = new JTextField();
        this.brdNameLabel.setText(this.studentProblemFile);
        this.brdNameLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.brdNameLabel.setMinimumSize(new Dimension(120, 22));
        this.brdNameLabel.setPreferredSize(new Dimension(120, 22));
        this.brdNameLabel.setMaximumSize(new Dimension(120, 22));
        this.brdNameLabel.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CTATHTMLProjectWizard.this.studentProblemFile = CTATHTMLProjectWizard.this.brdNameLabel.getText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CTATHTMLProjectWizard.this.studentProblemFile = CTATHTMLProjectWizard.this.brdNameLabel.getText();
            }
        });
        brdButtonBox.add(this.brdNameLabel);
        brdButtonBox.add(Box.createHorizontalGlue());
        aPanel.add(descBox);
        aPanel.add(Box.createRigidArea(new Dimension(0, 25)));
        aPanel.add(nameButtonBox);
        aPanel.add(brdButtonBox);
    }

    private void generateFinishPage(JPanel aPanel) {
        this.debug("actionPerformed ()");
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        File[] file;
        this.debug("actionPerformed ()");
        if (trace.getDebugCode("wizard")) {
            trace.out("wizard", "HTMLProjectWizard.actionPerformed(" + arg0.getActionCommand() + ", " + trace.nh(arg0.getSource()) + ")");
        }
        super.actionPerformed(arg0);
        if (arg0.getActionCommand().equalsIgnoreCase("aBrowsePackageDirectory") && (file = DialogUtilitiesMultiple.chooseFile(this.outputLocation, null, null, "Choose a package directory", "Open", 1, (Component)arg0.getSource())) != null && file.length > 0) {
            this.packageLocation.setText(file[0].getAbsolutePath());
            this.outputLocation = this.packageLocation.getText();
            this.updateTotalProjectPath();
        }
        if (arg0.getActionCommand().equalsIgnoreCase("TEMPLATEBLANK")) {
            this.picture.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/pwizard-template1.png")));
            this.chosenTemplate = "pwizard-template1.html";
            this.studentProblemTemplate = "pwizard-template1.brd";
        }
        if (arg0.getActionCommand().equalsIgnoreCase("TEMPLATEBASIC")) {
            this.picture.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/pwizard-template2.png")));
            this.chosenTemplate = "pwizard-template2.html";
            this.studentProblemTemplate = "pwizard-template2.brd";
        }
        if (arg0.getActionCommand().equalsIgnoreCase("TEMPLATEMCHOICERADIO")) {
            this.picture.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/pwizard-template3.png")));
            this.chosenTemplate = "pwizard-template3.html";
            this.studentProblemTemplate = "pwizard-template3.brd";
        }
        if (arg0.getActionCommand().equalsIgnoreCase("TEMPLATEMCHOICECHECKBOX")) {
            this.picture.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/pwizard-template4.png")));
            this.chosenTemplate = "pwizard-template4.html";
            this.studentProblemTemplate = "pwizard-template4.brd";
        }
        if (arg0.getActionCommand().equalsIgnoreCase("TEMPLATETEXT")) {
            this.picture.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/pwizard-template5.png")));
            this.chosenTemplate = "pwizard-template5.html";
            this.studentProblemTemplate = "pwizard-template5.brd";
        }
        if (arg0.getActionCommand().equalsIgnoreCase("TEMPLATEMCHOICEDND")) {
            this.picture.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/pwizard-template6.png")));
            this.chosenTemplate = "pwizard-template6.html";
            this.studentProblemTemplate = "pwizard-template6.brd";
        }
        if (arg0.getActionCommand().equalsIgnoreCase("CUSTOMDIR")) {
            this.aBrowseDirectory.setEnabled(true);
            this.packageLocation.setEnabled(true);
            this.updateTotalProjectPath();
        }
        if (arg0.getActionCommand().equalsIgnoreCase("WORKSPACEDIR")) {
            this.aBrowseDirectory.setEnabled(false);
            this.packageLocation.setEnabled(false);
            this.updateTotalProjectPath();
        }
    }

    private void updateTotalProjectPath() {
        this.debug("updateTotalProjectPath ()");
        this.outputLocation = this.goCustom.isSelected() ? this.packageLocation.getText() : CTATLink.workspaceLocation;
        String formatter = this.outputLocation + File.separator + this.projectName;
        File trans = new File(formatter);
        this.totalPath.setText(trans.getAbsolutePath());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.debug("itemStateChanged ()");
        ItemSelectable source = e.getItemSelectable();
        if (source == this.localCSSButton) {
            this.localCSS = this.localCSSButton.isSelected();
        } else if (source == this.localJQueryButton) {
            this.localJQuery = this.localJQueryButton.isSelected();
        } else if (source == this.localCTATButton) {
            this.localCTAT = this.localCTATButton.isSelected();
        } else if (source == this.localLoaderButton) {
            this.localLoader = this.localLoaderButton.isSelected();
        }
    }

    @Override
    protected Boolean processFinish() {
        File assetsDirMaker;
        File mainDirMaker;
        File dirMaker;
        this.debug("processFinish ()");
        File folderTest = new File(this.outputLocation);
        if (!folderTest.exists()) {
            this.debug("Creating workspace directory: " + this.outputLocation);
            folderTest.mkdir();
        }
        if (!folderTest.canWrite()) {
            JOptionPane.showMessageDialog(null, "The directory you have chosen is read-only, please choose a different location");
            return false;
        }
        File projectDirectory = new File(this.outputLocation + "/" + this.projectName);
        if (!projectDirectory.exists()) {
            this.debug("Creating project directory: " + this.projectName);
            projectDirectory.mkdir();
        }
        if (!(dirMaker = new File(projectDirectory + "/FinalBRDs/")).exists()) {
            dirMaker.mkdir();
        }
        if (!(mainDirMaker = new File(projectDirectory + "/HTML")).exists()) {
            mainDirMaker.mkdir();
        }
        if (!(assetsDirMaker = new File(mainDirMaker, "Assets")).isDirectory()) {
            if (assetsDirMaker.exists()) {
                assetsDirMaker.delete();
            }
            assetsDirMaker.mkdir();
        }
        if (this.singlePage != null) {
            return true;
        }
        if (this.localCSS.booleanValue()) {
            CTATLink.fManager.setContents(projectDirectory + "/HTML/Assets/CTAT.css", this.LMSConfiguration.ctatcssContent);
        } else {
            this.localCSSURL = "https://cdn.ctat.cs.cmu.edu/releases/latest/CTAT.css";
        }
        if (this.localJQuery.booleanValue()) {
            CTATLink.fManager.setContents(projectDirectory + "/HTML/Assets/jquery.min.js", this.LMSConfiguration.jquerylibContent);
        } else {
            this.localJQueryURL = "https://cdn.ctat.cs.cmu.edu/releases/latest/jquery.min.js";
        }
        if (this.localCTAT.booleanValue()) {
            CTATLink.fManager.setContents(projectDirectory + "/HTML/Assets/ctat.min.js", this.LMSConfiguration.ctatlibContent);
            CTATLink.fManager.setContents(projectDirectory + "/HTML/Assets/ctatloader.js", this.LMSConfiguration.ctatloaderContent);
        } else {
            this.localCTATURL = "https://cdn.ctat.cs.cmu.edu/releases/latest/ctat.min.js";
            this.localLoaderURL = "https://cdn.ctat.cs.cmu.edu/releases/latest/ctatloader.js";
        }
        try {
            CTATLink.fManager.copy(new File("Templates/ProjectWizard/favicon.ico"), new File(projectDirectory + "/HTML/favicon.ico"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            CTATLink.fManager.copy(new File("Templates/ProjectWizard/tutor.css"), new File(projectDirectory + "/HTML/Assets/tutor.css"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.debug("Chosen template: " + this.chosenTemplate);
        String interfaceBuffer = CTATLink.fManager.getContents("Templates/ProjectWizard/" + this.chosenTemplate);
        interfaceBuffer = interfaceBuffer.replaceAll("CSSLOCATION", this.localCSSURL);
        interfaceBuffer = interfaceBuffer.replaceAll("JQUERYLOCATION", this.localJQueryURL);
        interfaceBuffer = interfaceBuffer.replaceAll("CTATLOCATION", this.localCTATURL);
        interfaceBuffer = interfaceBuffer.replaceAll("LOADERLOCATION", this.localLoaderURL);
        interfaceBuffer = interfaceBuffer.replaceAll("BRDNAME", "../FinalBRDs/" + this.studentProblemFile);
        CTATLink.fManager.setContents(projectDirectory + "/HTML/" + this.studentInterfaceFile, interfaceBuffer);
        String problemContents = CTATLink.fManager.getContents("Templates/ProjectWizard/" + this.studentProblemTemplate);
        CTATLink.fManager.setContents(projectDirectory + "/FinalBRDs/" + this.studentProblemFile, problemContents);
        this.alert("Successfully generated package " + this.projectName + ". \n We will now open the generated BRD file in the authoring tools \n and we will open the generated html file in the default browser.");
        if (this.controller != null) {
            CtatFrameController cfController = this.controller.getCtatFrameController();
            if (cfController != null && cfController.getDockedFrame() != null) {
                CtatMenuBar ctatMenuBar = cfController.getDockedFrame().getCtatMenuBar();
                ctatMenuBar.loadGraph(new File(projectDirectory + "/FinalBRDs/" + this.studentProblemFile));
                ctatMenuBar.launchHTMLFile(projectDirectory + "/HTML/" + this.studentInterfaceFile);
            }
        } else {
            this.alert("This tool wasn't executed from within the Behavior Recorder, can't open files.");
        }
        return true;
    }

    @Override
    protected Boolean checkNextOK() {
        File projectDirectory;
        this.debug("checkNextOK (" + this.getCurrentIndex() + ")");
        if (this.getCurrentIndex() == 4 && (projectDirectory = new File(this.outputLocation + "/" + this.projectName)).exists()) {
            int dialogResult;
            File interfaceNameCheck = new File(projectDirectory + "/HTML/" + this.interfaceNameLabel.getText());
            File brdNameCheck = new File(projectDirectory + "/FinalBRDs/" + this.brdNameLabel.getText());
            if (interfaceNameCheck.exists()) {
                dialogResult = JOptionPane.showConfirmDialog(null, "Warning: interface file " + this.interfaceNameLabel.getText() + " already exists. Would you like to overwrite the file?", "CTAT Warning", 1);
                if (dialogResult == 0) {
                    this.studentProblemOverwrite = true;
                } else {
                    return false;
                }
            }
            if (brdNameCheck.exists()) {
                dialogResult = JOptionPane.showConfirmDialog(null, "Warning: BRD (Graph) file " + this.brdNameLabel.getText() + " already exists. Would you like to overwrite the file?", "CTAT Warning", 1);
                if (dialogResult == 0) {
                    this.studentInterfaceOverwrite = true;
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected Boolean checkReadyToFinish() {
        this.debug("checkReadyToFinish ()");
        return true;
    }

    @Override
    protected Boolean cleanup() {
        this.debug("cleanup ()");
        return false;
    }

    public static void main(String[] args) {
        new CTATLink(null);
        trace.addDebugCode("ll");
        trace.addDebugCode("pr");
        PreferencesModel prefs = new PreferencesModel();
        CTATHTMLProjectWizard t = new CTATHTMLProjectWizard(prefs, null, args);
        t.init();
        t.show();
    }
}

