/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.env.CTATFileEntry;
import edu.cmu.hcii.ctat.wizard.CTATLMSConfiguration;
import edu.cmu.hcii.ctat.wizard.CTATPackageGeneratorBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class CTATXBlockPackageGenerator
extends CTATPackageGeneratorBase {
    private CTATLMSConfiguration LMSConfiguration = null;

    public CTATXBlockPackageGenerator(CTATLMSConfiguration aConfiguration) {
        super(aConfiguration);
        this.setClassName("CTATXBlockPackageGenerator");
        this.debug("CTATXBlockPackageGenerator ()");
        this.LMSConfiguration = aConfiguration;
    }

    @Override
    public CTATLMSConfiguration getLMSConfiguration() {
        return this.LMSConfiguration;
    }

    @Override
    public void setLMSConfiguration(CTATLMSConfiguration aConfiguration) {
        this.LMSConfiguration = aConfiguration;
    }

    @Override
    public Boolean generatePackage(File outputZip) {
        File copyTarget;
        File copySource;
        int i;
        String packageNameFull = outputZip.getName().replaceFirst("[.][^.]+$", "").replaceAll(" ", "_").toLowerCase();
        String packageName = packageNameFull.toLowerCase();
        String packageClass = packageNameFull.toUpperCase() + "CLASS";
        this.LMSConfiguration.setName(packageNameFull);
        String[] HTMLFiles = this.LMSConfiguration.getInterfaceFiles();
        String[] BRDs = this.LMSConfiguration.getBrdFiles();
        this.debug("generatePackage (" + packageName + ")");
        String outputPath = outputZip.getParent();
        this.debug("Generating XBlock in: " + outputPath + " ...");
        File outPath = new File(outputPath);
        if (!outPath.exists()) {
            outPath.mkdir();
        }
        try {
            this.unZipIt("Templates/PackagingWizard/XBlock/XBlockCTATTemplate.zip", outputPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File renamer = new File(outputPath + "/XBlockCTATTemplate");
        renamer.renameTo(new File(outputPath + "/" + packageNameFull));
        File renamer2 = new File(outputPath + "/" + packageNameFull + "/ctatxblock");
        renamer2.renameTo(new File(outputPath + "/" + packageNameFull + "/" + packageName));
        String setupPy = CTATLink.fManager.getContents(outputPath + "/" + packageNameFull + "/setup.py");
        String formatter = setupPy.replaceAll("<PACKAGENAME>", packageName);
        formatter = formatter.replaceAll("<PACKAGENAMEFULL>", packageNameFull);
        formatter = formatter.replaceAll("<DESCRIPTION>", this.LMSConfiguration.getDescription());
        formatter = formatter.replaceAll("<PACKAGECLASS>", packageClass);
        CTATLink.fManager.setContents(outputPath + "/" + packageNameFull + "/setup.py", formatter);
        String initFile = CTATLink.fManager.getContents(outputPath + "/" + packageNameFull + "/" + packageName + "/__init__.py");
        if (initFile == null) {
            this.debug("Error, template file (" + outputPath + "/" + packageNameFull + "/" + packageName + "/__init__.py) does not exist");
            return false;
        }
        String classifier = initFile.replaceAll("<PACKAGENAME>", packageName);
        classifier = classifier.replaceAll("<PACKAGECLASS>", packageClass);
        CTATLink.fManager.setContents(outputPath + "/" + packageNameFull + "/" + packageName + "/__init__.py", classifier);
        renamer = new File(outputPath + "/" + packageNameFull + "/" + packageName + "/ctatxblock.py");
        if (!renamer.exists()) {
            this.debug("Error, template file (" + renamer.getAbsolutePath() + ") does not exist");
            return false;
        }
        if (!renamer.renameTo(new File(outputPath + "/" + packageNameFull + "/" + packageName + "/" + packageName + ".py"))) {
            this.debug("Error: can't rename file to: " + outputPath + "/" + packageNameFull + "/" + packageName + "/" + packageName + ".py");
            return false;
        }
        String configurePy = CTATLink.fManager.getContents(outputPath + "/" + packageNameFull + "/" + packageName + "/" + packageName + ".py");
        configurePy = configurePy.replaceAll("<INTERFACE>", new File(HTMLFiles[0]).getName());
        configurePy = configurePy.replaceAll("<BRD>", new File(BRDs[0]).getName());
        configurePy = configurePy.replaceAll("<PACKAGENAME>", packageName);
        configurePy = configurePy.replaceAll("<PACKAGECLASS>", packageClass);
        CTATLink.fManager.setContents(outputPath + "/" + packageNameFull + "/" + packageName + "/" + packageName + ".py", configurePy);
        this.debug("Copying BRDs ...");
        for (i = 0; i < BRDs.length; ++i) {
            String aBRDFile = BRDs[i];
            this.debug("Placing BRD file: " + aBRDFile + " ...");
            copySource = new File(aBRDFile);
            copyTarget = new File(outputPath + "/" + packageNameFull + "/" + packageName + "/public/problem_files/" + copySource.getName());
            try {
                CTATLink.fManager.copy(copySource, copyTarget);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.debug("Copying Interfaces ...");
        for (i = 0; i < HTMLFiles.length; ++i) {
            String aHTMLFile = HTMLFiles[i];
            this.debug("Placing HTML file: " + aHTMLFile + " ...");
            copySource = new File(aHTMLFile);
            copyTarget = new File(outputPath + "/" + packageNameFull + "/" + packageName + "/public/" + copySource.getName());
            try {
                CTATLink.fManager.copy(copySource, copyTarget);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String manifest = this.createManifest();
        CTATLink.fManager.setContents(outputPath + "/" + packageNameFull + "/" + packageName + "/public/package.xml", manifest);
        this.debug("Prepping assets (" + this.LMSConfiguration.getAssetValues().size() + ") ...");
        for (int i2 = 0; i2 < this.LMSConfiguration.getAssetValues().size(); ++i2) {
            copySource = this.LMSConfiguration.getAssetValues().get(i2);
            if (copySource.isDirectory()) {
                this.debug("Warning: file entry " + copySource.getName() + " is a directory and needs to be created first");
            }
            this.addFileEntry(copySource, this.LMSConfiguration.getAssetBasePath());
        }
        ArrayList<CTATFileEntry> tempList = this.LMSConfiguration.getFileList();
        this.debug("Copying assets (" + tempList.size() + ") ...");
        for (int j = 0; j < tempList.size(); ++j) {
            CTATFileEntry entry = tempList.get(j);
            this.debug("basePath: " + entry.basePath);
            this.debug("relativePath: " + entry.relativePath);
            this.debug("filePath: " + entry.filePath);
            this.debug("fullPath: " + entry.fullPath);
            File copySource2 = new File(entry.basePath + File.separator + entry.filePath);
            File testTarget = new File(outputPath + "/" + packageNameFull + "/" + packageName + "/public/" + entry.relativePath + File.separator);
            File copyTarget2 = new File(outputPath + "/" + packageNameFull + "/" + packageName + "/public/" + entry.relativePath + File.separator + entry.filePath);
            this.debug("Checking path: " + testTarget.getAbsolutePath());
            if (!testTarget.exists()) {
                this.debug("Path does not exist, creating: " + testTarget.getAbsolutePath());
                testTarget.mkdir();
            }
            try {
                CTATLink.fManager.copy(copySource2, copyTarget2);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.internalList = new ArrayList();
        this.listFilesAndFilesSubDirectories(outputPath + "/" + packageNameFull + "/");
        this.LMSConfiguration.reset();
        this.debug("Creating zip file with root path: " + outputPath + "/" + packageNameFull + "/");
        for (int k = 0; k < this.internalList.size(); ++k) {
            File toZip = (File)this.internalList.get(k);
            this.debug("Adding to zip: " + toZip.getAbsolutePath() + " -> " + toZip.getAbsolutePath().substring(outputPath.length()));
            CTATFileEntry anEntry = this.addFileEntryAsIs(toZip, outputPath + "/" + packageNameFull + "/");
            String tempPath = toZip.getAbsolutePath().substring(outputPath.length());
            anEntry.setIsSystemEntry(true);
            anEntry.relativePath = tempPath.substring(0, tempPath.length() - toZip.getName().length());
            this.debug("Set relative path to: " + anEntry.relativePath);
        }
        this.zipIt(outputZip.getAbsolutePath());
        try {
            CTATDesktopFileManager.deleteRecursive(new File(outputPath + "/" + packageNameFull));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }
}

