/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.oli.log.tools;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;

public class DiskImporter {
    private URL url;
    private FileReader infile;
    private Exception lastException;
    private HttpURLConnection conn;
    private SAXTransformerFactory tf;
    private TransformerHandler hd;
    private Transformer serializer;
    private SimpleDateFormat dateFormat;
    private Vector xmlBuffers;
    private Boolean opened = Boolean.FALSE;

    public DiskImporter() {
        try {
            this.url = new URL("http://olidev.ote.cmu.edu/log/server");
        }
        catch (MalformedURLException ex) {
            this.lastException = ex;
        }
        try {
            this.infile = new FileReader("log.dat");
        }
        catch (Exception ex) {
            this.lastException = ex;
        }
        this.dateFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        this.xmlBuffers = new Vector();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 1 & args[0].equals("--help")) {
            System.out.println("Usage: DiskImporter [infile [url]]");
            return;
        }
        DiskImporter dI = new DiskImporter();
        if (args.length > 0) {
            System.out.println("Using file     : " + args[0]);
            dI.setInfile(args[0]);
        }
        if (args.length > 1) {
            System.out.println("Sending to URL : " + args[1]);
            dI.setURL(args[1]);
        }
        dI.send();
        System.out.println(dI.getLastError());
    }

    public Boolean setURL(String connURL) {
        try {
            this.url = new URL(connURL);
        }
        catch (MalformedURLException ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean setInfile(String filename) {
        try {
            this.infile = new FileReader(filename);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private HttpURLConnection getConnection() {
        HttpURLConnection conn;
        try {
            conn = (HttpURLConnection)this.url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.addRequestProperty("Checksum", "It's log, it's log");
            conn.connect();
        }
        catch (IOException ex) {
            this.lastException = ex;
            return null;
        }
        return conn;
    }

    public Boolean send() {
        String toSend = "";
        String line = "";
        BufferedReader in = new BufferedReader(this.infile);
        try {
            while ((line = in.readLine()) != null) {
                toSend = toSend + line;
            }
        }
        catch (IOException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        String[] xmlDocs = toSend.split("<\\?xml");
        System.out.print("Sending " + xmlDocs.length + " documents ");
        for (int i = 1; i < xmlDocs.length; ++i) {
            OutputStream os;
            xmlDocs[i] = "<?xml" + xmlDocs[i];
            HttpURLConnection conn = this.getConnection();
            if (conn == null) {
                System.err.println("\nError opening connection to " + this.url + ": " + this.getLastError());
                return Boolean.FALSE;
            }
            try {
                os = conn.getOutputStream();
            }
            catch (IOException ex) {
                this.lastException = ex;
                return Boolean.FALSE;
            }
            try {
                os.write(xmlDocs[i].getBytes("ISO-8859-1"));
                os.flush();
                InputStream is = conn.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int c = -1;
                while (0 <= (c = is.read())) {
                    baos.write(c);
                }
                String response = new String(baos.toByteArray());
                if (response == null || !response.toLowerCase().contains("success")) {
                    throw new IOException("Unsuccessful response from server: \"" + response + "\"");
                }
                System.out.print(".");
                conn.disconnect();
                conn = null;
                continue;
            }
            catch (IOException ex) {
                this.lastException = ex;
                if (conn != null) {
                    conn.disconnect();
                }
                return Boolean.FALSE;
            }
        }
        System.out.println();
        return Boolean.TRUE;
    }

    public Exception getLastError() {
        return this.lastException;
    }
}

