/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Dialogs.DirectoryFilter;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.trace;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DialogUtilitiesMultiple {
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private static String osName = System.getProperty("os.name");

    public static File[] chooseFile(String targetDir, FileFilter filter, String title, String buttonLabel, CTAT_Controller ctlr) {
        return DialogUtilitiesMultiple.chooseFile(targetDir, null, filter, title, buttonLabel, ctlr);
    }

    public static File[] chooseFile(String targetDir, String initialFilename, FileFilter filter, String title, String buttonLabel, CTAT_Controller ctlr) {
        return DialogUtilitiesMultiple.chooseFile(targetDir, initialFilename, filter, title, buttonLabel, ctlr == null ? null : ctlr.getActiveWindow());
    }

    public static File[] chooseFile(String targetDir, String initialFilename, FileFilter filter, String title, String buttonLabel, Component parent) {
        return DialogUtilitiesMultiple.chooseFile(targetDir, initialFilename, filter, title, buttonLabel, 0, parent);
    }

    public static File[] chooseFile(String targetDir, String initialFilename, FileFilter filter, String title, String buttonLabel, int mode, Component parent) {
        if (osName != null && osName.toUpperCase().startsWith("MAC OS")) {
            return DialogUtilitiesMultiple.awtChooseFile(targetDir, initialFilename, filter, title, buttonLabel, mode, parent);
        }
        return DialogUtilitiesMultiple.swingChooseFile(targetDir, initialFilename, filter, title, buttonLabel, mode, parent);
    }

    public static File[] chooseDirectory(String targetDir, String initialFilename, FileFilter filter, String title, String buttonLabel, Component parent) {
        return DialogUtilitiesMultiple.swingChooseFile(targetDir, initialFilename, filter, title, buttonLabel, 1, parent);
    }

    static File[] swingChooseFile(String targetDir, String initialFilename, FileFilter filter, String title, String buttonLabel, int mode, Component parent) {
        int i;
        JFileChooser fc = new JFileChooser(targetDir);
        fc.setDialogTitle(title);
        fc.setMultiSelectionEnabled(true);
        if (initialFilename != null && initialFilename.length() > 0) {
            fc.setSelectedFile(new File(targetDir, initialFilename));
        }
        fc.setFileSelectionMode(mode);
        if (filter != null) {
            fc.setFileFilter(filter);
            if (filter instanceof DirectoryFilter) {
                fc.setFileSelectionMode(1);
                fc.setAcceptAllFileFilterUsed(false);
            }
        }
        if ((i = fc.showDialog(parent, buttonLabel)) != 0) {
            return null;
        }
        return fc.getSelectedFiles();
    }

    static File[] awtChooseFile(String targetDir, String initialFilename, final FileFilter filter, String title, String buttonLabel, final int filesOrDirectories, Component parent) {
        FileDialog d = null;
        Frame frame = null;
        int mode = 0;
        if (buttonLabel != null && ((buttonLabel = buttonLabel.toUpperCase()).contains("SAVE") || buttonLabel.contains("CREATE"))) {
            mode = 1;
        }
        if (filesOrDirectories != 0) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            mode = 0;
        }
        if (parent instanceof Dialog) {
            d = new FileDialog((Dialog)parent, title, mode);
        } else {
            frame = new Frame();
            if (parent != null) {
                frame.setBounds(parent.getBounds());
            }
            d = new FileDialog(frame, title, mode);
        }
        d.setMultipleMode(true);
        d.setFile(initialFilename);
        if (filter != null || filesOrDirectories != 0) {
            FilenameFilter awtFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    if (filter != null && filter.accept(f)) {
                        return true;
                    }
                    if (f.isDirectory()) {
                        return filesOrDirectories != 0;
                    }
                    return filter == null;
                }
            };
            d.setFilenameFilter(awtFilter);
        }
        d.setVisible(true);
        String selectedDir = d.getDirectory();
        File[] selectedItems = d.getFiles();
        if (frame != null) {
            if (trace.getDebugCode("br")) {
                trace.out("br", "before frame.dispose()");
            }
            frame.dispose();
            if (trace.getDebugCode("br")) {
                trace.out("br", "after frame.dispose()");
            }
        }
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        if (selectedItems == null) {
            return null;
        }
        return selectedItems;
    }
}

