/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SaveFileDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.DefaultLinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateReaderJDom;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.Utilities.trace;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class InsertSubgraphDialog {
    private static int insertCount = 0;
    private BR_Controller controller;
    private ProblemNode pasteNode;

    public InsertSubgraphDialog(BR_Controller controller, ProblemNode pasteNode) {
        this.controller = controller;
        this.pasteNode = pasteNode;
    }

    public static void doDialog(BR_Controller controller, ProblemNode pasteNode) {
        InsertSubgraphDialog isd = new InsertSubgraphDialog(controller, pasteNode);
        isd.insertSubgraph(isd.getBRDOtherLocation());
    }

    protected File getBRDOtherLocation() {
        String targetDir = SaveFileDialog.getBrdFileOtherLocation(this.controller);
        File f = DialogUtilities.chooseFile(targetDir, new BrdFilter(), "Choose a subgraph file", "Open", this.controller);
        return f;
    }

    void insertSubgraph(File brd) {
        if (brd == null) {
            return;
        }
        try {
            ProblemModel pm = this.loadBRD(brd);
            NodeView nv = this.pasteNode.getNodeView();
            ProblemNode copyNode = pm.getStartNode();
            trace.out("mg", "NodeView (insertSubgraph): setting copy node to " + (pm.getStartNode() == null ? "null" : "non-null"));
            BR_Controller.setCopySubgraphNode(pm.getStartNode());
            if (trace.getDebugCode("br")) {
                trace.out("br", "insertSubgraph(" + brd + ") copyNode " + copyNode + ", pasteNode " + this.pasteNode);
            }
            Map<ProblemEdge, ProblemEdge> oldToNewEdges = nv.paste(copyNode);
            ++insertCount;
            this.copyAllGroups(pm, this.pasteNode.getProblemModel(), oldToNewEdges);
        }
        catch (Exception e) {
            String errMsg = "Error loading subgraph from BRD file " + brd + ": " + e + (e.getCause() == null ? "" : "; cause " + e.getCause());
            trace.errStack(errMsg, e);
            JOptionPane.showMessageDialog(this.controller == null ? null : this.controller.getActiveWindow(), errMsg, "Error loading subgraph from BRD file", 0);
        }
    }

    public void insertSubgraphFromClipboard(ProblemNode sourceNode, ProblemNode destNode) {
        this.pasteNode = destNode;
        ProblemModel pm = sourceNode.getProblemModel();
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "insertSubgraphFromClipboard(" + sourceNode + ", " + destNode + ")");
        }
        try {
            NodeView nv = this.pasteNode.getNodeView();
            Map<ProblemEdge, ProblemEdge> oldToNewEdges = nv.paste(sourceNode);
            ++insertCount;
            this.copyAllGroups(pm, this.pasteNode.getProblemModel(), oldToNewEdges);
        }
        catch (Exception e) {
            String errMsg = "Error loading subgraph from problem model " + pm.getProblemName() + ": " + e + (e.getCause() == null ? "" : "; cause " + e.getCause());
            trace.errStack(errMsg, e);
            JOptionPane.showMessageDialog(this.controller == null ? null : this.controller.getActiveWindow(), errMsg, "Error loading subgraph from BRD file", 0);
        }
    }

    private void copyAllGroups(ProblemModel fromPM, ProblemModel toPM, Map<ProblemEdge, ProblemEdge> oldToNewMapping) {
        LinkedHashMap<Integer, ProblemEdge> oldEdgeIdMap = new LinkedHashMap<Integer, ProblemEdge>();
        for (ProblemEdge edge : oldToNewMapping.keySet()) {
            oldEdgeIdMap.put(edge.getUniqueID(), edge);
        }
        ExampleTracerGraph fromGraph = fromPM.getExampleTracerGraph();
        ExampleTracerGraph toGraph = toPM.getExampleTracerGraph();
        GroupModel fromGM = fromGraph.getGroupModel();
        GroupModel toGM = toGraph.getGroupModel();
        Set<String> fromGNames = fromGM.getAllGroupNames();
        for (String gName : fromGNames) {
            DefaultLinkGroup fromGrp = (DefaultLinkGroup)fromGM.getGroupByName(gName);
            String newName = Integer.toString(insertCount) + '-' + gName;
            Set<ExampleTracerLink> newLinks = this.getNewLinksInOldGroup(fromGrp, toGraph, oldToNewMapping, oldEdgeIdMap);
            toGM.addGroup(newName, fromGrp.isOrdered(), newLinks);
        }
    }

    private Set<ExampleTracerLink> getNewLinksInOldGroup(DefaultLinkGroup fromGrp, ExampleTracerGraph newGraph, Map<ProblemEdge, ProblemEdge> oldToNewMapping, Map<Integer, ProblemEdge> oldEdgeIdMap) {
        HashSet<ExampleTracerLink> result = new HashSet<ExampleTracerLink>();
        for (ExampleTracerLink oldLink : fromGrp.getLinks()) {
            ProblemEdge oldEdge = oldEdgeIdMap.get(oldLink.getUniqueID());
            ProblemEdge newEdge = oldToNewMapping.get(oldEdge);
            ExampleTracerLink newLink = newGraph.getLink(newEdge.getUniqueID());
            result.add(newLink);
        }
        return result;
    }

    private ProblemModel loadBRD(File brd) throws Exception {
        ProblemStateReaderJDom psrj = new ProblemStateReaderJDom(null);
        ProblemModel pm = psrj.loadBRDFileIntoProblemModel(brd.getCanonicalPath(), new RuleProduction.Catalog());
        return pm;
    }
}

