/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.Utilities.trace;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageEnumerator {
    private static final Set<String> ObjectMethods = new HashSet<String>();
    private static final Pattern ExtractMethodSignature;

    public static void main(String[] args) throws ClassNotFoundException {
        if (args.length > 0 && "-s".equalsIgnoreCase(args[0])) {
            for (int i = 1; i < args.length; ++i) {
                System.out.printf("[%d] %25s => \"%s\"\n", i, args[i], PackageEnumerator.extractMethodSignature(args[i]));
            }
            return;
        }
        HashSet<String> sigSet = new HashSet<String>();
        for (String arg : args) {
            if (arg.endsWith("Math")) {
                sigSet.addAll(PackageEnumerator.getSelectedMethodSignatures(Math.class, true, "[Math] "));
                continue;
            }
            if (arg.endsWith("String")) {
                sigSet.addAll(PackageEnumerator.getSelectedMethodSignatures(String.class, true, "[String] "));
                continue;
            }
            for (Class<?> cls : PackageEnumerator.getClassesForPackage(arg)) {
                if (cls.getSimpleName().contains("$")) continue;
                sigSet.addAll(PackageEnumerator.getSelectedMethodSignatures(cls, false, null));
            }
        }
        ArrayList result = new ArrayList(sigSet);
        Collections.sort(result, String.CASE_INSENSITIVE_ORDER);
        for (String s : result) {
            System.out.printf("  %55s => %s\n", s, PackageEnumerator.extractMethodSignature(s));
        }
    }

    public static List<String> getSelectedMethodSignatures(Class<?> cls, boolean wantAll, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        if (prefix == null) {
            prefix = "";
        }
        String clsName = cls.getSimpleName();
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if ((m.getModifiers() & 1) == 0 || !wantAll && !m.getName().equals(clsName) || ObjectMethods.contains(m.getName()) && (!"String".equals(clsName) || !"equals".equals(m.getName()))) continue;
            Class<?>[] mArgs = m.getParameterTypes();
            StringBuilder mArgStr = new StringBuilder();
            if (mArgs.length > 0) {
                int j = 0;
                do {
                    String argType = mArgs[j].getSimpleName();
                    if (m.isVarArgs() && j >= mArgs.length - 1 && mArgs[j].isArray() && argType.endsWith("[]")) {
                        argType = argType.substring(0, argType.length() - 2) + "...";
                    }
                    mArgStr.append(argType);
                    if (j >= mArgs.length - 1) continue;
                    mArgStr.append(", ");
                } while (++j < mArgs.length);
            }
            String signature = String.format("%s%s(%s): %s", prefix, m.getName(), mArgStr.toString(), m.getReturnType().getSimpleName());
            result.add(signature);
        }
        return result;
    }

    public static String extractMethodSignature(String s) {
        if (s == null) {
            return null;
        }
        Matcher m = ExtractMethodSignature.matcher(s);
        return m.matches() ? m.group(2) : s;
    }

    private static void checkDirectory(File directory, String pckgname, ArrayList<Class<?>> classes) {
        String clsExt = ".class";
        if (directory.exists() && directory.isDirectory()) {
            String[] files;
            for (String file : files = directory.list()) {
                if (file.endsWith(".class")) {
                    String clsName = pckgname + '.' + file.substring(0, file.length() - ".class".length());
                    try {
                        classes.add(Class.forName(clsName));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                    catch (ClassNotFoundException cnfe) {
                        trace.errStack("PackageEnumerator.checkDirectory(" + directory + ", " + pckgname + "): error from Class.forName(" + clsName + ")", cnfe);
                    }
                    continue;
                }
                File tmpDirectory = new File(directory, file);
                if (!tmpDirectory.isDirectory()) continue;
                PackageEnumerator.checkDirectory(tmpDirectory, pckgname + "." + file, classes);
            }
        }
    }

    private static void checkJarFile(JarURLConnection connection, String pckgname, ArrayList<Class<?>> classes) {
        JarFile jarFile = null;
        try {
            jarFile = connection.getJarFile();
        }
        catch (Exception e) {
            trace.errStack("PackageEnumerator.checkJarFile(" + connection + ", " + pckgname + "): error from JarURLConnection.getJarFile()", e);
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        JarEntry jarEntry = null;
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.endsWith(".class") || !(name = name.substring(0, name.length() - 6).replace('/', '.')).contains(pckgname)) continue;
            try {
                classes.add(Class.forName(name));
            }
            catch (Throwable e) {
                trace.errStack("PackageEnumerator.checkJarFile(" + connection + ", " + pckgname + "): error from Class.forName(" + name + ")", e);
            }
        }
    }

    public static ArrayList<Class<?>> getClassesForPackage(String pckgname) {
        ArrayList classes = new ArrayList();
        URL url = null;
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
            url = null;
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        PackageEnumerator.checkJarFile((JarURLConnection)connection, pckgname, classes);
                        continue;
                    }
                    if (connection != null) {
                        try {
                            PackageEnumerator.checkDirectory(new File(URLDecoder.decode(url.getPath(), "UTF-8")), pckgname, classes);
                        }
                        catch (UnsupportedEncodingException ex) {
                            trace.errStack("PackageEnumerator.getClassesForPackage(" + pckgname + ") Unsupported encoding \"UTF-8\"?!", ex);
                        }
                        continue;
                    }
                    trace.errStack("PackageEnumerator.getClassesForPackage(" + pckgname + "): cannot open connection to URL " + url, new IOException("URL.openConnection() returns null"));
                }
                catch (IOException ioe) {
                    trace.errStack("PackageEnumerator.getClassesForPackage(" + pckgname + "): error trying to get resources from URL " + url, ioe);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            trace.errStack("PackageEnumerator.getClassesForPackage(" + pckgname + "): " + cnfe.getMessage(), cnfe);
        }
        catch (NullPointerException npe) {
            trace.errStack("PackageEnumerator.getClassesForPackage() " + pckgname + " does not appear to be a valid package", npe);
        }
        catch (Exception e) {
            trace.errStack("PackageEnumerator.getClassesForPackage(" + pckgname + "): error trying to get resources", e);
        }
        return classes;
    }

    static {
        for (Method m : Object.class.getMethods()) {
            ObjectMethods.add(m.getName());
        }
        ExtractMethodSignature = Pattern.compile(" *(\\[[a-zA-Z]+\\] *)?([a-zA-Z_][a-zA-Z_0-9]*\\([^)]*\\)).*");
    }
}

