/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SaveFileDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateReaderJDom;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.ViewUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SkillMatrixDialog {
    private String reportDialogTitle = "Skill Matrix Report";
    private String dirName = "";
    private String dirFullName = "";
    private List<String> ruleProductionList = null;
    private Font subdirFont = new Font("Dialog", 1, 12);
    private Font problemFont = new Font("SansSerif", 0, 11);

    public static SkillMatrixDialog doDialog(BR_Controller ctlr) {
        String projDir = SaveFileDialog.getProjectsDirectory(ctlr);
        File dir = DialogUtilities.chooseFile(projDir, null, new BrdFilter(), "Skill Matrix: Please choose a directory to scan", "Open", 2, ctlr.getActiveWindow());
        if (dir == null) {
            return null;
        }
        List<File> brdFiles = Utils.findFiles(dir, new BrdFilter());
        if (brdFiles.size() < 1) {
            JOptionPane.showMessageDialog(ctlr.getActiveWindow(), "There are no .brd files under your selection.", "Skill Matrix: Warning", 2);
            return null;
        }
        return new SkillMatrixDialog(dir, brdFiles, ctlr);
    }

    public SkillMatrixDialog(File dir, List<File> brdFiles, BR_Controller ctlr) {
        this.dirFullName = dir.getPath();
        this.dirName = dir.getName();
        List<List<File>> subdirsWithFiles = SkillMatrixDialog.splitBySubdir(brdFiles);
        this.ruleProductionList = new ArrayList<String>();
        List<Object> tempVector = this.skillsMatrix(this.dirFullName, subdirsWithFiles, this.ruleProductionList);
        ArrayList<Object> meterFrequency = new ArrayList<Object>();
        meterFrequency.add(this.dirName);
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "size of top-level list: " + tempVector.size());
        }
        meterFrequency.addAll(tempVector);
        this.generateSkillsMatrixReport(meterFrequency, this.ruleProductionList, ctlr);
    }

    static List<List<File>> splitBySubdir(List<File> brdFiles) {
        ArrayList<List<File>> result = new ArrayList<List<File>>();
        int i = 0;
        while (i < brdFiles.size()) {
            int j;
            String parent = brdFiles.get(i).getParent();
            for (j = i; j < brdFiles.size() && parent.equals(brdFiles.get(j).getParent()); ++j) {
            }
            result.add(brdFiles.subList(i, j));
            i = j;
        }
        return result;
    }

    void generateSkillsMatrixReport(List<Object> skillsMatrix, List<String> ruleProductionList, BR_Controller ctlr) {
        new UnitSkillsMatrixReportPanel(skillsMatrix, ruleProductionList, ctlr);
    }

    private List<Object> skillsMatrix(String dirFullName, List<List<File>> subdirsWithFiles, List<String> ruleProductionList) {
        ArrayList<Object> skillsFrequency = new ArrayList<Object>();
        for (List<File> subdirList : subdirsWithFiles) {
            String subdir = subdirList.get(0).getParent();
            if (trace.getDebugCode("skills")) {
                trace.out("skills", "Calling subdirSkillsMatrix(" + subdir + ");\n    dirFullName " + dirFullName);
            }
            if (subdir.startsWith(dirFullName)) {
                subdir = subdir.length() == dirFullName.length() ? "." : subdir.substring(dirFullName.length() + 1);
            }
            if (!subdir.endsWith(File.separator)) {
                subdir = subdir + File.separator;
            }
            List<Object> subdirResult = this.subdirSkillsMatrix(subdirList, ruleProductionList);
            ArrayList<Object> subdirSkillsFrequency = new ArrayList<Object>();
            subdirSkillsFrequency.add(subdir);
            subdirSkillsFrequency.addAll(subdirResult);
            skillsFrequency.add(subdirSkillsFrequency);
        }
        return skillsFrequency;
    }

    private List<Object> subdirSkillsMatrix(List<File> brdFiles, List<String> ruleProductionList) {
        ArrayList<Object> subdirSkillsFrequency = new ArrayList<Object>();
        for (File problemFile : brdFiles) {
            if (!problemFile.isFile()) continue;
            RuleProduction.Catalog rpc = new RuleProduction.Catalog();
            ProblemStateReaderJDom psrj = new ProblemStateReaderJDom(null);
            ProblemModel pm = psrj.loadBRDFileIntoProblemModel(problemFile.toString(), rpc);
            if (trace.getDebugCode("skills")) {
                trace.out("skills", "subdirSkillsMatrix() pm " + pm + " from " + problemFile.getName());
            }
            if (pm == null) continue;
            List<Integer> tempVector = SkillMatrixDialog.problemSkillsMatrix(pm, ruleProductionList, rpc);
            ArrayList<Object> problemFrequency = new ArrayList<Object>();
            problemFrequency.add(problemFile.getName());
            problemFrequency.addAll(tempVector);
            subdirSkillsFrequency.add(problemFrequency);
        }
        return subdirSkillsFrequency;
    }

    public static List<Integer> problemSkillsMatrix(ProblemModel pm, List<String> ruleProductionList, RuleProduction.Catalog rpc) {
        ArrayList<Integer> problemSkillFrequency = new ArrayList<Integer>();
        int sizeOfRules = ruleProductionList.size();
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "problem name " + pm.getProblemName() + "; ruleProductionList[" + sizeOfRules + "] " + ruleProductionList);
        }
        for (int j = 0; j < sizeOfRules; ++j) {
            problemSkillFrequency.add(new Integer(0));
        }
        Vector<ProblemEdge> pathEdges = pm.findPathForProblemSkillsMatrix(pm.getStudentBeginsHereState());
        rpc.updateOpportunityCounts(pathEdges);
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "pathEdges " + pathEdges + "; rpc " + rpc);
        }
        HashSet<String> usedRPs = new HashSet<String>();
        for (int i = 0; i < sizeOfRules; ++i) {
            RuleProduction rp = (RuleProduction)rpc.get(ruleProductionList.get(i));
            if (rp == null) continue;
            problemSkillFrequency.set(i, rp.getOpportunityCount());
            usedRPs.add(rp.getKey());
        }
        for (String key : rpc.keySet()) {
            RuleProduction rp;
            if (usedRPs.contains(key) || (rp = (RuleProduction)rpc.get(key)).getOpportunityCount() <= 0) continue;
            ruleProductionList.add(key);
            problemSkillFrequency.add(new Integer(rp.getOpportunityCount()));
        }
        return problemSkillFrequency;
    }

    private class UnitSkillsMatrixReportPanel
    extends JDialog
    implements ActionListener {
        JLabel reportTitle;
        JPanel reportJPanel;
        JScrollPane reportScrollPanel;
        JPanel ruleNamesJPanel;
        JPanel metersJPanel;
        JPanel problemNamesJPanel;
        JPanel rulesPanel;
        JButton closeJButton;
        JPanel closeJPanel;
        JPanel contentPanel;
        private String dirName;
        int numberOfSubdirs;
        int numberOfProblems;
        int numberOfRules;
        final int cellSideLength = 25;
        final int maxLength = 750;
        final int maxHeight = 600;
        final int rulesPanelMargin = 20;
        int problemNamesJPanelWidth;
        final int ruleNameHeight = 20;
        final int topMargin = 20;
        final int leftMargin = 10;
        final int rightMargin = 10;

        public UnitSkillsMatrixReportPanel(List<Object> skillsMatrix, List<String> ruleProductionList, BR_Controller ctlr) {
            int i;
            super(ctlr.getActiveWindow());
            this.reportTitle = new JLabel();
            this.reportJPanel = new JPanel();
            this.ruleNamesJPanel = new JPanel();
            this.metersJPanel = new JPanel();
            this.problemNamesJPanel = new JPanel();
            this.rulesPanel = new JPanel();
            this.closeJButton = new JButton("Close");
            this.closeJPanel = new JPanel();
            this.contentPanel = new JPanel();
            this.cellSideLength = 25;
            this.maxLength = 750;
            this.maxHeight = 600;
            this.rulesPanelMargin = 20;
            this.problemNamesJPanelWidth = 20;
            this.ruleNameHeight = 20;
            this.topMargin = 20;
            this.leftMargin = 10;
            this.rightMargin = 10;
            this.setTitle(SkillMatrixDialog.this.reportDialogTitle);
            this.dirName = (String)skillsMatrix.get(0);
            if (trace.getDebugCode("skills")) {
                trace.out("skills", "dirName = " + this.dirName);
            }
            this.reportTitle.setText(this.dirName);
            this.reportTitle.setName("reportTitle");
            this.numberOfRules = ruleProductionList.size();
            if (trace.getDebugCode("skills")) {
                trace.out("skills", "numberOfRules = " + this.numberOfRules);
            }
            this.numberOfSubdirs = skillsMatrix.size() - 1;
            if (trace.getDebugCode("skills")) {
                trace.out("skills", "numberOfSubdirs = " + this.numberOfSubdirs);
            }
            this.numberOfProblems = 0;
            for (int i2 = 1; i2 <= this.numberOfSubdirs; ++i2) {
                List tempVector = (List)skillsMatrix.get(i2);
                this.numberOfProblems = this.numberOfProblems + tempVector.size() - 1;
            }
            if (trace.getDebugCode("skills")) {
                trace.out("skills", "total problems = " + this.numberOfProblems);
            }
            this.problemNamesJPanel.setLayout(new GridLayout(this.numberOfProblems + this.numberOfSubdirs + 1, 1));
            JLabel emptyJLabel = new JLabel(" ");
            emptyJLabel.setSize(new Dimension(this.problemNamesJPanelWidth, 25));
            this.problemNamesJPanel.add(emptyJLabel);
            this.metersJPanel.setLayout(new GridLayout(this.numberOfProblems + this.numberOfSubdirs + 1, this.numberOfRules));
            for (int i3 = 1; i3 <= this.numberOfRules; ++i3) {
                JLabel ruleJLabel = new JLabel("S" + i3);
                ruleJLabel.setHorizontalAlignment(11);
                ruleJLabel.setSize(new Dimension(25, 25));
                ruleJLabel.setBackground(Color.white);
                this.metersJPanel.add(ruleJLabel);
            }
            for (i = 1; i <= this.numberOfSubdirs; ++i) {
                int j;
                List subdirVector = (List)skillsMatrix.get(i);
                String subdirName = (String)subdirVector.get(0);
                JLabel subdirJLabel = new JLabel(subdirName);
                subdirJLabel.setFont(SkillMatrixDialog.this.subdirFont);
                FontMetrics fm = subdirJLabel.getFontMetrics(SkillMatrixDialog.this.subdirFont);
                this.problemNamesJPanelWidth = Math.max(this.problemNamesJPanelWidth, fm.stringWidth(subdirName));
                subdirJLabel.setSize(new Dimension(this.problemNamesJPanelWidth, 25));
                subdirJLabel.setBackground(Color.white);
                subdirJLabel.setName("subdirName" + i);
                this.problemNamesJPanel.add(subdirJLabel);
                for (j = 1; j <= this.numberOfRules; ++j) {
                    JLabel ruleJLabel = new JLabel("");
                    ruleJLabel.setFont(SkillMatrixDialog.this.problemFont);
                    ruleJLabel.setSize(new Dimension(25, 25));
                    ruleJLabel.setBackground(Color.white);
                    this.metersJPanel.add(ruleJLabel);
                }
                int subdirProblemNumbers = subdirVector.size() - 1;
                for (j = 1; j <= subdirProblemNumbers; ++j) {
                    int k;
                    List tempProblemVector = (List)subdirVector.get(j);
                    StringBuilder sb = new StringBuilder((String)tempProblemVector.get(0));
                    sb.insert(0, "   ");
                    int dotOffset = Math.max(sb.lastIndexOf("."), sb.length());
                    sb.delete(dotOffset, sb.length());
                    if (trace.getDebugCode("skills")) {
                        trace.out("skills", "tempProblemName = " + sb);
                    }
                    JLabel problemJLabel = new JLabel(sb.toString());
                    problemJLabel.setFont(SkillMatrixDialog.this.problemFont);
                    fm = problemJLabel.getFontMetrics(SkillMatrixDialog.this.problemFont);
                    this.problemNamesJPanelWidth = Math.max(this.problemNamesJPanelWidth, fm.stringWidth(sb.toString()));
                    problemJLabel.setSize(new Dimension(this.problemNamesJPanelWidth, 25));
                    problemJLabel.setBackground(Color.white);
                    problemJLabel.setName("problemName" + j);
                    this.problemNamesJPanel.add(problemJLabel);
                    if (trace.getDebugCode("skills")) {
                        trace.out("skills", "tempProblemVector.size() = " + tempProblemVector.size());
                    }
                    int problemRulesNumber = tempProblemVector.size() - 1;
                    for (k = 0; k < problemRulesNumber; ++k) {
                        Integer tempMeter = (Integer)tempProblemVector.get(k + 1);
                        JLabel meterJLabel = new JLabel(tempMeter.toString());
                        meterJLabel.setHorizontalAlignment(11);
                        if (trace.getDebugCode("skills")) {
                            trace.out("skills", "tempMeter[" + k + "] = " + tempMeter);
                        }
                        meterJLabel.setFont(SkillMatrixDialog.this.problemFont);
                        meterJLabel.setSize(new Dimension(25, 25));
                        this.metersJPanel.add(meterJLabel);
                    }
                    for (k = problemRulesNumber; k < this.numberOfRules; ++k) {
                        JLabel meterJLabel = new JLabel("0");
                        meterJLabel.setHorizontalAlignment(11);
                        meterJLabel.setSize(new Dimension(25, 25));
                        this.metersJPanel.add(meterJLabel);
                    }
                }
            }
            this.ruleNamesJPanel.setLayout(null);
            this.problemNamesJPanel.setLocation(10, 20);
            this.problemNamesJPanel.setBackground(Color.white);
            this.problemNamesJPanel.setSize(new Dimension(this.problemNamesJPanelWidth, (this.numberOfProblems + this.numberOfSubdirs + 1) * 25));
            this.problemNamesJPanel.setVisible(true);
            this.ruleNamesJPanel.add(this.problemNamesJPanel);
            this.metersJPanel.setLocation(10 + this.problemNamesJPanelWidth, 20);
            this.metersJPanel.setBackground(Color.white);
            this.metersJPanel.setSize(new Dimension(this.numberOfRules * 25, (this.numberOfProblems + this.numberOfSubdirs + 1) * 25));
            this.metersJPanel.setVisible(true);
            this.ruleNamesJPanel.add(this.metersJPanel);
            this.contentPanel.setLayout(new BorderLayout());
            ViewUtils.setStandardBorder(this.contentPanel);
            this.reportJPanel.setLayout(new FlowLayout());
            this.reportTitle.setFont(new Font("Dialog", 1, 14));
            this.reportJPanel.add(this.reportTitle);
            this.contentPanel.add((Component)this.reportJPanel, "North");
            this.rulesPanel.setLayout(new GridLayout(this.numberOfRules, 1));
            for (i = 1; i <= this.numberOfRules; ++i) {
                JLabel ruleLabel = new JLabel("S" + i + ": " + ruleProductionList.get(i - 1));
                ruleLabel.setSize(this.numberOfRules * 25, 20);
                ruleLabel.setName("ruleName" + i);
                this.rulesPanel.add(ruleLabel);
            }
            this.rulesPanel.setLocation(10, (this.numberOfProblems + this.numberOfSubdirs + 1) * 25 + 20 + 20);
            this.rulesPanel.setSize(new Dimension(this.problemNamesJPanel.getSize().width + this.metersJPanel.getSize().width, this.numberOfRules * 20 + 10));
            this.rulesPanel.setVisible(true);
            this.ruleNamesJPanel.add(this.rulesPanel);
            int tempWidth = 10 + this.problemNamesJPanelWidth + this.numberOfRules * 25 + 10;
            int tempHeight = (this.numberOfProblems + this.numberOfSubdirs + 1) * 25 + this.numberOfRules * 20 + 20 + 20 + 10;
            this.ruleNamesJPanel.setPreferredSize(new Dimension(tempWidth, tempHeight));
            this.reportScrollPanel = new JScrollPane(this.ruleNamesJPanel);
            this.contentPanel.add((Component)this.reportScrollPanel, "Center");
            Insets insets = this.contentPanel.getBorder().getBorderInsets(this.contentPanel);
            tempWidth += insets.left + insets.right;
            tempHeight += insets.top + insets.bottom;
            this.closeJPanel.setLayout(new FlowLayout(1));
            this.closeJPanel.add(this.closeJButton);
            this.closeJButton.addActionListener(this);
            this.contentPanel.add((Component)this.closeJPanel, "South");
            this.getContentPane().add(this.contentPanel);
            this.setSize(new Dimension(Math.min(750, tempWidth) + 20, Math.min(600, tempHeight) + 60));
            this.setLocationRelativeTo(ctlr.getActiveWindow());
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.closeJButton) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }
}

