/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.AdditionNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExponentNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExpressionTreeNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.NumberNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.VariableNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.Collections;

public class MultiplicationNode
extends ExpressionTreeNode {
    protected ArrayList<ExpressionTreeNode> multiplicands;
    protected ArrayList<ExpressionTreeNode> divisors;
    private boolean simpleTerm = false;
    private boolean numeratorIsSimpleTerm = false;
    private boolean denominatorIsSimpleTerm = true;

    public MultiplicationNode(ArrayList<ExpressionTreeNode> multiplicands, ArrayList<ExpressionTreeNode> divisors, Boolean negated, ExpressionTreeProperties properties) {
        super(null, negated, properties);
        this.multiplicands = new ArrayList<ExpressionTreeNode>(multiplicands);
        this.divisors = new ArrayList();
        if (divisors != null) {
            this.divisors.addAll(divisors);
        }
        if (this.divisors.size() < 1 && this.multiplicands.size() < 2) {
            throw new Error("MultiplicationNode() constructor with " + divisors.size() + " divisors, " + multiplicands.size() + " multiplicands");
        }
        this.children = null;
    }

    @Override
    public MultiplicationNode clone() {
        ArrayList<ExpressionTreeNode> newMultiplicands = new ArrayList<ExpressionTreeNode>();
        ArrayList<ExpressionTreeNode> newDivisors = new ArrayList<ExpressionTreeNode>();
        int i = 0;
        for (i = 0; i < this.multiplicands.size(); ++i) {
            newMultiplicands.add(this.multiplicands.get(i).clone());
        }
        for (i = 0; i < this.divisors.size(); ++i) {
            newDivisors.add(this.divisors.get(i).clone());
        }
        MultiplicationNode result = new MultiplicationNode(newMultiplicands, newDivisors, this.negated, this.properties);
        result.setSimpleTerm(this.isSimpleTerm());
        result.numeratorIsSimpleTerm = this.numeratorIsSimpleTerm;
        result.denominatorIsSimpleTerm = this.denominatorIsSimpleTerm;
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MN ");
        if (this.stringNeedsRecreation) {
            sb.append('{');
            if (this.negated) {
                sb.append('!');
            }
            sb.append("mult").append(this.multiplicands);
            sb.append(" divis").append(this.divisors);
            sb.append('}');
        } else {
            sb.append(this.myString);
        }
        return sb.toString();
    }

    @Override
    protected int count(int[] total) {
        int i;
        for (i = 0; i < this.multiplicands.size(); ++i) {
            this.multiplicands.get(i).count(total);
        }
        for (i = 0; i < this.divisors.size(); ++i) {
            this.divisors.get(i).count(total);
        }
        total[0] = total[0] + 1;
        return total[0];
    }

    @Override
    public void performBasicSimplification(boolean reorderTerms) {
        Properties factors = this.collectFactors();
        this.multiplicands = factors.multiplicands;
        this.divisors = factors.divisors;
        this.negated = factors.negated;
        this.simpleTerm = factors.simpleTerm;
        this.numeratorIsSimpleTerm = factors.numeratorIsSimpleTerm;
        this.denominatorIsSimpleTerm = factors.denominatorIsSimpleTerm;
        this.orderTerms();
        this.stringNeedsRecreation = true;
        if (trace.getDebugCode("functions")) {
            trace.out("functions", this.getClass().getSimpleName() + ".performBasicSimplification() result " + this);
        }
    }

    @Override
    protected ExpressionTreeNode removeIdentityOperandsAndDemote(boolean simpleTermsOnly) {
        int i;
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "MN.removeIdentityOperandsAndDemote() " + this.getNegatedString() + " recursing down on " + this.multiplicands.size() + " mults, " + this.divisors.size() + " divis");
        }
        for (i = 0; i < this.multiplicands.size(); ++i) {
            this.multiplicands.set(i, this.multiplicands.get(i).removeIdentityOperandsAndDemote(simpleTermsOnly));
        }
        for (i = 0; i < this.divisors.size(); ++i) {
            this.divisors.set(i, this.divisors.get(i).removeIdentityOperandsAndDemote(simpleTermsOnly));
        }
        this.stringNeedsRecreation = true;
        boolean[] myNegated = new boolean[]{this.negated};
        ArrayList<ExpressionTreeNode> newMultiplicands = this.removeIdentityOperands(this.multiplicands, this.numeratorIsSimpleTerm || this.isSimpleTerm(), simpleTermsOnly, myNegated);
        ArrayList<ExpressionTreeNode> newDivisors = this.removeIdentityOperands(this.divisors, this.denominatorIsSimpleTerm, simpleTermsOnly, myNegated);
        if (newMultiplicands.size() > 1 || this.hasDivisor(newDivisors) || simpleTermsOnly && newDivisors.size() > 0) {
            if (trace.getDebugCode("functions")) {
                trace.out("functions", "MN.removeIdentityOperandsAndDemote(" + simpleTermsOnly + ") nMults " + this.multiplicands.size() + " => " + newMultiplicands.size() + " nDivis " + this.divisors.size() + " => " + newDivisors.size() + " negated " + this.negated + " => " + myNegated[0]);
            }
            this.multiplicands = newMultiplicands;
            this.divisors = newDivisors;
            this.negated = myNegated[0];
            return this;
        }
        ExpressionTreeNode singleChild = newMultiplicands.get(0);
        boolean newNegated = singleChild.negated ^ myNegated[0];
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "MN.removeIdentityOperandsAndDemote(" + simpleTermsOnly + ") demotes to " + singleChild.getClass().getSimpleName() + " value " + singleChild.getNegatedString() + ", sign " + singleChild.negated + " => " + newNegated);
        }
        singleChild.negated = newNegated;
        return singleChild;
    }

    private ArrayList<ExpressionTreeNode> removeIdentityOperands(ArrayList<ExpressionTreeNode> operands, boolean wasSimpleTerm, boolean simpleTermsOnly, boolean[] myNegated) {
        int i;
        if (trace.getDebugCode("simpleterm")) {
            trace.outNT("simpleterm", "MN.removeIdentityOperands(" + operands + "," + wasSimpleTerm + "," + simpleTermsOnly + ")");
        }
        if (simpleTermsOnly && !wasSimpleTerm) {
            return operands;
        }
        ArrayList<ExpressionTreeNode> newOperands = new ArrayList<ExpressionTreeNode>();
        boolean oldNegated = myNegated[0];
        boolean[] childNegated = new boolean[1];
        for (i = 0; i < operands.size(); ++i) {
            ExpressionTreeNode child = operands.get(i);
            if (this.isIdentity(child, childNegated)) {
                if (!childNegated[0]) continue;
                myNegated[0] = !myNegated[0];
                continue;
            }
            newOperands.add(child);
        }
        if (newOperands.isEmpty() && i > 0) {
            newOperands.add(operands.get(i - 1));
        }
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "MN.removeIdentityOperands() size of input " + operands.size() + ", output " + newOperands.size() + "; negated was " + oldNegated + ", is " + myNegated[0]);
        }
        return newOperands;
    }

    @Override
    protected boolean isIdentity(ExpressionTreeNode operand, boolean[] negated) {
        if (!(operand instanceof NumberNode)) {
            return false;
        }
        if (negated != null && negated.length > 0) {
            negated[0] = ((NumberNode)operand).getNegatedValue() < 0.0;
        }
        return ((NumberNode)operand).getNonNegatedValue() == 1.0;
    }

    @Override
    public ExpressionTreeNode performComplexSimplification() {
        Properties factors = this.collectFactors();
        MultiplicationNode copy = new MultiplicationNode(factors.multiplicands, factors.divisors, factors.negated, this.properties);
        ExpressionTreeNode result = copy.mergeAndCancelTerms();
        return result;
    }

    public Properties collectFactors() {
        Properties newProps;
        ExpressionTreeNode child;
        Boolean localNegated = this.negated;
        ArrayList<ExpressionTreeNode> newMultiplicands = new ArrayList<ExpressionTreeNode>();
        ArrayList<ExpressionTreeNode> newDivisors = new ArrayList<ExpressionTreeNode>();
        boolean numeratorIsSimpleTerm = false;
        boolean denominatorIsSimpleTerm = false;
        int i = 0;
        for (i = 0; i < this.multiplicands.size(); ++i) {
            child = this.multiplicands.get(i);
            if (child.getClass() == MultiplicationNode.class) {
                newProps = ((MultiplicationNode)child).collectFactors();
                newMultiplicands.addAll(newProps.multiplicands);
                newDivisors.addAll(newProps.divisors);
                if (newProps.negated) {
                    localNegated = localNegated == false;
                }
                numeratorIsSimpleTerm = i == 0 && child.isSimpleTerm();
                continue;
            }
            newMultiplicands.add(child);
            if (!child.negated) continue;
            localNegated = localNegated == false;
            child.negate();
        }
        for (i = 0; i < this.divisors.size(); ++i) {
            child = this.divisors.get(i);
            if (child.getClass() == MultiplicationNode.class) {
                newProps = ((MultiplicationNode)child).collectFactors();
                newMultiplicands.addAll(newProps.divisors);
                newDivisors.addAll(newProps.multiplicands);
                if (newProps.negated) {
                    localNegated = localNegated == false;
                }
                denominatorIsSimpleTerm = i == 0 && newProps.denominatorIsSimpleTerm;
                continue;
            }
            newDivisors.add(child);
            if (!child.negated) continue;
            localNegated = localNegated == false;
            child.negate();
        }
        Properties totProps = new Properties();
        totProps.multiplicands = newMultiplicands;
        totProps.divisors = newDivisors;
        totProps.negated = localNegated;
        totProps.simpleTerm = this.isSimpleTerm();
        totProps.numeratorIsSimpleTerm = numeratorIsSimpleTerm;
        totProps.denominatorIsSimpleTerm = denominatorIsSimpleTerm;
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "MN.collectFactors() " + totProps);
        }
        return totProps;
    }

    @Override
    protected void orderTerms() {
        Collections.sort(this.multiplicands, new ExpressionTreeNode.CompareForSort());
        Collections.sort(this.divisors, new ExpressionTreeNode.CompareForSort());
    }

    @Override
    protected void orderTermsRecursive() {
        int i;
        for (i = 0; i < this.multiplicands.size(); ++i) {
            this.multiplicands.get(i).orderTermsRecursive();
        }
        Collections.sort(this.multiplicands, new ExpressionTreeNode.CompareTerms(false));
        for (i = 0; i < this.divisors.size(); ++i) {
            this.divisors.get(i).orderTermsRecursive();
        }
        Collections.sort(this.divisors, new ExpressionTreeNode.CompareTerms(false));
        this.stringNeedsRecreation = true;
        if (trace.getDebugCode("functions")) {
            trace.out("functions", this.getClass().getSimpleName() + ".orderTermsRecursive() result: " + this.toCanonicalString(4));
        }
    }

    public NumberNode mergeProductArray(ArrayList<ExpressionTreeNode> terms, NumberNode num_coefficient) {
        int j = 0;
        while (j < terms.size()) {
            ExpressionTreeNode mergeInto = terms.get(j);
            int i = j + 1;
            while (i < terms.size()) {
                ExpressionTreeNode candidate = terms.get(i);
                if (candidate.getNonNegatedString().equals("0.0")) {
                    terms.clear();
                    return new NumberNode("0.0", this.properties);
                }
                ExpressionTreeNode mergeResult = mergeInto.mergeMultiplicands(candidate);
                if (mergeResult != null) {
                    terms.remove(j);
                    mergeInto = mergeResult;
                    continue;
                }
                ++i;
            }
            if (mergeInto.getClass() == NumberNode.class) {
                num_coefficient = num_coefficient.mergeMultiplicands(mergeInto);
                terms.remove(j);
                continue;
            }
            terms.set(j, mergeInto);
            ++j;
        }
        return num_coefficient;
    }

    public ExpressionTreeNode mergeAndCancelTerms() {
        ExponentNode e;
        ExpressionTreeNode x;
        ArrayList<ExpressionTreeNode> newMultiplicands = new ArrayList<ExpressionTreeNode>();
        ArrayList<ExpressionTreeNode> newDivisors = new ArrayList<ExpressionTreeNode>();
        NumberNode mCoefficient = new NumberNode("1.0", this.properties);
        NumberNode dCoefficient = new NumberNode("1.0", this.properties);
        this.orderTerms();
        for (ExpressionTreeNode c : this.multiplicands) {
            newMultiplicands.add(c.performComplexSimplification());
        }
        mCoefficient = this.mergeProductArray(newMultiplicands, mCoefficient);
        for (ExpressionTreeNode c : this.divisors) {
            newDivisors.add(c.performComplexSimplification());
        }
        dCoefficient = this.mergeProductArray(newDivisors, dCoefficient);
        int m = 0;
        int d = 0;
        if (this.properties.cancelTerms) {
            while (m < newMultiplicands.size()) {
                ExpressionTreeNode result = null;
                boolean getNextMultiplicand = true;
                for (d = 0; d < newDivisors.size(); ++d) {
                    result = newMultiplicands.get(m).attemptCancelTerms(newDivisors.get(d));
                    if (result == null) continue;
                    if (result.getClass() == NumberNode.class) {
                        newMultiplicands.remove(m);
                        getNextMultiplicand = false;
                        newDivisors.remove(d);
                        mCoefficient = mCoefficient.mergeMultiplicands(result);
                        break;
                    }
                    newMultiplicands.set(m, result);
                    newDivisors.remove(d);
                    break;
                }
                if (!getNextMultiplicand) continue;
                ++m;
            }
        }
        m = 0;
        while (m < newMultiplicands.size()) {
            x = newMultiplicands.get(m);
            if (x.getClass() == ExponentNode.class) {
                e = (ExponentNode)x;
                if (e.getPower().negated) {
                    newMultiplicands.remove(m);
                    e.getPower().negate();
                    newDivisors.add(e);
                    continue;
                }
                ++m;
                continue;
            }
            ++m;
        }
        d = 0;
        while (d < newDivisors.size()) {
            x = newDivisors.get(d);
            if (x.getClass() == ExponentNode.class) {
                e = (ExponentNode)x;
                if (e.getPower().negated) {
                    newDivisors.remove(d);
                    e.getPower().negate();
                    newMultiplicands.add(e);
                    continue;
                }
                ++d;
                continue;
            }
            ++d;
        }
        NumberNode finalCoefficient = new NumberNode(Double.toString(mCoefficient.getNegatedValue() / dCoefficient.getNegatedValue()), this.properties);
        if (finalCoefficient.negated) {
            this.negate();
            finalCoefficient.negate();
        }
        if (finalCoefficient.getNegatedValue() != 1.0) {
            newMultiplicands.add(finalCoefficient);
        }
        if (newMultiplicands.size() == 0 && newDivisors.size() == 0) {
            if (this.negated) {
                return new NumberNode("-1.0", this.properties);
            }
            return new NumberNode("1.0", this.properties);
        }
        if (newMultiplicands.size() == 1 && newDivisors.size() == 0) {
            if (this.negated) {
                newMultiplicands.get(0).negate();
            }
            return newMultiplicands.get(0);
        }
        if (newMultiplicands.size() == 0) {
            newMultiplicands.add(new NumberNode("1.0", this.properties));
        }
        if (this.properties.distributeSums) {
            return new MultiplicationNode(newMultiplicands, newDivisors, this.negated, this.properties).distributeSums();
        }
        return new MultiplicationNode(newMultiplicands, newDivisors, this.negated, this.properties);
    }

    public ExpressionTreeNode distributeSums() {
        ExpressionTreeNode productResult = this.distributeOverArray(this.multiplicands);
        ExpressionTreeNode divisorResult = this.distributeOverArray(this.divisors);
        if (productResult != null) {
            this.multiplicands = productResult.children;
        }
        if (divisorResult != null) {
            this.divisors = divisorResult.children;
        }
        if (this.divisors.size() == 0 && productResult != null) {
            return productResult;
        }
        return this;
    }

    private ExpressionTreeNode distributeOverArray(ArrayList<ExpressionTreeNode> terms) {
        if (terms.size() < 2) {
            return null;
        }
        ArrayList<AdditionNode> sums = new ArrayList<AdditionNode>();
        int i = 0;
        while (i < terms.size()) {
            if (terms.get(i).getClass() == AdditionNode.class) {
                sums.add((AdditionNode)terms.remove(i));
                continue;
            }
            ++i;
        }
        if (sums.size() == 0) {
            return null;
        }
        AdditionNode partialExpansion = (AdditionNode)sums.remove(0);
        for (i = 0; i < sums.size(); ++i) {
            partialExpansion = partialExpansion.distribute((ExpressionTreeNode)sums.get(i));
        }
        if (terms.size() > 1) {
            partialExpansion = partialExpansion.distribute(new MultiplicationNode(terms, null, false, this.properties));
        }
        if (terms.size() == 1) {
            partialExpansion = partialExpansion.distribute(terms.get(0));
        }
        return partialExpansion.performComplexSimplification();
    }

    @Override
    protected ExpressionTreeNode additiveCombine(ExpressionTreeNode addMe) {
        if (this.divisors.size() > 0) {
            return null;
        }
        this.orderTerms();
        VariableNode thisNonCoefficient = null;
        NumberNode thisCoefficient = null;
        if (this.multiplicands.size() == 2) {
            if (this.multiplicands.get(1).getClass() == NumberNode.class) {
                thisCoefficient = (NumberNode)this.multiplicands.get(1);
            }
            if (this.multiplicands.get(0).getClass() == VariableNode.class) {
                thisNonCoefficient = (VariableNode)this.multiplicands.get(0);
            }
        }
        if (thisNonCoefficient == null || thisCoefficient == null) {
            return null;
        }
        addMe.orderTerms();
        VariableNode mergeNonCoefficient = null;
        NumberNode mergeCoefficient = null;
        if (addMe.getClass() == MultiplicationNode.class) {
            MultiplicationNode mNode = (MultiplicationNode)addMe;
            if (mNode.multiplicands.size() != 2 || mNode.divisors.size() > 0) {
                return null;
            }
            if (mNode.multiplicands.get(0).getClass() == VariableNode.class) {
                mergeNonCoefficient = (VariableNode)mNode.multiplicands.get(0);
            }
            if (mNode.multiplicands.get(1).getClass() == NumberNode.class) {
                mergeCoefficient = (NumberNode)mNode.multiplicands.get(1);
            }
        } else if (addMe.getClass() == VariableNode.class) {
            mergeNonCoefficient = (VariableNode)addMe;
            mergeCoefficient = new NumberNode("1.0", this.properties);
        } else {
            return null;
        }
        if (thisNonCoefficient.getNonNegatedString().equals(mergeNonCoefficient.getNonNegatedString())) {
            NumberNode newSum;
            double thisNegated = 1.0;
            double mergeNegated = 1.0;
            if (this.negated) {
                this.negate();
                thisNegated = -1.0;
            }
            if (addMe.negated) {
                mergeNegated = -1.0;
            }
            if ((newSum = new NumberNode(Double.toString(mergeCoefficient.getNegatedValue() * mergeNegated + thisCoefficient.getNegatedValue() * thisNegated), this.properties)).getNonNegatedValue() == 0.0) {
                return new NumberNode("0.0", this.properties);
            }
            if (newSum.negated) {
                this.negate();
                newSum.negate();
            }
            this.multiplicands.set(1, newSum);
            this.stringNeedsRecreation = true;
            return this;
        }
        return null;
    }

    @Override
    protected ExpressionTreeNode cloneAndMultiplyBy(ExpressionTreeNode x) {
        MultiplicationNode copyOfMe = this.clone();
        ExpressionTreeNode copyOfX = x.clone();
        if (copyOfX.getClass() == MultiplicationNode.class) {
            copyOfMe.multiplicands.addAll(((MultiplicationNode)copyOfX).multiplicands);
            copyOfMe.divisors.addAll(((MultiplicationNode)copyOfX).divisors);
        } else {
            copyOfMe.multiplicands.add(copyOfX);
        }
        if (copyOfX.negated) {
            copyOfMe.negate();
        }
        return copyOfMe;
    }

    @Override
    protected String toCanonicalString(int callerLevel) {
        StringBuilder sb = new StringBuilder();
        if (callerLevel < this.getNodeLevel()) {
            sb.append('(');
        }
        this.toCanonicalString(this.multiplicands, sb);
        if (this.hasDivisor(this.divisors)) {
            sb.append('/');
            this.toCanonicalString(this.divisors, sb);
        }
        if (callerLevel < this.getNodeLevel()) {
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean hasDivisor(ArrayList<ExpressionTreeNode> divisorsToCheck) {
        for (int i = 0; i < divisorsToCheck.size(); ++i) {
            ExpressionTreeNode divisorNode = divisorsToCheck.get(i);
            if (!(divisorNode instanceof NumberNode)) {
                return true;
            }
            NumberNode divisor = (NumberNode)divisorNode;
            if (divisor.getNegatedValue() == 1.0) continue;
            return true;
        }
        return false;
    }

    private void toCanonicalString(ArrayList<ExpressionTreeNode> members, StringBuilder sb) {
        int i;
        if (members.size() < 1) {
            sb.append('1');
            return;
        }
        sb.append('(');
        for (i = 0; i < members.size() - 1; ++i) {
            sb.append(members.get(i).toCanonicalString(this.getNodeLevel())).append("*");
        }
        sb.append(members.get(i).toCanonicalString(this.getNodeLevel()));
        sb.append(')');
    }

    @Override
    protected String getNonNegatedString(boolean preserveSimpleTerms) {
        ExpressionTreeNode node;
        int i;
        if (trace.getDebugCode("simpleterm")) {
            trace.out("simpleterm", String.format("MN.getNonNegatedString(%b) isSimpleTerm %b, myString %s", preserveSimpleTerms, this.isSimpleTerm(), this.myString));
        }
        if (preserveSimpleTerms && this.isSimpleTerm()) {
            return this.makeSimpleTermNonNegatedString();
        }
        if (!this.stringNeedsRecreation) {
            return this.myString;
        }
        StringBuilder tot = new StringBuilder();
        tot.append("(");
        for (i = 0; i < this.multiplicands.size() - 1; ++i) {
            node = this.multiplicands.get(i);
            tot.append(node.getNegatedString(preserveSimpleTerms)).append("*");
        }
        if (this.multiplicands.size() > 0) {
            tot.append(this.multiplicands.get(i).getNegatedString(preserveSimpleTerms));
        }
        for (i = 0; i < this.divisors.size(); ++i) {
            node = this.divisors.get(i);
            tot.append("/").append(node.getNegatedString(preserveSimpleTerms));
        }
        tot.append(")");
        this.setString(tot.toString());
        this.stringNeedsRecreation = false;
        return this.myString;
    }

    private String makeSimpleTermNonNegatedString() {
        ExpressionTreeNode node;
        int i;
        ArrayList<ExpressionTreeNode> multiplicands = new ArrayList<ExpressionTreeNode>(this.multiplicands);
        Collections.sort(multiplicands, new ExpressionTreeNode.CompareTerms(true));
        StringBuilder tot = new StringBuilder();
        tot.append("(");
        for (i = 0; i < multiplicands.size(); ++i) {
            node = multiplicands.get(i);
            tot.append(node.getNegatedString(true));
        }
        if (this.divisors.size() > 0) {
            tot.append(")/(");
            for (i = 0; i < this.divisors.size(); ++i) {
                node = this.divisors.get(i);
                tot.append(node.getNegatedString(true));
            }
        }
        tot.append(")");
        return tot.toString();
    }

    public String getNonCoefficientString() {
        int i;
        String full = this.getNonNegatedString();
        for (i = 0; i < full.length() && (full.charAt(i) < '0' || full.charAt(i) > '9' || full.charAt(i) == '.'); ++i) {
        }
        return full.substring(0, i);
    }

    public NumberNode getCoefficient() {
        for (int i = 0; i < this.multiplicands.size(); ++i) {
            if (this.multiplicands.get(i).getClass() != NumberNode.class) continue;
            if (i != this.multiplicands.size() - 1) {
                throw new Error("Coefficient in multiplciative Expression should be last...");
            }
            return (NumberNode)this.multiplicands.get(i);
        }
        return null;
    }

    @Override
    protected Boolean eval_internal() {
        Boolean eval_success = true;
        int i = 0;
        for (i = 0; i < this.multiplicands.size(); ++i) {
            eval_success = this.multiplicands.get(i).eval_internal() != false && eval_success != false;
        }
        for (i = 0; i < this.divisors.size(); ++i) {
            eval_success = this.divisors.get(i).eval_internal() != false && eval_success != false;
        }
        Double numerator_total = 1.0;
        Double denominator_total = 1.0;
        if (eval_success.booleanValue()) {
            for (i = 0; i < this.multiplicands.size(); ++i) {
                numerator_total = numerator_total * this.multiplicands.get(i).getEvalValue();
            }
            for (i = 0; i < this.divisors.size(); ++i) {
                denominator_total = denominator_total * this.divisors.get(i).getEvalValue();
            }
            Double total = numerator_total / denominator_total;
            if (this.negated) {
                total = -1.0 * total;
            }
            this.setEvalValue(total);
        }
        return eval_success;
    }

    @Override
    public boolean isSimpleTerm() {
        return this.simpleTerm;
    }

    @Override
    public void setSimpleTerm(boolean simpleTerm) {
        super.setSimpleTerm(simpleTerm);
        this.simpleTerm = simpleTerm;
        this.numeratorIsSimpleTerm = simpleTerm;
    }

    private class Properties {
        public ArrayList<ExpressionTreeNode> multiplicands;
        public ArrayList<ExpressionTreeNode> divisors;
        public boolean negated;
        public boolean simpleTerm;
        public boolean numeratorIsSimpleTerm;
        public boolean denominatorIsSimpleTerm;

        private Properties() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MN.Properties ");
            if (this.negated) {
                sb.append('!');
            }
            sb.append("mult").append(this.multiplicands);
            sb.append(" divs").append(this.divisors);
            return sb.toString();
        }
    }
}

