/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.LinkInspector;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.LinkEditFunctions;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorException;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorManager;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_ActionTypeSubpanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_HintSubpanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_MessageSubpanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_SAISubpanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_Subpanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_TraversalSubpanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeColorEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeDeletedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeRewiredEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class LinkInspectorPanel
extends JPanel
implements MouseListener {
    public static int PreferredWidth = 100;
    public static int PreferredHeight = 500;
    private LinkInspectorManager MyManager = null;
    private BR_Controller Controller = null;
    private long Identifier = -1L;
    private ProblemEdge MyEdge = null;
    private LinkEditFunctions functions;
    private boolean Locked = false;
    private JLabel StatusLabel = null;
    private Dimension CurrentDimensions = this.getSize();
    private JPanel DisplayPanel = null;
    private LI_ActionTypeSubpanel actionTypeSubpanel;
    private LI_SAISubpanel SAISubpanel;
    private LI_TraversalSubpanel traversalSubpanel;
    private LI_HintSubpanel hintSubpanel;
    private LI_MessageSubpanel messageSubpanel;
    private JScrollPane DisplayScrollPane = null;
    private ArrayList<LI_Subpanel> Subpanels = null;
    private Color defaultColor;

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    LinkInspectorPanel(LinkInspectorManager Manager, BR_Controller Controller, Color color) {
        if (trace.getDebugCode("linkinspector")) {
            trace.outNT("linkinspector", "Generating Blank Panel.");
        }
        this.defaultColor = color;
        this.MyManager = Manager;
        this.Controller = Controller;
        this.MyEdge = null;
        this.setBackground(Color.WHITE);
        Dimension PD = new Dimension(PreferredWidth, PreferredHeight);
        this.setPreferredSize(PD);
        this.setName("LinkInspector");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createLineBorder(color, 3));
        this.StatusLabel = new JLabel("Status Empty.");
        this.StatusLabel.setName("LI_StatusLabel");
        this.add(this.StatusLabel);
        this.addMouseListener(this);
        this.clearEdge();
        if (trace.getDebugCode("linkinspector")) {
            trace.outNT("linkinspector", "Done. Generating Blank Panel.");
        }
    }

    public void restoreEdgeColor() {
        if (this.MyEdge != null && this.MyEdge.getEdgeData() != null) {
            EdgeColorEvent evt = new EdgeColorEvent(this, this.MyEdge, this.MyEdge.getEdgeData().getDefaultColor());
            this.Controller.getProblemModel().fireProblemModelEvent(evt);
        }
    }

    long getIdentifier() {
        return this.Identifier;
    }

    void setIdentifier(long NewID) {
        this.Identifier = NewID;
    }

    Dimension getDimensions() {
        return this.CurrentDimensions;
    }

    void lock() {
        this.Locked = true;
        this.StatusLabel.setText("Locked");
    }

    void unlock() {
        this.Locked = false;
        this.StatusLabel.setText("Unlocked");
    }

    void makePrimary() {
    }

    void makeSecondary() {
    }

    void makeBinned() {
        this.clearEdge();
    }

    void clearEdge() {
        if (trace.getDebugCode("linkinspector")) {
            trace.outNT("linkinspector", "Setting blank look and feel.");
        }
        if (this.MyEdge != null) {
            this.MyEdge = null;
            this.remove(this.DisplayScrollPane);
            for (LI_Subpanel Subp : this.Subpanels) {
                Subp.clearEdge();
            }
            this.Subpanels = null;
            this.actionTypeSubpanel = null;
            this.SAISubpanel = null;
            this.traversalSubpanel = null;
            this.hintSubpanel = null;
            this.messageSubpanel = null;
            this.DisplayPanel = null;
            this.DisplayScrollPane = null;
            this.repaintLater();
        }
    }

    void updateStatusLabel(EdgeData data) {
        ProblemEdge edge = data.getEdge();
        String edgeText = data == null ? "Link: " : "Link #" + String.valueOf(data.getUniqueID()) + ": ";
        edgeText = edgeText + "(" + edge.getSource() + "->" + edge.getDest() + ")";
        this.StatusLabel.setText(edgeText);
    }

    void setEdge(ProblemEdge Edge) throws LinkInspectorException {
        if (trace.getDebugCode("LI_Panel")) {
            trace.outNT("LI_Panel", "Setting blank look and feel.");
        }
        int Height = 0;
        EdgeData Data = Edge.getEdgeData();
        Object Sub2 = null;
        int Width = this.getWidth() - 20;
        if (this.MyEdge != null) {
            this.restoreEdgeColor();
            this.clearEdge();
        }
        this.MyEdge = Edge;
        this.functions = Edge.getLinkEditFunctions();
        this.updateStatusLabel(Data);
        this.DisplayPanel = new JPanel();
        this.DisplayPanel.setName("LinkInspector:DisplayPanel");
        BoxLayout Layout = new BoxLayout(this.DisplayPanel, 1);
        this.DisplayPanel.setLayout(Layout);
        this.DisplayPanel.addMouseListener(this);
        this.Subpanels = new ArrayList(1);
        this.actionTypeSubpanel = new LI_ActionTypeSubpanel(this.Controller, Edge, Width, this);
        Height += this.addSubpanel(this.actionTypeSubpanel);
        this.traversalSubpanel = new LI_TraversalSubpanel(this.Controller, Edge, Width, this);
        Height += this.addSubpanel(this.traversalSubpanel);
        this.SAISubpanel = new LI_SAISubpanel(this.Controller, Edge, Width, this);
        Height += this.addSubpanel(this.SAISubpanel);
        if (Edge.isCorrectorFireableBuggy()) {
            this.hintSubpanel = new LI_HintSubpanel(this.Controller, Edge, Width, this);
            Height += this.addSubpanel(this.hintSubpanel);
        } else {
            this.hintSubpanel = null;
        }
        this.messageSubpanel = new LI_MessageSubpanel(this.Controller, Edge, Width, this);
        Height += this.addSubpanel(this.messageSubpanel);
        if (trace.getDebugCode("LI_Panel")) {
            trace.outNT("LI_Panel", "Setting preferred height: " + Height);
        }
        this.DisplayScrollPane = new JScrollPane(this.DisplayPanel);
        this.add(this.DisplayScrollPane);
        this.DisplayScrollPane.addMouseListener(this);
        this.Controller.getProblemModel().fireProblemModelEvent(new EdgeColorEvent(this, this.MyEdge, this.defaultColor));
        this.repaintLater();
    }

    private int addSubpanel(LI_Subpanel Subp) {
        if (trace.getDebugCode("LI_Panel")) {
            trace.outNT("LI_Panel", "Adding new subpanel: " + Subp.getName());
        }
        Subp.addMouseListener(this);
        this.DisplayPanel.add(Subp);
        this.Subpanels.add(Subp);
        Subp.setAlignmentX(0.0f);
        return Subp.getHeight();
    }

    private void updateContents(EdgeEvent Ev) {
        if (Ev instanceof EdgeRewiredEvent) {
            this.MyEdge = ((EdgeRewiredEvent)Ev).getEdgeCreatedEvent().getEdge();
            this.updateStatusLabel(this.MyEdge.getEdgeData());
        }
        for (LI_Subpanel S : this.Subpanels) {
            S.updateContents(Ev);
        }
        this.repaintLater();
    }

    public void repaintLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LinkInspectorPanel.this.repaint();
            }
        });
    }

    public void repaint2() {
        if (this.DisplayPanel != null) {
            this.DisplayPanel.repaint();
            this.DisplayScrollPane.repaint();
            for (LI_Subpanel S : this.Subpanels) {
                S.repaint();
            }
        }
        super.repaint();
    }

    public void updateDimensionsLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LinkInspectorPanel.this.updateDimensions();
                LinkInspectorPanel.this.repaint();
            }
        });
    }

    private boolean updateDimensions() {
        return this.updateDimensionsI(true);
    }

    private boolean updateDimensionsI(boolean AllowRecur) {
        Dimension NewDimensions = this.getSize();
        int HeightLim = this.StatusLabel.getHeight() + 4;
        boolean VScrollVisible = false;
        int WidthLim = 0;
        if (NewDimensions != this.CurrentDimensions) {
            if (trace.getDebugCode("LI_Panel")) {
                trace.outNT("LI_Panel", "Dimensions Changed");
            }
            this.CurrentDimensions = NewDimensions;
            if (this.DisplayPanel != null && this.Subpanels != null) {
                HeightLim = (int)NewDimensions.getHeight() - HeightLim;
                WidthLim = (int)NewDimensions.getWidth() - 2;
                Dimension PreferredDimensions = new Dimension(WidthLim, HeightLim);
                this.DisplayScrollPane.setPreferredSize(PreferredDimensions);
                JScrollBar VBar = this.DisplayScrollPane.getVerticalScrollBar();
                if (VBar == null && VBar.isVisible()) {
                    WidthLim = VBar.getWidth() + 10;
                    VScrollVisible = true;
                } else {
                    WidthLim = 10;
                    VScrollVisible = false;
                }
                WidthLim = (int)NewDimensions.getWidth() - WidthLim;
                PreferredDimensions = new Dimension(WidthLim, HeightLim);
                this.DisplayPanel.setPreferredSize(PreferredDimensions);
                this.DisplayPanel.setMaximumSize(PreferredDimensions);
                JScrollBar VScroll = this.DisplayScrollPane.getVerticalScrollBar();
                if (VScroll == null) {
                    if (trace.getDebugCode("LI_Panel")) {
                        trace.outNT("LI_Panel", "Scroll Panel Null");
                    }
                } else {
                    if (trace.getDebugCode("LI_Panel")) {
                        trace.outNT("LI_Panel", "Scroll Panel Present ");
                    }
                    if (VScroll.isVisible()) {
                        if (trace.getDebugCode("LI_Panel")) {
                            trace.outNT("LI_Panel", "Scroll Panel Visible");
                        }
                    } else {
                        trace.outNT("LI_Panel", "Scroll Panel invisible");
                    }
                    if (trace.getDebugCode("LI_Panel")) {
                        trace.outNT("LI_Panel", "Scroll Panel " + VScroll.getWidth() + "x" + VScroll.getHeight());
                    }
                    if (trace.getDebugCode("LI_Panel")) {
                        trace.outNT("LI_Panel", "Scroll Panel D" + VScroll.getSize().toString());
                    }
                }
                VBar = this.DisplayScrollPane.getVerticalScrollBar();
                if (AllowRecur) {
                    if (VBar == null && VBar.isVisible()) {
                        if (!VScrollVisible) {
                            if (trace.getDebugCode("LI_Panel")) {
                                trace.outNT("LI_Panel", "Scroll Changed visible, recursing.");
                            }
                            return this.updateDimensionsI(false);
                        }
                    } else {
                        if (!VScrollVisible) {
                            if (trace.getDebugCode("LI_Panel")) {
                                trace.outNT("LI_Panel", "Scroll Changed invisible, recursing.");
                            }
                            return this.updateDimensionsI(false);
                        }
                        return true;
                    }
                }
                return true;
            }
        }
        return false;
    }

    void handleProblemModelEvent(ProblemModelEvent Ev) {
        if (trace.getDebugCode("LI_Panel")) {
            trace.outNT("LI_Panel", "Handling Problem Model Event.");
        }
        boolean Updated = false;
        if (this.MyEdge != null) {
            int Result;
            if (Ev.isCompoundEventP()) {
                ArrayList<Class> TypeList = new ArrayList<Class>(2);
                TypeList.add(EdgeEvent.class);
                List<ProblemModelEvent> SubList2 = Ev.collectSubevents(null, TypeList, true, true, true);
                if (!SubList2.isEmpty()) {
                    for (ProblemModelEvent Ep : SubList2) {
                        Result = this.handleSingleEdgeEvent(Ep, Updated);
                        if (Result == -1) {
                            return;
                        }
                        if (Result != 1) continue;
                        Updated = true;
                    }
                }
            }
            if (Ev instanceof EdgeEvent) {
                Result = this.handleSingleEdgeEvent(Ev, Updated);
                if (Result != 0) {
                    return;
                }
            } else if (!Updated && Ev instanceof NodeCreatedEvent) {
                this.updateContents(null);
                return;
            }
        }
    }

    private int handleSingleEdgeEvent(ProblemModelEvent Ev, boolean Updated) {
        if (Ev.getSource().equals(this)) {
            return 0;
        }
        if (Ev instanceof EdgeEvent) {
            ProblemEdge Edg = ((EdgeEvent)((Object)Ev)).getEdge();
            if (Edg.getUniqueID() == this.MyEdge.getUniqueID()) {
                if (Ev instanceof EdgeDeletedEvent) {
                    if (((EdgeDeletedEvent)Ev).isEdgeBeingRewired()) {
                        return 0;
                    }
                    this.clearEdge();
                    return -1;
                }
                if (Ev instanceof EdgeCreatedEvent) {
                    return 0;
                }
                if (Ev instanceof EdgeRewiredEvent) {
                    if (Updated) {
                        return 0;
                    }
                    this.updateContents((EdgeRewiredEvent)Ev);
                    return 1;
                }
                if (Ev instanceof EdgeUpdatedEvent) {
                    if (Updated) {
                        return 0;
                    }
                    this.updateContents((EdgeUpdatedEvent)Ev);
                    return 1;
                }
            }
        } else if (!Updated && Ev instanceof NodeCreatedEvent) {
            this.updateContents(null);
            return 1;
        }
        return 0;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateDimensionsLater();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (trace.getDebugCode("LI_Panel")) {
            trace.outNT("LI_Panel", "Mouse Clicked.");
        }
        this.MyManager.activateThisPanel(this);
        this.repaintLater();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.updateDimensionsLater();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

