/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.HelpSuccessPanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorException;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorPanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_Subpanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LI_MessageSubpanel
extends LI_Subpanel {
    private static final int MAX_WIDTH = 300;
    private static int PREF_HEIGHT = 60;
    private JLabel PanelLabel = null;
    private JScrollPane ContentsPane = null;
    private MessageTextArea ContentsPaneMessage = null;
    private ActionLabel CurrActionLabel = null;

    public LI_MessageSubpanel(BR_Controller Controller, ProblemEdge Edge, int CurrWidth, LinkInspectorPanel Panel2) throws LinkInspectorException {
        this.Panel = Panel2;
        if (trace.getDebugCode("LI_MessageSubpanel")) {
            trace.outNT("LI_MessageSubpanel", "Generating Panel");
        }
        this.setController(Controller);
        this.setEdge(Edge);
        this.CurrActionLabel = this.CurrEdgeData.getActionLabel();
        this.setName("LI_MessageSubpanel");
        this.setPreferredSize(new Dimension(CurrWidth, PREF_HEIGHT));
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        String LabelText = this.CurrEdge.isBuggy() ? "<html><u>Buggy Message:</u></html>" : "<html><u>Message:</u></html>";
        this.PanelLabel = new JLabel(LabelText, 0);
        this.add(this.PanelLabel);
        this.PanelLabel.addMouseListener(this);
        MessageTextArea messageArea = this.CurrEdge.isBuggy() ? new MessageTextArea(this.CurrEdgeData.getBuggyMsg(), this) : new MessageTextArea(this.CurrEdgeData.getSuccessMsg(), this);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        this.ContentsPaneMessage = messageArea;
        this.ContentsPane = new JScrollPane(messageArea);
        this.ContentsPane.setVerticalScrollBarPolicy(20);
        this.ContentsPane.setHorizontalScrollBarPolicy(31);
        this.add(this.ContentsPane);
        this.setContents();
        if (trace.getDebugCode("LI_MessageSubpanel")) {
            trace.outNT("LI_MessageSubpanel", "L: " + this.getLocation());
        }
    }

    private void setContents() {
        String LabelText;
        String text;
        if (this.CurrEdge.isBuggy()) {
            text = this.CurrEdgeData.getBuggyMsg();
            LabelText = "<html><u>Buggy Message:</u></html>";
        } else {
            text = this.CurrEdgeData.getSuccessMsg();
            LabelText = "<html><u>Message:</u></html>";
        }
        this.PanelLabel.setText(LabelText);
        this.ContentsPaneMessage.setText(text);
        this.setSize(this.PanelLabel.getHeight() + this.ContentsPaneMessage.getHeight(), this.getWidth());
    }

    @Override
    public void refreshData(EdgeEvent Ev) {
        this.setContents();
    }

    @Override
    protected int getMinHeight(int WidthLimit) {
        if (this.ContentsPane == null) {
            return PREF_HEIGHT;
        }
        Dimension LabelDimen = this.PanelLabel.getSize();
        Dimension ContentDimen = this.ContentsPane.getSize();
        int ContentWidth = (int)ContentDimen.getWidth();
        int ContentHeight = (int)ContentDimen.getHeight();
        int NewHeight = ContentWidth * ContentHeight / WidthLimit;
        NewHeight += (int)LabelDimen.getHeight();
        return NewHeight += 5;
    }

    @Override
    public void mouseClicked(MouseEvent E) {
        String ActionType = this.CurrEdgeData.getActionType();
        if (ActionType.equalsIgnoreCase("Correct Action")) {
            new HelpSuccessPanel(this.Controller, this.CurrEdgeData, false).setVisible(true);
            this.handleUpdate();
        } else if (ActionType.equalsIgnoreCase("Buggy Action") || ActionType.equalsIgnoreCase("Fireable Buggy Action")) {
            this.CurrEdge.getLinkEditFunctions().showEditBuggyMsgPanel();
            this.handleUpdate();
        }
    }

    private void handleUpdate() {
        this.setContents();
        this.fireUpdateEvent(false, true);
    }

    class MessageTextArea
    extends JTextArea
    implements FocusListener {
        LI_MessageSubpanel panel;
        String oldText;
        EdgeData edgeData;

        public MessageTextArea(String text, LI_MessageSubpanel panel) {
            this.setText(text);
            this.panel = panel;
            this.edgeData = panel.CurrEdgeData;
            this.oldText = text;
            this.addFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String newText = this.getText();
            if (newText == null ? this.oldText == null || this.oldText.isEmpty() : newText.equals(this.oldText)) {
                return;
            }
            this.oldText = newText;
            if (this.edgeData.getEdge().isBuggy() || this.edgeData.getActionType().equalsIgnoreCase("Fireable Buggy Action")) {
                this.edgeData.setBuggyMsg(newText);
            } else {
                this.edgeData.setSuccessMsg(newText);
            }
            LI_MessageSubpanel.this.Controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this.panel.Panel, this.edgeData.getEdge(), true));
        }
    }
}

