/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;

public class DialogueSystemInfo {
    private static final String PARAM_DELIMITER = "&";
    private String student_Hint_Request;
    private String step_Successful_Completion;
    private String step_Student_Error;
    public static final int STEP_SUCCESSFUL = 0;
    public static final int STEP_HINT = 1;
    public static final int STEP_ERROR = 2;
    public static final String INVOKE_BROWSER_ON_EXTERNAL_URL = "Invoke Browser on External URL";
    public static final String EXTERNAL_URL_FOR_EDGE_TRAVERSAL = "External URL for Edge Traversal";
    protected BR_Controller controller;

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller;
    }

    public DialogueSystemInfo(BR_Controller controller) {
        this.controller = controller;
        this.student_Hint_Request = "";
        this.step_Successful_Completion = "";
        this.step_Student_Error = "";
    }

    public static boolean getUseDialogSystem(BR_Controller controller) {
        PreferencesModel pm = controller.getPreferencesModel();
        Boolean extSys = pm.getBooleanValue(INVOKE_BROWSER_ON_EXTERNAL_URL);
        return extSys != null && extSys != false;
    }

    public boolean processInfo(int type) {
        boolean findInfo = false;
        if (!this.hasInfo(type)) {
            return false;
        }
        PreferencesModel pm = this.controller.getPreferencesModel();
        Boolean invBr = pm.getBooleanValue(INVOKE_BROWSER_ON_EXTERNAL_URL);
        if (invBr != null && invBr.booleanValue()) {
            StringBuffer url = new StringBuffer();
            String prefix = pm.getStringValue(EXTERNAL_URL_FOR_EDGE_TRAVERSAL);
            if (prefix != null) {
                url.append(prefix);
            } else if (trace.getDebugCode("msg")) {
                trace.out("msg", "prefix part is null");
            }
            if (url.indexOf("?") < 0) {
                url.append("?");
            } else {
                url.append(PARAM_DELIMITER);
            }
            String studentName = null;
            LoggingSupport logger = this.controller.getLogger();
            if (logger != null) {
                studentName = logger.getStudentName();
            }
            if (studentName == null || studentName.length() == 0) {
                trace.err(this.getClass().getName() + ".processInfo(" + type + "): student login name is null or empty");
                studentName = "";
            }
            url.append("name=").append(studentName);
            if (url.indexOf("?") < 0) {
                url.append("?");
            } else {
                url.append(PARAM_DELIMITER);
            }
            if (type == 0) {
                url.append(this.getStep_Successful_Completion());
            } else if (type == 1) {
                url.append(this.getStudent_Hint_Request());
            } else {
                url.append(this.getStep_Student_Error());
            }
            Utils.invokeBrowser(url.toString());
            findInfo = true;
        }
        return findInfo;
    }

    public boolean hasInfo(int type) {
        return type == 0 && this.isStep_Successful_Completion() || type == 1 && this.isStudent_Hint_Request() || type == 2 && this.isStep_Student_Error();
    }

    public boolean hasInfo() {
        return this.isStep_Student_Error() || this.isStudent_Hint_Request() || this.isStep_Successful_Completion();
    }

    private String getInfo(int type) {
        if (type == 0) {
            return this.getStep_Successful_Completion();
        }
        if (type == 1) {
            return this.getStudent_Hint_Request();
        }
        if (type == 2) {
            return this.getStep_Student_Error();
        }
        return null;
    }

    public void setStudent_Hint_Request(String hint) {
        this.student_Hint_Request = hint;
    }

    public String getStudent_Hint_Request() {
        return this.student_Hint_Request;
    }

    public boolean isStudent_Hint_Request() {
        return !this.student_Hint_Request.equals("");
    }

    public void setStep_Successful_Completion(String successful) {
        this.step_Successful_Completion = successful;
    }

    public String getStep_Successful_Completion() {
        return this.step_Successful_Completion;
    }

    public boolean isStep_Successful_Completion() {
        return !this.step_Successful_Completion.equals("");
    }

    public void setStep_Student_Error(String error) {
        this.step_Student_Error = error;
    }

    public String getStep_Student_Error() {
        return this.step_Student_Error;
    }

    public boolean isStep_Student_Error() {
        return !this.step_Student_Error.equals("");
    }
}

