/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultLinkGroup
implements Comparable<DefaultLinkGroup>,
LinkGroup {
    private String groupName;
    private boolean isOrdered;
    private boolean isReenterable;
    private Set<ExampleTracerLink> links;
    private Set<LinkGroup> subgroups;
    private LinkGroup parent;
    private String defaultBuggyMsg = null;

    DefaultLinkGroup(String groupName, boolean isOrdered, boolean isReenterable) {
        this(groupName, isOrdered, isReenterable, null);
    }

    DefaultLinkGroup(String groupName, boolean isOrdered, boolean isReenterable, Set<ExampleTracerLink> links) {
        this.groupName = groupName;
        this.isOrdered = isOrdered;
        this.isReenterable = isReenterable;
        this.links = links != null ? new LinkedHashSet<ExampleTracerLink>(links) : new LinkedHashSet<ExampleTracerLink>();
        this.subgroups = new LinkedHashSet<LinkGroup>();
        this.parent = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append('(').append(this.getMode()).append(')');
        sb.append('{');
        Iterator<Object> it = this.getLinks().iterator();
        while (it.hasNext()) {
            sb.append(it.next().getUniqueID());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        it = this.getSubgroups().iterator();
        while (it.hasNext()) {
            sb.append(',').append(((DefaultLinkGroup)it.next()).getName());
        }
        sb.append('}');
        return sb.toString();
    }

    public String getTreeDisp() {
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append('(').append(this.getMode());
        sb.append(',');
        if (this.isReenterable()) {
            sb.append(" Reenterable");
        } else {
            sb.append(" Not Reenterable");
        }
        sb.append(')');
        return sb.toString();
    }

    public String getName() {
        return this.groupName;
    }

    public void setName(String name) {
        this.groupName = name;
    }

    String getMode() {
        if (this.isOrdered) {
            return "Ordered";
        }
        return "Unordered";
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void setOrdered(boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public boolean isReenterable() {
        return this.isReenterable;
    }

    public void setReenterable(boolean isReenterable) {
        this.isReenterable = isReenterable;
    }

    public Set<ExampleTracerLink> getLinks() {
        return this.links;
    }

    void addLink(ExampleTracerLink link) {
        this.links.add(link);
    }

    public boolean containsLink(ExampleTracerLink link) {
        return this.links.contains(link);
    }

    boolean removeLink(ExampleTracerLink link) {
        return this.links.remove(link);
    }

    public Set<LinkGroup> getSubgroups() {
        return this.subgroups;
    }

    public void addSubgroup(LinkGroup toBeAdded) {
        this.subgroups.add(toBeAdded);
    }

    public void removeSubgroup(LinkGroup subGroup) {
        this.subgroups.remove(subGroup);
    }

    public void removeAllSubGroups() {
        this.subgroups.clear();
    }

    public LinkGroup getParent() {
        return this.parent;
    }

    public void setParent(LinkGroup group) {
        this.parent = group;
    }

    @Override
    public int compareTo(DefaultLinkGroup group) {
        if (this.links.size() < group.getLinks().size()) {
            return 1;
        }
        if (this.links.size() == group.getLinks().size()) {
            return 0;
        }
        return -1;
    }

    public String getDefaultBuggyMsg() {
        return this.defaultBuggyMsg;
    }

    public void setDefaultBuggyMsg(String defaultBuggyMsg) {
        this.defaultBuggyMsg = defaultBuggyMsg;
    }
}

