/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.EditContextEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.EditorContextListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupChangeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupChangeListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.SingleGroupEditorContextInfo;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.SingleLinkEditorContextInfo;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupEditorContext
implements GroupChangeListener {
    Set<EditorContextListener> listeners = new HashSet<EditorContextListener>();
    Map<LinkGroup, SingleGroupEditorContextInfo> groupInfoMap;
    Map<ExampleTracerLink, SingleLinkEditorContextInfo> linkInfoMap;
    Map<ProblemEdge, Set<Shape>> edgeToShapesMap;
    Map<Shape, LinkGroup> shapeToGroupMap;
    GroupModel groupModel;
    LinkGroup selectedGroup;

    public GroupEditorContext(GroupModel groupModel) {
        this.groupModel = groupModel;
        groupModel.addGroupChangeListener(this);
        this.clear();
    }

    public GroupModel getGroupModel() {
        return this.groupModel;
    }

    public void addEditorContextListener(EditorContextListener listener) {
        this.listeners.add(listener);
    }

    public void removeEditorContextListener(EditorContextListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(EditContextEvent e) {
        for (EditorContextListener listener : this.listeners) {
            listener.editorContextChanged(e);
        }
    }

    public void addEdgeShapeGroupMap(ProblemEdge edge, Shape shapeToAdd, LinkGroup group) {
        Set<Shape> shapes = this.edgeToShapesMap.get(edge);
        if (shapes == null) {
            shapes = new HashSet<Shape>();
        }
        shapes.add(shapeToAdd);
        this.edgeToShapesMap.put(edge, shapes);
        this.shapeToGroupMap.put(shapeToAdd, group);
    }

    public void resetProblemEdgeMap(ProblemEdge target) {
        Set<Shape> shapes = this.edgeToShapesMap.get(target);
        if (shapes != null) {
            for (Shape shape : shapes) {
                this.shapeToGroupMap.remove(shape);
            }
        }
        this.edgeToShapesMap.remove(target);
    }

    public List<LinkGroup> getDisplayedGroupsByLink(ExampleTracerLink link) {
        ArrayList<LinkGroup> groupsForLink = new ArrayList<LinkGroup>();
        LinkGroup currentGroup = null;
        if (this.groupModel.isLinkInGroup(this.groupModel.getTopLevelGroup(), link)) {
            currentGroup = this.groupModel.getTopLevelGroup();
        }
        for (int i = this.groupModel.getHeight() - 1; i >= 0; --i) {
            if (this.getGroupIsDisplayedOnGraph(currentGroup)) {
                groupsForLink.add(currentGroup);
            }
            Set<LinkGroup> subgroups = this.groupModel.getGroupSubgroups(currentGroup);
            currentGroup = null;
            if (subgroups != null) {
                for (LinkGroup subgroup : subgroups) {
                    if (!this.groupModel.isLinkInGroup(subgroup, link)) continue;
                    currentGroup = subgroup;
                    break;
                }
            }
            if (currentGroup != null) continue;
            return groupsForLink;
        }
        return null;
    }

    public LinkGroup getGroupByPointOnGraph(Point p) {
        for (Set<Shape> shapes : this.edgeToShapesMap.values()) {
            for (Shape shape : shapes) {
                if (!shape.contains(p)) continue;
                return this.shapeToGroupMap.get(shape);
            }
        }
        return null;
    }

    public Set<ExampleTracerLink> getSelectedLinks() {
        HashSet<ExampleTracerLink> selectedLinks = new HashSet<ExampleTracerLink>();
        for (ExampleTracerLink link : this.groupModel.getGroupLinks(this.groupModel.getTopLevelGroup())) {
            if (!this.getLinkIsSelected(link)) continue;
            selectedLinks.add(link);
        }
        return selectedLinks;
    }

    public LinkGroup getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(LinkGroup group) {
        this.selectedGroup = group;
        this.notifyListeners(new EditContextEvent(3));
    }

    public Color getGroupColor(LinkGroup group) {
        return this.getGroupContextInfo((LinkGroup)group).color;
    }

    public void setGroupColor(LinkGroup group, Color c) {
        this.getGroupContextInfo((LinkGroup)group).color = c;
        this.notifyListeners(new EditContextEvent(3));
    }

    public boolean getGroupIsHovered(LinkGroup group) {
        return this.getGroupContextInfo((LinkGroup)group).isHovered;
    }

    public void setGroupIsHovered(LinkGroup group, boolean isHovered) {
        this.getGroupContextInfo((LinkGroup)group).isHovered = isHovered;
        this.notifyListeners(new EditContextEvent(3));
    }

    public boolean getGroupIsDisplayedOnGraph(LinkGroup group) {
        return this.getGroupContextInfo((LinkGroup)group).isDisplayedOnGraph;
    }

    public void setGroupIsDisplayedOnGraph(LinkGroup group, boolean isDisplayedOnGraph) {
        this.getGroupContextInfo((LinkGroup)group).isDisplayedOnGraph = isDisplayedOnGraph;
        this.notifyListeners(new EditContextEvent(2));
    }

    public boolean getGroupIsExpanded(LinkGroup group) {
        return this.getGroupContextInfo((LinkGroup)group).isExpanded;
    }

    public void setGroupIsExpanded(LinkGroup group, boolean isExpanded) {
        this.getGroupContextInfo((LinkGroup)group).isExpanded = isExpanded;
        this.notifyListeners(new EditContextEvent(1));
    }

    private SingleGroupEditorContextInfo getGroupContextInfo(LinkGroup group) {
        if (this.groupInfoMap.get(group) == null) {
            this.groupInfoMap.put(group, new SingleGroupEditorContextInfo());
        }
        return this.groupInfoMap.get(group);
    }

    public boolean getLinkIsSelected(ExampleTracerLink link) {
        return this.getLinkContextInfo((ExampleTracerLink)link).isSelected;
    }

    public void setLinkIsSelected(ExampleTracerLink link, boolean isSelected) {
        this.getLinkContextInfo((ExampleTracerLink)link).isSelected = isSelected;
        this.notifyListeners(new EditContextEvent(3));
    }

    public boolean getLinkIsHovered(ExampleTracerLink link) {
        return this.getLinkContextInfo((ExampleTracerLink)link).isHovered;
    }

    public void setLinkIsHovered(ExampleTracerLink link, boolean isHovered) {
        this.getLinkContextInfo((ExampleTracerLink)link).isHovered = isHovered;
        this.notifyListeners(new EditContextEvent(3));
    }

    private SingleLinkEditorContextInfo getLinkContextInfo(ExampleTracerLink link) {
        if (this.linkInfoMap.get(link) == null) {
            this.linkInfoMap.put(link, new SingleLinkEditorContextInfo());
        }
        return this.linkInfoMap.get(link);
    }

    @Override
    public void groupChanged(GroupChangeEvent e) {
        if (e.getEventType() == 1) {
            this.groupInfoMap.remove(e.getGroupTargeted());
            if (this.selectedGroup == null) {
                return;
            }
            if (this.selectedGroup.equals(e.getGroupTargeted())) {
                this.selectedGroup = null;
                this.notifyListeners(new EditContextEvent(3));
            }
        }
        if (e.getEventType() == 7) {
            this.setGroupIsDisplayedOnGraph(this.groupModel.getTopLevelGroup(), false);
        }
    }

    public ExampleTracerLink getLinkFromEdge(ProblemEdge edge) {
        for (ExampleTracerLink link : this.groupModel.getGroupLinks(this.groupModel.getTopLevelGroup())) {
            try {
                if (!link.getEdge().getEdge().equals(edge)) continue;
                return link;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public void clear() {
        this.groupInfoMap = new HashMap<LinkGroup, SingleGroupEditorContextInfo>();
        this.linkInfoMap = new HashMap<ExampleTracerLink, SingleLinkEditorContextInfo>();
        this.edgeToShapesMap = new HashMap<ProblemEdge, Set<Shape>>();
        this.shapeToGroupMap = new HashMap<Shape, LinkGroup>();
        this.setGroupIsDisplayedOnGraph(this.groupModel.getTopLevelGroup(), false);
    }
}

