/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.CTATFunctions;
import edu.cmu.pact.Utilities.trace;
import java.io.PrintWriter;
import java.io.StringWriter;

public class fmtNormal {
    public static final int DEFAULT_PRECISION = 6;
    public int defaultPrecision = 6;

    public fmtNormal() {
        this(6);
    }

    public fmtNormal(int prec) {
        this.defaultPrecision = prec;
    }

    public String fmtNormal(double value, int prec) {
        int i = 0;
        long n = 1L;
        while (i < prec) {
            double svd = value * (double)n;
            long svl = Math.round(svd);
            if (Math.abs(svd - (double)svl) < Double.MIN_NORMAL) {
                StringBuffer sb = new StringBuffer(Long.toString(svl));
                int nDigits = svl < 0L ? sb.length() - 1 : sb.length();
                int prefixOffset = svl < 0L ? 1 : 0;
                for (int j = nDigits; j < i; ++j) {
                    sb.insert(prefixOffset, '0');
                }
                if (i > 0) {
                    int decOffset = sb.length() - i < prefixOffset ? prefixOffset : sb.length() - i;
                    String dec = ".";
                    if (decOffset <= 0 || !Character.isDigit(sb.charAt(decOffset - 1))) {
                        dec = "0.";
                    }
                    sb.insert(decOffset, dec);
                }
                return fmtNormal.stripTrailingZeros(sb);
            }
            ++i;
            n *= 10L;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String fmt = "%." + prec + "f";
        pw.printf(fmt, value);
        String result = fmtNormal.stripTrailingZeros(sw.getBuffer());
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "fmtNormal(double " + value + ", int " + prec + ")->" + result);
        }
        return result;
    }

    private static String stripTrailingZeros(StringBuffer sb) {
        if (sb == null) {
            return null;
        }
        int dp = sb.lastIndexOf(".");
        if (dp < 0) {
            return sb.toString();
        }
        int end = sb.length();
        --end;
        while (dp < end && sb.charAt(end) == '0') {
            --end;
        }
        if (dp < end) {
            ++end;
        }
        return sb.substring(0, end);
    }

    public String fmtNormal(double value) {
        return this.fmtNormal(value, this.defaultPrecision);
    }

    public String fmtNormal(Object value, Object prec) {
        Double dv = CTATFunctions.toDouble(value);
        if (dv == null) {
            return "";
        }
        Double pv = CTATFunctions.toDouble(prec);
        if (pv == null) {
            return this.fmtNormal(dv);
        }
        return this.fmtNormal(dv, (int)Math.round(pv));
    }

    public String fmtNormal(Object value) {
        Double dv = CTATFunctions.toDouble(value);
        if (dv == null) {
            return "";
        }
        return this.fmtNormal(dv);
    }

    public static void main(String[] args) {
        trace.addDebugCodes(System.getProperty("DebugCodes"));
        fmtNormal t = new fmtNormal();
        int i = 0;
        int prec = 2;
        block4: for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            char option = args[i].charAt(1);
            switch (option) {
                case 'p': {
                    prec = Integer.parseInt(args[++i]);
                    t.setDefaultPrecision(prec);
                    continue block4;
                }
                case 'D': {
                    Double pD = new Double(Double.parseDouble(args[++i]));
                    Double vD = new Double(Double.parseDouble(args[++i]));
                    System.out.println("fmtNormal(" + vD + ", " + pD + ")=" + t.fmtNormal(vD, pD));
                    return;
                }
                default: {
                    System.err.println("unknown option -" + option);
                }
            }
        }
        while (i < args.length) {
            String arg = args[i];
            System.out.println("fmtNormal(" + arg + ")=" + t.fmtNormal(arg));
            ++i;
        }
    }

    public int getDefaultPrecision() {
        return this.defaultPrecision;
    }

    public void setDefaultPrecision(int defaultPrecision) {
        this.defaultPrecision = defaultPrecision;
    }
}

