/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions;

import edu.cmu.pact.Utilities.trace;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class match2D {
    private static final Pattern Point2D = Pattern.compile("\\s*[(]?\\s*(-?\\d+[.]?\\d*([eE]-?[0-9]+)?)\\s*,\\s*(-?\\d+[.]?\\d*([eE]-?[0-9]+)?)\\s*[)]?\\s*");
    private static final double DEFAULT_TOLERANCE = 0.1;

    public static void main(String[] args) {
        int i;
        match2D m2d = new match2D();
        if (args.length < 2 || args[0].equalsIgnoreCase("-h")) {
            match2D.usageExit("Too few arguments.");
        }
        Double epsilon = args[i = 0].startsWith("-") ? Double.valueOf(args[i++].substring(1)) : null;
        String target = args[i++];
        System.out.printf("with x,y tolerance " + (epsilon == null ? "default 0.1" : epsilon.toString()) + ":\n", new Object[0]);
        while (i < args.length) {
            System.out.printf("   %s: %5b %s\n", target, epsilon == null ? m2d.match2D(args[i], target) : m2d.match2D(args[i], target, epsilon), args[i]);
            ++i;
        }
    }

    public boolean match2D(String input, String target) {
        return this.match2D(input, target, 0.1, 0.1);
    }

    public boolean match2D(String input, String target, double tolerance) {
        return this.match2D(input, target, tolerance, tolerance);
    }

    public boolean match2D(String input, String target, double xTolerance, double yTolerance) {
        double x = 0.0;
        double y = 0.0;
        try {
            double[] targetCoords = match2D.parse(target);
            x = targetCoords[0];
            y = targetCoords[1];
        }
        catch (Exception e) {
            String errMsg = "match2D() target \"" + target + "\" fails to parse as (x,y)";
            trace.err(errMsg + ": " + e + "; cause " + e.getCause());
            throw new IllegalArgumentException(errMsg, e);
        }
        try {
            double[] inputCoords = match2D.parse(input);
            if (Math.abs(x - inputCoords[0]) > Math.abs(xTolerance)) {
                return false;
            }
            return !(Math.abs(y - inputCoords[1]) > Math.abs(yTolerance));
        }
        catch (Exception e) {
            if (trace.getDebugCode("functions")) {
                trace.outNT("functions", "match2D(..., " + target + ") input \"" + input + "\" fails to parse as (x,y): " + e);
            }
            return false;
        }
    }

    private static void usageExit(String errMsg) {
        System.err.printf("%s Usage:\n  %s -[epsilon] target test...\n", errMsg, new match2D().getClass().getSimpleName());
        System.err.println("where--\n  [epsilon] is a floating-point tolerance for both x and y;\n  target is the (x,y) pair to match against (you'll want to quote this);\n  test... are (x,y) pair(s) to test for matching.");
        System.exit(2);
    }

    public static double[] parse(String input) {
        Matcher m = Point2D.matcher(input);
        boolean matched = m.find();
        double[] xy = null;
        if (matched) {
            xy = new double[]{Double.parseDouble(m.group(1)), Double.parseDouble(m.group(3))};
        }
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "match2D.parse(" + input + ") match" + (matched ? "es ok" : " fail") + "; x=" + (xy == null ? "" : Double.toString(xy[0])) + "; y=" + (xy == null ? "" : Double.toString(xy[1])) + ";");
        }
        return xy;
    }
}

