/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels;

import cl.utilities.TestableTutor.InitializationException;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.MatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.SolverMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SolverMatcherPanel
extends MatcherPanel {
    private static final String GOAL_PREFIX = "Goal: ";
    private static final Vector<String> goalNameChoices = new Vector();
    private static String[] autoSimplifyTypeinChoices;
    private JComboBox autoSimplifyTypeinList;
    private JComboBox goalNameList;
    private JTextField inputInitializer;
    private VectorMatcher vm = null;

    private static String goalIndex2GoalName(int i) {
        if (i == 0) {
            return null;
        }
        String goalName = goalNameChoices.get(i);
        return goalName.substring(GOAL_PREFIX.length());
    }

    private static int goalName2GoalIndex(String goalName) {
        int i = 0;
        if (goalName != null && goalName.length() > 0) {
            i = goalNameChoices.indexOf(GOAL_PREFIX + goalName);
        }
        return i;
    }

    private static boolean[] choice2BooleanModes(int i) {
        boolean autoSimplify = false;
        boolean typeinMode = false;
        switch (i) {
            case 0: {
                autoSimplify = true;
                typeinMode = false;
                break;
            }
            case 1: {
                autoSimplify = false;
                typeinMode = false;
                break;
            }
            case 2: {
                autoSimplify = false;
                typeinMode = true;
                break;
            }
            default: {
                autoSimplify = false;
                typeinMode = false;
            }
        }
        return new boolean[]{autoSimplify, typeinMode};
    }

    private static int booleanModes2Choice(boolean autoSimplify, boolean typeinMode) {
        if (autoSimplify) {
            return 0;
        }
        if (typeinMode) {
            return 2;
        }
        return 1;
    }

    public SolverMatcherPanel(VectorMatcher vm, Color bgColor) {
        super(1);
        if (bgColor == null) {
            bgColor = Color.WHITE;
        }
        this.vm = vm;
        boolean autoSimplify = false;
        boolean typeinMode = false;
        String goalName = null;
        String initialInput = null;
        if (vm instanceof SolverMatcher) {
            autoSimplify = ((SolverMatcher)vm).getAutoSimplify();
            typeinMode = ((SolverMatcher)vm).getTypeinMode();
            goalName = ((SolverMatcher)vm).getGoalName();
            initialInput = ((SolverMatcher)vm).getProblemSpec();
        }
        this.SAIPane = new JPanel(new GridBagLayout());
        this.c = new GridBagConstraints();
        int width = 0;
        this.c.fill = 0;
        this.c.anchor = 10;
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.c.insets = new Insets(5, 10, 5, 10);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.autoSimplifyTypeinList = new JComboBox<String>(autoSimplifyTypeinChoices);
        this.autoSimplifyTypeinList.setName("autoSimplifyTypeinList");
        this.autoSimplifyTypeinList.setEditable(false);
        this.autoSimplifyTypeinList.setSelectedIndex(SolverMatcherPanel.booleanModes2Choice(autoSimplify, typeinMode));
        width = this.autoSimplifyTypeinList.getPreferredSize().width;
        this.SAIPane.add((Component)this.autoSimplifyTypeinList, this.c);
        this.c.gridy = 2;
        this.goalNameList = new JComboBox<String>(goalNameChoices);
        this.goalNameList.setName("goalNameList");
        this.goalNameList.setEditable(false);
        this.goalNameList.setVisible(false);
        this.goalNameList.setSelectedIndex(SolverMatcherPanel.goalName2GoalIndex(goalName));
        if (width < this.goalNameList.getPreferredSize().width) {
            width = this.goalNameList.getPreferredSize().width;
        }
        this.c.gridy = 3;
        JLabel inputInitializerLabel = new JLabel("Initial expression or equation:");
        if (width < inputInitializerLabel.getPreferredSize().width) {
            width = inputInitializerLabel.getPreferredSize().width;
        }
        this.SAIPane.add((Component)inputInitializerLabel, this.c);
        this.c.gridy = 4;
        this.c.insets = new Insets(0, 10, 5, 10);
        this.inputInitializer = new JTextField(20);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.inputInitializer);
        this.inputInitializer.setName("inputInitializer");
        this.inputInitializer.setText(initialInput);
        if (width < this.inputInitializer.getPreferredSize().width) {
            width = this.inputInitializer.getPreferredSize().width;
        }
        this.inputInitializer.setMinimumSize(new Dimension(width, this.inputInitializer.getPreferredSize().height));
        this.SAIPane.add((Component)this.inputInitializer, this.c);
        this.add(this.SAIPane);
    }

    @Override
    public Matcher createMatcher() throws IllegalArgumentException, InitializationException {
        boolean[] autoSimplifyTypeinModes = SolverMatcherPanel.choice2BooleanModes(this.autoSimplifyTypeinList.getSelectedIndex());
        boolean autoSimplify = autoSimplifyTypeinModes[0];
        boolean typeinMode = autoSimplifyTypeinModes[1];
        String goalName = SolverMatcherPanel.goalIndex2GoalName(this.goalNameList.getSelectedIndex());
        SolverMatcher sm = new SolverMatcher(this.vm.isConcat(), this.vm.getMatchers(0), this.vm.getMatchers(1), this.vm.getMatchers(2), this.vm.getActor(), Boolean.toString(autoSimplify), Boolean.toString(typeinMode), goalName);
        Matcher m = this.edgeData.getMatcher();
        if (m != null) {
            sm.setDefaultInput(m.getDefaultInput());
            sm.setDefaultAction(m.getDefaultAction());
            sm.setDefaultSelection(m.getDefaultSelection());
            sm.setDefaultActor(m.getDefaultActor());
        }
        return sm;
    }

    @Override
    public String getMatcherType() {
        return "Equation Solver";
    }

    public String getText() {
        return this.inputInitializer.getText();
    }

    public Boolean getAutoSimplify() {
        boolean[] autoSimplifyTypeinModes = SolverMatcherPanel.choice2BooleanModes(this.autoSimplifyTypeinList.getSelectedIndex());
        boolean autoSimplify = autoSimplifyTypeinModes[0];
        return new Boolean(autoSimplify);
    }

    public Boolean getTypeinMode() {
        boolean[] autoSimplifyTypeinModes = SolverMatcherPanel.choice2BooleanModes(this.autoSimplifyTypeinList.getSelectedIndex());
        boolean typeinMode = autoSimplifyTypeinModes[1];
        return new Boolean(typeinMode);
    }

    public String getGoalName() {
        int i = this.goalNameList.getSelectedIndex();
        return SolverMatcherPanel.goalIndex2GoalName(i);
    }

    static {
        goalNameChoices.add("Goal: default");
        for (String goalName : SolverMatcher.getAllGoalNames()) {
            goalNameChoices.add(GOAL_PREFIX + goalName);
        }
        autoSimplifyTypeinChoices = new String[]{"Simplify subexpressions automatically", "Require simplification, but no type-in", "Require student to type in each result"};
    }
}

