/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Dialogs.EditStudentInputDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.PackageEnumerator;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.AnyMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExpressionMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherFactory;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.ExpressionMatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.FunctionTransferHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.MatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.RangeMatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.SolverMatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RangeMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RegexMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.SolverMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.WildcardMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.WindowUtils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.ActionListModel;
import edu.cmu.pact.ctat.model.CtatListModel;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.RemoteToolProxy;
import pact.CommWidgets.StudentInterfaceConnectionStatus;
import pact.CommWidgets.UniversalToolProxy;

public class VectorMatcherPanel
extends MatcherPanel
implements ActionListener {
    private static final long serialVersionUID = 201403112100L;
    private static final String DONT_REPLACE = "(don't replace)";
    private static final int TEXT_AREA_LENGTH = 250;
    private static final int TEXT_AREA_NUM_LINES = 12;
    private static final int LINE_HEIGHT = 15;
    private static final Dimension TEXT_AREA_DIM;
    private static final Dimension DEMO_SEL_ACT_DIM;
    private static final String[] DEFAULT_SELECTION_MATCHERS;
    private static final String[] DEFAULT_ACTION_MATCHERS;
    private static final String[] DEFAULT_INPUT_MATCHERS;
    private static final String[][] DEFAULT_MATCHERS;
    private static final String DEFAULT_MATCHER = "Any Match";
    private static final int SELECTION = 0;
    private static final int ACTION = 1;
    private static final int INPUT = 2;
    final Map<Integer, String> selectionMatchersTypes = new HashMap<Integer, String>();
    final Map<Integer, String> actionMatchersTypes = new HashMap<Integer, String>();
    final Map<Integer, String> inputMatchersTypes = new HashMap<Integer, String>();
    Map[] matchersTypes = new Map[]{this.selectionMatchersTypes, this.actionMatchersTypes, this.inputMatchersTypes};
    final Map<Integer, Matcher> selectionMatchers = new HashMap<Integer, Matcher>();
    final Map<Integer, Matcher> actionMatchers = new HashMap<Integer, Matcher>();
    final Map<Integer, Matcher> inputMatchers = new HashMap<Integer, Matcher>();
    Map[] matchers = new Map[]{this.selectionMatchers, this.actionMatchers, this.inputMatchers};
    final Vector<String> selectionValues = new Vector();
    final Vector<String> actionValues = new Vector();
    final Vector<String> inputValues = new Vector();
    Vector[] values = new Vector[]{this.selectionValues, this.actionValues, this.inputValues};
    JButton okButton;
    JButton cancelButton;
    EditStudentInputDialog parent;
    private ButtonGroup tvs;
    private JRadioButton anyButton;
    private JRadioButton ungradedButton;
    private Box actorBox;
    private JLabel actorLabel;
    private JLabel triggerLabel;
    private JRadioButton stateTriggerBtn;
    private JRadioButton linkTriggerBtn;
    private ButtonGroup triggerBtns;
    private Box triggerBox;
    private JCheckBox replaceInputCheckBox;
    private JComboBox replaceInputFormulaField;
    private static final String[] replaceInputFormulas;
    private JPanel view;
    private MatcherView curView;
    private SimpleView simpleView;
    private ComplexView complexView;
    private ConcatView concatView;
    private final Vector defaultSelectionVector;
    private final Vector defaultActionVector;
    private final Vector defaultInputVector;
    private Vector[] defaults;
    private Matcher existingMatcher;
    private EdgeData previousEdgeData;
    public static final String CONCAT_VIEW = "Concat View";
    public static final String SIMPLE_VIEW = "Simple View";
    public static final String COMPLEX_VIEW = "Complex View";
    private static final String TRIGGER = "Trigger:";
    private static final String STATE_TRIGGER = " On current state ";
    private static final String LINK_TRIGGER = " On previous link ";
    private static final Color UneditableBackgroundColor;
    private static final Set<AWTKeyStroke> TabKey;
    private static final Set<AWTKeyStroke> ShiftTabKey;
    private static final String FUNCTIONS_PACKAGE = "edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions";

    public VectorMatcherPanel(EditStudentInputDialog parent, EdgeData edgeData, boolean allowToolReportedActions, int max_students) {
        super(1);
        String actor;
        int vector;
        this.previousEdgeData = edgeData.cloneEdgeData();
        this.parent = parent;
        this.edgeData = edgeData;
        this.defaultSelectionVector = edgeData.getSelection();
        this.defaultActionVector = edgeData.getAction();
        this.defaultInputVector = edgeData.getInput();
        this.defaults = new Vector[3];
        this.defaults[0] = this.defaultSelectionVector;
        this.defaults[1] = this.defaultActionVector;
        this.defaults[2] = this.defaultInputVector;
        this.triggerLabel = new JLabel(TRIGGER);
        this.stateTriggerBtn = new JRadioButton(STATE_TRIGGER);
        this.stateTriggerBtn.setName("stateTriggerBtn");
        this.linkTriggerBtn = new JRadioButton(LINK_TRIGGER);
        this.linkTriggerBtn.setName("linkTriggerBtn");
        this.triggerBtns = new ButtonGroup();
        this.triggerBtns.add(this.stateTriggerBtn);
        this.triggerBtns.add(this.linkTriggerBtn);
        this.stateTriggerBtn.setSelected(true);
        this.triggerBox = new Box(0);
        this.triggerBox.add(this.stateTriggerBtn);
        this.triggerBox.add(this.linkTriggerBtn);
        this.replaceInputCheckBox = new JCheckBox("When correct, replace student input with:");
        this.replaceInputCheckBox.setName("replaceInputCheckBox");
        this.replaceInputCheckBox.setBackground(this.getBackground());
        this.replaceInputFormulaField = new JComboBox();
        this.replaceInputFormulaField.setName("replaceInputFormulaField");
        this.actorLabel = new JLabel("Actor:");
        this.toolButton = new JRadioButton("Tutor");
        this.ungradedButton = new JRadioButton("Tutor (unevaluated)");
        this.studentButton = new JRadioButton("Student");
        this.anyButton = new JRadioButton("Any");
        this.toolButton.setActionCommand(this.toolButton.getText());
        this.ungradedButton.setActionCommand(this.ungradedButton.getText());
        this.studentButton.setActionCommand(this.studentButton.getText());
        this.anyButton.setActionCommand(this.anyButton.getText());
        this.toolButton.setToolTipText("Tutor will perform and evaluate this step.");
        this.ungradedButton.setToolTipText("Tutor will perform this step but leave it unevaluated.");
        this.studentButton.setToolTipText("Only the student can perform this step.");
        this.anyButton.setToolTipText("The student or the tutor may perform this step.");
        this.tvs = new ButtonGroup();
        this.tvs.add(this.toolButton);
        this.tvs.add(this.ungradedButton);
        this.tvs.add(this.studentButton);
        this.tvs.add(this.anyButton);
        this.studentButton.setSelected(true);
        ActorListener al = new ActorListener();
        this.toolButton.addActionListener(al);
        this.ungradedButton.addActionListener(al);
        this.studentButton.addActionListener(al);
        this.anyButton.addActionListener(al);
        this.actorBox = new Box(0);
        this.actorBox.add(this.toolButton);
        this.actorBox.add(this.ungradedButton);
        this.actorBox.add(this.studentButton);
        this.actorBox.add(this.anyButton);
        this.existingMatcher = edgeData.getMatcher();
        if (this.existingMatcher == null) {
            this.existingMatcher = new VectorMatcher();
            edgeData.setMatcher(this.existingMatcher);
            for (int vector2 = 0; vector2 < 3; ++vector2) {
                this.matchersTypes[vector2].put(0, "Exact Match");
            }
        }
        if (this.existingMatcher instanceof VectorMatcher) {
            Matcher m;
            int j;
            VectorMatcher vm = (VectorMatcher)edgeData.getMatcher();
            for (vector = 0; vector < 3; ++vector) {
                for (j = 0; j < vm.getMatchers(vector).size(); ++j) {
                    m = vm.getMatchers(vector).get(j);
                    this.matchers[vector].put(j, m);
                    this.matchersTypes[vector].put(j, m.getMatcherType());
                }
            }
            if (vm.isConcat()) {
                for (vector = 0; vector < 3; ++vector) {
                    Matcher m2 = (Matcher)this.matchers[vector].get(0);
                    if (m2 == null) continue;
                    this.values[vector] = new Vector<String>(Arrays.asList(m2.getValuesVector()));
                }
            } else {
                for (vector = 0; vector < 3; ++vector) {
                    j = 0;
                    while (this.matchers[vector].get(j) != null) {
                        m = (Matcher)this.matchers[vector].get(j);
                        if (m != null) {
                            this.values[vector].add(m.toString());
                        }
                        ++j;
                    }
                }
            }
        } else {
            String[] oldMatchersTypes = new String[3];
            if (this.existingMatcher instanceof ExpressionMatcher) {
                oldMatchersTypes[0] = "Exact Match";
                oldMatchersTypes[1] = "Exact Match";
                oldMatchersTypes[2] = "Formula Match";
                this.values[0].add(this.existingMatcher.getSelection());
                this.values[1].add(this.existingMatcher.getAction());
                this.values[2].add(((ExpressionMatcher)this.existingMatcher).toString());
            } else if (this.existingMatcher instanceof ExactMatcher) {
                oldMatchersTypes[0] = "Exact Match";
                oldMatchersTypes[1] = "Exact Match";
                oldMatchersTypes[2] = "Exact Match";
                this.values[0].add(this.existingMatcher.getSelection());
                this.values[1].add(this.existingMatcher.getAction());
                this.values[2].add(this.existingMatcher.getInput());
            } else if (this.existingMatcher instanceof RegexMatcher) {
                oldMatchersTypes[0] = "Regular Expression Match";
                oldMatchersTypes[1] = "Regular Expression Match";
                oldMatchersTypes[2] = "Regular Expression Match";
                this.values[0].add(((RegexMatcher)this.existingMatcher).getSelectionPattern());
                this.values[1].add(((RegexMatcher)this.existingMatcher).getActionPattern());
                this.values[2].add(((RegexMatcher)this.existingMatcher).getInputPattern());
            } else if (this.existingMatcher instanceof WildcardMatcher) {
                oldMatchersTypes[0] = "Wildcard Match";
                oldMatchersTypes[1] = "Wildcard Match";
                oldMatchersTypes[2] = "Wildcard Match";
                this.values[0].add(((WildcardMatcher)this.existingMatcher).getSimpleSelectionPattern());
                this.values[1].add(((WildcardMatcher)this.existingMatcher).getSimpleActionPattern());
                this.values[2].add(((WildcardMatcher)this.existingMatcher).getSimpleInputPattern());
            } else if (this.existingMatcher instanceof AnyMatcher) {
                oldMatchersTypes[0] = "Exact Match";
                oldMatchersTypes[1] = "Exact Match";
                oldMatchersTypes[2] = DEFAULT_MATCHER;
                this.values[0].add(this.existingMatcher.getSelection());
                this.values[1].add(this.existingMatcher.getAction());
            } else if (this.existingMatcher instanceof RangeMatcher) {
                oldMatchersTypes[0] = "Exact Match";
                oldMatchersTypes[1] = "Exact Match";
                oldMatchersTypes[2] = "Range Match";
                this.values[0].add(this.existingMatcher.getSelection());
                this.values[1].add(this.existingMatcher.getAction());
                this.values[2].add(((RangeMatcher)this.existingMatcher).toString());
            }
            for (vector = 0; vector < 3; ++vector) {
                this.matchersTypes[vector].put(0, oldMatchersTypes[vector]);
            }
        }
        if ((actor = edgeData.getActor()).equals("Tutor (unevaluated)")) {
            this.ungradedButton.doClick();
        } else if (actor.equals("Tutor")) {
            this.toolButton.doClick();
        } else if (actor.equals("Any")) {
            this.anyButton.doClick();
        } else if (actor.equals("Student")) {
            this.studentButton.doClick();
        }
        if (this.existingMatcher != null) {
            if (this.existingMatcher.isLinkTriggered()) {
                this.linkTriggerBtn.setSelected(true);
            } else {
                this.stateTriggerBtn.setSelected(true);
            }
        }
        this.initReplaceInput(this.existingMatcher);
        this.concatView = new ConcatView(true);
        this.curView = this.concatView;
        this.view = new JPanel(new BorderLayout());
        this.view.add((Component)this.curView, "Center");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        Box b3 = new Box(0);
        b3.add(this.okButton);
        b3.add(Box.createHorizontalStrut(12));
        b3.add(this.cancelButton);
        this.view.add((Component)WindowUtils.wrapRight(b3), "South");
        this.add(this.view);
    }

    public FocusTraversalPolicy getCustomFocusTraversalPolicy() {
        return this.concatView.getCustomFocusTraversalPolicy();
    }

    private void initReplaceInput(Matcher m) {
        String existingFormula = m != null && m.replaceInput() ? m.getReplacementFormula() : null;
        ArrayList<String> formulas = new ArrayList<String>();
        formulas.addAll(Arrays.asList(replaceInputFormulas));
        int selectedItemIndex = 0;
        if (existingFormula != null && existingFormula.length() > 0) {
            selectedItemIndex = formulas.indexOf(existingFormula);
            if (selectedItemIndex < 0) {
                formulas.add(existingFormula);
                selectedItemIndex = formulas.size() - 1;
            }
        } else {
            existingFormula = null;
        }
        formulas.add("");
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(formulas.toArray());
        model.setSelectedItem(formulas.get(selectedItemIndex));
        this.replaceInputFormulaField.setModel(model);
        this.replaceInputFormulaField.setEditable(true);
        this.replaceInputFormulaField.setEnabled(existingFormula != null);
        this.replaceInputCheckBox.getModel().setSelected(existingFormula != null);
        this.replaceInputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean checked = VectorMatcherPanel.this.replaceInputCheckBox.getModel().isSelected();
                if (trace.getDebugCode("pm")) {
                    trace.outNT("pm", "checkBoxActionListener: checkbox.isSelected() " + checked + ", field " + VectorMatcherPanel.this.replaceInputFormulaField.getModel().getSelectedItem().toString());
                }
                VectorMatcherPanel.this.replaceInputFormulaField.setEnabled(checked);
            }
        });
        this.replaceInputFormulaField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (trace.getDebugCode("pm")) {
                    trace.outNT("pm", "fieldActionListener: checkbox.isSelected() " + VectorMatcherPanel.this.replaceInputCheckBox.getModel().isSelected() + ", field " + VectorMatcherPanel.this.replaceInputFormulaField.getModel().getSelectedItem().toString());
                }
            }
        });
        if (trace.getDebugCode("editstudentinput")) {
            trace.out("editstudentinput", String.format("VMP.initReplaceInput() editor %s, component %s, transferHandler %s", this.replaceInputFormulaField.getEditor(), this.replaceInputFormulaField.getEditor() != null ? this.replaceInputFormulaField.getEditor().getEditorComponent() : null, this.replaceInputFormulaField.getEditor().getEditorComponent() instanceof JTextComponent ? ((JTextComponent)this.replaceInputFormulaField.getEditor().getEditorComponent()).getTransferHandler() : null));
        }
        Component edCmp = null;
        ComboBoxEditor ed = this.replaceInputFormulaField.getEditor();
        edCmp = ed.getEditorComponent();
        if (edCmp != null && edCmp instanceof JTextComponent) {
            TransferHandler edTxtCmpTH = null;
            JTextComponent edTxtCmp = (JTextComponent)edCmp;
            edTxtCmpTH = edTxtCmp.getTransferHandler();
            if (edTxtCmpTH != null) {
                edTxtCmp.setTransferHandler(new FunctionTransferHandler(edTxtCmpTH));
            }
        }
    }

    public String getDemonstratedValue(int vector) {
        Vector defaultVector = null;
        switch (vector) {
            case 0: {
                defaultVector = this.defaultSelectionVector;
                break;
            }
            case 1: {
                defaultVector = this.defaultActionVector;
                break;
            }
            case 2: {
                defaultVector = this.defaultInputVector;
            }
        }
        return Matcher.vector2ConcatString(defaultVector);
    }

    public JComboBox createCombo(String[] values, boolean editable, ActionListener listener, String name) {
        return this.createCombo(new Vector<String>(Arrays.asList(values)), editable, listener, name);
    }

    public JComboBox createCombo(Vector values, boolean editable, ActionListener listener, String name) {
        JComboBox combo = new JComboBox(values);
        combo.setName(name);
        combo.setFont(new Font(null, 0, 11));
        combo.setEditable(editable);
        if (listener != null) {
            combo.addActionListener(listener);
        }
        return combo;
    }

    public JScrollPane scrollerizeTextArea(JTextArea area, Dimension d) {
        JScrollPane s = new JScrollPane(area);
        if (d != null) {
            s.setPreferredSize(d);
            s.setMaximumSize(d);
        }
        if (trace.getDebugCode("editstudentinput")) {
            trace.printStack("editstudentinput", "VMP.scrollerizeTextArea(" + area.getName() + "," + d + ") area.prefScrVwprtSize " + area.getPreferredScrollableViewportSize() + ", scrollPane prefSize " + s.getPreferredSize());
        }
        return s;
    }

    public static JTextArea createTextArea(String name) {
        final JTextArea a = new JTextArea(){

            @Override
            public void setText(String s) {
                String s0 = this.getText();
                super.setText(s);
                this.setSelectionStart(0);
                this.setSelectionEnd(0);
                this.firePropertyChange("text", s0, s);
            }
        };
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(a);
        a.setName(name);
        a.setFont(new Font(null, 0, 11));
        if (trace.getDebugCode("editstudentinput")) {
            trace.out("editstudentinput", "createTextArea(" + name + ") focusTravKeys:\n  FORWARD    " + a.getFocusTraversalKeys(0) + "\n  BACKWARD   " + a.getFocusTraversalKeys(1) + "\n  UP_CYCLE   " + a.getFocusTraversalKeys(2) + "\n  DOWN_CYCLE " + a.getFocusTraversalKeys(3));
        }
        a.setFocusTraversalKeys(0, TabKey);
        a.setFocusTraversalKeys(1, ShiftTabKey);
        a.setDragEnabled(true);
        a.setDropMode(DropMode.USE_SELECTION);
        a.setTransferHandler(new FunctionTransferHandler(a.getTransferHandler()));
        a.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                a.firePropertyChange("text", 'O', 'N');
            }
        });
        return a;
    }

    public static String vector2name(int vector) {
        switch (vector) {
            case 0: {
                return "selection";
            }
            case 1: {
                return "action";
            }
            case 2: {
                return "input";
            }
        }
        return null;
    }

    @Override
    public VectorMatcher createMatcher() throws Exception {
        String matcherName;
        int vector;
        LinkedList<Matcher> sList = new LinkedList<Matcher>();
        LinkedList<Matcher> aList = new LinkedList<Matcher>();
        LinkedList<Matcher> iList = new LinkedList<Matcher>();
        List[] lists = new List[]{sList, aList, iList};
        if (this.curView == this.concatView) {
            for (vector = 0; vector < 3; ++vector) {
                Matcher m = null;
                try {
                    matcherName = (String)this.matchersTypes[vector].get(0);
                    if (matcherName == "Formula Match") {
                        ExpressionMatcherPanel exprPanel = (ExpressionMatcherPanel)this.concatView.valuePanels[vector].getComponent(0);
                        m = new ExpressionMatcher(true, vector, exprPanel.relationOptions.getSelectedIndex(), exprPanel.inputArea.getText());
                    } else if (matcherName == "Range Match") {
                        RangeMatcherPanel rangePanel = (RangeMatcherPanel)this.concatView.valuePanels[vector].getComponent(0);
                        String min = rangePanel.minimumField.getText();
                        String max = rangePanel.maximumField.getText();
                        m = new RangeMatcher(true, vector, min, max);
                    } else if (matcherName == "Equation Solver") {
                        SolverMatcherPanel solverPanel = (SolverMatcherPanel)this.concatView.valuePanels[vector].getComponent(0);
                        String input = solverPanel.getText();
                        m = MatcherFactory.createSingleMatcher("Exact Match", true, vector, input);
                    } else {
                        String input = this.concatView.valueAreas[vector].getText();
                        m = MatcherFactory.createSingleMatcher(matcherName, true, vector, input);
                    }
                }
                catch (Exception e) {
                    this.concatView.checkButtons[vector].doClick();
                    throw e;
                }
                lists[vector].add(m);
            }
        } else {
            for (vector = 0; vector < 3; ++vector) {
                for (int j = this.values[vector].size() - 1; j >= 0; ++j) {
                    matcherName = (String)this.matchersTypes[vector].get(j);
                    if (matcherName.equals(DEFAULT_MATCHER)) continue;
                    lists[vector].add(0, MatcherFactory.createSingleMatcher(matcherName, false, vector, (String)this.values[vector].get(j)));
                }
            }
        }
        VectorMatcher mvm = null;
        if ("Equation Solver".equals(this.matchersTypes[2].get(0))) {
            SolverMatcherPanel solverPanel = (SolverMatcherPanel)this.concatView.valuePanels[2].getComponent(0);
            Boolean autoSimplify = solverPanel.getAutoSimplify();
            Boolean typeinMode = solverPanel.getTypeinMode();
            String goalName = solverPanel.getGoalName();
            mvm = new SolverMatcher(this.curView == this.concatView, sList, aList, iList, this.getActorFromTvs(), autoSimplify.toString(), typeinMode.toString(), goalName);
        } else {
            mvm = new VectorMatcher(this.curView == this.concatView, sList, aList, iList);
            mvm.setDefaultActor(this.getActorFromTvs());
        }
        mvm.setLinkTriggered(this.linkTriggerBtn.isSelected());
        mvm.setDefaultSelection(this.concatView.defaultAreas[0].getText());
        mvm.setDefaultAction(this.concatView.defaultAreas[1].getText());
        mvm.setDefaultInput(this.concatView.defaultAreas[2].getText());
        this.saveReplaceInput(mvm);
        return mvm;
    }

    private VectorMatcher createTempVectorMatcher() {
        LinkedList<Matcher> sList = new LinkedList<Matcher>();
        LinkedList<Matcher> aList = new LinkedList<Matcher>();
        LinkedList<Matcher> iList = new LinkedList<Matcher>();
        List[] lists = new List[]{sList, aList, iList};
        for (int vector = 0; vector < 3; ++vector) {
            String input = this.concatView.valueAreas[vector].getText();
            Matcher m = MatcherFactory.createSingleMatcher("Exact Match", true, vector, input);
            lists[vector].add(m);
        }
        VectorMatcher mvm = new VectorMatcher(this.curView == this.concatView, sList, aList, iList);
        mvm.setDefaultActor(this.getActorFromTvs());
        mvm.setLinkTriggered(this.linkTriggerBtn.isSelected());
        mvm.setDefaultSelection(this.concatView.defaultAreas[0].getText());
        mvm.setDefaultAction(this.concatView.defaultAreas[1].getText());
        mvm.setDefaultInput(this.concatView.defaultAreas[2].getText());
        this.saveReplaceInput(mvm);
        return mvm;
    }

    private String getActorFromTvs() {
        ButtonModel bm = this.tvs.getSelection();
        String actor = "Student";
        if (this.toolButton.getModel() == bm) {
            actor = "Tutor";
        } else if (this.anyButton.getModel() == bm) {
            actor = "Any";
        } else if (this.ungradedButton.getModel() == bm) {
            actor = "Tutor (unevaluated)";
        } else if (this.studentButton.getModel() == bm) {
            actor = "Student";
        }
        return actor;
    }

    @Override
    public String getMatcherType() {
        return "Multiple Vectors Match";
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.okButton) {
            this.commitChanges(this.edgeData);
        } else if (src != this.cancelButton) {
            return;
        }
        this.parent.close();
    }

    public EdgeData commitChanges(EdgeData ed) {
        this.curView.updateInfo(ed);
        VectorMatcher m = null;
        try {
            m = this.createMatcher();
        }
        catch (Exception e) {
            String errMsg = "Error creating matcher: " + e + (e.getCause() == null ? "" : ";\n  cause " + e.getCause());
            JOptionPane.showMessageDialog(this.parent, errMsg, "Error editing student input matching", 0);
            trace.errStack(errMsg, e);
            return ed;
        }
        if (m != null) {
            ed.setMatcher(m);
        }
        ed.getActionLabel().resetForeground();
        ed.getActionLabel().update();
        ed.getController().fireCtatModeEvent(CtatModeEvent.REPAINT);
        if (ed == this.edgeData) {
            ed.getController().getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this, this.edgeData.getEdge(), true));
        }
        return ed;
    }

    private void saveReplaceInput(Matcher m) {
        boolean checked = this.replaceInputCheckBox.getModel().isSelected();
        if (trace.getDebugCode("pm")) {
            trace.outNT("pm", "saveInputReplace: checkbox.isSelected() " + checked + ", field " + this.replaceInputFormulaField.getModel().getSelectedItem().toString());
        }
        if (!checked) {
            m.setReplacementFormula(null);
        } else {
            String formula;
            Object item = this.replaceInputFormulaField.getModel().getSelectedItem();
            String string = formula = item == null ? null : item.toString();
            if (formula == null) {
                m.setReplacementFormula(null);
            } else if ((formula = formula.trim()).length() < 1) {
                m.setReplacementFormula(null);
            } else if (formula.equalsIgnoreCase(DONT_REPLACE)) {
                m.setReplacementFormula(null);
            } else {
                m.setReplacementFormula(formula);
            }
        }
    }

    public void switchView(String viewType) {
        this.view.removeAll();
        if (viewType == CONCAT_VIEW) {
            if (this.concatView == null) {
                this.concatView = new ConcatView(false);
            }
            this.curView = this.concatView;
        } else if (viewType == SIMPLE_VIEW) {
            if (this.simpleView == null) {
                this.simpleView = new SimpleView(false);
            }
            this.curView = this.simpleView;
        } else if (viewType == COMPLEX_VIEW) {
            if (this.complexView == null) {
                this.complexView = new ComplexView(false);
            }
            this.curView = this.complexView;
        }
        this.curView.updateView();
        this.view.add(this.curView);
        this.validate();
        this.repaint();
    }

    public void closeViaOkCancel() {
        EdgeData newEdgeData = this.commitChanges(this.previousEdgeData.cloneEdgeData());
        if (EdgeData.sameSettings(this.previousEdgeData, newEdgeData)) {
            this.cancelButton.doClick();
        } else {
            int ync = JOptionPane.showConfirmDialog(this.parent.getActiveWindow(), "You have changed some settings. Apply changes before closing?", "Edited Student Input Matching", 1, 2);
            if (1 == ync) {
                this.cancelButton.doClick();
            } else if (0 == ync) {
                this.okButton.doClick();
            }
        }
    }

    private static List<String> getFunctionList() {
        HashSet<String> sigSet = new HashSet<String>();
        sigSet.addAll(PackageEnumerator.getSelectedMethodSignatures(Math.class, true, "[Math] "));
        sigSet.addAll(PackageEnumerator.getSelectedMethodSignatures(String.class, true, "[String] "));
        for (Class<?> cls : PackageEnumerator.getClassesForPackage(FUNCTIONS_PACKAGE)) {
            if (cls.getSimpleName().contains("$")) continue;
            sigSet.addAll(PackageEnumerator.getSelectedMethodSignatures(cls, false, null));
        }
        ArrayList<String> result = new ArrayList<String>(sigSet);
        Collections.sort(result, String.CASE_INSENSITIVE_ORDER);
        return result;
    }

    static {
        String[] stringArray;
        TEXT_AREA_DIM = new Dimension(250, 180);
        DEMO_SEL_ACT_DIM = new Dimension(VectorMatcherPanel.TEXT_AREA_DIM.width * 6 / 10, VectorMatcherPanel.TEXT_AREA_DIM.height / 2);
        DEFAULT_SELECTION_MATCHERS = new String[]{"Exact Match", "Wildcard Match", "Regular Expression Match", "Range Match", DEFAULT_MATCHER, "Formula Match"};
        DEFAULT_ACTION_MATCHERS = new String[]{"Exact Match", "Wildcard Match", "Regular Expression Match", "Range Match", DEFAULT_MATCHER, "Formula Match"};
        if (VersionInformation.includesCL()) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "Exact Match";
            stringArray2[1] = "Wildcard Match";
            stringArray2[2] = "Regular Expression Match";
            stringArray2[3] = "Range Match";
            stringArray2[4] = DEFAULT_MATCHER;
            stringArray2[5] = "Formula Match";
            stringArray = stringArray2;
            stringArray2[6] = "Equation Solver";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "Exact Match";
            stringArray3[1] = "Wildcard Match";
            stringArray3[2] = "Regular Expression Match";
            stringArray3[3] = "Range Match";
            stringArray3[4] = DEFAULT_MATCHER;
            stringArray = stringArray3;
            stringArray3[5] = "Formula Match";
        }
        DEFAULT_INPUT_MATCHERS = stringArray;
        DEFAULT_MATCHERS = new String[][]{DEFAULT_SELECTION_MATCHERS, DEFAULT_ACTION_MATCHERS, DEFAULT_INPUT_MATCHERS};
        replaceInputFormulas = VersionInformation.includesCL() ? new String[]{DONT_REPLACE, "simplify(input)"} : new String[]{DONT_REPLACE, "algEval(input)"};
        UneditableBackgroundColor = new Color(244, 244, 244);
        TabKey = new HashSet<AWTKeyStroke>(Arrays.asList(AWTKeyStroke.getAWTKeyStroke(9, 0)));
        ShiftTabKey = new HashSet<AWTKeyStroke>(Arrays.asList(AWTKeyStroke.getAWTKeyStroke(9, 64)));
    }

    private static class StyledStringRenderer
    implements ListCellRenderer {
        private final JLabel plainLabel;
        private final JLabel boldLabel;

        StyledStringRenderer(ListCellRenderer delegate) {
            if (!(delegate instanceof JLabel)) {
                throw new IllegalArgumentException("Unexpected plainLabel class " + trace.nh(delegate) + " for StyledStringRenderer: should be JLabel");
            }
            this.plainLabel = (JLabel)((Object)delegate);
            Font plainFont = this.plainLabel.getFont();
            this.boldLabel = new JLabel();
            Font boldFont = new Font(plainFont.getFontName(), plainFont.getStyle() | 1, plainFont.getSize());
            this.boldLabel.setFont(boldFont);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean shouldBold;
            Component result = ((ListCellRenderer)((Object)this.plainLabel)).getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            boolean bl = shouldBold = list.getModel() instanceof ActionListModel && ((ActionListModel)list.getModel()).isActionForSelection((String)value);
            if (trace.getDebugCode("editstudentinputrenderer")) {
                trace.out("editstudentinputrenderer", "StyledStringRenderer.getListCellRendererComponent(" + value + ", " + index + ") result " + trace.nh(this.plainLabel) + ", shouldBold " + shouldBold + ", listModel " + list.getModel());
            }
            if (shouldBold && value != null) {
                this.boldLabel.setText(value.toString());
                this.boldLabel.setForeground(result.getForeground());
                this.boldLabel.setBackground(result.getBackground());
                result = this.boldLabel;
            }
            return result;
        }
    }

    private class RegexDialog
    extends JDialog
    implements ActionListener {
        ActionListener actionListener;
        public int vector;
        JButton okButton;
        JButton cancelRegexButton;
        JButton validateButton;
        private static final String OK = "Save";
        private static final String CANCEL = "Cancel";
        private static final String VALIDATE = "Check";
        private JTextArea regexArea;
        private JTextArea validateArea;
        private boolean wild;
        private final Dimension STATUS_DIM;

        public RegexDialog(JDialog owner, ActionListener listener, String text, int vector, boolean wildcard) {
            super(owner, "Create a Regular Expression", true);
            this.STATUS_DIM = new Dimension(180, 60);
            this.actionListener = listener;
            this.vector = vector;
            this.wild = wildcard;
            Box b = new Box(1);
            JLabel regexText = new JLabel("<html>Please insert a regular expression match<br>Greedy quantifiers include:<br>* - 0 or more<br>+ - 1 or more<br>? - 0 or 1<br><br>Character classes include:<br>. - any character<br>\\d - any digit<br>\\D - any non-digit<br>\\s - any white space<br>\\S(any non-white space)<br><br>For more on Java's regular expression usage,see<br>http://java.sun.com/j2se/1.4.2/docs/api/java/util/regex/Pattern.html<br><br></html>");
            JLabel wildcardText = new JLabel("<html>Use a * where you would like to insert a wildcard<br>Any number of characters can be matched there<br><br></html>");
            JPanel SAIPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.ipadx = 5;
            c.ipady = 5;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            SAIPane.add((Component)(wildcard ? wildcardText : regexText), c);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 1;
            JLabel regexInputLabel = new JLabel("Regular expression:");
            SAIPane.add((Component)regexInputLabel, c);
            this.regexArea = VectorMatcherPanel.createTextArea("regexArea");
            this.regexArea.setText(text);
            c.gridx = 1;
            SAIPane.add((Component)VectorMatcherPanel.this.scrollerizeTextArea(this.regexArea, TEXT_AREA_DIM), c);
            c.gridx = 0;
            c.gridy = 2;
            JLabel checkStatusLabel = new JLabel("Check status:");
            SAIPane.add((Component)checkStatusLabel, c);
            c.gridx = 1;
            this.validateArea = VectorMatcherPanel.createTextArea("ValidateArea");
            this.validateArea.setBackground(this.getBackground());
            this.validateArea.setEditable(false);
            SAIPane.add((Component)VectorMatcherPanel.this.scrollerizeTextArea(this.validateArea, this.STATUS_DIM), c);
            b.add(SAIPane);
            b.add(Box.createVerticalStrut(5));
            this.okButton = new JButton(OK);
            this.okButton.addActionListener(this);
            this.cancelRegexButton = new JButton(CANCEL);
            this.cancelRegexButton.addActionListener(this);
            this.validateButton = new JButton(VALIDATE);
            this.validateButton.addActionListener(this);
            Box b3 = new Box(0);
            b3.add(this.validateButton);
            b3.add(Box.createHorizontalStrut(12));
            b3.add(this.okButton);
            b3.add(Box.createHorizontalStrut(12));
            b3.add(this.cancelRegexButton);
            b3.add(Box.createHorizontalStrut(12));
            b.add(WindowUtils.wrapRight(b3));
            b.add(Box.createVerticalStrut(5));
            this.getContentPane().add(b);
            this.pack();
            this.validate();
            this.setVisible(true);
        }

        public String getRegex() {
            return this.regexArea.getText();
        }

        public boolean validateRegex() {
            String demonstrated;
            String regex = this.regexArea.getText().replaceAll("\n", "");
            if (this.wild) {
                regex = WildcardMatcher.convertToFullRegex(regex);
            }
            boolean againstDefault = false;
            try {
                demonstrated = VectorMatcherPanel.this.getDemonstratedValue(this.vector);
                againstDefault = Pattern.compile(regex).matcher(demonstrated).matches();
            }
            catch (PatternSyntaxException pse) {
                this.validateArea.setText("Invalid pattern: \n" + regex);
                return false;
            }
            this.validateArea.setText((againstDefault ? "Matches to " : "Does not match to ") + "Demonstrated Value");
            if (!againstDefault) {
                this.validateArea.append("\n" + regex + "\n" + demonstrated);
            }
            return againstDefault;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == this.validateButton) {
                this.validateRegex();
            } else {
                this.actionListener.actionPerformed(new ActionEvent(this, -1, ((JButton)src).getText()));
            }
        }
    }

    private class RangeDialog
    extends JDialog
    implements ActionListener {
        ActionListener actionListener;
        public int vector;
        JButton okButton;
        JButton cancelRngButton;
        private static final String OK = "OK";
        private static final String CANCEL = "Cancel";
        private RangeMatcherPanel rmp;

        public RangeDialog(JDialog owner, ActionListener listener, String text, int vector) {
            super(owner, "Create a Range", true);
            this.actionListener = listener;
            this.vector = vector;
            Box b = new Box(1);
            this.rmp = new RangeMatcherPanel(text);
            b.add(this.rmp);
            b.add(Box.createVerticalStrut(5));
            this.okButton = new JButton(OK);
            this.okButton.addActionListener(this);
            this.cancelRngButton = new JButton(CANCEL);
            this.cancelRngButton.addActionListener(this);
            Box b3 = new Box(0);
            b3.add(this.okButton);
            b3.add(Box.createHorizontalStrut(12));
            b3.add(this.cancelRngButton);
            b3.add(Box.createHorizontalStrut(12));
            b.add(WindowUtils.wrapRight(b3));
            b.add(Box.createVerticalStrut(5));
            this.getContentPane().add(b);
            this.pack();
            this.validate();
            this.setVisible(true);
        }

        public String getMin() {
            return this.rmp.minimumField.getText();
        }

        public String getMax() {
            return this.rmp.maximumField.getText();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            this.actionListener.actionPerformed(new ActionEvent(this, -1, ((JButton)src).getText()));
        }
    }

    private class ExpressionDialog
    extends JDialog
    implements ActionListener {
        private ExpressionMatcherPanel exprPanel;
        private JTextComponent syntaxCheck;
        private JButton checkButton;
        private JButton saveButton;
        private JButton cancelExprButton;
        private final Dimension SYNTAX_CHECK_DIM;
        static final String CHECK = "Check";
        static final String SAVE = "Save";
        static final String CANCEL = "Cancel";
        ActionListener actionListener;
        public int vector;
        private boolean concat;

        public ExpressionDialog(JDialog owner, ActionListener listener, String text, int vector, boolean concat2, EdgeData edgeData) {
            super(owner, "Create a function", true);
            this.SYNTAX_CHECK_DIM = new Dimension(300, 75);
            this.setTitle("Expression Dialog");
            this.actionListener = listener;
            this.vector = vector;
            this.concat = concat2;
            Box b = new Box(1);
            b.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.exprPanel = new ExpressionMatcherPanel(edgeData, text);
            this.exprPanel.setVisible(true);
            b.add(this.exprPanel);
            b.add(Box.createVerticalStrut(5));
            this.syntaxCheck = VectorMatcherPanel.createTextArea("Syntax Check");
            this.syntaxCheck.setBackground(this.getBackground());
            this.syntaxCheck.setEditable(false);
            this.exprPanel.setSyntaxCheck(this.syntaxCheck);
            b.add(VectorMatcherPanel.this.scrollerizeTextArea((JTextArea)this.syntaxCheck, this.SYNTAX_CHECK_DIM));
            b.add(Box.createVerticalStrut(5));
            this.checkButton = new JButton(CHECK);
            this.checkButton.addActionListener(this);
            this.saveButton = new JButton(SAVE);
            this.saveButton.addActionListener(this);
            this.cancelExprButton = new JButton(CANCEL);
            this.cancelExprButton.addActionListener(this);
            Box b3 = new Box(0);
            b3.add(this.checkButton);
            b3.add(Box.createHorizontalStrut(12));
            b3.add(this.saveButton);
            b3.add(Box.createHorizontalStrut(12));
            b3.add(this.cancelExprButton);
            b3.add(Box.createHorizontalStrut(12));
            b.add(WindowUtils.wrapRight(b3));
            this.getContentPane().add(b);
            b.validate();
            this.pack();
            this.repaint();
            this.setVisible(true);
        }

        public String getText() {
            if (this.exprPanel == null) {
                return null;
            }
            return this.exprPanel.inputArea.getText();
        }

        public String getRelation() {
            if (this.exprPanel == null) {
                return null;
            }
            return this.exprPanel.relationOptions.getSelectedValue().toString();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == this.checkButton) {
                this.exprPanel.checkDemonstratedValues(true, this.concat, this.vector, VectorMatcherPanel.this.defaultSelectionVector, VectorMatcherPanel.this.defaultActionVector, VectorMatcherPanel.this.defaultInputVector);
                return;
            }
            this.actionListener.actionPerformed(new ActionEvent(this, -1, ((JButton)src).getText()));
            this.setVisible(false);
            this.dispose();
        }
    }

    private class ComplexView
    extends MatcherView
    implements MouseListener,
    ActionListener {
        DefaultTableModel dtm;
        JTable table;
        EachRowEditor indexEditor;
        EachRowEditor valueEditor;
        EachRowEditor matcherEditor;
        private JMenuItem insertAbove;
        private JMenuItem insertBelow;
        private JMenuItem remove;
        private final String[] COLUMN_HEADERS;
        private int INDEX_COL_WIDTH;
        int sIndex;
        int aIndex;
        int iIndex;
        Box actor;

        public ComplexView(boolean initialize) {
            this.COLUMN_HEADERS = new String[]{"Index", "Values", "Matchers"};
            this.INDEX_COL_WIDTH = 30;
            this.setLayout(new BoxLayout(this, 1));
            this.dtm = new DefaultTableModel();
            this.dtm.setColumnIdentifiers(this.COLUMN_HEADERS);
            this.table = new JTable(this.dtm);
            this.table.addMouseListener(this);
            this.indexEditor = new EachRowEditor(this.table, null);
            this.valueEditor = new EachRowEditor(this.table, new DefaultCellEditor(new JTextField()));
            this.matcherEditor = new EachRowEditor(this.table, new DefaultCellEditor(new JTextField()));
            this.table.getColumn("Index").setCellEditor(this.indexEditor);
            this.table.getColumn("Values").setCellEditor(this.valueEditor);
            this.table.getColumn("Matchers").setCellEditor(this.matcherEditor);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(this.INDEX_COL_WIDTH);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
            this.add(this.table);
            this.add(Box.createVerticalStrut(5));
            this.actor = new Box(0);
            this.actor.add(VectorMatcherPanel.this.actorLabel);
            this.actor.add(VectorMatcherPanel.this.actorBox);
            this.actor.add(VectorMatcherPanel.this.triggerBox);
            this.add(WindowUtils.wrapLeft(this.actor));
            if (initialize) {
                // empty if block
            }
            this.updateView();
        }

        private Vector getTitle(String name) {
            Vector<String> row = new Vector<String>();
            row.add("");
            row.add(name);
            row.add("");
            return row;
        }

        private int row2index(int rowNum) {
            if (rowNum < this.aIndex) {
                return rowNum - this.sIndex;
            }
            if (rowNum < this.iIndex) {
                return rowNum - this.aIndex;
            }
            return rowNum - this.iIndex;
        }

        private int row2type(int rowNum) {
            if (rowNum < this.aIndex) {
                return 0;
            }
            if (rowNum < this.iIndex) {
                return 1;
            }
            return 2;
        }

        @Override
        public void updateView() {
            int i;
            int rowNum = 0;
            for (i = this.dtm.getRowCount() - 1; i >= 0; --i) {
                this.dtm.removeRow(i);
            }
            this.dtm.addRow(this.getTitle("Selections"));
            this.valueEditor.setEditorAt(rowNum, null);
            this.matcherEditor.setEditorAt(rowNum, null);
            this.sIndex = rowNum++;
            for (i = 0; i < VectorMatcherPanel.this.selectionValues.size(); ++i) {
                Vector<String> row = new Vector<String>();
                String matcherType = VectorMatcherPanel.this.selectionMatchersTypes.get(i);
                row.add("Sel " + this.row2index(rowNum));
                row.add(VectorMatcherPanel.this.selectionValues.get(i));
                row.add(matcherType);
                this.dtm.addRow(row);
                JComboBox selCombo = VectorMatcherPanel.this.createCombo(DEFAULT_SELECTION_MATCHERS, false, null, "sel " + i + " matcher combo");
                selCombo.setSelectedItem(matcherType);
                this.matcherEditor.setEditorAt(rowNum, new DefaultCellEditor(selCombo));
                ++rowNum;
            }
            this.dtm.addRow(this.getTitle("Actions"));
            this.valueEditor.setEditorAt(rowNum, null);
            this.matcherEditor.setEditorAt(rowNum, null);
            this.aIndex = rowNum++;
            this.dtm.addRow(this.getTitle("Inputs"));
            this.valueEditor.setEditorAt(rowNum, null);
            this.matcherEditor.setEditorAt(rowNum, null);
            this.sIndex = rowNum++;
            this.actor = new Box(0);
            this.actor.add(VectorMatcherPanel.this.actorLabel);
            this.actor.add(VectorMatcherPanel.this.actorBox);
            this.actor.add(VectorMatcherPanel.this.triggerBox);
            this.add(WindowUtils.wrapLeft(this.actor));
        }

        private void insertAboveRow(int row, String newValue, JComboBox matcherCombo) {
            for (int i = this.dtm.getRowCount(); i >= row + 1; ++i) {
                this.matcherEditor.setEditorAt(i, this.matcherEditor.getEditorAt(i - 1));
            }
            this.matcherEditor.setEditorAt(row, new DefaultCellEditor(matcherCombo));
            Vector<String> v = new Vector<String>();
            v.add(this.row2index(row) + "");
            v.add(newValue);
            v.add(matcherCombo.getSelectedItem().toString());
            this.dtm.insertRow(row, v);
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (SwingUtilities.isRightMouseButton(me)) {
                JTable source = (JTable)me.getSource();
                int row = source.rowAtPoint(me.getPoint());
                int column = source.columnAtPoint(me.getPoint());
                source.changeSelection(row, column, false, false);
                JPopupMenu popup = new JPopupMenu("Choose an action");
                this.insertAbove = new JMenuItem("Insert above");
                this.insertAbove.addActionListener(this);
                popup.add(this.insertAbove);
                this.insertBelow = new JMenuItem("Insert below");
                this.insertBelow.addActionListener(this);
                popup.add(this.insertBelow);
                this.remove = new JMenuItem("Remove");
                this.remove.addActionListener(this);
                popup.add(this.remove);
                popup.show(me.getComponent(), me.getX(), me.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == this.insertAbove) {
                this.insertAboveRow(this.table.getSelectedRow(), "", VectorMatcherPanel.this.createCombo(DEFAULT_MATCHERS[this.row2type(this.table.getSelectedRow())], true, (ActionListener)this, "a good name goes here"));
            } else if (src == this.insertBelow) {
                this.insertAboveRow(this.table.getSelectedRow(), "", VectorMatcherPanel.this.createCombo(DEFAULT_MATCHERS[this.row2type(this.table.getSelectedRow() + 1)], true, (ActionListener)this, "and here as well"));
            } else if (src == this.remove) {
                this.dtm.removeRow(this.table.getSelectedRow());
            }
        }

        @Override
        public void updateInfo(EdgeData ed) {
            if (ed != VectorMatcherPanel.this.edgeData) {
                return;
            }
            this.actor.remove(VectorMatcherPanel.this.actorLabel);
            this.actor.remove(VectorMatcherPanel.this.actorBox);
            this.actor.remove(VectorMatcherPanel.this.triggerBox);
            this.remove(this.actor);
        }

        private class EachRowEditor
        implements TableCellEditor {
            protected Hashtable editors;
            protected Object editor;
            protected Object defaultEditor;
            JTable table;
            private Object[] nullEditor = new Object[0];

            public EachRowEditor(JTable table, Object defaultEditor) {
                this.table = table;
                this.editors = new Hashtable();
                this.defaultEditor = defaultEditor;
            }

            public void setEditorAt(int row, Object editor) {
                if (editor == null) {
                    editor = this.nullEditor;
                }
                this.editors.put(new Integer(row), editor);
            }

            public TableCellEditor getEditorAt(int row) {
                Object e = this.editors.get(new Integer(row));
                if (e == null) {
                    e = this.defaultEditor;
                }
                if (e == this.nullEditor) {
                    e = null;
                }
                return (TableCellEditor)e;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return ((TableCellEditor)this.editor).getTableCellEditorComponent(table, value, isSelected, row, column);
            }

            @Override
            public Object getCellEditorValue() {
                return ((TableCellEditor)this.editor).getCellEditorValue();
            }

            @Override
            public boolean stopCellEditing() {
                return ((TableCellEditor)this.editor).stopCellEditing();
            }

            @Override
            public void cancelCellEditing() {
                ((TableCellEditor)this.editor).cancelCellEditing();
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                this.selectEditor((MouseEvent)anEvent);
                if (this.editor == null || this.editor == this.nullEditor) {
                    return false;
                }
                return ((TableCellEditor)this.editor).isCellEditable(anEvent);
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
                ((TableCellEditor)this.editor).addCellEditorListener(l);
            }

            @Override
            public void removeCellEditorListener(CellEditorListener l) {
                ((TableCellEditor)this.editor).removeCellEditorListener(l);
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                this.selectEditor((MouseEvent)anEvent);
                return ((TableCellEditor)this.editor).shouldSelectCell(anEvent);
            }

            protected void selectEditor(MouseEvent e) {
                int row = e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(e.getPoint());
                this.editor = this.editors.get(new Integer(row));
                if (this.editor == null) {
                    this.editor = this.defaultEditor;
                }
            }
        }
    }

    private class SimpleView
    extends MatcherView
    implements ActionListener {
        private int[] currentChoices;
        JPanel SAIPane;
        GridBagConstraints c;
        final JComboBox selectionValuesCombo;
        final JComboBox actionValuesCombo;
        final JComboBox inputValuesCombo;
        JComboBox[] valuesCombos;
        final JComboBox selectionMatchersCombo;
        final JComboBox actionMatchersCombo;
        final JComboBox inputMatchersCombo;
        JComboBox[] matchersCombos;

        public SimpleView(boolean initialize) {
            this.currentChoices = new int[]{0, 0, 0};
            this.selectionValuesCombo = VectorMatcherPanel.this.createCombo(VectorMatcherPanel.this.selectionValues, true, (ActionListener)this, "selectionValuesCombo");
            this.actionValuesCombo = VectorMatcherPanel.this.createCombo(VectorMatcherPanel.this.actionValues, true, (ActionListener)this, "actionValuesCombo");
            this.inputValuesCombo = VectorMatcherPanel.this.createCombo(VectorMatcherPanel.this.inputValues, true, (ActionListener)this, "inputValuesCombo");
            this.valuesCombos = new JComboBox[]{this.selectionValuesCombo, this.actionValuesCombo, this.inputValuesCombo};
            this.selectionMatchersCombo = VectorMatcherPanel.this.createCombo(DEFAULT_SELECTION_MATCHERS, false, (ActionListener)this, "selectionMatchersCombo");
            this.actionMatchersCombo = VectorMatcherPanel.this.createCombo(DEFAULT_ACTION_MATCHERS, false, (ActionListener)this, "actionMatchersCombo");
            this.inputMatchersCombo = VectorMatcherPanel.this.createCombo(DEFAULT_INPUT_MATCHERS, false, (ActionListener)this, "inputMatchersCombo");
            this.matchersCombos = new JComboBox[]{this.selectionMatchersCombo, this.actionMatchersCombo, this.inputMatchersCombo};
            this.SAIPane = new JPanel(new GridBagLayout());
            this.add(WindowUtils.wrapLeft(this.SAIPane));
            this.c = new GridBagConstraints();
            this.c.fill = 2;
            this.c.ipadx = 5;
            this.c.ipady = 5;
            this.c.insets = new Insets(5, 5, 5, 5);
            this.c.gridx = 0;
            this.c.gridy = 0;
            this.SAIPane.add((Component)new JLabel("Selection: "), this.c);
            this.c.gridx = 1;
            this.SAIPane.add((Component)this.selectionValuesCombo, this.c);
            this.c.gridx = 2;
            this.SAIPane.add((Component)this.selectionMatchersCombo, this.c);
            this.c.gridx = 0;
            this.c.gridy = 1;
            this.SAIPane.add((Component)new JLabel("Action: "), this.c);
            this.c.gridx = 1;
            this.SAIPane.add((Component)this.actionValuesCombo, this.c);
            this.c.gridx = 2;
            this.SAIPane.add((Component)this.actionMatchersCombo, this.c);
            this.c.gridx = 0;
            this.c.gridy = 2;
            this.SAIPane.add((Component)new JLabel("Input: "), this.c);
            this.c.gridx = 1;
            this.SAIPane.add((Component)this.inputValuesCombo, this.c);
            this.c.gridx = 2;
            this.SAIPane.add((Component)this.inputMatchersCombo, this.c);
            if (initialize) {
                this.setDefaultValues(VectorMatcherPanel.this.selectionMatchersTypes, this.selectionMatchersCombo, VectorMatcherPanel.this.edgeData.getSelection().size());
                this.setDefaultValues(VectorMatcherPanel.this.actionMatchersTypes, this.actionMatchersCombo, VectorMatcherPanel.this.edgeData.getAction().size());
                this.setDefaultValues(VectorMatcherPanel.this.inputMatchersTypes, this.inputMatchersCombo, VectorMatcherPanel.this.edgeData.getInput().size());
            }
            this.updateView();
        }

        private void setDefaultValues(Map<Integer, String> matcherTypes, JComboBox matchersCombo, int length) {
            matchersCombo.setSelectedItem("Exact Match");
            matcherTypes.put(0, (String)matchersCombo.getSelectedItem());
            for (int vector = 1; vector < length; ++vector) {
                matcherTypes.put(vector, VectorMatcherPanel.DEFAULT_MATCHER);
            }
            matcherTypes.put(-1, VectorMatcherPanel.DEFAULT_MATCHER);
        }

        @Override
        public void updateView() {
            this.selectionMatchersCombo.setSelectedItem(VectorMatcherPanel.this.selectionMatchersTypes.get(this.selectionValuesCombo.getSelectedIndex()));
            this.actionMatchersCombo.setSelectedItem(VectorMatcherPanel.this.actionMatchersTypes.get(this.actionValuesCombo.getSelectedIndex()));
            this.inputMatchersCombo.setSelectedItem(VectorMatcherPanel.this.inputMatchersTypes.get(this.inputValuesCombo.getSelectedIndex()));
            this.c.gridx = 0;
            this.c.gridy = 3;
            this.SAIPane.add((Component)VectorMatcherPanel.this.actorLabel, this.c);
            this.c.gridx = 1;
            this.SAIPane.add((Component)VectorMatcherPanel.this.actorBox, this.c);
            this.c.gridx = 2;
            this.SAIPane.add((Component)VectorMatcherPanel.this.triggerBox, this.c);
        }

        public void setCurrentSelectedItems(int s, int a, int i) {
            this.currentChoices[0] = s;
            this.currentChoices[1] = a;
            this.currentChoices[2] = i;
            this.selectionValuesCombo.setSelectedIndex(s);
            this.actionValuesCombo.setSelectedIndex(a);
            this.inputValuesCombo.setSelectedIndex(i);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            String selC = this.selectionValuesCombo.getItemAt(0).toString();
            String selM = this.selectionMatchersCombo.getItemAt(0).toString();
            Vector<String> selV = VectorMatcherPanel.this.selectionValues;
            int s = this.currentChoices[0];
            if (src == this.selectionValuesCombo) {
                this.updateVector(0);
            } else if (src == this.actionValuesCombo) {
                this.updateVector(1);
            } else if (src == this.inputValuesCombo) {
                this.updateVector(2);
            } else if (src == this.selectionMatchersCombo) {
                VectorMatcherPanel.this.selectionMatchersTypes.put(this.currentChoices[0], (String)this.selectionMatchersCombo.getSelectedItem());
            } else if (src == this.actionMatchersCombo) {
                VectorMatcherPanel.this.actionMatchersTypes.put(this.currentChoices[1], (String)this.actionMatchersCombo.getSelectedItem());
            } else if (src == this.inputMatchersCombo) {
                VectorMatcherPanel.this.inputMatchersTypes.put(this.currentChoices[2], (String)this.inputMatchersCombo.getSelectedItem());
            } else if (src instanceof ExpressionDialog) {
                if (ae.getActionCommand().equals("Cancel")) {
                    return;
                }
                ExpressionMatcher em = new ExpressionMatcher();
                em.setInputExpression(((ExpressionDialog)src).getText());
                em.setRelation(((ExpressionDialog)src).getRelation());
                VectorMatcherPanel.this.inputMatchers.put(this.currentChoices[2], em);
            }
        }

        public void updateVector(int vector) {
            int newChoice = this.valuesCombos[vector].getSelectedIndex();
            if (newChoice == -1) {
                VectorMatcherPanel.this.values[vector].set(this.currentChoices[vector], this.valuesCombos[vector].getSelectedItem().toString());
                return;
            }
            if (this.currentChoices[vector] != newChoice) {
                this.currentChoices[vector] = newChoice;
                this.matchersCombos[vector].setSelectedItem(VectorMatcherPanel.this.matchersTypes[vector].get(newChoice));
                return;
            }
        }

        @Override
        public void updateInfo(EdgeData ed) {
            if (ed != VectorMatcherPanel.this.edgeData) {
                return;
            }
            this.updateVector(0);
            this.updateVector(1);
            this.updateVector(2);
            this.SAIPane.remove(VectorMatcherPanel.this.actorLabel);
            this.SAIPane.remove(VectorMatcherPanel.this.actorBox);
            this.SAIPane.remove(VectorMatcherPanel.this.triggerBox);
        }
    }

    private class ConcatView
    extends MatcherView
    implements ActionListener,
    MouseListener {
        final JTextArea defaultSelectionArea;
        final JTextArea defaultActionArea;
        final JTextArea defaultInputArea;
        JTextArea[] defaultAreas;
        final JTextArea selectionValueArea;
        final JTextArea actionValueArea;
        final JTextArea inputValueArea;
        JTextArea[] valueAreas;
        CtatListModel actionsLM;
        CtatListModel selectionsLM;
        final JComponent selectionValueList;
        final JComponent actionValueList;
        final JComponent variableNameList;
        final JPanel selectionValuePanel;
        final JPanel actionValuePanel;
        final JPanel inputValuePanel;
        JPanel[] valuePanels;
        final JComboBox selectionMatcherCombo;
        final JComboBox actionMatcherCombo;
        final JComboBox inputMatcherCombo;
        JComboBox[] matcherCombos;
        final JTextArea selectionMatcherArea;
        final JTextArea actionMatcherArea;
        final JTextArea inputMatcherArea;
        JTextArea[] matcherAreas;
        final JButton selectionCheckButton;
        final JButton actionCheckButton;
        final JButton inputCheckButton;
        JButton[] checkButtons;
        final JButton checkAllButton;
        final JButton selectionLastEvalButton;
        final JButton actionLastEvalButton;
        final JButton inputLastEvalButton;
        JButton[] lastEvalButtons;
        final JPanel selectionMatcherPanel;
        final JPanel actionMatcherPanel;
        final JPanel inputMatcherPanel;
        JPanel[] matcherPanels;
        GridBagConstraints c;

        public ConcatView(boolean initialize) {
            this.defaultSelectionArea = VectorMatcherPanel.createTextArea("defaultSelectionArea");
            this.defaultActionArea = VectorMatcherPanel.createTextArea("defaultActionArea");
            this.defaultInputArea = VectorMatcherPanel.createTextArea("defaultInputArea");
            this.defaultAreas = new JTextArea[]{this.defaultSelectionArea, this.defaultActionArea, this.defaultInputArea};
            this.selectionValueArea = VectorMatcherPanel.createTextArea("selectionValueArea");
            this.actionValueArea = VectorMatcherPanel.createTextArea("actionValueArea");
            this.inputValueArea = VectorMatcherPanel.createTextArea("inputValueArea");
            this.valueAreas = new JTextArea[]{this.selectionValueArea, this.actionValueArea, this.inputValueArea};
            this.actionsLM = this.listActions(this.selectionValueArea);
            this.selectionsLM = this.listSelections();
            this.selectionValueList = this.createValueList("SelectionValueList", this.selectionsLM, "Drag names to the Demonstrated Value or Matcher Settings area for this selection.");
            this.actionValueList = this.createValueList("ActionValueList", this.actionsLM, "<html>Drag Action names from this list to the Demonstrated Value or Matcher Settings area.<br/><b>Boldface</b> actions are known to supported by the component named in Selection Matcher Settings.</html>");
            this.variableNameList = this.createValueList("InputValueList", this.listVariables(this.selectionsLM), "Drag variable names from this list for use in formulas.");
            this.selectionValuePanel = this.createValueAreaPanel(this.selectionValueArea, new Dimension(TEXT_AREA_DIM.width, DEMO_SEL_ACT_DIM.height));
            this.actionValuePanel = this.createValueAreaPanel(this.actionValueArea, new Dimension(TEXT_AREA_DIM.width, DEMO_SEL_ACT_DIM.height));
            this.inputValuePanel = this.createValueAreaPanel(this.inputValueArea, TEXT_AREA_DIM);
            this.valuePanels = new JPanel[]{this.selectionValuePanel, this.actionValuePanel, this.inputValuePanel};
            this.selectionMatcherCombo = VectorMatcherPanel.this.createCombo(DEFAULT_SELECTION_MATCHERS, false, (ActionListener)this, "selectionMatcherCombo");
            this.actionMatcherCombo = VectorMatcherPanel.this.createCombo(DEFAULT_ACTION_MATCHERS, false, (ActionListener)this, "actionMatcherCombo");
            this.inputMatcherCombo = VectorMatcherPanel.this.createCombo(DEFAULT_INPUT_MATCHERS, false, (ActionListener)this, "inputMatcherCombo");
            this.matcherCombos = new JComboBox[]{this.selectionMatcherCombo, this.actionMatcherCombo, this.inputMatcherCombo};
            this.selectionMatcherArea = VectorMatcherPanel.createTextArea("selectionMatcherArea");
            this.actionMatcherArea = VectorMatcherPanel.createTextArea("actionMatcherArea");
            this.inputMatcherArea = VectorMatcherPanel.createTextArea("inputMatcherArea");
            for (JTextArea ma : this.matcherAreas = new JTextArea[]{this.selectionMatcherArea, this.actionMatcherArea, this.inputMatcherArea}) {
                ma.setFont(new Font("Monospaced", 0, 11));
            }
            this.selectionCheckButton = this.createCheckButton("Check", "selectionCheckButton");
            this.actionCheckButton = this.createCheckButton("Check", "actionCheckButton");
            this.inputCheckButton = this.createCheckButton("Check", "inputCheckButton");
            this.checkButtons = new JButton[]{this.selectionCheckButton, this.actionCheckButton, this.inputCheckButton};
            this.checkAllButton = this.createCheckButton("Check All", "checkAllButton");
            this.selectionLastEvalButton = this.createLastEvalButton("selectionLastEvalButton");
            this.actionLastEvalButton = this.createLastEvalButton("actionLastEvalButton");
            this.inputLastEvalButton = this.createLastEvalButton("inputLastEvalButton");
            this.lastEvalButtons = new JButton[]{this.selectionLastEvalButton, this.actionLastEvalButton, this.inputLastEvalButton};
            this.selectionMatcherPanel = this.createMatcherPanel(0);
            this.actionMatcherPanel = this.createMatcherPanel(1);
            this.inputMatcherPanel = this.createMatcherPanel(2);
            this.matcherPanels = new JPanel[]{this.selectionMatcherPanel, this.actionMatcherPanel, this.inputMatcherPanel};
            VectorMatcherPanel.this.SAIPane = new JPanel(new GridBagLayout());
            VectorMatcherPanel.this.SAIPane.setBorder(new EmptyBorder(0, 0, 4, 0));
            for (int vector = 0; vector < 3; ++vector) {
                this.valueAreas[vector].addMouseListener(this);
                this.matcherAreas[vector].setBackground(UneditableBackgroundColor);
                this.matcherAreas[vector].setRows(2);
                this.matcherAreas[vector].setColumns(20);
            }
            this.c = new GridBagConstraints();
            this.c.fill = 2;
            this.c.anchor = 21;
            this.c.ipadx = 5;
            this.c.ipady = 5;
            this.c.fill = 0;
            this.c.anchor = 22;
            this.c.insets = new Insets(0, 0, 10, 0);
            this.c.gridx = 0;
            this.c.gridy = 0;
            VectorMatcherPanel.this.SAIPane.add((Component)new JLabel("<html><b>Link #" + VectorMatcherPanel.this.edgeData.getUniqueID() + "</b></html>"), this.c);
            this.c.fill = 2;
            this.c.anchor = 21;
            this.c.insets = new Insets(0, 10, 10, 0);
            this.c.gridx = 1;
            VectorMatcherPanel.this.SAIPane.add((Component)new JLabel("<html><b>Demonstrated Value</b></html>"), this.c);
            this.c.gridx = 2;
            this.c.weightx = 1.0;
            VectorMatcherPanel.this.SAIPane.add((Component)new JLabel("<html><b>Matcher Settings</b></html>"), this.c);
            this.c.weightx = 0.0;
            this.c.gridx = 3;
            VectorMatcherPanel.this.SAIPane.add((Component)new JLabel("<html><b>Matcher Type and Check</b></html>"), this.c);
            this.c.gridx = 4;
            this.c.fill = 0;
            this.c.anchor = 22;
            VectorMatcherPanel.this.SAIPane.add((Component)this.checkAllButton, this.c);
            this.c.fill = 0;
            this.c.anchor = 24;
            this.c.insets = new Insets(0, 0, 10, 0);
            this.c.gridx = 0;
            this.c.gridy = 1;
            this.c.weighty = 0.2;
            VectorMatcherPanel.this.SAIPane.add((Component)new JLabel("Selection:"), this.c);
            this.c.fill = 1;
            this.c.anchor = 23;
            this.c.insets = new Insets(0, 10, 10, 0);
            this.c.gridx = 1;
            VectorMatcherPanel.this.SAIPane.add((Component)this.createValueAreaPanel(this.defaultSelectionArea, this.selectionValueList, DEMO_SEL_ACT_DIM), this.c);
            this.c.gridx = 2;
            this.c.weightx = 1.0;
            VectorMatcherPanel.this.SAIPane.add((Component)this.selectionValuePanel, this.c);
            this.c.weightx = 0.0;
            this.c.gridx = 3;
            this.c.gridwidth = 0;
            VectorMatcherPanel.this.SAIPane.add((Component)this.selectionMatcherPanel, this.c);
            this.c.gridwidth = 1;
            this.c.fill = 0;
            this.c.anchor = 24;
            this.c.insets = new Insets(0, 0, 10, 0);
            this.c.gridx = 0;
            this.c.gridy = 2;
            this.c.weighty = 0.2;
            VectorMatcherPanel.this.SAIPane.add((Component)new JLabel("Action:"), this.c);
            this.c.fill = 1;
            this.c.anchor = 23;
            this.c.insets = new Insets(0, 10, 10, 0);
            this.c.gridx = 1;
            VectorMatcherPanel.this.SAIPane.add((Component)this.createValueAreaPanel(this.defaultActionArea, this.actionValueList, DEMO_SEL_ACT_DIM), this.c);
            this.c.gridx = 2;
            this.c.weightx = 1.0;
            VectorMatcherPanel.this.SAIPane.add((Component)this.actionValuePanel, this.c);
            this.c.weightx = 0.0;
            this.c.gridx = 3;
            this.c.gridwidth = 0;
            VectorMatcherPanel.this.SAIPane.add((Component)this.actionMatcherPanel, this.c);
            this.c.gridwidth = 1;
            this.c.fill = 0;
            this.c.anchor = 24;
            this.c.insets = new Insets(0, 0, 10, 0);
            this.c.gridx = 0;
            this.c.gridy = 3;
            this.c.weighty = 0.6;
            VectorMatcherPanel.this.SAIPane.add((Component)new JLabel("Input:"), this.c);
            this.c.fill = 1;
            this.c.anchor = 23;
            this.c.insets = new Insets(0, 10, 10, 0);
            this.c.gridx = 1;
            VectorMatcherPanel.this.SAIPane.add((Component)this.createValueAreaPanel(this.defaultInputArea, this.variableNameList, new Dimension(DEMO_SEL_ACT_DIM.width, TEXT_AREA_DIM.height)), this.c);
            this.c.gridx = 2;
            this.c.weightx = 1.0;
            VectorMatcherPanel.this.SAIPane.add((Component)this.inputValuePanel, this.c);
            this.c.weightx = 0.0;
            this.c.gridx = 3;
            this.c.gridwidth = 0;
            VectorMatcherPanel.this.SAIPane.add((Component)this.inputMatcherPanel, this.c);
            this.c.gridwidth = 1;
            this.c.weighty = 0.0;
            this.c.fill = 2;
            for (int i = 0; i < 3; ++i) {
                this.setDefaultAreaValues(i);
            }
            this.updateView();
            this.setLayout(new BorderLayout());
            this.add((Component)VectorMatcherPanel.this.SAIPane, "Center");
        }

        FocusTraversalPolicy getCustomFocusTraversalPolicy() {
            return new SAITraversalPolicy(new JComponent[]{this.defaultSelectionArea, this.selectionValueArea, this.defaultActionArea, this.actionValueArea, this.defaultInputArea, this.inputValueArea});
        }

        private JComponent createValueList(String name, final CtatListModel listModel, String toolTip) {
            final JList result = new JList(listModel);
            listModel.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    if (trace.getDebugCode("editstudentinput")) {
                        trace.out("editstudentinput", "contentsChanged(" + e + ") receieved: to setModel()");
                    }
                    result.setModel(listModel);
                    result.setEnabled(listModel.hasData());
                }
            });
            result.addMouseListener(new MouseAdapter(){
                final int mask = 7168;

                @Override
                public void mouseEntered(MouseEvent e) {
                    if ((e.getModifiersEx() & 0x1C00) == 0) {
                        result.setCursor(Cursor.getPredefinedCursor(13));
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if ((e.getModifiersEx() & 0x1C00) == 0) {
                        result.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
            result.setCellRenderer(new StyledStringRenderer(result.getCellRenderer()));
            result.setEnabled(listModel.hasData());
            result.setName(name);
            result.setSelectionMode(0);
            result.setLayoutOrientation(0);
            result.setBackground(Color.WHITE);
            result.setFont(new Font(null, 0, 11));
            result.setVisibleRowCount(3);
            result.setDragEnabled(true);
            String saiElt = name.replace("ValueList", "");
            if (listModel.getCannotFill()) {
                result.setToolTipText("Cannot retrieve names of selections because no student interface is connected.");
            } else {
                result.setToolTipText(toolTip);
            }
            JScrollPane scroller = new JScrollPane(result);
            scroller.setVerticalScrollBarPolicy(22);
            return scroller;
        }

        private CtatListModel listSelections() {
            UniversalToolProxy utp;
            CtatListModel result = new CtatListModel(null);
            BR_Controller ctlr = VectorMatcherPanel.this.edgeData.getController();
            if (ctlr == null || (utp = ctlr.getUniversalToolProxy()) == null) {
                result.setCannotFill(true);
            } else if (utp.getStudentInterfaceConnectionStatus() == StudentInterfaceConnectionStatus.Disconnected) {
                result.setCannotFill(true);
            } else {
                VectorMatcherPanel.this.edgeData.getController().getUniversalToolProxy().listSelectionNames(result);
            }
            return result;
        }

        private CtatListModel listActions(JTextComponent textArea) {
            ActionListModel result;
            String studentInterfacePlatform = "HTML & Flash";
            UniversalToolProxy utp = null;
            if (VectorMatcherPanel.this.edgeData.getController() != null && (utp = VectorMatcherPanel.this.edgeData.getController().getUniversalToolProxy()) != null) {
                studentInterfacePlatform = utp.getStudentInterfacePlatform();
            }
            if (utp != null) {
                result = new ActionListModel(utp.getAllActionNames(), utp.getStartStateModel());
                utp.addStartStateListener(result);
            } else {
                result = "Java".equalsIgnoreCase(studentInterfacePlatform) ? new ActionListModel(JCommWidget.listActionNames(), null) : new ActionListModel(RemoteToolProxy.getFlashActionNames(), null);
            }
            if (textArea != null) {
                textArea.addPropertyChangeListener(result);
            }
            return result;
        }

        private CtatListModel listVariables(CtatListModel selectionsLM) {
            class VarListModel
            extends CtatListModel
            implements ListDataListener {
                private static final long serialVersionUID = 201403071920L;

                VarListModel(CtatListModel selectionsLM) {
                    super(null);
                    this.refresh(selectionsLM);
                }

                private synchronized void refresh(CtatListModel selectionsLM) {
                    VariableTable vt;
                    ProblemModel pm;
                    ArrayList<String> minVList = new ArrayList<String>(Arrays.asList("selection", "action", "input"));
                    BR_Controller ctlr = VectorMatcherPanel.this.edgeData.getController();
                    if (ctlr == null || (pm = ctlr.getProblemModel()) == null || (vt = pm.getVariableTable()) == null) {
                        minVList.addAll(VectorMatcherPanel.getFunctionList());
                        this.addAll(minVList, false);
                        return;
                    }
                    HashSet vars = new HashSet(vt.keySet());
                    int n = vars.size();
                    int k = 0;
                    Iterator<String> it = selectionsLM.iterator();
                    while (it.hasNext()) {
                        if (!vars.remove(it.next())) continue;
                        ++k;
                    }
                    vars.addAll(minVList);
                    if (trace.getDebugCode("editstudentinput")) {
                        trace.out("editstudentinput", "VarListModel.refresh(" + selectionsLM + ") " + n + " vars, " + k + " removed, " + minVList.size() + " minVars, final size " + vars.size());
                    }
                    ArrayList<String> vList = new ArrayList<String>(vars);
                    Collections.sort(vList, String.CASE_INSENSITIVE_ORDER);
                    vList.addAll(VectorMatcherPanel.getFunctionList());
                    this.addAll(vList, false);
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    if (!(e.getSource() instanceof CtatListModel)) {
                        throw new IllegalArgumentException("Event source " + trace.nh(e.getSource()) + " is not a CtatListModel; event " + e);
                    }
                    this.refresh((CtatListModel)e.getSource());
                }
            }
            VarListModel result = new VarListModel(selectionsLM);
            selectionsLM.addListDataListener(result);
            return result;
        }

        private JButton createLastEvalButton(String name) {
            JButton b = new JButton("Last Evaluation");
            b.setName(name);
            b.setFont(new Font(null, 0, 11));
            b.addActionListener(this);
            b.setVisible(false);
            return b;
        }

        private JPanel createValueAreaPanel(JTextArea area, Dimension dim) {
            area.setRows(4);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setPreferredSize(dim);
            p.setMinimumSize(dim);
            p.add(VectorMatcherPanel.this.scrollerizeTextArea(area, null));
            p.add(Box.createRigidArea(new Dimension(dim.width, 0)));
            return p;
        }

        private JPanel createValueAreaPanel(JTextArea area, JComponent list, Dimension dim) {
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            p.setPreferredSize(dim);
            p.setMinimumSize(dim);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 23;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            FontMetrics fm = area.getFontMetrics(area.getFont());
            JScrollPane pane = VectorMatcherPanel.this.scrollerizeTextArea(area, new Dimension(dim.width, fm.getHeight() * 3));
            p.add((Component)pane, c);
            c.insets = new Insets(2, 0, 0, 0);
            c.fill = 1;
            c.gridy = 1;
            c.gridheight = 0;
            c.weighty = 1.0;
            list.setPreferredSize(new Dimension(dim.width, dim.height - pane.getPreferredSize().height - 2));
            p.add((Component)list, c);
            return p;
        }

        private JButton createCheckButton(String text, String name) {
            JButton b = new JButton(text);
            b.setName(name);
            b.setFont(new Font(null, 0, 11));
            b.addActionListener(this);
            return b;
        }

        private JPanel createMatcherPanel(int vector) {
            this.matcherAreas[vector].setEditable(false);
            this.matcherAreas[vector].setBackground(UneditableBackgroundColor);
            this.matcherAreas[vector].setRows(2);
            this.matcherAreas[vector].setColumns(20);
            JPanel pane = new JPanel();
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 2, 0);
            c.anchor = 23;
            c.gridx = 0;
            c.fill = 0;
            c.gridy = 0;
            pane.add((Component)this.matcherCombos[vector], c);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridy = 1;
            this.matcherAreas[vector].setRows(4);
            JScrollPane masp = VectorMatcherPanel.this.scrollerizeTextArea(this.matcherAreas[vector], null);
            pane.add((Component)masp, c);
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridy = 2;
            Box buttons = new Box(2);
            buttons.add(this.checkButtons[vector]);
            buttons.add(Box.createHorizontalGlue());
            buttons.add(this.lastEvalButtons[vector]);
            pane.add((Component)buttons, c);
            return pane;
        }

        private ExpressionMatcherPanel createExpressionArea(int vector, String name) {
            ExpressionMatcherPanel expr = new ExpressionMatcherPanel(VectorMatcherPanel.this.edgeData, this.valueAreas[vector].getText());
            expr.setName(name);
            expr.setPreferredSize(TEXT_AREA_DIM);
            return expr;
        }

        private RangeMatcherPanel createRangeArea(int vector, String name) {
            RangeMatcherPanel rmp = new RangeMatcherPanel(this.valueAreas[vector].getText());
            rmp.setName(name);
            return rmp;
        }

        private MatcherPanel createSolverArea(Matcher vm, String name) {
            if (!(vm instanceof VectorMatcher)) {
                trace.err("createSolverArea() needs a VectorMatcher but got " + vm.getClass().getSimpleName());
                vm = VectorMatcherPanel.this.createTempVectorMatcher();
            }
            SolverMatcherPanel vmp = new SolverMatcherPanel((VectorMatcher)vm, this.getBackground());
            vmp.setName(name);
            return vmp;
        }

        public void setDefaultAreaValues(int vector) {
            this.defaultAreas[vector].setText(VectorMatcherPanel.this.getDemonstratedValue(vector));
            this.defaultAreas[vector].setEditable(true);
            this.defaultAreas[vector].setBackground(Color.WHITE);
        }

        private boolean check(int vector) {
            if (VectorMatcherPanel.this.getDemonstratedValue(vector) == null) {
                this.matcherAreas[vector].setText("No demonstrated values given");
                return false;
            }
            String matcherName = (String)VectorMatcherPanel.this.matchersTypes[vector].get(0);
            Matcher m = null;
            if (matcherName == "Formula Match") {
                ExpressionMatcherPanel exprPanel = (ExpressionMatcherPanel)this.valuePanels[vector].getComponent(0);
                exprPanel.setSyntaxCheck(this.matcherAreas[vector]);
                return exprPanel.checkDemonstratedValues(true, true, vector, VectorMatcherPanel.this.defaultSelectionVector, VectorMatcherPanel.this.defaultActionVector, VectorMatcherPanel.this.defaultInputVector);
            }
            if (matcherName == "Range Match") {
                RangeMatcherPanel rangePanel = (RangeMatcherPanel)this.valuePanels[vector].getComponent(0);
                String min = rangePanel.minimumField.getText();
                String max = rangePanel.maximumField.getText();
                try {
                    m = new RangeMatcher(true, vector, min, max);
                }
                catch (NumberFormatException e) {
                    this.matcherAreas[vector].setText("Invalid syntax: \"" + min + "\" or \"" + max + "\"");
                    return false;
                }
            }
            String input = this.valueAreas[vector].getText();
            try {
                m = MatcherFactory.createSingleMatcher(matcherName, true, vector, input);
            }
            catch (Exception e) {
                this.matcherAreas[vector].setText("Invalid syntax: " + input);
                return false;
            }
            boolean checkAgainst = m.matchConcatenation(VectorMatcherPanel.this.defaults[vector]);
            if (checkAgainst) {
                this.matcherAreas[vector].setText("Matches demonstrated value(s)");
            } else {
                this.matcherAreas[vector].setText("Did not match demonstrated value(s)");
            }
            return checkAgainst;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src instanceof JComboBox) {
                int vector;
                String matcherName = null;
                for (vector = 0; vector < 3; ++vector) {
                    if (src != this.matcherCombos[vector]) continue;
                    if (vector == 2) {
                        this.matcherCombos[0].setEnabled(true);
                        this.matcherCombos[1].setEnabled(true);
                    }
                    this.matcherAreas[vector].setText("");
                    if (VectorMatcherPanel.this.matchersTypes[vector].get(0) == "Formula Match") {
                        this.lastEvalButtons[vector].setVisible(false);
                        Component panel = this.valuePanels[vector].getComponent(0);
                        if (panel instanceof ActionListener) {
                            this.lastEvalButtons[vector].removeActionListener((ActionListener)((Object)panel));
                        }
                    }
                    matcherName = (String)this.matcherCombos[vector].getSelectedItem();
                    VectorMatcherPanel.this.matchersTypes[vector].put(0, matcherName);
                    break;
                }
                if (vector == 3) {
                    return;
                }
                this.valuePanels[vector].removeAll();
                if (matcherName == "Equation Solver") {
                    this.matcherCombos[0].setEnabled(false);
                    this.matcherCombos[1].setEnabled(false);
                    this.valuePanels[vector].add(this.createSolverArea(VectorMatcherPanel.this.existingMatcher, VectorMatcherPanel.vector2name(vector) + "SolverArea"));
                } else if (matcherName == "Formula Match") {
                    ExpressionMatcherPanel exprPanel = this.createExpressionArea(vector, VectorMatcherPanel.vector2name(vector) + "ExpressionArea");
                    this.valuePanels[vector].add(exprPanel);
                    if (VectorMatcherPanel.this.existingMatcher instanceof ExpressionMatcher) {
                        exprPanel.setLastMatcher((ExpressionMatcher)VectorMatcherPanel.this.existingMatcher);
                    } else if (VectorMatcherPanel.this.existingMatcher instanceof VectorMatcher && ((VectorMatcher)VectorMatcherPanel.this.existingMatcher).getMatchers(vector).get(0) instanceof ExpressionMatcher) {
                        exprPanel.setLastMatcher((ExpressionMatcher)((VectorMatcher)VectorMatcherPanel.this.existingMatcher).getMatchers(vector).get(0));
                    }
                    this.lastEvalButtons[vector].addActionListener(exprPanel);
                    this.lastEvalButtons[vector].setVisible(true);
                    exprPanel.setSyntaxCheck(this.matcherAreas[vector]);
                } else if (matcherName == "Range Match") {
                    this.valuePanels[vector].add(this.createRangeArea(vector, VectorMatcherPanel.vector2name(vector) + "RangeArea"));
                } else {
                    this.valuePanels[vector].add(VectorMatcherPanel.this.scrollerizeTextArea(this.valueAreas[vector], null));
                    this.valuePanels[vector].add(Box.createRigidArea(new Dimension(TEXT_AREA_DIM.width, 0)));
                }
                VectorMatcherPanel.this.parent.validate();
                VectorMatcherPanel.this.parent.repaint();
            } else if (src == this.selectionCheckButton) {
                this.check(0);
            } else if (src == this.actionCheckButton) {
                this.check(1);
            } else if (src == this.inputCheckButton) {
                this.check(2);
            } else if (src == this.checkAllButton) {
                for (int vector = 0; vector < 3; ++vector) {
                    this.check(vector);
                }
            }
        }

        private void updateVectorInfo(int vector) {
            String[] vals = this.valueAreas[vector].getText().split("\n", -1);
            Vector<String> s = new Vector<String>();
            for (int i = 0; i < vals.length; ++i) {
                s.add(vals[i]);
            }
            VectorMatcherPanel.this.values[vector] = s;
            VectorMatcherPanel.this.matchersTypes[vector].put(0, this.matcherCombos[vector].getSelectedItem());
        }

        private void updateDemonstrateValueInfo(JTextArea[] demonstrateValue, EdgeData ed) {
            for (int i = 0; i < demonstrateValue.length; ++i) {
                String newValue = demonstrateValue[i].getText();
                if (trace.getDebugCode("br")) {
                    trace.out("br", "ConcatView.demonstrateValue[" + i + "]=" + newValue);
                }
                Vector<String> currentValueVector = new Vector<String>();
                currentValueVector.add(newValue);
                if (demonstrateValue[i] == this.defaultSelectionArea) {
                    ed.setSelection(currentValueVector);
                    continue;
                }
                if (demonstrateValue[i] == this.defaultActionArea) {
                    ed.setAction(currentValueVector);
                    continue;
                }
                if (demonstrateValue[i] != this.defaultInputArea) continue;
                ed.setInput(currentValueVector);
            }
            ed.resetCommMessage();
        }

        @Override
        public void updateInfo(EdgeData ed) {
            this.updateVectorInfo(0);
            this.updateVectorInfo(1);
            this.updateVectorInfo(2);
            this.updateDemonstrateValueInfo(this.defaultAreas, ed);
            if (ed == VectorMatcherPanel.this.edgeData) {
                VectorMatcherPanel.this.SAIPane.remove(VectorMatcherPanel.this.actorLabel);
                VectorMatcherPanel.this.SAIPane.remove(VectorMatcherPanel.this.actorBox);
                VectorMatcherPanel.this.SAIPane.remove(VectorMatcherPanel.this.triggerLabel);
                VectorMatcherPanel.this.SAIPane.remove(VectorMatcherPanel.this.triggerBox);
                VectorMatcherPanel.this.SAIPane.remove(VectorMatcherPanel.this.replaceInputCheckBox);
                VectorMatcherPanel.this.SAIPane.remove(VectorMatcherPanel.this.replaceInputFormulaField);
            }
        }

        private void updateVectorView(int vector) {
            String text = Matcher.vector2ConcatString(VectorMatcherPanel.this.values[vector]);
            this.valueAreas[vector].setText(text);
            if (VectorMatcherPanel.this.existingMatcher instanceof SolverMatcher && vector == 2) {
                this.matcherCombos[vector].setSelectedItem("Equation Solver");
            } else {
                this.matcherCombos[vector].setSelectedItem(VectorMatcherPanel.this.matchersTypes[vector].get(0));
            }
        }

        @Override
        public void updateView() {
            this.updateVectorView(0);
            this.updateVectorView(1);
            this.updateVectorView(2);
            this.c.fill = 0;
            this.c.anchor = 22;
            this.c.insets = new Insets(0, 0, 2, 0);
            this.c.gridy = 4;
            this.c.gridx = 0;
            VectorMatcherPanel.this.SAIPane.add((Component)VectorMatcherPanel.this.actorLabel, this.c);
            this.c.fill = 2;
            this.c.anchor = 21;
            this.c.insets = new Insets(0, 10, 2, 0);
            this.c.gridx = 1;
            this.c.gridwidth = 2;
            VectorMatcherPanel.this.SAIPane.add((Component)VectorMatcherPanel.this.actorBox, this.c);
            this.c.gridx = 3;
            this.c.gridwidth = 0;
            VectorMatcherPanel.this.SAIPane.add((Component)VectorMatcherPanel.this.replaceInputCheckBox, this.c);
            this.c.gridwidth = 1;
            this.c.fill = 0;
            this.c.anchor = 22;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.c.gridy = 5;
            this.c.gridx = 0;
            VectorMatcherPanel.this.SAIPane.add((Component)VectorMatcherPanel.this.triggerLabel, this.c);
            this.c.fill = 2;
            this.c.anchor = 21;
            this.c.insets = new Insets(0, 10, 0, 0);
            this.c.gridx = 1;
            this.c.gridwidth = 2;
            VectorMatcherPanel.this.SAIPane.add((Component)VectorMatcherPanel.this.triggerBox, this.c);
            this.c.gridx = 3;
            this.c.gridwidth = 0;
            VectorMatcherPanel.this.SAIPane.add((Component)VectorMatcherPanel.this.replaceInputFormulaField, this.c);
            this.c.gridwidth = 1;
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            Object src = me.getSource();
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
        }

        class SAITraversalPolicy
        extends FocusTraversalPolicy {
            private final JComponent[] components;

            SAITraversalPolicy(JComponent[] components) {
                this.components = components;
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                for (int i = 0; i < this.components.length - 1; ++i) {
                    if (!this.components[i].equals(aComponent)) continue;
                    return this.components[i + 1];
                }
                return this.components[0];
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                for (int i = this.components.length - 1; i > 0; --i) {
                    if (!this.components[i].equals(aComponent)) continue;
                    return this.components[i - 1];
                }
                return this.components[this.components.length - 1];
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return this.components[0];
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return this.components[this.components.length - 1];
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return this.getFirstComponent(aContainer);
            }
        }
    }

    private abstract class MatcherView
    extends JPanel {
        private MatcherView() {
        }

        public abstract void updateView();

        public abstract void updateInfo(EdgeData var1);
    }

    private class ActorListener
    implements ActionListener {
        private ActorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            boolean enable = !VectorMatcherPanel.this.studentButton.getActionCommand().equals(cmd);
            VectorMatcherPanel.this.triggerLabel.setEnabled(enable);
            VectorMatcherPanel.this.stateTriggerBtn.setEnabled(enable);
            VectorMatcherPanel.this.linkTriggerBtn.setEnabled(enable);
        }
    }
}

