/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RangeMatcher
extends Matcher {
    public static final int DEFAULT_MINIMUM = 0;
    public static final int DEFAULT_MAXIMUM = 100;
    private double minimum = 0.0;
    private double maximum = 100.0;
    private String minimumStr = Double.toString(0.0);
    private String maximumStr = Double.toString(100.0);
    Element element;
    private Document doc;
    private Element minimumElement;
    private Element maximumElement;
    private Element selectionElement;
    private Element actionElement;
    private Element actorElement;
    private String action;
    private String selection;
    private String actor;

    public RangeMatcher(boolean concat2, int vector, String text) throws NumberFormatException {
        super(concat2, vector);
        String minText = text == null || text.length() == 0 ? "0" : text;
        String maxText = "0";
        if (text != null) {
            int maxIndex;
            int commaIndex;
            int minIndex = text.indexOf("[");
            if (minIndex >= 0 && (commaIndex = text.indexOf(",", minIndex + 1)) >= 0 && (maxIndex = text.indexOf("]", commaIndex + 1)) >= 0) {
                minText = text.substring(minIndex + 1, commaIndex);
                maxText = text.substring(commaIndex + 1, maxIndex);
            }
            this.setMinimum(minText);
            this.setMaximum(maxText);
        }
    }

    public RangeMatcher(boolean concat2, int vector, String minText, String maxText) {
        super(concat2, vector);
        this.setMinimum(minText);
        this.setMaximum(maxText);
    }

    public RangeMatcher() {
        this.initXML();
        this.setMinimum(Double.toString(0.0));
        this.setMaximum(Double.toString(100.0));
    }

    private void initXML() {
        this.element = new Element("matcher");
        Element type = new Element("matcherType");
        type.addContent("RangeMatcher");
        this.element.addContent((Content)type);
        this.minimumElement = new Element("matcherParameter");
        this.minimumElement.addContent(this.minimumStr);
        this.maximumElement = new Element("matcherParameter");
        this.maximumElement.addContent(this.maximumStr);
        this.selectionElement = new Element("matcherParameter");
        this.actionElement = new Element("matcherParameter");
        this.actorElement = new Element("matcherParameter");
        this.element.addContent((Content)this.minimumElement);
        this.element.addContent((Content)this.maximumElement);
        this.element.addContent((Content)this.selectionElement);
        this.element.addContent((Content)this.actionElement);
        this.element.addContent((Content)this.actorElement);
        this.doc = new Document(this.element);
    }

    @Override
    public Object clone() {
        RangeMatcher m = new RangeMatcher(this.concat, this.vector, this.minimumStr, this.maximumStr);
        m.copyFrom(this);
        m.initXML();
        m.setSelection(this.getSelection());
        m.setAction(this.getAction());
        m.setActor(this.getActor());
        return m;
    }

    @Override
    public String toXML() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
            outp.output(this.doc, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        String newString = out.toString();
        newString = newString.substring(newString.indexOf("\n"), newString.length());
        return newString;
    }

    @Override
    public String toXML(String prefix) {
        String xml = this.toXML();
        xml = prefix + xml;
        xml = xml.replaceAll("\n", "\n" + prefix);
        return xml;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public String getMaximumStr() {
        return this.maximumStr;
    }

    public String getMinimumStr() {
        return this.minimumStr;
    }

    public void setMinimum(String min) {
        if (trace.getDebugCode("range")) {
            trace.out("range", "setMinimum() old \"" + this.minimumStr + "\"=" + this.minimum + ", new " + min);
        }
        if (min == null) {
            return;
        }
        this.minimumStr = min;
        try {
            this.minimum = Double.parseDouble(this.minimumStr);
        }
        catch (NumberFormatException e) {
            trace.err("Bad numeric \"" + min + "\"for range minimum: " + e);
            this.minimum = 0.0;
        }
        if (this.minimumElement != null) {
            this.minimumElement.addContent(this.minimumStr);
        }
    }

    public void setMaximum(String max) {
        if (trace.getDebugCode("range")) {
            trace.out("range", "setMaximum() old \"" + this.maximumStr + "\"=" + this.maximum + ", new " + max);
        }
        if (max == null) {
            return;
        }
        this.maximumStr = max;
        try {
            this.maximum = Double.parseDouble(max);
        }
        catch (NumberFormatException e) {
            trace.err("Bad numeric \"" + max + "\"for range maximum: " + e);
            this.maximum = this.minimum;
        }
        if (this.maximumElement != null) {
            this.maximumElement.addContent(this.maximumStr);
        }
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "RangeMatcher.match(" + selection + ", " + action + "," + input + ") min " + this.minimumStr + ", max " + this.maximumStr);
        }
        if (selection == null || action == null || this.minimum > this.maximum) {
            throw new InvalidParameterException("Error: mimimum (" + this.minimum + ") must be less than maximum (" + this.maximum + ")");
        }
        if (!selection.elementAt(0).equals(this.selection) || !action.elementAt(0).equals(this.action)) {
            return false;
        }
        return this.matchInput(input);
    }

    @Override
    public String getSelectionLabelText() {
        return this.selection;
    }

    @Override
    public String getActionLabelText() {
        return this.action;
    }

    @Override
    public String getInputLabelText() {
        return this.minimumStr + ", " + this.maximumStr;
    }

    @Override
    public String getSingleLabelText() {
        return "<" + this.minimumStr + ", " + this.maximumStr + ">";
    }

    @Override
    public boolean matchForHint(Vector selection, Vector action, String actor, VariableTable vt) {
        if (selection == null || this.minimum > this.maximum) {
            throw new InvalidParameterException("Error: mimimum (" + this.minimum + ") must be less than maximum (" + this.maximum + ")");
        }
        if (!selection.elementAt(0).equals(this.selection)) {
            return false;
        }
        if (action != null && !action.elementAt(0).equals(this.action)) {
            return false;
        }
        return this.matchActor(actor);
    }

    @Override
    public boolean matchConcatenation(Vector v) {
        return this.matchSingle(v.get(0).toString());
    }

    @Override
    public boolean matchSingle(String s) {
        block3: {
            try {
                double answer = Double.parseDouble(s);
                if (answer >= this.minimum && answer <= this.maximum) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                if (!trace.getDebugCode("br")) break block3;
                trace.out("br", "Error: number format exception in Range Matcher");
            }
        }
        return false;
    }

    @Override
    protected boolean matchInput(Vector input) {
        block3: {
            try {
                double answer = Double.parseDouble((String)input.elementAt(0));
                if (answer >= this.minimum && answer <= this.maximum) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                if (!trace.getDebugCode("br")) break block3;
                trace.out("br", "Error: number format exception in Range Matcher");
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setParameterInternal(Element element2, int index) {
        if (this.concat || RangeMatcher.versionIsBeforeMatcherParameterStd(element2)) {
            if (index == 0) {
                this.setMinimum(element2.getText());
                return;
            } else if (index == 1) {
                this.setMaximum(element2.getText());
                return;
            } else {
                if (this.concat) {
                    throw new UnknownError("Parameter index " + index + " not recognized for a single element.");
                }
                if (index == 2) {
                    this.setSelection(element2.getText());
                    return;
                } else if (index == 3) {
                    this.setAction(element2.getText());
                    return;
                } else {
                    if (index != 4) throw new UnknownError("Parameter index " + index + " not recognized.");
                    this.setActor(element2.getText());
                }
            }
            return;
        } else {
            this.setParameterByIndex(element2.getText(), index);
        }
    }

    @Override
    public void setParameterByIndex(String stringValue, int index) {
        switch (index) {
            case 0: {
                this.setSelection(stringValue);
                return;
            }
            case 1: {
                this.setAction(stringValue);
                return;
            }
            case 2: {
                this.setMinimum(stringValue);
                return;
            }
            case 3: {
                this.setMaximum(stringValue);
                return;
            }
            case 4: {
                this.setActor(stringValue);
                return;
            }
        }
        trace.err("ExactMatcher.setParameterByIndex(): unknown index " + index);
    }

    @Override
    public void setParameter(Element element2, int index) {
        String name = element2.getAttributeValue("name");
        if (name != null && name.length() > 0) {
            if (name.equalsIgnoreCase("selection")) {
                this.setSelection(element2.getText());
                return;
            }
            if (name.equalsIgnoreCase("action")) {
                this.setAction(element2.getText());
                return;
            }
            if (name.equalsIgnoreCase("minimum")) {
                this.setMinimum(element2.getText());
                return;
            }
            if (name.equalsIgnoreCase("maximum")) {
                this.setMaximum(element2.getText());
                return;
            }
            if (name.equalsIgnoreCase("actor")) {
                this.setActor(element2.getText());
                return;
            }
        }
        this.setParameterInternal(element2, index);
    }

    @Override
    public Matcher.MatcherParameter getMatcherParameter(int index) {
        if (this.single) {
            switch (index) {
                case 0: {
                    return new Matcher.MatcherParameter("minimum", this.getParameter(index));
                }
                case 1: {
                    return new Matcher.MatcherParameter("maximum", this.getParameter(index));
                }
            }
            return null;
        }
        switch (index) {
            case 0: {
                return new Matcher.MatcherParameter("selection", this.getParameter(index));
            }
            case 1: {
                return new Matcher.MatcherParameter("action", this.getParameter(index));
            }
            case 2: {
                return new Matcher.MatcherParameter("minimum", this.getParameter(index));
            }
            case 3: {
                return new Matcher.MatcherParameter("maximum", this.getParameter(index));
            }
            case 4: {
                return new Matcher.MatcherParameter("actor", this.getParameter(index));
            }
        }
        return null;
    }

    @Override
    public Object getParameter(int index) {
        if (this.single) {
            if (index == 0) {
                return this.getMinimumStr();
            }
            if (index == 1) {
                return this.getMaximumStr();
            }
            return null;
        }
        if (index == 0) {
            return this.getSelection();
        }
        if (index == 1) {
            return this.getAction();
        }
        if (index == 2) {
            return this.getMinimumStr();
        }
        if (index == 3) {
            return this.getMaximumStr();
        }
        if (index == 4) {
            return this.getActor();
        }
        return null;
    }

    @Override
    public int getParameterCount() {
        return this.single ? 2 : 5;
    }

    @Override
    public String getMatcherType() {
        return "Range Match";
    }

    @Override
    public String getMatcherTypeText() {
        return "Range";
    }

    @Override
    public String getMatcherClassType() {
        return "RangeMatcher";
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getSelection() {
        return this.selection;
    }

    @Override
    public String getActor() {
        return this.actor;
    }

    public void setAction(String action) {
        this.action = action;
        this.actionElement.addContent(action);
    }

    public void setSelection(String text) {
        this.selection = text;
        this.selectionElement.addContent(this.selection);
    }

    public void setActor(String actor) {
        this.actor = actor;
        this.actorElement.addContent(actor);
    }

    public String toString() {
        return "[ " + this.getMinimumStr() + " , " + this.getMaximumStr() + " ]";
    }

    @Override
    public String[] getValuesVector() {
        String[] arr = new String[]{this.toString()};
        return arr;
    }

    @Override
    public String getActionMatcherType() {
        return "Exact";
    }

    @Override
    public String getInputMatcherType() {
        return this.getMatcherTypeText();
    }

    @Override
    public String getSelectionMatcherType() {
        return "Exact";
    }
}

