/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.Utilities.trace;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProblemModelManager {
    private static final int PASTE_OFFSET = 20;
    private ProblemModel mainModel;
    private BR_Controller controller;
    private int offset = 0;
    private static ProblemModel _intermediateModel;
    private static List<ExampleTracerLink> _topLinks;
    private static List<ExampleTracerLink> _bottomLinks;
    private static Set<ProblemNode> _topNodes;
    private static Set<ExampleTracerLink> selectedLinks;
    private static ProblemModel sourceProblemModel;
    private static Rectangle selectedBounds;

    public ProblemModelManager(ProblemModel main, BR_Controller controller) {
        this.mainModel = main;
        this.controller = controller;
        if (_topNodes == null) {
            _topNodes = new HashSet<ProblemNode>();
        }
        if (_topLinks == null) {
            _topLinks = new ArrayList<ExampleTracerLink>();
        }
        if (_bottomLinks == null) {
            _bottomLinks = new ArrayList<ExampleTracerLink>();
        }
    }

    public ProblemModel getMainModel() {
        return this.mainModel;
    }

    public int copySelectedLinks() {
        _intermediateModel = new ProblemModel(null);
        _intermediateModel.setProblemName("intermedate");
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "ProblemModelManager (copySelectedLinks): start");
        }
        _topNodes.clear();
        _topLinks.clear();
        _bottomLinks.clear();
        sourceProblemModel = this.controller.getProblemModel();
        selectedLinks = this.controller.getProblemModel().getSelectedLinks();
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.copySelectedLinks(): links " + selectedLinks);
        }
        HashSet<Integer> linkIDs = new HashSet<Integer>();
        HashSet<Integer> nodeIDs = new HashSet<Integer>();
        HashSet<ProblemNode> nodes = new HashSet<ProblemNode>();
        HashSet<String> bottomIDs = new HashSet<String>();
        for (ExampleTracerLink link : selectedLinks) {
            linkIDs.add(link.getUniqueID());
            int prevNodeID = link.getPrevNode();
            nodeIDs.add(prevNodeID);
            nodes.add(this.mainModel.getProblemNode(prevNodeID));
            int nextNodeID = link.getNextNode();
            nodeIDs.add(nextNodeID);
            nodes.add(this.mainModel.getProblemNode(nextNodeID));
        }
        selectedBounds = this.getSelectedBounds(nodes);
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.copySelectedLinks(): linkIDs " + linkIDs);
            trace.out("mg", "PMMgr.selectedBounds:              " + selectedBounds);
            trace.out("mg", "PMMgr.copySelectedLinks(): nodeIDs " + nodeIDs);
            trace.out("mg", "PMMgr.copySelectedLinks(): nextNodes " + nodes);
        }
        HashSet<ExampleTracerLink> _topLinks = new HashSet<ExampleTracerLink>();
        for (ExampleTracerLink link : selectedLinks) {
            int prevNodeID = link.getPrevNode();
            if (nodeIDs.contains(prevNodeID)) continue;
            _topLinks.add(link);
            _topNodes.add(this.mainModel.getProblemNode(prevNodeID));
        }
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.copySelectedLinks(): _topLinks " + _topLinks);
            trace.out("mg", "PMMgr.copySelectedLinks(): _topNodes " + _topNodes);
        }
        for (ProblemNode nextNode : nodes) {
            int nodeID = nextNode.getUniqueID();
            ExampleTracerNode node = this.mainModel.getExampleTracerGraph().getNode(nodeID);
            boolean outLinkFound = false;
            for (ExampleTracerLink outLink : node.getOutLinks()) {
                if (!linkIDs.contains(outLink.getUniqueID())) continue;
                outLinkFound = true;
                break;
            }
            if (outLinkFound) continue;
            for (ExampleTracerLink inLink : node.getInLinks()) {
                if (!linkIDs.contains(inLink.getUniqueID())) continue;
                _bottomLinks.add(inLink);
                bottomIDs.add(inLink.getEdge().getName());
            }
        }
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.copySelectedLinks(): _bottomLinks " + _bottomLinks);
            trace.out("mg", "PMMgr.copySelectedLinks(): bottomIDs " + bottomIDs);
        }
        return selectedLinks.size();
    }

    public void pasteLinks() {
        if (selectedLinks == null || selectedLinks.isEmpty()) {
            return;
        }
        boolean xOffset = false;
        Rectangle xlate = this.calcOffset(selectedBounds, this.controller.getGraphViewPortBounds());
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.pasteLinks() no of selectedLinks " + selectedLinks.size());
            trace.out("mg", "PMMgr.pasteLinks() selectedBounds      " + selectedBounds);
            trace.out("mg", "PMMgr.pasteLinks() xlate               " + xlate);
            trace.out("mg", "PMMgr.pasteLinks() number of top nodes " + _topNodes.size());
        }
        ArrayList<ProblemModelEvent> subEvents = new ArrayList<ProblemModelEvent>();
        ProblemNode firstNode = null;
        LinkedHashMap<ProblemNode, ProblemNode> oldToNewNodeMap = new LinkedHashMap<ProblemNode, ProblemNode>();
        LinkedHashMap<ProblemNode, ProblemNode> newNodesOldNodes = new LinkedHashMap<ProblemNode, ProblemNode>();
        LinkedHashMap<ProblemEdge, ProblemEdge> oldToNewEdges = new LinkedHashMap<ProblemEdge, ProblemEdge>();
        ProblemModel pm = this.controller.getProblemModel();
        firstNode = pm.getStartNode();
        if (firstNode == null) {
            this.controller.getCtatFrameController().getDockedFrame().getCtatModePanel().createStartState();
            firstNode = pm.getStartNode();
        }
        for (ExampleTracerLink exampleTracerLink : selectedLinks) {
            ProblemNode newDest;
            EdgeData currEdgeData = exampleTracerLink.getEdge();
            ProblemEdge currEdge = currEdgeData.getEdge();
            EdgeData newData = currEdgeData.cloneEdgeData(pm);
            ProblemNode currSource = currEdge.getSource();
            ProblemNode currDest = currEdge.getDest();
            ProblemNode newSource = (ProblemNode)oldToNewNodeMap.get(currSource);
            if (newSource == null) {
                Point sourceLoc = currSource.getNodeView().getLocation();
                Point newSourceLoc = new Point(xlate.x + xlate.width + sourceLoc.x, xlate.y + xlate.height + sourceLoc.y);
                if (trace.getDebugCode("mg")) {
                    trace.out("mg", "PMM.pasteLinks() old sourceLoc " + sourceLoc + ", new " + newSourceLoc);
                }
                newSource = this.controller.createProblemNode(null, newSourceLoc);
                newNodesOldNodes.put(newSource, currSource);
                NodeCreatedEvent evt = new NodeCreatedEvent(firstNode == null ? this : firstNode.getNodeView(), newSource);
                if (firstNode == null) {
                    firstNode = newSource;
                    this.controller.getProblemModel().fireProblemModelEvent(evt);
                } else {
                    subEvents.add(evt);
                }
                oldToNewNodeMap.put(currSource, newSource);
            }
            if ((newDest = (ProblemNode)oldToNewNodeMap.get(currDest)) == null) {
                Point destLoc = currDest.getNodeView().getLocation();
                Point newDestLoc = new Point(xlate.x + xlate.width + destLoc.x, xlate.y + xlate.height + destLoc.y);
                if (trace.getDebugCode("mg")) {
                    trace.out("mg", "PMM.pasteLinks() old sourceLoc " + destLoc + ", new " + newDestLoc);
                }
                newDest = this.controller.createProblemNode(newData.getSelection(), newDestLoc);
                newNodesOldNodes.put(newSource, currSource);
                subEvents.add(new NodeCreatedEvent(firstNode.getNodeView(), newDest));
                oldToNewNodeMap.put(currDest, newDest);
            }
            ProblemEdge newEdge = this.controller.getProblemModel().getProblemGraph().addEdge(newSource, newDest, newData);
            newEdge.addEdgeLabels();
            newData.getActionLabel().update();
            oldToNewEdges.put(currEdge, newEdge);
            EdgeCreatedEvent newEdgeEvt = new EdgeCreatedEvent(firstNode.getNodeView(), newEdge);
            newEdgeEvt.setSelected(true);
            subEvents.add(newEdgeEvt);
        }
        for (Map.Entry entry : newNodesOldNodes.entrySet()) {
            this.setPreferredPath((ProblemNode)entry.getValue(), (ProblemNode)entry.getKey(), oldToNewEdges);
        }
        NodeCreatedEvent fireMe = new NodeCreatedEvent(firstNode.getNodeView(), ((NodeCreatedEvent)subEvents.get(0)).getNode(), new ArrayList<ProblemModelEvent>(subEvents.subList(1, subEvents.size())));
        this.controller.getProblemModel().fireProblemModelEvent(fireMe);
    }

    private ProblemNode findBestStartNode(Set<ProblemNode> topNodes, Set<ExampleTracerLink> links) {
        HashSet<Integer> linkIDs = new HashSet<Integer>();
        for (ExampleTracerLink link : links) {
            linkIDs.add(new Integer(link.getID()));
        }
        int rLinks = -1;
        ProblemNode result = null;
        for (ProblemNode tn : topNodes) {
            int nLinks = this.countDescendants(tn, linkIDs, 0);
            if (rLinks >= nLinks) continue;
            rLinks = nLinks;
            result = tn;
        }
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.findBestStartNode(" + topNodes + ") result " + result + ", n " + rLinks);
        }
        return result;
    }

    private int countDescendants(ProblemNode n, Set<Integer> linkIDs, int count) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.countDescendants(" + n + ") entry count " + count);
        }
        for (ProblemEdge edge : n.getOutgoingEdges()) {
            if (!linkIDs.contains(edge.getUniqueID())) continue;
            count = this.countDescendants(edge.getDest(), linkIDs, count) + 1;
        }
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.countDescendants(" + n + ") retrn count " + count);
        }
        return count;
    }

    private Rectangle calcOffset(Rectangle sb, Rectangle vp) {
        if (sourceProblemModel == this.controller.getProblemModel()) {
            this.offset += 20;
            return new Rectangle(0, 0, this.offset, this.offset);
        }
        if (sb == null || vp == null) {
            return null;
        }
        int dx = vp.x + (vp.width + 1) / 2 - (sb.x + (sb.width + 1) / 2);
        int dy = vp.y + (vp.height + 1) / 2 - (sb.y + (sb.height + 1) / 2);
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "PMMgr.calcOffset() sb " + sb);
            trace.out("mg", "PMMgr.calcOffset() vp " + vp);
            trace.out("mg", "PMMgr.calcOffset() sb midpoint " + (sb.x + (sb.width + 1) / 2) + ", " + (sb.y + (sb.height + 1) / 2));
            trace.out("mg", "PMMgr.calcOffset() vp midpoint " + (vp.x + (vp.width + 1) / 2) + ", " + (vp.y + (vp.height + 1) / 2));
            trace.out("mg", "PMMgr.calcOffset() dx, dy      " + dx + ", " + dy);
        }
        int m = 10;
        int dxAll = sb.x + dx;
        dxAll = dxAll < 0 ? -dxAll + 10 : 0;
        int dyAll = sb.y + dy;
        dyAll = dyAll < 0 ? -dyAll + 10 : 0;
        return new Rectangle(dx, dy, dxAll, dyAll);
    }

    private void setPreferredPath(ProblemNode on, ProblemNode nn, Map<ProblemEdge, ProblemEdge> oldToNewEdges) {
        int n = 0;
        EdgeData firstCorrect = null;
        EdgeData firstSuboptimal = null;
        for (ProblemEdge oldEdge : on.getOutgoingEdges()) {
            ProblemEdge newEdge = oldToNewEdges.get(oldEdge);
            if (newEdge == null) continue;
            EdgeData newEdgeData = newEdge.getEdgeData();
            boolean p = oldEdge.getEdgeData().isPreferredEdge();
            if (p && ++n > 1) {
                trace.err("PMMgr.setPreferredPath() nPreferredEdges " + n + ">1 from node " + on + " at edge " + oldEdge.getEdgeData().toString());
            }
            if (n < 2) {
                newEdgeData.setPreferredEdge(p);
            }
            if (firstCorrect == null && "Correct Action".equalsIgnoreCase(newEdgeData.getActionType())) {
                firstCorrect = newEdgeData;
            }
            if (firstSuboptimal != null || !"Fireable Buggy Action".equalsIgnoreCase(newEdgeData.getActionType())) continue;
            firstSuboptimal = newEdgeData;
        }
        if (n < 1) {
            if (firstCorrect != null) {
                firstCorrect.setPreferredEdge(true);
            } else if (firstSuboptimal != null) {
                firstSuboptimal.setPreferredEdge(true);
            } else {
                trace.err("PMMgr.setPreferredPath() no correct or subopimal edges from node " + on + " mapping to node " + nn);
            }
        }
        n = 0;
        for (ProblemEdge newEdge : nn.getOutgoingEdges()) {
            if (!newEdge.getEdgeData().isPreferredEdge()) continue;
            ++n;
        }
        if (n > 1) {
            trace.err("PMMgr.setPreferredPath() too many " + n + " preferred edges from node " + on + " mapping to node " + nn);
        }
    }

    private int getVisualWidth(ProblemModel problemModel) {
        int result = 0;
        int width = 0;
        Enumeration<ProblemNode> nodes = problemModel.getProblemGraph().nodes();
        while (nodes.hasMoreElements()) {
            NodeView nv = nodes.nextElement().getNodeView();
            if (nv == null || nv.getLocation() == null) continue;
            Point location = nv.getLocation();
            if (result >= location.x) continue;
            result = location.x;
            width = nv.getSize().width;
        }
        return result + width;
    }

    private Rectangle getSelectedBounds(Set<ProblemNode> nodes) {
        Dimension dim;
        Point location;
        NodeView nv;
        Rectangle r = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        boolean revised = false;
        for (ProblemNode node : nodes) {
            nv = node.getNodeView();
            if (nv == null || (location = nv.getLocation()) == null || (dim = nv.getSize()) == null) continue;
            if (r.x > location.x) {
                r.x = location.x;
            }
            if (r.y > location.y) {
                r.y = location.y;
            }
            revised = true;
        }
        for (ProblemNode node : nodes) {
            nv = node.getNodeView();
            if (nv == null || (location = nv.getLocation()) == null || (dim = nv.getSize()) == null) continue;
            if (r.width < location.x + dim.width - r.x) {
                r.width = location.x + dim.width - r.x;
            }
            if (r.height < location.y + dim.height - r.y) {
                r.height = location.y + dim.height - r.y;
            }
            revised = true;
        }
        if (!revised) {
            return null;
        }
        return r;
    }

    public static ProblemModel getClipboardProblemModel() {
        return _intermediateModel;
    }

    public int nSelectedLinks() {
        return selectedLinks == null ? 0 : selectedLinks.size();
    }
}

