/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerInterpretation;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerPath;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracer;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class SAIList {
    private final int startNodeID;
    private ArrayList<ExampleTracerSAI> sais = new ArrayList();
    private LinkedHashMap<Integer, Integer> visitedNodeToSAI = null;
    private int targetNodeID = -1;

    public SAIList(int startNodeID) {
        this.startNodeID = startNodeID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        int last2 = this.sais.size() - 1;
        for (int i = 0; i < last2; ++i) {
            sb.append(String.format(" %-21s <= %s\n ", this.sais.get(i).getGrade(), this.sais.get(i)));
        }
        if (last2 >= 0) {
            sb.append(String.format(" %-21s <= %s ", this.sais.get(last2).getGrade(), this.sais.get(last2)));
        }
        return sb.append("}").toString();
    }

    private boolean add(ExampleTracerSAI sai, String grade) {
        if ("Hint Action".equalsIgnoreCase(grade)) {
            return false;
        }
        sai.setGrade(grade);
        boolean result = this.add(sai);
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "SAIList.add(" + sai + "," + grade + ") now\n" + this);
        }
        return result;
    }

    public synchronized void clear() {
        if (this.visitedNodeToSAI != null) {
            this.visitedNodeToSAI.clear();
        }
        this.sais.clear();
    }

    public synchronized boolean add(ExampleTracerEvent event, ExampleTracerTracer tracer) {
        ExampleTracerLink highestUntraversedLink = null;
        ExampleTracerLink link = null;
        if (this.maxNodes(event.getResult()) > 0) {
            if (tracer != null) {
                ExampleTracerInterpretation interp = tracer.getBestInterpretation();
                ExampleTracerPath path = interp == null ? null : ExampleTracerPath.getBestPath(interp.getPaths());
                highestUntraversedLink = path == null ? null : tracer.getHighestUntraversedLink(interp, path, false, true);
            }
            link = event.getReportableLink();
        }
        return this.add(event, highestUntraversedLink == null ? -1 : highestUntraversedLink.getPrevNode(), link == null ? -1 : link.getNextNode());
    }

    private int maxNodes(String grade) {
        if ("Correct Action".equalsIgnoreCase(grade)) {
            return 2;
        }
        if ("Fireable Buggy Action".equalsIgnoreCase(grade)) {
            return 2;
        }
        if ("NO-MODEL".equalsIgnoreCase(grade)) {
            return 0;
        }
        if ("UNEVALUATED".equalsIgnoreCase(grade)) {
            return 0;
        }
        return 1;
    }

    synchronized boolean add(ExampleTracerEvent event, int currentNodeID, int destNodeID) {
        if (trace.getDebugCode("sai")) {
            trace.out("sai", String.format("SAIList.add(%s => %s, %d, %d)", event.getStudentSAI(), event.getHintRequest() ? "Hint Action" : event.getResult(), currentNodeID, destNodeID));
        }
        if (event.getHintRequest()) {
            return false;
        }
        ExampleTracerSAI sai = event.getStudentSAI();
        String grade = event.getResult();
        boolean result = false;
        if ("Student".equalsIgnoreCase(sai.getActor())) {
            result = this.add(sai, grade);
        }
        if (this.maxNodes(grade) >= 2) {
            this.mapNodeToSAI(currentNodeID, this.sais.size(), true);
            this.mapNodeToSAI(destNodeID, this.sais.size(), false);
        } else if (this.maxNodes(grade) == 1) {
            this.mapNodeToSAI(destNodeID, this.sais.size(), false);
        }
        return result;
    }

    private boolean add(ExampleTracerSAI sai) {
        return this.sais.add(sai);
    }

    private int mapNodeToSAI(int nodeID, int saiIndex, boolean isCurrentNode) {
        Integer key;
        Integer result;
        if (nodeID == this.startNodeID) {
            return -1;
        }
        if (this.visitedNodeToSAI == null) {
            this.visitedNodeToSAI = new LinkedHashMap();
        }
        if ((result = this.visitedNodeToSAI.get(key = Integer.valueOf(isCurrentNode ? nodeID : -nodeID))) == null) {
            result = saiIndex;
            this.visitedNodeToSAI.put(key, result);
        }
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "mapNodeToSAI(" + key + "," + saiIndex + ") map now\n  " + this.visitedNodeToSAI + "\n");
        }
        return result;
    }

    public List<ExampleTracerSAI> getSAIsForNodeID(int nodeID) {
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "SAIList.getSAIsForNodeID(" + nodeID + ") this\n" + this + "\n map " + this.visitedNodeToSAI);
        }
        if (this.visitedNodeToSAI == null) {
            return null;
        }
        Integer saiIndex = this.visitedNodeToSAI.get(nodeID);
        if (saiIndex == null) {
            saiIndex = this.visitedNodeToSAI.get(-nodeID);
        }
        ArrayList<ExampleTracerSAI> result = null;
        if (saiIndex != null) {
            int i;
            result = new ArrayList<ExampleTracerSAI>();
            for (i = 0; i < saiIndex - 1; ++i) {
                ExampleTracerSAI sai = this.sais.get(i);
                if (!this.mustReplay(sai.getGrade())) continue;
                result.add(sai);
            }
            if (i < saiIndex) {
                result.add(this.sais.get(i));
            }
        }
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "SAIList.getSAIsForNodeID(" + nodeID + ") returning list of length " + (result == null ? null : Integer.toString(result.size())));
        }
        return result;
    }

    private boolean mustReplay(String grade) {
        return "Correct Action".equalsIgnoreCase(grade) || "Fireable Buggy Action".equalsIgnoreCase(grade) || "UNEVALUATED".equalsIgnoreCase(grade);
    }

    public int last() {
        return this.sais.size() - 1;
    }

    public int size() {
        return this.sais.size();
    }

    public void setTargetNodeID(int targetNodeID) {
        this.targetNodeID = targetNodeID;
    }

    int getTargetNodeID() {
        return this.targetNodeID;
    }

    public int clearTargetNodeID() {
        int result = this.getTargetNodeID();
        this.setTargetNodeID(-1);
        return result;
    }
}

