/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.SolutionStateModel;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.SolutionStateModel.TraversedLinkObject;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TraversedLinksModel {
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat().setIndent(" ").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator("\n"));
    private Document document;
    String traversedLinksFileName = "";
    static final String TRAVERSEDLINKS_FILE = "TraversedLinks_File";
    static final String LINK = "Link";
    static final String LINK_NAME = "Link_Name";
    static final String COMMMSG_OBJ_NAME = "CommMsgObj_Name";
    static final String AUTHOR_INTENT_NAME = "AuthorIntent_Name";
    static final String LINK_UNIQUEID_NAME = "LinkUniqueID_Name";
    private BR_Controller controller;

    public TraversedLinksModel(BR_Controller controller) {
        this.controller = controller;
        this.initDom();
    }

    public void initDom() {
        this.document = this.makeRoot();
        if (trace.getDebugCode("br")) {
            trace.out("br", "TRAVERSED_LINK_MODEL.initDom() " + this.document.hashCode());
        }
    }

    private Document makeRoot() {
        try {
            Element root = new Element(TRAVERSEDLINKS_FILE);
            Document document = new Document(root);
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadTraversedLinks_Fromfile(String traversedLinksFileName) {
        if (traversedLinksFileName == null) {
            trace.out(5, this, "traversedLinksFileName is null");
            return;
        }
        if (traversedLinksFileName.trim().equals("")) {
            trace.out(5, this, "traversedLinksFileName is empty");
            return;
        }
        this.traversedLinksFileName = traversedLinksFileName;
        File f = new File(traversedLinksFileName);
        if (!f.exists()) {
            this.initDom();
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            this.document = builder.build(traversedLinksFileName);
            if (trace.getDebugCode("br")) {
                trace.out("br", "TRAVERSED_LINK_MODEL.loadTraversedLinks_Fromfile() " + this.document.hashCode());
            }
        }
        catch (JDOMException je) {
            trace.err("Error parsing traversed links file " + traversedLinksFileName + ": " + (Object)((Object)je) + "\nCause:");
            Throwable x = je;
            if (je.getCause() != null) {
                x = je.getCause();
            }
            x.printStackTrace();
        }
        catch (IOException ioe) {
            trace.err("Error parsing traversed links file " + traversedLinksFileName + ": " + ioe);
            ioe.printStackTrace();
        }
    }

    public void loadTraversedLinks_FromXML(String currentState) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "load TraversedLinks_FromXML: currentState = " + currentState);
        }
        if (currentState == null) {
            this.traversedLinksFileName = "";
            this.initDom();
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            StringReader reader = new StringReader(currentState);
            this.document = builder.build((Reader)reader);
            if (trace.getDebugCode("br")) {
                trace.out("br", "TRAVERSED_LINK_MODEL.loadTraversedLinks_FromXML() " + this.document.hashCode());
            }
            if (trace.getDebugCode("br")) {
                trace.out("br", "Document = " + this.document);
            }
        }
        catch (JDOMException je) {
            trace.err("Error parsing traversed links XML string " + currentState + ": " + (Object)((Object)je) + "\nCause:");
            Throwable x = je;
            if (je.getCause() != null) {
                x = je.getCause();
            }
            x.printStackTrace();
        }
        catch (IOException ioe) {
            trace.err("Error parsing traversed links XML string " + currentState + ": " + ioe);
            ioe.printStackTrace();
        }
    }

    public void saveTraversedLinks_Tofile(String newTraversedLinksFileName) {
        if (this.document == null) {
            if (trace.getDebugCode("br")) {
                trace.out("br", "saveTraversedLinks_Tofile(): document is null");
            }
            return;
        }
        String savedDOMFileName = newTraversedLinksFileName;
        if (this.traversedLinksFileName == null) {
            trace.out(5, this, "traversedLinksFileName is null. Save the DOM at: " + this.traversedLinksFileName);
            savedDOMFileName = this.traversedLinksFileName;
        } else if (newTraversedLinksFileName.equals("")) {
            trace.out(5, this, "newTraversedLinksFileName is empty. Save the DOM at: " + this.traversedLinksFileName);
            savedDOMFileName = this.traversedLinksFileName;
        }
        File f = new File(savedDOMFileName);
        try {
            FileWriter fw = new FileWriter(savedDOMFileName);
            String asXML = outputter.outputString(this.document);
            fw.write(asXML);
            fw.close();
        }
        catch (Exception e) {
            trace.err("Error writing traversed links file " + savedDOMFileName + ": " + e);
            e.printStackTrace();
        }
    }

    public String getTraversedLinks_asXML() {
        if (trace.getDebugCode("br")) {
            trace.out("br", "getTraversedLinks_asXML(): nodes = " + this.getTraversedLinkNodes());
        }
        if (this.document == null) {
            return null;
        }
        try {
            return outputter.outputString(this.document);
        }
        catch (Exception e) {
            trace.err("Error writing traversed links to XML: " + e);
            e.printStackTrace();
            return null;
        }
    }

    public TraversedLinkObject getTraversedLinkObject(String linkNodeName) {
        Element linkNode = this.getTraversedLinkNode(linkNodeName);
        if (linkNode == null) {
            return null;
        }
        TraversedLinkObject linkObj = this.get_LinkObj_From_LinkNode(linkNode);
        return linkObj;
    }

    public Vector getTraversedLinkNodes() {
        Vector<TraversedLinkObject> nodeList = new Vector<TraversedLinkObject>();
        Element rootNode = this.document.getRootElement();
        if (rootNode == null) {
            trace.err("getTraversedLinkNodes(): rootNode is null");
            return nodeList;
        }
        List eltList = rootNode.getChildren();
        for (Element linkNode : eltList) {
            TraversedLinkObject tlo = this.get_LinkObj_From_LinkNode(linkNode);
            nodeList.addElement(tlo);
        }
        return nodeList;
    }

    public Vector<String> getTraversedLinkNodesNames() {
        Vector<String> nameList = new Vector<String>();
        Element rootNode = this.document.getRootElement();
        if (rootNode == null) {
            trace.err("getTraversedLinkNodesNames(): rootNode is null");
            return nameList;
        }
        List nodeList = rootNode.getChildren();
        if (trace.getDebugCode("br")) {
            trace.out("br", "nodeList = " + nodeList);
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            Element linkNode = (Element)nodeList.get(i);
            Element nameNode = linkNode.getChild(LINK_NAME);
            String nameText = nameNode.getText();
            nameList.addElement(nameText);
        }
        return nameList;
    }

    private Element getTraversedLinkNode(String linkName) {
        Element rootNode = this.document.getRootElement();
        List nodeList = rootNode.getChildren();
        for (int i = 0; i < nodeList.size(); ++i) {
            Element linkNode = (Element)nodeList.get(i);
            Element nameNode = linkNode.getChild(LINK_NAME);
            String nameNodeText = nameNode.getText();
            if (!nameNodeText.equals(linkName)) continue;
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "Found the matched LinkNode with linkName: " + linkName);
            }
            return linkNode;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "Not Found the matched linkNode with linkName: " + linkName);
        }
        return null;
    }

    private TraversedLinkObject get_LinkObj_From_LinkNode(Element linkNode) {
        if (linkNode == null) {
            return null;
        }
        String linkName = "";
        MessageObject CommMsgObj = null;
        String authorIntent = "";
        int uniqueID = -999;
        List nodeList = linkNode.getChildren();
        trace.out(5, this, "linkNode has " + nodeList.size() + " elements.");
        for (int i = 0; i < nodeList.size(); ++i) {
            Element tagNode = (Element)nodeList.get(i);
            String tagNodeName = tagNode.getName();
            String tempString = tagNode.getText();
            if (tagNodeName.equals(LINK_NAME)) {
                linkName = tempString;
                continue;
            }
            if (tagNodeName.equals(COMMMSG_OBJ_NAME)) {
                CommMsgObj = MessageObject.parse(tempString);
                continue;
            }
            if (tagNodeName.equals(AUTHOR_INTENT_NAME)) {
                authorIntent = tempString;
                continue;
            }
            if (tagNodeName.equals(LINK_UNIQUEID_NAME)) {
                uniqueID = Integer.valueOf(tempString);
                continue;
            }
            trace.out(5, this, "not defined tag: " + tagNodeName);
        }
        return new TraversedLinkObject(linkName, CommMsgObj, authorIntent, uniqueID);
    }

    private void build_Single_Element(Element parentNode, String tagName, String elementValue) {
        Element tagNode = new Element(tagName);
        tagNode.setText(elementValue);
        parentNode.addContent((Content)tagNode);
    }

    private Element buildLinkNode(TraversedLinkObject linkObj) {
        Element linkNode = new Element(LINK);
        this.build_Single_Element(linkNode, LINK_NAME, linkObj.getLinkName());
        String CommMsgObjString = linkObj.getCommMsgObj().toString();
        this.build_Single_Element(linkNode, COMMMSG_OBJ_NAME, CommMsgObjString);
        this.build_Single_Element(linkNode, AUTHOR_INTENT_NAME, linkObj.getAuthorIntent());
        this.build_Single_Element(linkNode, LINK_UNIQUEID_NAME, linkObj.getUniqueID() + "");
        return linkNode;
    }

    public void addLinkNode(TraversedLinkObject linkObj) {
        Element rootNode = this.document.getRootElement();
        Element newLinkNode = this.buildLinkNode(linkObj);
        Element existLinkNode = this.getTraversedLinkNode(linkObj.getLinkName());
        if (existLinkNode != null) {
            boolean removed = rootNode.removeContent((Content)existLinkNode);
            if (trace.getDebugCode("br")) {
                trace.out("br", "removed existLinkNode " + existLinkNode);
            }
        }
        rootNode.addContent((Content)newLinkNode);
    }

    public void removeLinkNode(String linkName) {
        if (linkName == null) {
            trace.out(5, this, "linkName is null in the method removeLinkNode()");
            return;
        }
        if (linkName.trim().equals("")) {
            trace.out(5, this, "linkName is empty in the method removeLinkNode()");
            return;
        }
        Element rootNode = this.document.getRootElement();
        Element tempLinkNode = this.getTraversedLinkNode(linkName);
        if (tempLinkNode != null) {
            rootNode.removeContent((Content)tempLinkNode);
            return;
        }
        trace.out(5, this, "Not found matched linkNode with linkName: " + linkName);
    }

    public void addLinkNode(String linkName, MessageObject messageObject, String actionType, int uniqueID) {
        TraversedLinkObject tlo = new TraversedLinkObject(linkName, messageObject, actionType, uniqueID);
        this.addLinkNode(tlo);
    }

    public int size() {
        Element rootNode = this.document.getRootElement();
        List children = rootNode.getChildren();
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    public int deleteLinksFromTail(int nLinksToDelete) {
        Element rootNode = this.document.getRootElement();
        List children = rootNode.getChildren();
        int oldSize = children.size();
        int newSize = oldSize - nLinksToDelete;
        if (newSize <= 0) {
            this.initDom();
            return oldSize;
        }
        Element root = this.document.getRootElement();
        for (int i = oldSize - 1; i >= newSize; --i) {
            root.removeContent((Content)((Element)children.get(i)));
        }
        return nLinksToDelete;
    }

    public List getCommMsgs() {
        Element rootNode = this.document.getRootElement();
        ArrayList<MessageObject> result = new ArrayList<MessageObject>();
        List children = rootNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TraversedLinkObject tlo = this.get_LinkObj_From_LinkNode((Element)children.get(i));
            result.add(tlo.getCommMsgObj());
        }
        return result;
    }
}

