/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATComponent;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATJPanel;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATParameter;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATPropertyTable;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializable;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializableTableEntry;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSheetCellEditor;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATStyleProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class CTATComponentPanel
extends CTATJPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private CTATComponent component = null;
    private JButton foldButton = null;
    private JLabel componentType = null;
    private JPanel preview = null;
    Icon close = null;
    Icon open = null;
    private Boolean folded = false;
    private int fixedWidth = 200;
    private int fixedHeight = 300;
    JPanel parameterPanel = null;
    JPanel stylePanel = null;
    JPanel SAIPanel = null;
    JCheckBox componentShow = null;
    JLabel componentIcon = null;
    CTATPropertyTable parameterTable = null;
    CTATPropertyTable styleTable = null;
    String[] columnNames = new String[]{"Name", "Value"};
    DefaultTableModel parameterModel = null;
    DefaultTableModel styleModel = null;
    BR_Controller controller = null;

    public CTATComponentPanel() {
        this.debug("CTATComponentPanel ()");
        this.close = new ImageIcon(this.getClass().getClassLoader().getResource("pact/CommWidgets/close.png"));
        this.open = new ImageIcon(this.getClass().getClassLoader().getResource("pact/CommWidgets/open.png"));
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        Box panelBox = new Box(1);
        this.add(panelBox);
        Box controlBox = new Box(0);
        panelBox.add(controlBox);
        this.foldButton = new JButton();
        this.foldButton.setIcon(this.close);
        this.foldButton.setText("");
        this.foldButton.setFont(new Font("Dialog", 1, 10));
        this.foldButton.setMinimumSize(new Dimension(20, 20));
        this.foldButton.setMaximumSize(new Dimension(5000, 20));
        this.foldButton.setHorizontalAlignment(2);
        this.foldButton.addActionListener(this);
        controlBox.add(this.addInHorizontalLayout(this.foldButton, 5000, 20));
        this.componentShow = new JCheckBox("Show");
        this.componentShow.setSelected(false);
        this.componentShow.addItemListener(this);
        controlBox.add(this.componentShow);
        this.defaultIcon = this.createImageIcon("CTATButton.png", null);
        this.componentIcon = new JLabel();
        this.componentIcon.setMinimumSize(new Dimension(20, 20));
        this.componentIcon.setPreferredSize(new Dimension(20, 20));
        this.componentIcon.setMaximumSize(new Dimension(20, 20));
        this.componentIcon.setIcon(this.defaultIcon);
        controlBox.add(this.componentIcon);
        this.componentType = new JLabel();
        this.componentType.setFont(new Font("Dialog", 1, 10));
        this.componentType.setMinimumSize(new Dimension(10, 20));
        this.componentType.setMaximumSize(new Dimension(5000, 20));
        this.componentType.setBorder(BorderFactory.createEtchedBorder(1));
        panelBox.add(this.addInHorizontalLayout(this.componentType, 5000, 20));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setMinimumSize(new Dimension(10, 20));
        tabbedPane.setMaximumSize(new Dimension(5000, 5000));
        tabbedPane.setFont(new Font("Dialog", 1, 10));
        panelBox.add(this.addInHorizontalLayout(tabbedPane, 5000, 5000));
        this.stylePanel = new JPanel();
        tabbedPane.addTab("Styles", null, this.stylePanel, "tbd");
        BorderLayout styleBox = new BorderLayout();
        this.stylePanel.setLayout(styleBox);
        this.styleTable = new CTATPropertyTable();
        this.styleTable.setBorder(BorderFactory.createLineBorder(Color.black));
        this.styleTable.setMinimumSize(new Dimension(20, 20));
        this.styleTable.setMaximumSize(new Dimension(5000, 5000));
        JScrollPane styleScrollList = new JScrollPane(this.styleTable);
        styleScrollList.setMinimumSize(new Dimension(10, 10));
        styleScrollList.setMaximumSize(new Dimension(5000, 5000));
        this.stylePanel.add((Component)styleScrollList, "Center");
        this.parameterPanel = new JPanel();
        tabbedPane.addTab("Parameters", null, this.parameterPanel, "tbd");
        BorderLayout configBox = new BorderLayout();
        this.parameterPanel.setLayout(configBox);
        this.parameterTable = new CTATPropertyTable();
        this.parameterTable.setBorder(BorderFactory.createLineBorder(Color.black));
        this.parameterTable.setMaximumSize(new Dimension(5000, 5000));
        JScrollPane parameterScrollList = new JScrollPane(this.parameterTable);
        parameterScrollList.setMinimumSize(new Dimension(10, 10));
        parameterScrollList.setMaximumSize(new Dimension(5000, 5000));
        this.parameterPanel.add((Component)parameterScrollList, "Center");
    }

    public void setController(BR_Controller aController) {
        this.debug("setController ()");
        this.controller = aController;
        if (this.parameterTable != null) {
            this.parameterTable.setController(aController);
        }
        if (this.styleTable != null) {
            this.styleTable.setController(aController);
        }
    }

    public void setPreview(JPanel preview) {
        this.preview = preview;
    }

    public JPanel getPreview() {
        return this.preview;
    }

    public void setFixedWidth(int fixedWidth) {
        this.fixedWidth = fixedWidth;
    }

    public int getFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedHeight(int fixedHeight) {
        this.fixedHeight = fixedHeight;
    }

    public int getFixedHeight() {
        return this.fixedHeight;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.debug("itenStateChanged ()");
        ItemSelectable source = e.getItemSelectable();
        if (source == this.componentShow) {
            this.checkComponent();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.foldButton) {
            if (this.folded.booleanValue()) {
                this.foldOut();
            } else {
                this.foldIn();
            }
        }
    }

    public void foldOut() {
        if (this.foldButton != null) {
            this.foldButton.setIcon(this.close);
        }
        if (this.parameterPanel != null) {
            this.parameterPanel.setVisible(true);
        }
        if (this.stylePanel != null) {
            this.stylePanel.setVisible(true);
        }
        if (this.componentType != null) {
            this.componentType.setVisible(true);
        }
        this.setMinimumSize(new Dimension(50, 26));
        this.setPreferredSize(new Dimension(this.getWidth(), this.getFixedHeight()));
        this.setMaximumSize(new Dimension(5000, this.getFixedHeight()));
        this.folded = false;
    }

    public void foldIn() {
        if (this.foldButton != null) {
            this.foldButton.setIcon(this.open);
        }
        this.setMinimumSize(new Dimension(50, 26));
        this.setPreferredSize(new Dimension(this.getWidth(), 26));
        this.setMaximumSize(new Dimension(5000, 26));
        if (this.componentType != null) {
            this.componentType.setVisible(false);
        }
        if (this.parameterPanel != null) {
            this.parameterPanel.setVisible(false);
        }
        if (this.stylePanel != null) {
            this.stylePanel.setVisible(false);
        }
        this.folded = true;
    }

    public void setComponent(CTATComponent component) {
        this.component = component;
        this.component.setChecker(this.componentShow);
        this.configComponentPanel();
    }

    public CTATComponent getComponent() {
        return this.component;
    }

    private void configComponentPanel() {
        CTATSerializableTableEntry entry2;
        CTATSerializableTableEntry entry1;
        if (this.foldButton != null) {
            this.foldButton.setText(this.component.getInstanceName());
        }
        if (this.componentType != null) {
            this.componentType.setText(this.component.getClassType());
            ImageIcon icon = this.createImageIcon(this.component.getClassType() + ".png", null);
            this.componentIcon.setIcon(icon);
        }
        if (this.parameterTable != null) {
            this.parameterModel = new DefaultTableModel((Object[][])null, this.columnNames);
            this.parameterModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent arg0) {
                    CTATComponentPanel.this.debug("Table changed: " + arg0.getFirstRow() + "," + arg0.getType());
                    if (arg0.getType() == 0) {
                        CTATComponentPanel.this.debug("Propagating parameter value back into CTAT object ...");
                        Object tester = CTATComponentPanel.this.parameterTable.getValueAt(arg0.getFirstRow(), 1);
                        CTATComponentPanel.this.debug("Style object: " + tester.getClass().getName() + " with value: " + tester);
                        CTATSerializableTableEntry value = (CTATSerializableTableEntry)CTATComponentPanel.this.parameterModel.getValueAt(arg0.getFirstRow(), 1);
                        CTATStyleProperty entry = (CTATStyleProperty)value.getEntry();
                        if (entry != null) {
                            CTATComponentPanel.this.debug("Entry: " + entry.toString());
                            CTATComponent target = value.getComponent();
                            entry.setTouched(true);
                            if (CTATComponentPanel.this.controller != null) {
                                CTATComponentPanel.this.controller.sendInterfaceDescription(target.getName(), target.toStringElementTouched());
                            } else {
                                CTATComponentPanel.this.debug("Error: controller object is null!");
                            }
                            entry.setTouched(false);
                        }
                    }
                }
            });
            ArrayList<CTATParameter> params = this.component.getParameters();
            for (int i = 0; i < params.size(); ++i) {
                CTATParameter param = params.get(i);
                entry1 = new CTATSerializableTableEntry(param.getName());
                entry2 = new CTATSerializableTableEntry(param.getValue());
                entry2.setEntry(param);
                entry2.setComponent(this.getComponent());
                Object[] parameterData = new CTATSerializableTableEntry[]{entry1, entry2};
                this.parameterModel.addRow(parameterData);
            }
            this.parameterTable.setModel(this.parameterModel);
            TableColumn colP = this.parameterTable.getColumnModel().getColumn(1);
            colP.setCellEditor(new CTATSheetCellEditor());
        }
        if (this.styleTable != null) {
            this.styleModel = new DefaultTableModel((Object[][])null, this.columnNames);
            this.styleModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent arg0) {
                    CTATComponentPanel.this.debug("Table changed: " + arg0.getFirstRow() + "," + arg0.getType());
                    if (arg0.getType() == 0) {
                        CTATComponentPanel.this.debug("Propagating style value back into CTAT object ...");
                        Object tester = CTATComponentPanel.this.styleTable.getValueAt(arg0.getFirstRow(), 1);
                        CTATSerializableTableEntry value = (CTATSerializableTableEntry)CTATComponentPanel.this.styleModel.getValueAt(arg0.getFirstRow(), 1);
                        CTATStyleProperty entry = (CTATStyleProperty)value.getEntry();
                        if (entry != null) {
                            CTATComponentPanel.this.debug("Entry: " + entry.toString());
                            CTATComponent target = value.getComponent();
                            entry.setTouched(true);
                            if (CTATComponentPanel.this.controller != null) {
                                CTATComponentPanel.this.controller.sendInterfaceDescription(target.getName(), target.toStringElementTouched());
                            } else {
                                CTATComponentPanel.this.debug("Error: controller object is null!");
                            }
                            entry.setTouched(false);
                        } else {
                            CTATComponentPanel.this.debug("Error: style entity is not the right entry type");
                        }
                    }
                }
            });
            ArrayList<CTATStyleProperty> styles = this.component.getStyleProperties();
            for (int j = 0; j < styles.size(); ++j) {
                CTATStyleProperty style = styles.get(j);
                this.debug("Adding: " + style.getName() + " with value: " + style.getValue());
                entry1 = new CTATSerializableTableEntry(style.getName());
                entry2 = new CTATSerializableTableEntry(style.getValue());
                entry2.setEntry(style);
                entry2.setComponent(this.getComponent());
                Object[] styleData = new CTATSerializableTableEntry[]{entry1, entry2};
                this.styleModel.addRow(styleData);
            }
            this.styleTable.setModel(this.styleModel);
            TableColumn colS = this.styleTable.getColumnModel().getColumn(1);
            colS.setCellEditor(new CTATSheetCellEditor());
        }
    }

    private void untouch() {
        CTATSerializable entry;
        CTATSerializableTableEntry value;
        Object tester;
        this.debug("untouch ()");
        for (int i = 0; i < this.styleModel.getRowCount(); ++i) {
            tester = this.styleModel.getValueAt(i, 1);
            if (tester instanceof CTATSerializableTableEntry) {
                value = (CTATSerializableTableEntry)this.styleModel.getValueAt(i, 1);
                entry = value.getEntry();
                entry.setTouched(false);
                continue;
            }
            this.debug("Internal error: item in style table is not a CTAT entry");
        }
        for (int j = 0; j < this.parameterModel.getRowCount(); ++j) {
            tester = this.parameterModel.getValueAt(j, 1);
            if (tester instanceof CTATSerializableTableEntry) {
                value = (CTATSerializableTableEntry)this.parameterModel.getValueAt(j, 1);
                entry = value.getEntry();
                entry.setTouched(false);
                continue;
            }
            this.debug("Internal error: item in parameter table is not a CTAT entry");
        }
    }

    public void checkComponent() {
        this.debug("checkComponent ()");
        if (this.controller != null) {
            if (this.componentShow.isSelected()) {
                this.controller.sendHighlightMsg("", this.s2v(this.component.getInstanceName()), this.s2v("dummy"));
                this.component.setSelected(true);
            } else {
                this.controller.sendUnHighlightMsg("", this.s2v(this.component.getInstanceName()), this.s2v("dummy"));
                this.component.setSelected(false);
            }
            if (this.preview != null) {
                this.preview.repaint();
            }
        } else {
            this.debug("Error: controller object is null");
        }
    }
}

