/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class CTATNumberFieldFilter
extends PlainDocument {
    public static final char DOT = '.';
    public static final char NEGATIVE = '-';
    public static final String BLANK = "";
    public static final int DEF_PRECISION = 2;
    public static final int NUMERIC = 2;
    public static final int DECIMAL = 3;
    public static final String FM_NUMERIC = "0123456789";
    public static final String FM_DECIMAL = "0123456789.";
    public int maxLength = 0;
    public int format = 2;
    public String negativeChars = "";
    public String allowedChars = null;
    public boolean allowNegative = false;
    public int precision = 0;
    private static final long serialVersionUID = 1L;

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        String text = this.getText(0, offset) + str + this.getText(offset, this.getLength() - offset);
        if (str == null || text == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            if ((this.allowedChars + this.negativeChars).indexOf(str.charAt(i)) != -1) continue;
            return;
        }
        int precisionLength = 0;
        int dotLength = 0;
        int minusLength = 0;
        int textLength = text.length();
        try {
            if (this.format == 2) {
                new Long(text);
            } else if (this.format == 3) {
                new Double(text);
                int dotIndex = text.indexOf(46);
                if (dotIndex != -1 && (precisionLength = textLength - dotIndex - (dotLength = 1)) > this.precision) {
                    return;
                }
            }
        }
        catch (Exception ex) {
            return;
        }
        if (text.startsWith("-")) {
            if (!this.allowNegative) {
                return;
            }
            minusLength = 1;
        }
        if (this.maxLength < textLength - dotLength - precisionLength - minusLength) {
            return;
        }
        super.insertString(offset, str, attr);
    }
}

