/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATArgument;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializable;
import java.util.ArrayList;
import org.jdom.Content;
import org.jdom.Element;

public class CTATSAI
extends CTATSerializable {
    private String action = "";
    private ArrayList<CTATArgument> arguments = null;

    public CTATSAI() {
        this.setClassName("CTATSAI");
        this.arguments = new ArrayList();
    }

    public ArrayList<CTATArgument> getArguments() {
        return this.arguments;
    }

    public int getArgumentSize() {
        return this.arguments.size();
    }

    public void setSelection(String selection) {
        this.setName(selection);
    }

    public String getSelection() {
        return this.getName();
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    private void resetArguments() {
        this.arguments.clear();
    }

    private CTATArgument getArgument(int anIndex) {
        this.debug("getArgument (" + anIndex + "->" + this.arguments.size() + ")");
        CTATArgument arg = this.arguments.get(anIndex);
        if (arg == null) {
            this.debug("Error: unable to retrieve argument at index " + anIndex);
        }
        return arg;
    }

    private CTATArgument checkDefaultArgument() {
        this.debug("checkDefaultArgument ()");
        if (this.arguments.size() == 0) {
            this.debug("Adding default argument");
            CTATArgument defaultArgument = new CTATArgument();
            this.arguments.add(defaultArgument);
            return defaultArgument;
        }
        return null;
    }

    public CTATArgument setArgument(int anIndex, String aValue) {
        this.debug("setArgument ()");
        this.checkDefaultArgument();
        CTATArgument tempArgument = this.arguments.get(anIndex);
        tempArgument.setValue(aValue);
        return tempArgument;
    }

    public CTATArgument addArgument(String aName, String aValue, String aType, String aFormat) {
        this.debug("addArgument ()");
        CTATArgument tempArgument = new CTATArgument();
        tempArgument.setName(aName);
        tempArgument.setValue(aValue);
        tempArgument.setType(aType);
        tempArgument.setFormat(aFormat);
        this.arguments.add(tempArgument);
        return tempArgument;
    }

    public void setInput(String newInput) {
        this.debug("setInput()");
        this.checkDefaultArgument();
        CTATArgument arg = this.getArgument(0);
        arg.setValue(newInput);
    }

    public String getInput() {
        this.debug("getInput()");
        if (this.arguments.size() == 0) {
            return "";
        }
        CTATArgument arg = this.getArgument(0);
        return arg.getValue();
    }

    @Override
    public void setType(String aType) {
        this.debug("setType()");
        this.checkDefaultArgument();
        CTATArgument arg = this.getArgument(0);
        arg.setType(aType);
    }

    @Override
    public String getType() {
        this.debug("getType()");
        if (this.arguments.size() == 0) {
            return "";
        }
        CTATArgument arg = this.getArgument(0);
        return arg.getType();
    }

    @Override
    public void setFormat(String aFormat) {
        this.debug("setFormat()");
        this.checkDefaultArgument();
        CTATArgument arg = this.getArgument(0);
        arg.setFormat(aFormat);
    }

    @Override
    public String getFormat() {
        this.debug("getFormat()");
        if (this.arguments.size() == 0) {
            return "";
        }
        CTATArgument arg = this.getArgument(0);
        return arg.getFormat();
    }

    public String toArgumentString() {
        StringBuffer formatted = new StringBuffer();
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0) {
                formatted.append(", ");
            }
            CTATArgument arg = this.arguments.get(i);
            formatted.append(arg.getName() + ":" + arg.getValue());
        }
        return formatted.toString();
    }

    @Override
    public String toString() {
        StringBuffer formatted = new StringBuffer();
        formatted.append(this.getClassOpen() + "<selection>" + this.getName() + "</selection><action>" + this.action + "</action>");
        for (int i = 0; i < this.arguments.size(); ++i) {
            CTATArgument arg = this.arguments.get(i);
            formatted.append("<input name=\"" + arg.getName() + "\" fmt=\"" + arg.getFormat() + "\" type=\"" + arg.getType() + "\" >" + arg.getValue() + "</input>");
        }
        formatted.append(this.getClassClose());
        return formatted.toString();
    }

    public String toXMLString() {
        return this.toString();
    }

    public String toCommXMLString() {
        return "<Selection><value>" + this.getName() + "</value></Selection><Action><value>" + this.action + "</value></Action><Input><input fmt=\"text\" type=\"" + this.getType() + "\" >" + this.getValue() + "</input></Input>";
    }

    @Override
    public Element toStringElement() {
        this.debug("toStringElement ()");
        Element newElement = this.getClassElement();
        Element selectionElement = new Element("selection");
        selectionElement.setText(this.getName());
        newElement.addContent((Content)selectionElement);
        Element actionElement = new Element("action");
        actionElement.setText(this.action);
        newElement.addContent((Content)actionElement);
        Element argElement = new Element("internalArguments");
        newElement.addContent((Content)argElement);
        for (int i = 0; i < this.arguments.size(); ++i) {
            CTATArgument arg = this.arguments.get(i);
            Element inputElement = new Element("value");
            inputElement.setAttribute("fmt", arg.getFormat());
            inputElement.setAttribute("type", arg.getType());
            inputElement.setText(arg.getValue());
            argElement.addContent((Content)inputElement);
        }
        return newElement;
    }

    @Override
    public void fromXML(Element node) {
        this.debug("fromXML ()");
        this.resetArguments();
        for (Element elem : node.getChildren()) {
            this.debug("Parsing text node (" + elem.getName() + ")...");
            if (elem.getName().equals("selection")) {
                this.debug("Parsing selection: " + elem.getValue());
                this.setName(elem.getValue());
            }
            if (elem.getName().equals("action")) {
                this.debug("Parsing selection: " + elem.getValue());
                this.setAction(elem.getValue());
            }
            if (elem.getName().equals("internalArguments")) {
                for (Element elemArg : elem.getChildren()) {
                    if (!elemArg.getName().equals("value")) continue;
                    this.debug("Parsing argument/value: " + elemArg.getAttributeValue("name") + " - " + elemArg.getAttributeValue("type") + " - " + elemArg.getAttributeValue("fmt"));
                    this.addArgument(elemArg.getAttributeValue("name"), elemArg.getValue(), elemArg.getAttributeValue("type"), elemArg.getAttributeValue("fmt"));
                }
            }
            this.debug("Argument string: " + this.toArgumentString());
        }
    }

    public void fromCommXML(Element node) {
        this.debug("fromCommXML (" + node.getName() + ")");
        this.resetArguments();
        for (Element elem : node.getChildren()) {
            this.debug("Parsing text node (" + elem.getName() + ")...");
            if (elem.getName().equals("Selection")) {
                for (Element elemArg : elem.getChildren()) {
                    this.debug("Parsing Selection: " + elemArg.getValue());
                    this.setName(elemArg.getValue());
                }
            }
            if (elem.getName().equals("Action")) {
                for (Element actArg : elem.getChildren()) {
                    this.debug("Parsing Action: " + actArg.getValue());
                    this.setAction(actArg.getValue());
                }
            }
            if (!elem.getName().equals("Input")) continue;
            for (Element elemArg : elem.getChildren()) {
                if (!elemArg.getName().equals("value")) continue;
                this.debug("Parsing argument/value: " + elemArg.getAttributeValue("name") + " - " + elemArg.getAttributeValue("type") + " - " + elemArg.getAttributeValue("fmt"));
                this.addArgument(elemArg.getAttributeValue("name"), elemArg.getValue(), elemArg.getAttributeValue("type"), elemArg.getAttributeValue("fmt"));
            }
        }
    }
}

