/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATColorUtil;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATJPanel;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializable;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializableTableEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CTATSheetCellColor
extends CTATJPanel
implements TableCellRenderer {
    private static final long serialVersionUID = -1568793295263302888L;
    boolean isBordered = true;
    private CTATSerializable object = null;
    private JLabel colorLabel = new JLabel("");
    private JPanel colorPicker = new JPanel();

    public CTATSheetCellColor(boolean isBordered) {
        this.debug("CTATSheetCellColor ()");
        this.setLayout(new BoxLayout(this, 0));
        this.setMinimumSize(new Dimension(10, 10));
        this.setMaximumSize(new Dimension(5000, 5000));
        this.isBordered = isBordered;
        this.setOpaque(true);
        this.colorLabel = new JLabel("");
        this.colorLabel.setHorizontalAlignment(2);
        this.colorLabel.setFont(new Font("Dialog", 1, 10));
        this.colorLabel.setOpaque(true);
        this.colorLabel.setBackground(new Color(255, 255, 255));
        this.colorLabel.setMinimumSize(new Dimension(50, 20));
        this.colorLabel.setMaximumSize(new Dimension(2000, 20));
        this.colorPicker = new JPanel();
        this.colorPicker.setBorder(BorderFactory.createLineBorder(Color.black));
        this.colorPicker.setMinimumSize(new Dimension(30, 20));
        this.colorPicker.setMaximumSize(new Dimension(30, 30));
        this.add(this.colorLabel);
        this.add(this.colorPicker);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object aValue, boolean isSelected, boolean hasFocus, int row, int column) {
        this.debug("getTableCellRendererComponent (" + aValue.getClass().getName() + ")");
        Color newColor = null;
        if (aValue instanceof String) {
            String safety = (String)aValue;
            this.debug("For some reason we're now getting a string back, going into safety mode ...");
            this.debug("Parsing: " + safety);
            this.colorLabel.setText(safety);
            newColor = CTATColorUtil.parse(safety);
            this.colorPicker.setBackground(newColor);
        } else {
            CTATSerializableTableEntry value = (CTATSerializableTableEntry)aValue;
            this.object = value.getEntry();
            this.debug("Parsing: " + this.object.getValue());
            this.colorLabel.setText(this.object.getValue());
            newColor = CTATColorUtil.parse(this.object.getValue());
            this.colorPicker.setBackground(newColor);
            this.colorPicker.repaint();
        }
        this.setToolTipText("RGB value: " + newColor.getRed() + ", " + newColor.getGreen() + ", " + newColor.getBlue());
        return this;
    }
}

