/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.GraphInspector;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.EditContextEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.EditorContextListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupEditorContext;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class GroupTreeSelectionSync
implements TreeSelectionListener,
EditorContextListener {
    GroupEditorContext editContext;
    JTree tree;

    public GroupTreeSelectionSync(JTree tree, GroupEditorContext editContext) {
        this.tree = tree;
        tree.addTreeSelectionListener(this);
        this.editContext = editContext;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath[] selectionChangedPaths;
        for (TreePath path : selectionChangedPaths = event.getPaths()) {
            if (!(path.getLastPathComponent() instanceof LinkGroup) || !event.isAddedPath(path)) continue;
            LinkGroup group = (LinkGroup)path.getLastPathComponent();
            if (this.editContext.getSelectedGroup() != null && this.editContext.getSelectedGroup().equals(group)) continue;
            this.editContext.setSelectedGroup(group);
        }
    }

    @Override
    public void editorContextChanged(EditContextEvent e) {
        if (e.getType() != 3) {
            return;
        }
        LinkGroup group = this.editContext.getSelectedGroup();
        if (group == null) {
            return;
        }
        Object ob = this.tree.getSelectionPath().getLastPathComponent();
        if (!(ob instanceof LinkGroup) || !group.equals((LinkGroup)ob)) {
            this.tree.setSelectionPath(this.getGroupPath(group));
        }
    }

    private TreePath getGroupPath(LinkGroup group) {
        LinkedList<LinkGroup> treePath = new LinkedList<LinkGroup>();
        do {
            treePath.addFirst(group);
        } while ((group = this.editContext.getGroupModel().getGroupParent(group)) != null);
        return new TreePath(treePath.toArray(new LinkGroup[0]));
    }
}

