/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.jgraphwindow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphEdgeView;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphController;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.MarathonElement;
import java.awt.Color;
import java.awt.Point;
import java.util.Map;
import java.util.Vector;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.GraphConstants;

public class BR_JGraphEdge
extends DefaultEdge
implements MarathonElement {
    private static final long serialVersionUID = -830251680303940439L;
    private Color edgeColor = null;
    private ProblemEdge problemEdge;
    private transient JGraphController controller;

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller.getJGraphWindow().getJGraphController();
    }

    public BR_JGraphEdge(ProblemEdge problemEdge, JGraphController controller) {
        super((Object)"");
        this.problemEdge = problemEdge;
        problemEdge.setJGraphEdge(this);
        this.setOptions(problemEdge);
        this.controller = controller;
    }

    public JGraphController getController() {
        return this.controller;
    }

    private void setOptions(ProblemEdge problemEdge) {
        int arrow = 2;
        GraphConstants.setLineEnd((Map)this.getAttributes(), (int)arrow);
        GraphConstants.setEndFill((Map)this.getAttributes(), (boolean)false);
        GraphConstants.setDisconnectable((Map)this.getAttributes(), (boolean)true);
        GraphConstants.setMoveable((Map)this.getAttributes(), (boolean)true);
        GraphConstants.setConnectable((Map)this.getAttributes(), (boolean)true);
        GraphConstants.setSelectable((Map)this.getAttributes(), (boolean)false);
        if (this.getEdgeColor() != null) {
            GraphConstants.setLineColor((Map)this.getAttributes(), (Color)this.getEdgeColor());
        }
        GraphConstants.setLabelAlongEdge((Map)this.getAttributes(), (boolean)true);
        boolean preferred = problemEdge.isPreferredEdge();
        if (preferred) {
            GraphConstants.setLineWidth((Map)this.getAttributes(), (float)2.0f);
        }
    }

    public ProblemEdge getProblemEdge() {
        return this.problemEdge;
    }

    public MarathonElement getMarathonElement(String uniqueIdentifier) {
        String[] split = uniqueIdentifier.split("::");
        if (split[1].equals("Rule")) {
            int index = this.getRuleIndex(uniqueIdentifier);
            return this.problemEdge.getEdgeData().getRuleLabels().get(index);
        }
        if (split[1].equals("ActionLabel")) {
            return this.problemEdge.getActionLabel();
        }
        if (split[1].equals("CheckLabel")) {
            return this.problemEdge.getPreLispCheckLabel();
        }
        if (split[1].equals("Link")) {
            return this;
        }
        return null;
    }

    @Override
    public String getMarathonIdentifier() {
        return "Link" + this.problemEdge.getUniqueID() + "::Link";
    }

    @Override
    public String getText() {
        return "Link" + this.problemEdge.getUniqueID();
    }

    @Override
    public int getTextStyle() {
        return 0;
    }

    @Override
    public String getToolTipText() {
        return this.problemEdge.getEdgeData().getTooltipText();
    }

    public int getRuleIndex(String uniqueIdentifier) {
        String[] split = uniqueIdentifier.split("::");
        String recordedRuleText = split[2];
        int index = 0;
        Vector<RuleLabel> ruleList = this.problemEdge.getEdgeData().getRuleLabels();
        int count = 0;
        for (RuleLabel ruleLabel : ruleList) {
            String ruleText = ruleLabel.getText();
            if (recordedRuleText.equals(ruleText)) {
                index = count;
            }
            ++count;
        }
        return index;
    }

    public MarathonElement getMarathonElement(Point location) {
        CellView mapping = this.controller.getGraphView().getMapping((Object)this, true);
        BR_JGraphEdgeView view = (BR_JGraphEdgeView)mapping;
        return view.getMarathonElement(location);
    }

    public boolean matchesMarathonIdentifier(String uniqueIdentifier) {
        String[] split = uniqueIdentifier.split("::");
        if (split[0].equals("Edge" + this.problemEdge.getActionLabel().getUniqueID())) {
            return true;
        }
        return split[0].equals("Link" + this.problemEdge.getUniqueID());
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }
}

