/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.jgraphwindow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.BRDLoadedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ChangeCurrentNodeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeColorEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeDeletedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeRewiredEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NewProblemEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeDeletedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.BehaviorRecorder.View.BRPanel;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraph;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphEdge;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphNode;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphPanel;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.HashMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class JGraphController
implements ProblemModelListener,
CtatModeListener {
    private BR_Controller brController;
    private JGraphPanel jgraphWindow;
    private GraphLayoutCache graphView;
    private BR_JGraph jgraph;
    private GraphModel graphModel;
    private final double MINIMUM_ZOOM_SCALE = 1.0E-5;
    private boolean resetCopyNode;

    public JGraphController(BR_Controller controller, JGraphPanel window, GraphModel graphModel, GraphLayoutCache graphView) {
        this.brController = controller;
        this.jgraphWindow = window;
        this.jgraph = window.getJGraph();
        this.graphModel = graphModel;
        this.brController.addCtatModeListener(this);
        this.brController.getProblemModel().addProblemModelListener(this);
        this.graphView = graphView;
    }

    private boolean handlePMEventRecursive(ProblemModelEvent event, Set<DefaultEdge> selectedEdges) {
        if (event instanceof EdgeColorEvent) {
            this.handleEdgeColorEvent((EdgeColorEvent)event);
            return false;
        }
        if (event instanceof BRDLoadedEvent) {
            ArrayList<ProblemModelEvent> nodeCreatedEvents = new ArrayList<ProblemModelEvent>(event.collectTypeSubevents(NodeCreatedEvent.class, true, true, true));
            this.handleLoadedBRDNodes(nodeCreatedEvents);
            ArrayList<ProblemModelEvent> edgeCreatedEvents = new ArrayList<ProblemModelEvent>(event.collectTypeSubevents(EdgeCreatedEvent.class, true, true, true));
            this.handleLoadedBRDEdges(edgeCreatedEvents);
            return true;
        }
        if (event instanceof NodeCreatedEvent) {
            this.resetCopyNode = true;
            this.handleNodeCreatedEvent(event);
        }
        if (event instanceof NodeUpdatedEvent) {
            this.handleNodeUpdatedEvent((NodeUpdatedEvent)event);
        }
        if (event instanceof NodeDeletedEvent) {
            this.resetCopyNode = true;
            this.handleNodeDeletedEvent((NodeDeletedEvent)event);
        }
        if (event instanceof ChangeCurrentNodeEvent) {
            this.handleChangeCurrentNodeEvent((ChangeCurrentNodeEvent)event);
        }
        if (event instanceof NewProblemEvent) {
            this.resetCopyNode = true;
            this.handleNewProblemEvent();
        }
        if (event instanceof EdgeRewiredEvent) {
            this.resetCopyNode = true;
            EdgeRewiredEvent ere = (EdgeRewiredEvent)event;
            Color resetColor = ere.getEdgeDeletedEvent().getEdge().getJGraphEdge().getEdgeColor();
            this.handleEdgeDeletedEvent(ere.getEdgeDeletedEvent());
            DefaultEdge edge = this.handleEdgeCreatedEvent(ere.getEdgeCreatedEvent(), resetColor);
            if (ere.getEdgeCreatedEvent().isSelected()) {
                selectedEdges.add(edge);
            }
        }
        if (event instanceof EdgeCreatedEvent) {
            this.resetCopyNode = true;
            DefaultEdge edge = this.handleEdgeCreatedEvent((EdgeCreatedEvent)event, null);
            if (((EdgeCreatedEvent)event).isSelected()) {
                selectedEdges.add(edge);
            }
        }
        if (event instanceof EdgeUpdatedEvent) {
            this.handleEdgeUpdatedEvent((EdgeUpdatedEvent)event);
        }
        if (event instanceof EdgeDeletedEvent) {
            this.resetCopyNode = true;
            this.handleEdgeDeletedEvent((EdgeDeletedEvent)event);
        }
        if (event.isCompoundEventP()) {
            for (ProblemModelEvent E : event.getSubevents()) {
                this.resetCopyNode = this.handlePMEventRecursive(E, selectedEdges) || this.resetCopyNode;
            }
        }
        return this.resetCopyNode;
    }

    private void markEdgesSelected(Set<DefaultEdge> selectedEdges) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "JGraphCtlr.markEdgesSelected() nEdges " + selectedEdges.size());
        }
        Object[] edges = new DefaultEdge[selectedEdges.size()];
        selectedEdges.toArray(edges);
        this.jgraph.setSelectionCells(edges);
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent event) {
        final HashSet<DefaultEdge> selectedEdges = new HashSet<DefaultEdge>();
        this.resetCopyNode = false;
        this.resetCopyNode = this.handlePMEventRecursive(event, selectedEdges);
        if (!Utils.isRuntime()) {
            if (this.resetCopyNode) {
                BR_Controller.setCopySubgraphNode(null);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CellView[] roots = JGraphController.this.graphView.getRoots();
                    for (int i = 0; i < roots.length; ++i) {
                        JGraphController.this.jgraph.updateAutoSize(roots[i]);
                    }
                    JGraphController.this.markEdgesSelected(selectedEdges);
                    JGraphController.this.jgraphWindow.repaint();
                    JGraphController.this.jgraphWindow.revalidate();
                }
            });
        }
    }

    private void handleChangeCurrentNodeEvent(ChangeCurrentNodeEvent event) {
        ProblemNode oldNode = event.getOldProblemNode();
        ProblemNode newNode = event.getNewProblemNode();
        Map nestedAttributes = null;
        if (newNode != null) {
            nestedAttributes = this.setBold(newNode, true, nestedAttributes);
        }
        if (oldNode != null && !oldNode.equals(newNode)) {
            nestedAttributes = this.setBold(oldNode, false, nestedAttributes);
        }
        if (nestedAttributes != null) {
            SwingUtilities.invokeLater(new InvokeGraphLayoutCacheEdit(nestedAttributes));
        }
    }

    private Map setBold(ProblemNode problemNode, boolean bold, Map nestedAttributes) {
        int thickness;
        Font font;
        BR_JGraphNode cell;
        BR_JGraphNode bR_JGraphNode = cell = problemNode == null ? null : problemNode.getJGraphNode();
        if (trace.getDebugCode("br")) {
            trace.out("br", "setBold(" + problemNode + ", " + bold + ") cell " + cell + ", graphView " + this.graphView);
        }
        if (problemNode == null || cell == null || this.graphView == null) {
            return nestedAttributes;
        }
        Object[] cells = new Object[]{cell};
        CellView[] cellViews = this.graphView.getMapping(cells);
        HashMap attributeMap = new HashMap();
        int padding = 2;
        if (bold) {
            font = BRPanel.BOLD_FONT;
            thickness = 2;
        } else {
            font = BRPanel.NORMAL_FONT;
            thickness = 1;
        }
        GraphConstants.setFont((Map)attributeMap, (Font)font);
        GraphConstants.setBorder((Map)attributeMap, (Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, thickness), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        GraphConstants.setResize((Map)attributeMap, (boolean)true);
        if (nestedAttributes == null) {
            nestedAttributes = new HashMap();
        }
        nestedAttributes.put(cell, attributeMap);
        return nestedAttributes;
    }

    private void handleNodeUpdatedEvent(NodeUpdatedEvent event) {
        BR_JGraphNode cell;
        ProblemNode problemNode = event.getNode();
        BR_JGraphNode bR_JGraphNode = cell = problemNode == null ? null : problemNode.getJGraphNode();
        if (trace.getDebugCode("br")) {
            trace.out("br", "handleNodeUpdatedEvent(" + event + ") problemNode " + problemNode + ", cell " + cell + ", graphView " + this.graphView);
        }
        if (problemNode == null || cell == null || this.graphView == null) {
            return;
        }
        if (Utils.isRuntime()) {
            return;
        }
        Object[] cells = new Object[]{cell};
        CellView[] cellViews = this.graphView.getMapping(cells);
        HashMap attributeMap = new HashMap();
        Rectangle2D bounds = cellViews[0].getBounds();
        Rectangle2D.Double bounds2 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)bounds2);
        GraphConstants.setBackground((Map)attributeMap, (Color)cell.getBackground());
        HashMap nestedAttributes = new HashMap();
        nestedAttributes.put(cells[0], attributeMap);
        SwingUtilities.invokeLater(new InvokeGraphLayoutCacheEdit(nestedAttributes));
    }

    private void handleNewProblemEvent() {
        this.graphModel.remove(DefaultGraphModel.getRoots((GraphModel)this.graphModel));
    }

    private void handleNodeDeletedEvent(NodeDeletedEvent event) {
        ProblemNode deletedNode = event.getNode();
        if (trace.getDebugCode("jgraph")) {
            trace.out("jgraph", "Node Deleted Event: " + deletedNode);
        }
        BR_JGraphNode[] graphNode = new BR_JGraphNode[]{deletedNode.getJGraphNode()};
        List cellsToRemove = this.graphView.getIncomingEdges((Object)graphNode[0], null, true, true);
        cellsToRemove.add(graphNode[0]);
        Enumeration ports = graphNode[0].children();
        while (ports.hasMoreElements()) {
            cellsToRemove.add(ports.nextElement());
        }
        this.graphView.remove(cellsToRemove.toArray());
    }

    private void handleEdgeDeletedEvent(EdgeDeletedEvent event) {
        Object[] edge = new BR_JGraphEdge[]{event.getEdge().getJGraphEdge()};
        this.graphView.remove(edge);
    }

    private void handleEdgeUpdatedEvent(EdgeUpdatedEvent event) {
        ProblemEdge problemEdge = event.getEdge();
        EdgeData edgeData = problemEdge.getEdgeData();
        BR_JGraphEdge jg_edge = problemEdge.getJGraphEdge();
        if (edgeData.isPreferredEdge()) {
            GraphConstants.setLineWidth((Map)jg_edge.getAttributes(), (float)2.0f);
        } else {
            GraphConstants.setLineWidth((Map)jg_edge.getAttributes(), (float)1.0f);
        }
        GraphConstants.setLineColor((Map)jg_edge.getAttributes(), (Color)edgeData.getDefaultColor());
        if (!Utils.isRuntime()) {
            this.graphView.editCell((Object)jg_edge, (Map)jg_edge.getAttributes());
        }
    }

    private void handleLoadedBRDEdges(ArrayList<ProblemModelEvent> edgeCreatedEvents) {
        Object[] cells = new DefaultGraphCell[edgeCreatedEvents.size()];
        for (int i = 0; i < edgeCreatedEvents.size(); ++i) {
            ProblemEdge problemEdge = ((EdgeCreatedEvent)edgeCreatedEvents.get(i)).getEdge();
            EdgeData edgeData = problemEdge.getEdgeData();
            ProblemNode[] nodes = problemEdge.getNodes();
            BR_JGraphNode source = nodes[0].getJGraphNode();
            BR_JGraphNode target = nodes[1].getJGraphNode();
            BR_JGraphEdge jg_edge = new BR_JGraphEdge(problemEdge, this);
            jg_edge.setSource(source.getChildAt(0));
            jg_edge.setTarget(target.getChildAt(0));
            GraphConstants.setSelectable((Map)jg_edge.getAttributes(), (boolean)true);
            GraphConstants.setBendable((Map)jg_edge.getAttributes(), (boolean)false);
            GraphConstants.setEditable((Map)jg_edge.getAttributes(), (boolean)false);
            GraphConstants.setLineColor((Map)jg_edge.getAttributes(), (Color)edgeData.getDefaultColor());
            cells[i] = jg_edge;
        }
        if (!Utils.isRuntime()) {
            this.graphView.insert(cells);
        }
    }

    private void handleEdgeColorEvent(EdgeColorEvent event) {
        ProblemEdge edge = event.getEdge();
        Color newColor = event.getColor() == null ? edge.getEdgeData().getDefaultColor() : event.getColor();
        BR_JGraphEdge jedge = edge.getJGraphEdge();
        jedge.setEdgeColor(newColor);
        GraphConstants.setLineColor((Map)jedge.getAttributes(), (Color)newColor);
        if (!Utils.isRuntime()) {
            this.graphView.editCell((Object)jedge, (Map)jedge.getAttributes());
        }
    }

    private DefaultEdge handleEdgeCreatedEvent(EdgeCreatedEvent event, Color resetColor) {
        ProblemEdge problemEdge = event.getEdge();
        ProblemNode[] nodes = problemEdge.getNodes();
        BR_JGraphNode source = nodes[0].getJGraphNode();
        BR_JGraphNode target = nodes[1].getJGraphNode();
        Object[] cells = new DefaultGraphCell[1];
        BR_JGraphEdge jg_edge = new BR_JGraphEdge(problemEdge, this);
        cells[0] = jg_edge;
        jg_edge.setSource(source.getChildAt(0));
        jg_edge.setTarget(target.getChildAt(0));
        GraphConstants.setSelectable((Map)jg_edge.getAttributes(), (boolean)true);
        GraphConstants.setBendable((Map)jg_edge.getAttributes(), (boolean)false);
        GraphConstants.setEditable((Map)jg_edge.getAttributes(), (boolean)false);
        if (resetColor != null) {
            jg_edge.setEdgeColor(resetColor);
            GraphConstants.setLineColor((Map)jg_edge.getAttributes(), (Color)resetColor);
        } else if (problemEdge.getEdgeData().isTutorPerformed(null)) {
            jg_edge.setEdgeColor(EdgeData.TPAColor);
            GraphConstants.setLineColor((Map)jg_edge.getAttributes(), (Color)EdgeData.TPAColor);
        }
        if (!Utils.isRuntime()) {
            this.graphView.insert(cells);
        }
        return jg_edge;
    }

    private void handleLoadedBRDNodes(ArrayList<ProblemModelEvent> nodeCreatedEvents) {
        Object[] cells = new DefaultGraphCell[nodeCreatedEvents.size()];
        for (int i = 0; i < nodeCreatedEvents.size(); ++i) {
            int y = 0;
            int x = 0;
            ProblemNode curr = ((NodeCreatedEvent)nodeCreatedEvents.get(i)).getNode();
            if (!Utils.isRuntime()) {
                Point location = curr.getNodeView().getLocation();
                x = location.x;
                y = location.y;
                trace.out("jgraph", "x = " + x + " y = " + y);
            }
            BR_JGraphNode jgraphNode = new BR_JGraphNode(curr, x, y);
            cells[i] = jgraphNode;
        }
        if (!Utils.isRuntime()) {
            this.graphView.insert(cells);
        }
    }

    private void handleNodeCreatedEvent(ProblemModelEvent event) {
        ProblemNode problemNode = ((NodeCreatedEvent)event).getNode();
        if (trace.getDebugCode("br")) {
            trace.out("br", "handleNodeCreatedEvent() problemNode " + problemNode);
        }
        boolean updateAuthorUI = !Utils.isRuntime() && problemNode.getProblemModel().getController() != null;
        int x = 0;
        int y = 0;
        if (updateAuthorUI) {
            Point location = problemNode.getNodeView().getLocation();
            x = location.x;
            y = location.y;
            trace.out("jgraph", "x = " + x + " y = " + y);
        }
        BR_JGraphNode jgraphNode = new BR_JGraphNode(problemNode, x, y);
        Object[] cells = new DefaultGraphCell[]{jgraphNode};
        if (updateAuthorUI) {
            this.graphView.insert(cells);
        }
    }

    @Override
    public void ctatModeEventOccured(CtatModeEvent e) {
        if (System.getProperty("noCtatWindow") != null) {
            return;
        }
        if (e instanceof CtatModeEvent.RepaintEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JGraphController.this.jgraphWindow.repaint();
                }
            });
        } else if (e instanceof CtatModeEvent.SetCurrentNodeEvent) {
            this.setCurrentNode((CtatModeEvent.SetCurrentNodeEvent)e);
        }
    }

    private void setCurrentNode(CtatModeEvent.SetCurrentNodeEvent event) {
    }

    public void zoomListActionPerfomed(String ZoomName) {
        double factor = Double.parseDouble(ZoomName.substring(0, ZoomName.length() - 1)) / 100.0;
        this.zoom(factor, false);
    }

    public void zoomOutActionPerfomed() {
        double factor = 0.9;
        this.zoom(0.9, true);
    }

    public void zoomInActionPerfomed() {
        double factor = 1.1;
        this.zoom(1.1, true);
    }

    private void zoom(double factor, boolean relative) {
        BR_JGraphNode currentNode;
        double scale;
        if (relative) {
            scale = this.jgraph.getScale();
            scale *= factor;
        } else {
            scale = factor;
        }
        double temp = scale % 1.0E-4;
        scale -= temp;
        if (scale < 1.0E-5) {
            scale = 1.0E-5;
        }
        try {
            currentNode = this.brController.getSolutionState().getCurrentNode().getJGraphNode();
        }
        catch (NullPointerException e) {
            return;
        }
        CellView currentView = this.graphView.getMapping((Object)currentNode, false);
        Rectangle2D bounds = currentView.getBounds();
        Point2D.Double p = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        trace.out("jgraph", "p = " + p);
        this.jgraph.setScale(scale);
        this.jgraph.scrollCellToVisible(currentNode);
        this.jgraphWindow.repaint();
    }

    public DefaultGraphCell getMouseOverCell() {
        return this.jgraph.getMouseOverCell();
    }

    public GraphLayoutCache getGraphView() {
        return this.graphView;
    }

    private class InvokeGraphLayoutCacheEdit
    implements Runnable {
        private final Map nestedAttributes;

        InvokeGraphLayoutCacheEdit(Map nestedAttributes) {
            this.nestedAttributes = nestedAttributes;
        }

        @Override
        public void run() {
            if (trace.getDebugCode("br")) {
                trace.outNT("br", "InvokeGraphLayoutCacheEdit.run() on graphView " + JGraphController.this.graphView + ", keySet " + this.nestedAttributes.keySet());
            }
            for (Object cell : this.nestedAttributes.keySet()) {
                if (!(cell instanceof BR_JGraphNode)) continue;
                if (trace.getDebugCode("br")) {
                    trace.outNT("br", " " + cell + " old " + ((BR_JGraphNode)cell).getAttributes());
                }
                if (!trace.getDebugCode("br")) continue;
                trace.outNT("br", " " + cell + " new " + this.nestedAttributes.get(cell));
            }
            JGraphController.this.graphView.edit(this.nestedAttributes);
        }
    }
}

