/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import com.sun.corba.se.impl.io.TypeMismatchException;
import edu.cmu.pact.Log.TutorActionLog;
import edu.cmu.pact.Log.TutorActionLogV4;
import edu.cmu.pact.Utilities.Logger;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.jess.LogWorkingMemory;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.LogContext;
import edu.cmu.pslc.logging.Message;
import edu.cmu.pslc.logging.PlainMessage;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.TutorMessage;
import edu.cmu.pslc.logging.element.EventElement;
import edu.cmu.pslc.logging.element.MetaElement;
import edu.cmu.pslc.logging.element.SemanticEventElement;
import edu.cmu.pslc.logging.element.SkillElement;
import edu.cmu.pslc.logging.element.UiEventElement;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class DataShopMessageObject
extends MessageObject {
    public static final String HINT_REQUEST = "HINT_REQUEST";
    public static final String STEP_ID = "step_id";
    protected static final String START_PROBLEM = "START_PROBLEM";
    private TutorActionLogV4 logMsg = null;
    private String replay = null;
    private boolean tutorToTool;
    private String actionEvaluation;
    private LogContext logger;
    private String originalElementString;
    private String problemName = "";
    private static final List<String> toolOnlyMessageTypes = Arrays.asList("InterfaceAction".toLowerCase());
    private static final List<String> tutorOnlyMessageTypes = Arrays.asList("AssociatedRules".toLowerCase(), "NextHintMessage".toLowerCase(), "PreviousHintMessage".toLowerCase());
    private static final List<String> contextMessageTypes = Arrays.asList("StartProblem".toLowerCase(), "LoadBRDFileSuccess".toLowerCase());
    private static final List<String> uiEventMessageTypes = Arrays.asList("Glossary".toLowerCase(), "CognitiveLoad".toLowerCase());
    private static final String[][] msgTypeToSemanticEvtArr = new String[][]{{"InterfaceAction", null}, {"Glossary".toLowerCase(), "GLOSSARY"}, {"CognitiveLoad".toLowerCase(), "COGNITIVE_LOAD"}};
    private static final Map<String, String> msgTypeToSemanticEvt = new HashMap<String, String>();
    private static final Pattern HintPattern;
    public static final String UTCTimeStampFmt = "yyyy-MM-dd HH:mm:ss.SSS z";
    public static final DateFormat UTCTimeStampDateFmt;

    public String getReplay() {
        return this.replay;
    }

    protected void setActionEvaluation(String actionEvaluation) {
        this.actionEvaluation = actionEvaluation;
    }

    protected String getActionEvaluation() {
        return this.actionEvaluation;
    }

    public DataShopMessageObject(MessageObject mo, boolean tutorToTool, LogContext logger) {
        super(mo);
        this.tutorToTool = tutorToTool;
        this.logger = logger;
        this.logMsg = null;
        this.replay = (String)this.getProperty("replay");
        String indicator = (String)this.getProperty("Indicator");
        if (indicator != null && indicator.length() > 0) {
            this.setActionEvaluation(indicator);
        } else {
            this.setActionEvaluation(this.msgTypeToActionEval());
        }
        String subtype = (String)this.getProperty("subtype");
        if (trace.getDebugCode("log")) {
            trace.out("log", "tutorToTool " + tutorToTool + ", subtype " + subtype + ", indicator " + indicator + ", actionEval " + this.getActionEvaluation() + "; message\n  " + this);
        }
    }

    private String msgTypeToActionEval() {
        String msgType = this.getMessageType();
        if ("NextHintMessage".equalsIgnoreCase(msgType)) {
            return "HINT_NEXT";
        }
        if ("PreviousHintMessage".equalsIgnoreCase(msgType)) {
            return "HINT_PREVIOUS";
        }
        return null;
    }

    public DataShopMessageObject(String xmlStr, Logger logger) {
        MetaElement meta = null;
        if (logger != null && logger.getContextMessage() != null) {
            meta = logger.getContextMessage().getMetaElement();
        }
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "DatatShopMessageObject constructor: meta element = " + meta.toString());
        }
        TutorActionLog logAct = TutorActionLog.factory(xmlStr, "4", meta);
        this.init("InterfaceAction");
        this.OLI2Native(logAct);
    }

    @Override
    public String toXML() {
        if (this.getLogMsg() == null) {
            return super.toXML();
        }
        return this.getLogMsg().toString();
    }

    private Boolean getTutorToToolRestriction(String messageType) {
        if (toolOnlyMessageTypes.contains(messageType)) {
            return Boolean.FALSE;
        }
        if (tutorOnlyMessageTypes.contains(messageType)) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    protected void setPropertyInternal(String propertyName, Object propertyValue, boolean useAsIs) {
        super.setPropertyInternal(propertyName, propertyValue, useAsIs);
        this.logMsg = null;
    }

    public TutorActionLogV4 getLogMsg() {
        List<String> advices;
        if (this.logMsg != null) {
            if (trace.getDebugCode("mo")) {
                trace.out("mo", "getLogMsg() logMsg already exists");
            }
            return this.logMsg;
        }
        Class cls = this.whichDataShopMsgType();
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "getLogMsg() logMsg is of type " + cls.getName());
        }
        if (cls == PlainMessage.class) {
            if (trace.getDebugCode("mo")) {
                trace.out("mo", "creating a new plain message");
            }
            this.logMsg = this.createPlainMessage();
            return this.logMsg;
        }
        if (cls == ContextMessage.class) {
            this.logMsg = this.createContextMessage();
            return this.logMsg;
        }
        if (cls == TutorMessage.class) {
            ToolMessage lastToolMessage = this.getLastToolMessage(this.logger);
            TutorMessage msg = TutorMessage.create((ToolMessage)lastToolMessage);
            String actionEvaluation = this.getActionEvaluation();
            this.setResponseType(actionEvaluation, msg);
            this.logMsg = new TutorActionLogV4(msg);
            if (trace.getDebugCode("mo")) {
                trace.out("mo", "tutorMessage: new logMsg before adding more info " + this.logMsg.toString());
            }
            this.logMsg.setProblemName(this.logger.getProblemName());
            this.createEventDesc(this.logMsg);
            this.addCustomFields(this.logMsg);
            if (this.replay != null) {
                this.logMsg.setReplay(this.replay);
            }
            if (actionEvaluation != null && actionEvaluation.toUpperCase().contains("HINT")) {
                this.populateHintElements(this.logMsg);
                this.createSkills(this.logMsg);
                this.addTimeStamp(this.logMsg);
                this.addStepId(this.logMsg);
                if (trace.getDebugCode("mo")) {
                    trace.out("mo", "tutorMessage: in if loop, after more settings " + this.logMsg.toString());
                }
                return this.logMsg;
            }
        } else {
            ToolMessage msg = ToolMessage.create((ContextMessage)this.logger.getContextMessage());
            if (DataShopMessageObject.isUIEventMsg(this)) {
                this.setAsUIEvent(msg, this.getTransactionId());
            } else {
                if (DataShopMessageObject.isHintMsg(this)) {
                    msg.setAsHintRequest();
                } else {
                    msg.setAsAttempt();
                    String semEvtName = ((SemanticEventElement)msg.getEventElement()).getName();
                    SemanticEventElement see2 = new SemanticEventElement(this.getTransactionId(), semEvtName, (String)this.getProperty("trigger"), (String)this.getProperty("subtype"));
                    msg.setEventElement((EventElement)see2);
                }
                msg.setTransactionId(this.getTransactionId());
                this.logger.setLastToolMessage(msg);
            }
            this.logMsg = new TutorActionLogV4(msg);
            this.logMsg.setProblemName(this.logger.getProblemName());
            this.createEventDesc(this.logMsg);
            if (this.replay != null) {
                this.logMsg.setReplay(this.replay);
            }
            if (DataShopMessageObject.isUIEventMsg(this) || DataShopMessageObject.isHintMsg(this)) {
                this.addTimeStamp(this.logMsg);
                return this.logMsg;
            }
        }
        if (this.getActionEvaluation() != null) {
            this.logMsg.addActionEvaluation(this.getActionEvaluation());
        }
        if ((advices = this.createTutorAdvices()) != null) {
            for (String advice : advices) {
                this.logMsg.addTutorAdvice(advice);
            }
        }
        this.createSkills(this.logMsg);
        if (this.replay != null) {
            this.logMsg.setReplay(this.replay);
        }
        this.addTimeStamp(this.logMsg);
        this.addWMImages(this.logMsg);
        this.addStepId(this.logMsg);
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "getLogMsg() reached the end of the method call: " + this.logMsg.toString());
        }
        return this.logMsg;
    }

    protected void addCustomFields(TutorActionLogV4 logMsg) {
        Message msg = logMsg.getMsg();
        if (!(msg instanceof TutorMessage)) {
            throw new TypeMismatchException("Only add custom fields to tutor_messages (not including time)");
        }
        Object test = this.getProperty("custom_fields");
        if (!(test instanceof List)) {
            trace.out("mo", "addCustomFields can't get a list of custom_fields");
            return;
        }
        for (Object obj : (List)test) {
            if (trace.getDebugCode("mo")) {
                trace.out("mo", "addCustomFields trying to add obj " + new XMLOutputter().outputString((Element)obj));
            }
            if (!(obj instanceof Element)) {
                trace.out("mo", "addCustomFields obj is not an element: " + obj);
                continue;
            }
            String name = ((Element)obj).getChildText("name");
            String value = ((Element)obj).getChildText("value");
            ((TutorMessage)msg).addCustomField(name, value);
        }
    }

    protected int addWMImages(TutorActionLogV4 logMsg) {
        Message msg = logMsg.getMsg();
        int count = 0;
        Vector wmImages = (Vector)this.getProperty("WMImages");
        if (wmImages != null) {
            Iterator it = wmImages.iterator();
            while (it.hasNext()) {
                String[] parsedImage = LogWorkingMemory.parseImage((String)it.next());
                if (msg instanceof TutorMessage) {
                    ((TutorMessage)msg).addCustomField(parsedImage[0], parsedImage[1]);
                } else if (msg instanceof ToolMessage) {
                    ((ToolMessage)msg).addCustomField(parsedImage[0], parsedImage[1]);
                }
                ++count;
            }
        }
        return count;
    }

    protected void setAsUIEvent(ToolMessage msg, String id) {
        msg.setEventElement((EventElement)new UiEventElement(id, this.calcSemanticEvt()));
    }

    private String calcSemanticEvt() {
        String semanticEvtName = msgTypeToSemanticEvt.get(this.getMessageType());
        if (semanticEvtName != null) {
            return semanticEvtName;
        }
        if ("InterfaceAction".equalsIgnoreCase(this.getMessageType())) {
            if (DataShopMessageObject.isHintMsg(this)) {
                return HINT_REQUEST;
            }
            return "ATTEMPT";
        }
        if ("AssociatedRules".equalsIgnoreCase(this.getMessageType())) {
            if (DataShopMessageObject.isHintMsg(this)) {
                return "HINT_MSG";
            }
            return "RESULT";
        }
        trace.err("calcSemanticEvt(): no semantic event; using message type " + this.getMessageType());
        return this.getMessageType();
    }

    static boolean isHintMsg(MessageObject mo) {
        String selection0 = mo.getSelection0();
        if ("help".equalsIgnoreCase(selection0)) {
            return true;
        }
        if ("hint".equalsIgnoreCase(selection0)) {
            return true;
        }
        if ("NextHintButton".equalsIgnoreCase(selection0)) {
            return true;
        }
        return "PreviousHintButton".equalsIgnoreCase(selection0);
    }

    static boolean isUIEventMsg(MessageObject mo) {
        return uiEventMessageTypes.contains(mo.getMessageType().toLowerCase());
    }

    private void addStepId(TutorActionLogV4 logMsg) {
        Message msg = logMsg.getMsg();
        String stepId = (String)this.getProperty("StepID");
        if (stepId == null || stepId.length() < 1) {
            return;
        }
        if (msg instanceof TutorMessage) {
            ((TutorMessage)msg).addCustomField(STEP_ID, stepId);
        } else if (msg instanceof ToolMessage) {
            ((ToolMessage)msg).addCustomField(STEP_ID, stepId);
        }
    }

    protected void addTimeStamp(TutorActionLogV4 logMsg) {
        Message msg = logMsg.getMsg();
        Date ts = logMsg.getTimeStamp();
        String tsUTC = DataShopMessageObject.UTCTimeStamp(ts);
        if (msg instanceof TutorMessage) {
            ((TutorMessage)msg).addCustomField("tutor_event_time", tsUTC);
        } else if (msg instanceof ToolMessage) {
            ((ToolMessage)msg).addCustomField("tool_event_time", tsUTC);
        }
    }

    protected void populateHintElements(TutorActionLogV4 result) {
        List<String> adviceList;
        int h;
        Integer totalHints = this.getPropertyAsInteger("TotalHintsAvailable");
        Integer currentHintNumber = this.getPropertyAsInteger("CurrentHintNumber");
        if (trace.getDebugCode("mo")) {
            trace.out("mo", ", totalHints " + totalHints + ", currentHintNo " + currentHintNumber + ", actionEvaluation " + this.getActionEvaluation());
        }
        result.addActionEvaluation(this.getActionEvaluation(), currentHintNumber != null ? currentHintNumber : 1, totalHints != null ? totalHints : -1);
        if (trace.getDebugCode("mo")) {
            trace.out("hint num " + currentHintNumber + ", totalHints " + totalHints);
        }
        if ((h = (adviceList = this.createTutorAdvices()).size() - 1) >= currentHintNumber - 1) {
            h = currentHintNumber - 1;
        }
        if (trace.getDebugCode("mo")) {
            trace.out("adviceList.size " + adviceList.size() + ", adviceList[" + h + "]:\n  " + adviceList.get(h));
        }
        this.logMsg.addTutorAdvice(adviceList.get(h));
    }

    protected int createSkills(TutorActionLogV4 logMsg) {
        int result = 0;
        Vector skills = (Vector)this.getProperty("Skills");
        if (skills != null) {
            Iterator it = skills.iterator();
            while (it.hasNext()) {
                this.parseAndAddSkill((String)it.next(), logMsg);
                ++result;
            }
            return result;
        }
        Vector rules = (Vector)this.getProperty("Rules");
        if (rules != null) {
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                this.parseAndAddSkill((String)it.next(), logMsg);
                ++result;
            }
        }
        return result;
    }

    private void parseAndAddSkill(String text, TutorActionLogV4 logMsg) {
        int categoryIndex;
        String[] parts;
        String category = "";
        String probability = null;
        String sbDelim = (String)this.getProperty("skillBarDelimiter");
        if (sbDelim == null || sbDelim.length() < 1) {
            sbDelim = "=";
        }
        if ((parts = text.split(sbDelim)).length > 1) {
            probability = parts[1];
        }
        if ((categoryIndex = text.lastIndexOf(32) + 1) > 0) {
            category = parts[0].substring(categoryIndex);
            text = parts[0].substring(0, categoryIndex - 1);
        } else {
            text = parts[0];
        }
        logMsg.addSkill(text, category, probability);
    }

    protected List<String> createTutorAdvices() {
        Object v = this.getProperty("TutorAdvice");
        if (v == null) {
            v = this.getProperty("HintsMessage");
        }
        if (v == null) {
            return new ArrayList<String>();
        }
        if (v instanceof Vector) {
            Vector advices = (Vector)v;
            return new ArrayList<String>(advices);
        }
        if (v instanceof String) {
            ArrayList<String> result = new ArrayList<String>();
            result.add((String)v);
            return result;
        }
        throw new IllegalArgumentException("TutorAdvice property is unrecognized type " + v.getClass().getName());
    }

    protected void createEventDesc(TutorActionLogV4 logMsg) {
        Vector<String> inputs;
        Vector<String> actions;
        Iterator<String> sit = null;
        Iterator<String> ait = null;
        Iterator<String> iit = null;
        int n = 0;
        Vector<String> selections = this.getSelection();
        if (selections != null) {
            sit = selections.iterator();
            n = Math.max(n, selections.size());
        }
        if ((actions = this.getAction()) != null) {
            ait = actions.iterator();
            n = Math.max(n, actions.size());
        }
        if ((inputs = this.getInput()) != null) {
            iit = inputs.iterator();
            n = Math.max(n, inputs.size());
        }
        for (int i = 0; i < n; ++i) {
            String ac = ait != null && ait.hasNext() ? ait.next() : "";
            String se = sit != null && sit.hasNext() ? sit.next() : "";
            String in = iit != null && iit.hasNext() ? iit.next() : "";
            logMsg.addEventDescriptor(this.getTransactionId(), ac, se, in);
        }
    }

    protected void setResponseType(String actionEvaluation, TutorMessage msg) {
        if (actionEvaluation == null) {
            trace.err("DataShopMessageObject: null action evaluation for tutor response");
            return;
        }
        if ("CORRECT".equalsIgnoreCase(actionEvaluation) || "SUCCESS".equalsIgnoreCase(actionEvaluation)) {
            msg.setAsCorrectAttemptResponse();
        } else if ("INCORRECT".equalsIgnoreCase(actionEvaluation) || "BUG".equalsIgnoreCase(actionEvaluation) || "NO-MODEL".equalsIgnoreCase(actionEvaluation) || "FIREABLE-BUG".equalsIgnoreCase(actionEvaluation)) {
            msg.setAsIncorrectAttemptResponse();
        } else if (HintPattern.matcher(actionEvaluation).matches()) {
            msg.setAsHintResponse(actionEvaluation);
        } else {
            trace.err("ConvV4: no response type for action evaluation " + actionEvaluation);
        }
    }

    private ToolMessage getLastToolMessage(LogContext logger) {
        ToolMessage result = logger.getLastToolMessage();
        if (result != null) {
            return result;
        }
        result = ToolMessage.create((ContextMessage)logger.getContextMessage());
        result.setAsAttempt();
        return result;
    }

    private TutorActionLogV4 createContextMessage() {
        ContextMessage msg = this.logger.getContextMessage(START_PROBLEM);
        TutorActionLogV4 result = new TutorActionLogV4(msg);
        if (this.replay != null) {
            result.setReplay(this.replay);
        }
        return result;
    }

    private TutorActionLogV4 createPlainMessage() {
        PlainMessage msg = PlainMessage.create((ContextMessage)this.logger.getContextMessage());
        TutorActionLogV4 result = new TutorActionLogV4(msg);
        this.populateProperties(this, result);
        if (this.replay != null) {
            result.setReplay(this.replay);
        }
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "createPlainMessage() " + result.toString());
        }
        return result;
    }

    protected void populateProperties(MessageObject mo, TutorActionLogV4 result) {
        String verb = mo.getVerb();
        if (verb != null && verb.length() > 0) {
            result.addMsgProperty("verb", verb);
        }
        List<String> propertyNames = this.getPropertyNames();
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "propertyNames.size() " + propertyNames.size());
        }
        for (int i = 0; i < propertyNames.size(); ++i) {
            String name = propertyNames.get(i);
            trace.out("log", "name = " + name);
            Object value = this.getProperty(name);
            trace.out("log", "value = " + value);
            if (value instanceof List) {
                result.addMsgProperty(name, (List)value);
                continue;
            }
            result.addMsgProperty(name, value.toString());
        }
    }

    private Class whichDataShopMsgType() {
        if (this.getMessageType() == null) {
            return PlainMessage.class;
        }
        String msgType = this.getMessageType().toLowerCase();
        if (tutorOnlyMessageTypes.contains(msgType) && this.tutorToTool) {
            return TutorMessage.class;
        }
        if (toolOnlyMessageTypes.contains(msgType)) {
            if (!this.tutorToTool) {
                return ToolMessage.class;
            }
            String subtype = (String)this.getProperty("subtype");
            if ("tutor-performed".equalsIgnoreCase(subtype)) {
                return ToolMessage.class;
            }
        }
        if (contextMessageTypes.contains(msgType)) {
            return ContextMessage.class;
        }
        return PlainMessage.class;
    }

    protected void setLogMsg(TutorActionLogV4 logMsg) {
        this.logMsg = logMsg;
    }

    public String getContextMessageId() {
        return this.getLogMsg().getContextMessageId();
    }

    public Date getTimeStamp() {
        return this.getLogMsg().getTimeStamp();
    }

    public static String UTCTimeStamp(Date ts) {
        String tsUTC = UTCTimeStampDateFmt.format(ts);
        if (trace.getDebugCode("log")) {
            trace.out("log", "Convert from \"" + ts + "\" => " + tsUTC);
        }
        return tsUTC;
    }

    public void setOriginalElementString(String eltStr) {
        this.originalElementString = eltStr;
    }

    public String getOriginalElementString() {
        return this.originalElementString;
    }

    protected void OLI2Native(TutorActionLog logMsg) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "DataShopMessageObject(" + (Object)((Object)logMsg) + ") class " + ((Object)((Object)logMsg)).getClass().getSimpleName());
        }
        TutorActionLogV4 logV4 = null;
        if (logMsg instanceof TutorActionLogV4 && (logV4 = (TutorActionLogV4)logMsg).getReplay() != null) {
            this.setProperty("replay", logV4.getReplay());
        }
        if (HINT_REQUEST.equals(this.getSemanticEvt(logMsg))) {
            this.createPropertyList(logMsg);
            this.setMessageType("InterfaceAction");
            this.reviseSAIForHintRequest();
        } else {
            if ("tool_message".equals(logMsg.getTopElementType())) {
                this.setMessageType("InterfaceAction");
            } else if ("tutor_message".equals(logMsg.getTopElementType())) {
                this.setMessageType("AssociatedRules");
            }
            this.createPropertyList(logMsg);
        }
        if (logMsg instanceof TutorActionLogV4) {
            this.logMsg = (TutorActionLogV4)logMsg;
        }
    }

    private void reviseSAIForHintRequest() {
        String action0 = this.getAction0();
        if ("ButtonPressed".equalsIgnoreCase(action0)) {
            return;
        }
        Vector<String> selections = this.getSelection();
        Vector<String> actions = this.getAction();
        Vector<String> inputs = this.getInput();
        if (selections == null) {
            selections = new Vector();
        }
        if (actions == null) {
            actions = new Vector();
        }
        if (inputs == null) {
            inputs = new Vector();
        }
        selections.add(0, "Hint");
        actions.add(0, "ButtonPressed");
        inputs.add(0, "-1");
        this.setSelection(selections);
        this.setAction(actions);
        this.setInput(inputs);
    }

    protected void createPropertyList(TutorActionLog logMsg) {
        Iterator it;
        this.setProblemName(logMsg.getProblemName());
        String tid = logMsg.getTransactionId();
        if (tid != null && tid.length() > 0) {
            this.setTransactionId(tid);
        }
        if ((it = logMsg.actionEvaluationsIterator()).hasNext()) {
            TutorActionLog.ActionEvaluation ae = (TutorActionLog.ActionEvaluation)it.next();
            this.setProperty("Indicator", ae.getText().trim());
        }
        if ((it = logMsg.eventDescriptorsIterator()).hasNext()) {
            Vector<String> selections = new Vector<String>();
            Vector<String> actions = new Vector<String>();
            Vector<String> inputs = new Vector<String>();
            do {
                TutorActionLog.EventDescriptor ed = (TutorActionLog.EventDescriptor)it.next();
                selections.addAll(DataShopMessageObject.makeStringVector(ed.getSelections()));
                actions.addAll(DataShopMessageObject.makeStringVector(ed.getActions()));
                inputs.addAll(DataShopMessageObject.makeStringVector(ed.getInputs()));
            } while (it.hasNext());
            this.setSelection(selections);
            this.setAction(actions);
            this.setInput(inputs);
        }
        if ((it = logMsg.tutorAdvicesIterator()).hasNext()) {
            Serializable advices;
            if (this.getSemanticEvt(logMsg) != null && this.getSemanticEvt(logMsg).toLowerCase().contains("hint")) {
                advices = new Vector();
                do {
                    ((Vector)advices).add(it.next());
                } while (it.hasNext());
                this.setProperty("TutorAdvice", advices);
            } else {
                advices = new StringBuffer((String)it.next());
                while (it.hasNext()) {
                    ((StringBuffer)advices).append(' ').append(it.next());
                }
                this.setProperty("TutorAdvice", DataShopMessageObject.s2v(((StringBuffer)advices).toString()));
            }
        }
        if (!(logMsg instanceof TutorActionLogV4)) {
            it = logMsg.skillsIterator();
            if (it.hasNext()) {
                Vector<String> ruleNames = new Vector<String>();
                do {
                    TutorActionLog.Skill skill = (TutorActionLog.Skill)it.next();
                    ruleNames.add(skill.text);
                } while (it.hasNext());
                this.setProperty("Rules", ruleNames);
            }
            return;
        }
        Message msg = ((TutorActionLogV4)logMsg).getMsg();
        if (msg instanceof TutorMessage) {
            Vector<String> skills = new Vector<String>();
            Vector<String> ruleNames = new Vector<String>();
            List skillList = ((TutorMessage)msg).getSkillList();
            for (SkillElement skill : skillList) {
                String category;
                String name = skill.getName();
                if (name == null || name.length() < 1) {
                    name = "unnamed";
                }
                if ((category = skill.getCategory()) != null && category.length() > 0) {
                    name = name + " " + category;
                }
                if (name == null || name.trim().length() < 1) {
                    name = "unnamed";
                }
                ruleNames.add(name);
                if ("unnamed".equalsIgnoreCase(name)) continue;
                try {
                    String probability = skill.getProbability();
                    float p = Float.parseFloat(probability);
                    skills.add(name + "=" + probability + "=" + "0");
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (ruleNames.size() > 0) {
                this.setProperty("Rules", ruleNames);
            }
            if (skills.size() > 0) {
                this.setProperty("Skills", ruleNames);
            }
        }
    }

    private String getSemanticEvt(TutorActionLog logMsg) {
        if (logMsg == null) {
            return null;
        }
        TutorActionLog.SemanticEvent se = logMsg.getSemanticEvent(null);
        if (se == null) {
            return null;
        }
        return se.getName();
    }

    public static Vector makeStringVector(List list) {
        Vector<String> result = new Vector<String>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            result.add(((TutorActionLog.TextIsString)it.next()).toString());
        }
        if (result.size() < 1) {
            result.add("");
        }
        return result;
    }

    public String getUserId() {
        return this.getLogMsg().getUserGuid();
    }

    public void setUserId(String userId) {
        this.getLogMsg().setUserGuid(userId);
    }

    public String getSessionId() {
        return this.getLogMsg().getSessionId();
    }

    public void setSessionId(String sessionId) {
        this.getLogMsg().setSessionId(sessionId);
    }

    public void setTimeStamp(Date timeStamp) {
        this.getLogMsg().setTimeStamp(timeStamp);
    }

    public String getProblemName() {
        return this.problemName;
    }

    void setProblemName(String newProblemName) {
        this.setProperty("problem_name", newProblemName);
        this.problemName = newProblemName;
    }

    static {
        for (int i = 0; i < msgTypeToSemanticEvtArr.length; ++i) {
            msgTypeToSemanticEvt.put(msgTypeToSemanticEvtArr[i][0], msgTypeToSemanticEvtArr[i][1]);
        }
        HintPattern = Pattern.compile(".*[hH][iI][nN][tT].*");
        UTCTimeStampDateFmt = new SimpleDateFormat(UTCTimeStampFmt);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        UTCTimeStampDateFmt.setTimeZone(tz);
    }
}

