/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.pact.Log.DataShopMessageObject;
import edu.cmu.pact.Utilities.ProblemNameParser;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.TutorMessage;
import edu.cmu.pslc.logging.element.ActionEvaluationElement;
import edu.cmu.pslc.logging.element.EventElement;
import edu.cmu.pslc.logging.element.MetaElement;
import edu.cmu.pslc.logging.element.SemanticEventElement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class DataShopReader {
    static final DateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private BufferedReader fr;
    private ArrayList<ArrayList<DataShopMessageObject>> replayUnitList;
    private ProblemNameParser pnparse;
    private ArrayList<ArrayList<String>> replayUnitNames = new ArrayList();

    public DataShopReader(String datashopFile, String brdFile, String brdLocation) throws IOException {
        this.replayUnitList = this.init(datashopFile, brdFile, brdLocation);
    }

    private ArrayList<ArrayList<DataShopMessageObject>> init(String fileName, String fileName2, String brdLocation) throws IOException {
        ContextMessage context;
        String[] header;
        this.pnparse = new ProblemNameParser(fileName2, brdLocation);
        String xmlOutput = "";
        ArrayList<DataShopMessageObject> replaySingleton = new ArrayList<DataShopMessageObject>();
        ArrayList<ArrayList<DataShopMessageObject>> replayUnitList = new ArrayList<ArrayList<DataShopMessageObject>>();
        String userID = "";
        String levelAssi = "";
        String levelSet = "";
        String probName = "";
        String probView = "";
        String sessionID = "";
        String timeString = "";
        String schoolName = "";
        String className = "";
        String condName = "";
        String condType = "";
        HashMap<Object, Object> mapRow = new HashMap<String, String>();
        List<HashMap<String, String>> listToSort = new ArrayList<HashMap<String, String>>();
        try {
            this.fr = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            trace.out("log", "Unable to read DataShop file.");
        }
        String keyRow = this.fr.readLine();
        if (keyRow != null) {
            String row;
            header = keyRow.split("\t");
            context = ContextMessage.create((String)"", null);
            while ((row = this.fr.readLine()) != null) {
                String[] values = row.split("\t");
                mapRow = new HashMap();
                for (int i = 0; i < values.length; ++i) {
                    if (header[i].equalsIgnoreCase("CF (tool_event_time)") || header[i].equalsIgnoreCase("CF (tutor_event_time)")) {
                        try {
                            String noSlashesDate = values[i].replaceAll("/", "-");
                            Date d = formatTime.parse(noSlashesDate);
                            String newValDate = formatTime.format(d);
                            mapRow.put(header[i], newValDate);
                        }
                        catch (ParseException e) {
                            trace.out("log", "Error in parsing the date");
                        }
                        continue;
                    }
                    mapRow.put(header[i], values[i]);
                }
                listToSort.add(mapRow);
            }
        } else {
            this.fr.close();
            throw new IllegalArgumentException("stream is empty");
        }
        listToSort = this.sort(listToSort, "Session Id");
        listToSort = this.sortTime(listToSort);
        listToSort = this.sortStudent(listToSort);
        listToSort = this.checkConditionField(listToSort);
        for (int j = 0; j < listToSort.size(); ++j) {
            String timestamp;
            mapRow = listToSort.get(j);
            xmlOutput = "";
            sessionID = (String)mapRow.get("Session Id");
            userID = (String)mapRow.get("Anon Student Id");
            levelAssi = (String)mapRow.get("Level (" + DataShopReader.getDatasetLevelType(1) + ")");
            levelSet = (String)mapRow.get("Level (" + DataShopReader.getDatasetLevelType(2) + ")");
            probName = (String)mapRow.get("Problem Name");
            probView = (String)mapRow.get("Problem View");
            timeString = (String)mapRow.get("CF (tool_event_time)");
            schoolName = (String)mapRow.get("School");
            className = (String)mapRow.get("Class");
            condName = (String)mapRow.get("Condition Name");
            condType = (String)mapRow.get("Condition Type");
            if (!(!this.replayUnitNames.isEmpty() && this.replayUnitNames.get(this.replayUnitNames.size() - 1).get(0).equalsIgnoreCase(sessionID) && this.replayUnitNames.get(this.replayUnitNames.size() - 1).get(1).equalsIgnoreCase(userID) && this.replayUnitNames.get(this.replayUnitNames.size() - 1).get(2).equalsIgnoreCase(levelAssi) && this.replayUnitNames.get(this.replayUnitNames.size() - 1).get(3).equalsIgnoreCase(levelSet) && this.replayUnitNames.get(this.replayUnitNames.size() - 1).get(4).equalsIgnoreCase(probName) && this.replayUnitNames.get(this.replayUnitNames.size() - 1).get(5).equalsIgnoreCase(probView))) {
                replayUnitList.add(replaySingleton);
                replaySingleton = new ArrayList();
                ArrayList<String> unit = new ArrayList<String>();
                unit.add(0, sessionID);
                unit.add(1, userID);
                unit.add(2, levelAssi);
                unit.add(3, levelSet);
                unit.add(4, probName);
                unit.add(5, probView);
                unit.add(6, timeString);
                unit.add(7, schoolName);
                unit.add(8, className);
                unit.add(9, condName);
                unit.add(10, condType);
                this.replayUnitNames.add(unit);
            }
            if (((String)mapRow.get("Student Response Subtype")).equalsIgnoreCase("tutor-performed")) continue;
            MetaElement meta = new MetaElement((String)mapRow.get("Anon Student Id"), (String)mapRow.get("Session Id"), (String)mapRow.get("Time"), (String)mapRow.get("Time Zone"));
            xmlOutput = xmlOutput + "<tutor_related_message_sequence version_number=\"4\">";
            context = ContextMessage.create((String)((String)mapRow.get("Problem Name")), (MetaElement)meta);
            if (!meta.getTime().equalsIgnoreCase(context.getTimeString())) {
                meta.setTime(context.getTimeString());
            }
            ToolMessage tool = ToolMessage.create((ContextMessage)context);
            tool.setProblemName((String)mapRow.get("Problem Name"));
            tool.addSai((String)mapRow.get("Selection"), (String)mapRow.get("Action"), (String)mapRow.get("Input"));
            if (trace.getDebugCode("dsr")) {
                trace.out("dsr", "DSR.init() tool.addSai(" + tool.getEventDescriptorElement() + ")");
            }
            timestamp = (timestamp = (String)mapRow.get("CF (tool_event_time)")) != "" ? timestamp : (String)mapRow.get("Time");
            String timezone = timestamp.trim().endsWith("UTC") ? "UTC" : (String)mapRow.get("Time Zone");
            String subtype = (String)mapRow.get("Student Response Subtype");
            String trigger = subtype != null && subtype.equalsIgnoreCase("tutor-performed") ? "DATA" : "USER";
            SemanticEventElement semevt = new SemanticEventElement((String)mapRow.get("Transaction Id"), (String)mapRow.get("Student Response Type"), trigger, subtype);
            tool.setEventElement((EventElement)semevt);
            xmlOutput = xmlOutput + tool.toString();
            if (!((String)mapRow.get("Outcome")).trim().equals("")) {
                TutorMessage tutor = TutorMessage.create((ToolMessage)tool);
                String stepName = (String)mapRow.get("Step Name");
                String action = stepName.substring(stepName.lastIndexOf(" ") + 1);
                String selection = stepName.substring(0, stepName.lastIndexOf(" ") + 1);
                String input = (String)mapRow.get("Input");
                tutor.addSai(selection, action, input);
                tutor.setActionEvaluationElement(new ActionEvaluationElement((String)mapRow.get("Feedback Text"), (String)mapRow.get("Help Level"), (String)mapRow.get("Total Num Hints"), (String)mapRow.get("Feedback Classification"), (String)mapRow.get("Outcome")));
                tutor.addTutorAdvice((String)mapRow.get("Feedback Text"));
                tutor.setProblemName((String)mapRow.get("Problem Name"));
                for (int i = 1; i < header.length; ++i) {
                    if (!header[i].startsWith("CF") || header[i].contains("tool_event_time")) continue;
                    if (header[i].contains("tutor_event_time")) {
                        tutor.setTimeString((String)mapRow.get(header[i]));
                        continue;
                    }
                    tutor.addCustomField(header[i].substring(header[i].indexOf("(") + 1, header[i].indexOf(")")), (String)mapRow.get(header[i]));
                }
                xmlOutput = xmlOutput + tutor.toString();
            }
            xmlOutput = xmlOutput + "</tutor_related_message_sequence>";
            DataShopMessageObject obj = new DataShopMessageObject(xmlOutput, null);
            obj.setProperty("Time", timestamp);
            obj.setProperty("TimeZone", timezone);
            File brdPath = null;
            ProblemNameParser.ProblemBundle pb = null;
            try {
                pb = this.pnparse.findBundle(probName, levelAssi, levelSet);
                if (pb == null) continue;
                brdPath = new File(new URL(pb.getBRD()).getPath());
            }
            catch (Exception e) {
                trace.errStack("DSR.init() on URL from " + pb + "=PNP.findBundle(" + probName + ", " + levelAssi + ", " + levelSet + ")", e);
                try {
                    brdPath = new File(pb.getBRD());
                }
                catch (Exception e2) {
                    trace.errStack("DSR.init() on PNP.findBundle(" + probName + ", " + levelAssi + ", " + levelSet + ")", e2);
                    throw e2;
                }
            }
            String brdFile = brdPath.getName().replaceAll("[.]brd$", "");
            obj.setProperty("question_file", brdFile);
            if (trace.getDebugCode("dsr")) {
                trace.out("dsr", "DSR.init() DSMO[" + obj + "]");
            }
            replaySingleton.add(obj);
        }
        this.fr.close();
        replayUnitList.add(replaySingleton);
        return replayUnitList;
    }

    private List<HashMap<String, String>> sortStudent(List<HashMap<String, String>> listToSort) {
        HashMap map = new HashMap();
        ArrayList<HashMap<String, String>> group = new ArrayList<HashMap<String, String>>();
        String currSess = listToSort.get(0).get("Anon Student Id");
        String currUser = listToSort.get(0).get("Session Id");
        for (int i = 0; i < listToSort.size(); ++i) {
            String userid = listToSort.get(i).get("Anon Student Id");
            String sessid = listToSort.get(i).get("Session Id");
            if (userid.equals(currUser) && sessid.equals(currSess) && i != listToSort.size() - 1) {
                group.add(listToSort.get(i));
                continue;
            }
            if (!map.containsKey(currUser)) {
                map.put(currUser, new ArrayList());
            }
            for (int j = 0; j < group.size(); ++j) {
                ((ArrayList)map.get(currUser)).add(group.get(j));
            }
            currUser = userid;
            currSess = sessid;
            group = new ArrayList();
            group.add(listToSort.get(i));
        }
        Object[] students = map.keySet().toArray();
        ArrayList<HashMap<String, String>> ret = new ArrayList<HashMap<String, String>>();
        for (int i = 0; i < students.length; ++i) {
            String key = (String)students[i];
            List<HashMap<String, String>> units = (List<HashMap<String, String>>)map.get(key);
            units = this.sort(units, "CF (tool_event_time)");
            for (int j = 0; j < units.size(); ++j) {
                ret.add(units.get(j));
            }
        }
        return ret;
    }

    private List<HashMap<String, String>> checkConditionField(List<HashMap<String, String>> listToSort) {
        boolean deleteCol = false;
        for (int i = 0; i < listToSort.size(); ++i) {
            HashMap<String, String> mapRow = listToSort.get(i);
            String condName = mapRow.get("Condition Name");
            if (condName == null) {
                deleteCol = true;
                break;
            }
            if (!condName.equals("")) continue;
            deleteCol = true;
            break;
        }
        if (!deleteCol) {
            return listToSort;
        }
        for (int j = 0; j < listToSort.size(); ++j) {
            listToSort.get(j).remove("Condition Name");
            listToSort.get(j).remove("Condition Type");
        }
        return listToSort;
    }

    public static boolean makeChunk(int numChunks, int numRows, int index, int partitions) {
        int chunkSize = numRows / partitions;
        int n = chunkSize * (numChunks + 1);
        return index > n;
    }

    static String getDatasetLevelType(int level) {
        try {
            switch (level) {
                case 1: {
                    return "Assignment";
                }
                case 2: {
                    return "ProblemSet";
                }
            }
            throw new IllegalArgumentException("Undefined dataset level index " + level + "; should be in range [1,2]");
        }
        catch (Exception e) {
            trace.errStack("Error in DataShopReader.getDatasetLevelType(): " + e, e);
            return "";
        }
    }

    public ArrayList<ArrayList<String>> getreplayUnitNames() {
        return this.replayUnitNames;
    }

    public ArrayList<ArrayList<DataShopMessageObject>> getReplayUnitList() {
        return this.replayUnitList;
    }

    public String createTempFile(int index) {
        ArrayList<DataShopMessageObject> session = this.replayUnitList.get(index + 1);
        String dir = System.getProperty("user.dir");
        File newFile = new File(dir + File.separator + "temp" + File.separator);
        newFile.mkdir();
        String fileName = newFile.getAbsolutePath() + File.separator + "temp.xml";
        try {
            BufferedWriter wr = new BufferedWriter(new FileWriter(fileName));
            wr.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            wr.append("<root>");
            for (int i = 0; i < session.size(); ++i) {
                wr.append(session.get(i).toString());
            }
            wr.append("</root>");
            wr.close();
        }
        catch (IOException e) {
            trace.out("log", "could not write to temporary file");
        }
        return fileName;
    }

    public ProblemNameParser getParser() {
        return this.pnparse;
    }

    public ProblemNameParser.ProblemBundle grabProblemBundle(String probName, String levelAssi, String probSet) {
        return this.pnparse.findBundle(probName, levelAssi, probSet);
    }

    private List<HashMap<String, String>> sort(List<HashMap<String, String>> list, String parameter) {
        if (list.size() == 0 || list.size() == 1) {
            return list;
        }
        List<HashMap<String, String>> left = this.sort(list.subList(0, list.size() / 2), parameter);
        List<HashMap<String, String>> right = this.sort(list.subList(list.size() / 2, list.size()), parameter);
        return this.merge(left, right, parameter);
    }

    private List<HashMap<String, String>> sortTime(List<HashMap<String, String>> list) {
        if (list.size() == 0 || list.size() == 1) {
            return list;
        }
        int start = 0;
        int end = 0;
        HashMap<String, String> curr = null;
        List<HashMap<String, String>> temp = null;
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        String session = "";
        session = list.get(0).get("Session Id");
        for (int i = 0; i < list.size(); ++i) {
            curr = list.get(i);
            if (curr.get("Session Id").equalsIgnoreCase(session)) continue;
            session = curr.get("Session Id");
            end = i;
            temp = this.sort(list.subList(start, end), "CF (tool_event_time)");
            result.addAll(temp);
            if (trace.getDebugCode("dsr")) {
                trace.out("dsr", "DSR.sortTime() sublist[" + start + "," + end + "] size " + temp.size());
            }
            start = i;
        }
        temp = this.sort(list.subList(start, list.size()), "CF (tool_event_time)");
        result.addAll(temp);
        if (trace.getDebugCode("dsr")) {
            trace.out("dsr", "DSR.sortTime() sublist[" + start + "," + list.size() + "] size " + temp.size());
        }
        return result;
    }

    private List<HashMap<String, String>> merge(List<HashMap<String, String>> list1, List<HashMap<String, String>> list2, String parameter) {
        ArrayList<HashMap<String, String>> result;
        block6: {
            int j;
            block5: {
                int i = 0;
                j = 0;
                result = new ArrayList<HashMap<String, String>>();
                while (i < list1.size() && j < list2.size()) {
                    if (list1.get(i).get(parameter).compareToIgnoreCase(list2.get(j).get(parameter)) < 0) {
                        result.add(list1.get(i));
                        ++i;
                        continue;
                    }
                    if (list1.get(i).get(parameter).compareToIgnoreCase(list2.get(j).get(parameter)) > 0) {
                        result.add(list2.get(j));
                        ++j;
                        continue;
                    }
                    result.add(list1.get(i));
                    result.add(list2.get(j));
                    ++i;
                    ++j;
                }
                if (i >= list1.size()) break block5;
                while (i < list1.size()) {
                    result.add(list1.get(i));
                    ++i;
                }
                break block6;
            }
            if (j >= list2.size()) break block6;
            while (j < list2.size()) {
                result.add(list2.get(j));
                ++j;
            }
        }
        return result;
    }
}

