/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.pact.Log.TutorActionLog;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pslc.logging.AbstractMessageLogger;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.Message;
import edu.cmu.pslc.logging.PlainMessage;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.TutorMessage;
import edu.cmu.pslc.logging.element.ActionEvaluationElement;
import edu.cmu.pslc.logging.element.EventElement;
import edu.cmu.pslc.logging.element.MetaElement;
import edu.cmu.pslc.logging.element.PropertyElement;
import edu.cmu.pslc.logging.element.SemanticEventElement;
import edu.cmu.pslc.logging.element.SkillElement;
import java.rmi.server.UID;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class TutorActionLogV4
extends TutorActionLog {
    private String replay;
    public static final String REPLAY = "replay";
    public static final String VERSION_NUMBER = "4";
    private DTDv4Logger dtdV4Logger = new DTDv4Logger();

    static String generateGUID() {
        UID uid = new UID();
        return "T" + uid.toString();
    }

    public TutorActionLogV4(ContextMessage contextMessage) {
        super("context_message");
        this.msg = contextMessage;
    }

    public TutorActionLogV4(ToolMessage toolMessage) {
        super("tool_message");
        this.msg = toolMessage;
    }

    public TutorActionLogV4(TutorMessage tutorMessage) {
        super("tutor_message");
        this.msg = tutorMessage;
    }

    public TutorActionLogV4(PlainMessage plainMessage) {
        super("message");
        this.msg = plainMessage;
    }

    public TutorActionLogV4(Element elt, MetaElement meta) {
        super(elt, meta);
    }

    @Override
    public String getDTDVersionNumber() {
        return VERSION_NUMBER;
    }

    @Override
    protected void parseSkills(Element msgElt, Namespace ns) throws JDOMException {
        Iterator it = msgElt.getChildren("skill", ns).iterator();
        if (it.hasNext()) {
            this.skills = new LinkedList();
            do {
                Element categoryElt;
                String name = "unnamed";
                String category = "";
                Element e = (Element)it.next();
                Element nameElt = e.getChild("name", ns);
                if (nameElt != null && nameElt.getTextNormalize().length() > 0) {
                    name = nameElt.getTextNormalize();
                }
                if ((categoryElt = e.getChild("category", ns)) != null) {
                    category = categoryElt.getTextNormalize();
                }
                SkillElement skillElt = new SkillElement(name, category);
                if (category.length() > 0) {
                    name = categoryElt.getTextNormalize() + " " + name;
                }
                String probability = e.getAttributeValue("probability", ns);
                skillElt.setProbability(probability);
                ((TutorMessage)this.getMsg()).addSkill(skillElt);
                this.skills.add(new TutorActionLog.Skill(name, probability));
            } while (it.hasNext());
        }
    }

    @Override
    public void addMsgProperty(String name, String stringValue) {
        ((PlainMessage)this.getMsg()).addProperty(name, stringValue);
    }

    @Override
    public void addMsgProperty(String name, List list) {
        PropertyElement pe = new PropertyElement(name, list);
        ((PlainMessage)this.getMsg()).addProperty(pe);
    }

    @Override
    public String getInfo() {
        return this.dtdV4Logger.getInfo(this.msg);
    }

    @Override
    public String toString() {
        return this.getInfo();
    }

    @Override
    protected void setTopElementType(String topElementType) {
        trace.out("log", "called V4 setTopElementType");
        if ("tool_message".equalsIgnoreCase(topElementType)) {
            this.topElementType = "tool_message";
        } else if ("tutor_message".equalsIgnoreCase(topElementType)) {
            this.topElementType = "tutor_message";
        } else if ("context_message".equalsIgnoreCase(topElementType)) {
            this.topElementType = "context_message";
        } else if ("message".equalsIgnoreCase(topElementType)) {
            this.topElementType = "message";
        } else {
            throw new IllegalArgumentException("Undefined element type: " + topElementType);
        }
    }

    public Message getMsg() {
        return this.msg;
    }

    @Override
    public void setProblemName(String name) {
        if (this.getMsg() instanceof ToolMessage) {
            ((ToolMessage)this.getMsg()).setProblemName(name);
        } else if (this.getMsg() instanceof TutorMessage) {
            ((TutorMessage)this.getMsg()).setProblemName(name);
        }
    }

    @Override
    public String addEventDescriptor(String dummySemanticEvtId, String ac, String se, String in) {
        if (this.getMsg() instanceof ToolMessage) {
            ((ToolMessage)this.getMsg()).addSai(se, ac, in);
        } else if (this.getMsg() instanceof TutorMessage) {
            ((TutorMessage)this.getMsg()).addSai(se, ac, in);
        }
        return dummySemanticEvtId;
    }

    @Override
    public void addTutorAdvice(String text) {
        TutorMessage msg = (TutorMessage)this.getMsg();
        msg.addTutorAdvice(text);
    }

    @Override
    public void addActionEvaluation(String text, String currentHintNumber, String totalHintsAvailable) {
        ActionEvaluationElement aee = new ActionEvaluationElement(currentHintNumber, totalHintsAvailable, null, null, text);
        TutorMessage msg = (TutorMessage)this.getMsg();
        msg.setActionEvaluationElement(aee);
    }

    public void addSkill(String name, String category, String probability) {
        TutorMessage msg = (TutorMessage)this.getMsg();
        SkillElement skill = new SkillElement(name, category);
        if (probability != null) {
            skill.setProbability(probability);
        }
        msg.addSkill(skill);
    }

    public String getContextMessageId() {
        if (this.getMsg() != null) {
            return this.getMsg().getContextMessageId();
        }
        return null;
    }

    @Override
    public String getTransactionId() {
        EventElement ee = null;
        if (this.getMsg() instanceof TutorMessage) {
            ee = ((TutorMessage)this.getMsg()).getEventElement();
        } else if (this.getMsg() instanceof ToolMessage) {
            ee = ((ToolMessage)this.getMsg()).getEventElement();
        }
        if (ee instanceof SemanticEventElement) {
            return ((SemanticEventElement)ee).getTransactionId();
        }
        return null;
    }

    public String getReplay() {
        return this.replay;
    }

    public void setReplay(String newReplay) {
        this.replay = newReplay;
    }

    @Override
    protected void parseCommonContent(Element msgElt, Namespace ns) throws JDOMException {
        super.parseCommonContent(msgElt, ns);
        List elts = msgElt.getChildren(REPLAY);
        trace.out("log", "TutorActionLogV4.parseCommonContent(" + this.msg + "," + msgElt.getName() + ") " + REPLAY + " count " + elts.size());
        Iterator it = elts.iterator();
        if (it.hasNext()) {
            this.setReplay(((Element)it.next()).getText());
        }
    }

    private class DTDv4Logger
    extends AbstractMessageLogger {
        DTDv4Logger() {
            super("UTF-8");
        }

        public boolean log(Message msg) {
            return this.log(msg, null);
        }

        public boolean log(String authToken, Message msg) {
            return this.log(msg, null);
        }

        public boolean log(String authToken, Message msg, Date date) {
            return this.log(msg, null);
        }

        public boolean log(Message msg, Date date) {
            return false;
        }

        public void close() {
        }

        public String getInfo(Message msg) {
            return this.getOpenXml() + msg.toString(false) + this.getCloseXml();
        }
    }
}

