/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Preferences;

import edu.cmu.pact.Preferences.GroupNode;
import edu.cmu.pact.Utilities.EmptyIterator;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PreferencesModel {
    public static final int INSTALLATION_SCOPE = 3;
    public static final int INTERFACE_SCOPE = 2;
    public static final int PROBLEM_SCOPE = 1;
    public static final int AUTHOR_SCOPE = 0;
    public static final String[] scopeNameToNumberTable = new String[]{"AUTHOR", "PROBLEM", "INTERFACE", "INSTALLATION"};
    private static final int MAX_SCOPE = 3;
    private static final int MIN_SCOPE = 0;
    private static final int DEFAULT_SCOPE = 0;
    public static final String TOP_ELEMENT_NAME = "preferences";
    public static final String CAT_ELEMENT_NAME = "category";
    public static final String PREF_ELEMENT_NAME = "preference";
    public static final String NAME_NAME = "name";
    public static final String CLS_NAME = "class";
    public static final String VALUE_NAME = "value";
    public static final String SCOPE_NAME = "scope";
    public static final String EDITOR_LABEL_NAME = "editor_label";
    public static final String DESCRIPTION_NAME = "description";
    public static final String TOOLTIP_NAME = "tooltip";
    public static final String INSTALLATION_PREF_FILENAME = "InstallationPreferences.xml";
    private static final String DEFAULT_CATEGORY = "General";
    private static String instanceSync = "instanceSync";
    private static volatile PreferencesModel instance = null;
    private List<Map<String, Preference>> tableList = null;
    private GroupNode displayRoot = null;
    private PropertyChangeSupport listeners = null;
    private static final String PREFERENCES_DIR = "${user.home}" + File.separator + ".ctat";
    private static final String PREFERENCES_FILE = "brPrefs.xml";
    private File docFile = PreferencesModel.makePrefFile(PREFERENCES_DIR + File.separator + "brPrefs.xml", false);
    private boolean preventSaves = false;
    private String latestCategory = "General";
    private static final Pattern sysPropPattern = Pattern.compile("[$][{]([^${}]+)[}]");

    static File makePrefFile(String path, boolean create) {
        if (trace.getDebugCode("prefs")) {
            trace.printStack("prefs", "makePrefFile(" + path + ")");
        }
        if (path == null || path.length() < 1) {
            return null;
        }
        try {
            Matcher m = sysPropPattern.matcher(path);
            if (trace.getDebugCode("prefs")) {
                boolean matched = m.find();
                trace.out("prefs", "makePrefFile(" + path + ") matched " + matched + (matched ? "[" + m.start() + "," + m.end() + "]" : ""));
                m.reset();
            }
            StringBuilder sb = new StringBuilder();
            int end = 0;
            while (m.find()) {
                sb.append(path.substring(end, m.start()));
                sb.append(System.getProperty(path.substring(m.start(1), m.end(1)), "."));
                end = m.end();
            }
            sb.append(path.substring(end));
            File result = new File(sb.toString());
            if (create) {
                if (!result.exists()) {
                    File parent = result.getParentFile();
                    if (parent != null && !parent.exists() && !parent.mkdirs()) {
                        throw new Exception("Could not create parent directory for preference file \"" + path + "\"");
                    }
                } else if (result.isDirectory()) {
                    throw new Exception("Path for preference file \"" + path + "\" is a directory.");
                }
            }
            if (trace.getDebugCode("prefs")) {
                trace.out("prefs", "makePrefFile(" + path + ") returning " + result);
            }
            return result;
        }
        catch (Exception e) {
            trace.err("Error creating file from path \"" + path + "\": " + e + "; cause: " + e.getCause());
            return null;
        }
    }

    public void setPreferenceFile(String filename) {
        File f = PreferencesModel.makePrefFile(filename, false);
        if (f != null) {
            this.docFile = f;
        }
    }

    public void setPreventSaves(boolean preventSaves) {
        if (trace.getDebugCode("applet")) {
            trace.printStack("applet", "PreferencesModel.setPreventSaves(" + preventSaves + ") old value " + this.preventSaves);
        }
        this.preventSaves = preventSaves;
    }

    PreferencesModel(int scope) {
        this(scope, (String)null);
    }

    PreferencesModel(String fileToRead) {
        this(0, fileToRead);
    }

    PreferencesModel(int scope, String fileToRead) {
        this.init(scope);
        this.loadFromDisk(scope, fileToRead);
        this.setPreventSaves(Utils.isRuntime());
    }

    PreferencesModel(int scope, URL urlToRead) {
        this.init(scope);
        this.loadFromURL(scope, urlToRead);
        this.setPreventSaves(Utils.isRuntime());
    }

    public PreferencesModel() {
        this(0, "");
        this.createMaxScopeInstance();
        this.setPreventSaves(Utils.isRuntime());
    }

    private void init(int scope) {
        if (scope < 0) {
            throw new IllegalArgumentException("given scope " + scope + " less than min " + 0);
        }
        if (scope > 3) {
            throw new IllegalArgumentException("given scope " + scope + " exceeds max " + 3);
        }
        if (this.tableList == null) {
            this.tableList = new ArrayList<Map<String, Preference>>(4);
            for (int i = 0; i <= 3; ++i) {
                this.tableList.add(null);
            }
        }
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.tableList.set(scope, new LinkedHashMap());
    }

    private void createMaxScopeInstance() {
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "createMaxScopeInstance tableList.size() " + this.tableList.size() + ", tableList.get(MAX) " + (this.tableList.size() <= 3 ? "" : this.tableList.get(3)));
        }
        if (this.tableList.size() > 3 && this.tableList.get(3) != null) {
            return;
        }
        URL url = Utils.getFileInSamePackage(this, INSTALLATION_PREF_FILENAME);
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "createMaxScopeInstance: url=" + url);
        }
        this.init(3);
        int nPrefs = this.loadFromURL(3, url);
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "createMaxScopeInstance: nPrefs " + nPrefs + "; EnableLogService " + this.getBooleanValue("EnableLogService"));
        }
    }

    public int loadFromDisk() {
        return this.loadFromDisk(0, null);
    }

    public int loadFromDisk(int scope, String fileToRead) {
        File f = PreferencesModel.makePrefFile(fileToRead, false);
        if (f != null) {
            this.docFile = f;
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(this.docFile);
        }
        catch (Exception e) {
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "error reading file " + this.docFile + ": " + e);
            }
            return 0;
        }
        return this.loadFromElement(scope, doc.getRootElement());
    }

    public int loadFromURL(int scope, URL url) {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        if (url == null) {
            return -1;
        }
        try {
            doc = builder.build(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            trace.err("error reading URL " + url + ": " + e);
            return 0;
        }
        return this.loadFromElement(scope, doc.getRootElement());
    }

    public int loadFromElement(int scope, Element topElt) {
        if (scope == 3) {
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "creating displayRoot");
            }
            this.displayRoot = new GroupNode("Category", null);
        }
        int result = this.loadFromElement(scope, topElt, this.displayRoot);
        return result;
    }

    private int loadFromElement(int scope, Element parentElt, GroupNode parentNode) {
        List elts = parentElt.getChildren();
        int count = 0;
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "parentElt name " + parentElt.getName());
        }
        for (Element elt : elts) {
            Map<String, Preference> table;
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "elt name " + elt.getName());
            }
            if (!PREF_ELEMENT_NAME.equals(elt.getName())) {
                String nodeId = elt.getAttributeValue(NAME_NAME);
                String descId = elt.getAttributeValue(DESCRIPTION_NAME);
                String tooltipId = elt.getAttributeValue(TOOLTIP_NAME);
                GroupNode node = null;
                node = tooltipId == null ? new GroupNode(nodeId, descId) : new GroupNode(nodeId, descId, tooltipId);
                if (parentNode != null) {
                    parentNode.add(node);
                }
                count += this.loadFromElement(scope, elt, node);
                continue;
            }
            Element prefElt = elt;
            String name = prefElt.getChild(NAME_NAME).getTextTrim();
            String clsName = prefElt.getChild(CLS_NAME).getTextTrim();
            String valStr = prefElt.getChild(VALUE_NAME).getTextTrim();
            String scopeStr = prefElt.getAttributeValue(SCOPE_NAME);
            Preference pref = null;
            int defaultScope = PreferencesModel.scopeNameToNumber(scopeStr);
            if (defaultScope < 0) {
                System.err.println("PreferencesModel: bad scope attribute " + scopeStr + " in file " + this.docFile);
            }
            Class<?> cls = null;
            try {
                cls = Class.forName(clsName);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    cls = this.getClass().getClassLoader().loadClass(clsName);
                }
                catch (ClassNotFoundException cnfe2) {
                    System.err.println("PreferencesModel: unknown class " + clsName + " in file " + this.docFile);
                    continue;
                }
            }
            try {
                if (cls.isEnum()) {
                    Method fromStringMethod = cls.getMethod("fromString", String.class);
                    pref = new Preference(name, (Enum)fromStringMethod.invoke(null, valStr));
                } else {
                    pref = Integer.class.getName().equals(clsName) ? new Preference(name, Integer.valueOf(valStr)) : (Boolean.class.getName().equals(clsName) ? new Preference(name, Boolean.valueOf(valStr)) : new Preference(name, cls, valStr));
                }
            }
            catch (Exception e) {
                System.err.println("PreferencesModel: error parsing value \"" + valStr + "\", class " + clsName + " in file " + this.docFile + ":\n " + e + (e.getCause() == null ? "" : ";\n cause: " + e.getCause()));
                continue;
            }
            Element extraInfo = prefElt.getChild(EDITOR_LABEL_NAME);
            if (extraInfo != null) {
                pref.editorLabel = extraInfo.getTextTrim();
            }
            if ((extraInfo = prefElt.getChild(DESCRIPTION_NAME)) != null) {
                pref.description = extraInfo.getTextTrim();
            }
            if ((extraInfo = prefElt.getChild(TOOLTIP_NAME)) != null) {
                pref.tooltip = extraInfo.getTextTrim();
            }
            if (defaultScope >= 0) {
                pref.defaultScope = defaultScope;
            }
            if ((table = this.tableList.get(scope)) == null) {
                this.init(scope);
                table = this.tableList.get(scope);
            }
            if (null == table.put(pref.name, pref)) {
                ++count;
            }
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "adding " + pref.name + " to " + (parentNode == null ? "null" : parentNode.getName()));
            }
            if (parentNode == null) continue;
            parentNode.add(pref);
        }
        return count;
    }

    public static int scopeNameToNumber(String scopeName) {
        if (scopeName == null) {
            return 0;
        }
        String n = scopeName.trim();
        if (n.length() < 1) {
            return 0;
        }
        n = n.toUpperCase();
        for (int i = 0; i < scopeNameToNumberTable.length; ++i) {
            if (!n.startsWith(scopeNameToNumberTable[i])) continue;
            return i;
        }
        return -1;
    }

    public int saveToDisk() {
        return this.saveToDisk(0, null);
    }

    public int saveToDisk(String fileToWrite) {
        return this.saveToDisk(0, fileToWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveToDisk(int scope, String fileToWrite) {
        if (this.preventSaves) {
            return 0;
        }
        try {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            if (bs != null) {
                return 0;
            }
        }
        catch (Exception bs) {
            // empty catch block
        }
        File f = PreferencesModel.makePrefFile(fileToWrite, true);
        if (f != null) {
            this.docFile = f;
        }
        Element root = new Element(TOP_ELEMENT_NAME);
        int count = this.saveToElement(scope, root);
        PrintStream outStr = null;
        try {
            Document doc = new Document(root);
            XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
            FileOutputStream fileOutStr = new FileOutputStream(this.docFile);
            outStr = new PrintStream(fileOutStr);
            outp.output(doc, (OutputStream)outStr);
        }
        catch (FileNotFoundException e) {
            if (e.getMessage().indexOf("Access is denied") >= 0) {
                trace.err("Save to disk(): " + e.getMessage());
                int n = 0;
                return n;
            }
            System.err.println("file not found " + this.docFile + ": " + e + "; cause " + e.getCause());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("error writing file " + this.docFile + ": " + e + "; cause " + e.getCause());
            e.printStackTrace();
            count = 0;
        }
        finally {
            if (outStr != null) {
                outStr.close();
            }
            outStr = null;
        }
        return count;
    }

    public int saveToElement(int scope, Element topElt) {
        int count = 0;
        Iterator it = this.iterator(scope);
        while (it.hasNext()) {
            Preference pref = (Preference)it.next();
            Element prefElt = new Element(PREF_ELEMENT_NAME);
            Element nameElt = new Element(NAME_NAME);
            nameElt.setText(pref.name);
            prefElt.addContent((Content)nameElt);
            Element clsElt = new Element(CLS_NAME);
            clsElt.setText(pref.cls.getName());
            prefElt.addContent((Content)clsElt);
            Element valueElt = new Element(VALUE_NAME);
            try {
                valueElt.setText(pref.value.toString());
            }
            catch (NullPointerException npe) {
                System.err.println("null pointer on pref " + pref.name + ", value " + pref.value);
                npe.printStackTrace();
            }
            prefElt.addContent((Content)valueElt);
            topElt.addContent((Content)prefElt);
            ++count;
        }
        return count;
    }

    public Iterator iterator(int scope) {
        if (scope < 0 || 3 < scope) {
            throw new IllegalArgumentException("undefined scope " + scope);
        }
        if (this.tableList.size() <= scope) {
            return EmptyIterator.instance();
        }
        Map<String, Preference> table = this.tableList.get(scope);
        if (table == null) {
            return EmptyIterator.instance();
        }
        return table.values().iterator();
    }

    public Object getValue(String name) {
        Preference result = this.getPreference(name);
        if (trace.getDebugCode("pr")) {
            trace.outNT("pr", this.getClass().getSimpleName() + ".getValue() result " + result);
        }
        if (result != null) {
            return result.value;
        }
        return null;
    }

    Preference getPreference(String name) {
        for (int i = 0; i < this.tableList.size(); ++i) {
            Preference result;
            Map<String, Preference> table = this.tableList.get(i);
            if (null == table || (result = table.get(name)) == null) continue;
            return result;
        }
        return null;
    }

    private Preference getPreference(int scope, String name) {
        if (this.tableList.size() <= scope) {
            return null;
        }
        Map<String, Preference> table = this.tableList.get(scope);
        if (table == null) {
            return null;
        }
        return table.get(name);
    }

    public Object setValue(int scope, String name, Class cls, Object value) {
        return this.setValue(this, scope, name, cls, value);
    }

    private Object setValue(Object src, int scope, String name, Class cls, Object value) {
        Preference result = null;
        PropertyChangeEvent evt = null;
        for (int i = 0; i <= scope && i < this.tableList.size(); ++i) {
            Map<String, Preference> table = this.tableList.get(i);
            if (null == table) {
                if (i < scope) continue;
                table = new LinkedHashMap<String, Preference>();
                this.tableList.set(scope, table);
            }
            if ((result = table.get(name)) != null && value == null) {
                Object oldValue = this.getValue(name);
                table.remove(name);
                evt = new PropertyChangeEvent(src, name, oldValue, value);
                if (trace.getDebugCode("pr")) {
                    trace.out("pr", "1 firing change to " + name + " from " + oldValue + " to (null)");
                }
                this.listeners.firePropertyChange(evt);
                break;
            }
            if (result == null && i != scope || value == null) continue;
            Object oldValue = this.getValue(name);
            Preference newPref = new Preference(name, cls, value);
            table.put(name, newPref);
            evt = new PropertyChangeEvent(src, name, oldValue, value);
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "2 firing change to " + name + " from " + oldValue + " to " + value);
            }
            this.listeners.firePropertyChange(evt);
            break;
        }
        return result == null ? null : result.value;
    }

    public void setBooleanValue(String valueName, Boolean value) {
        this.setValue(0, valueName, Boolean.class, value);
    }

    public Boolean getBooleanValue(String valueName) {
        return (Boolean)this.getValue(valueName);
    }

    public void setEnumValue(String valueName, Enum value) {
        this.setValue(0, valueName, value.getClass(), value);
    }

    public Enum getEnumValue(String valueName) {
        return (Enum)this.getValue(valueName);
    }

    public void setIntegerValue(String valueName, int value) {
        this.setIntegerValue(valueName, new Integer(value));
    }

    public void setIntegerValue(String valueName, Integer value) {
        this.setValue(0, valueName, Integer.class, value);
    }

    public Integer getIntegerValue(String valueName) {
        return (Integer)this.getValue(valueName);
    }

    public void setStringValue(String key, String value) {
        this.setValue(0, key, String.class, value);
    }

    public String getStringValue(String valueName) {
        return (String)this.getValue(valueName);
    }

    GroupNode getDisplayRoot() {
        return this.displayRoot;
    }

    void checkForMaxScopeInstance() {
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "checkForMaxScopeInstance() tableList.size() " + this.tableList.size() + ", tableList.get(MAX) " + (this.tableList.size() <= 3 ? "" : this.tableList.get(3)));
        }
        if (this.tableList.size() <= 3 || this.tableList.get(3) == null) {
            this.createMaxScopeInstance();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(name, listener);
    }

    void fireEditorChanges(Object src, Collection<PropertyChangeEvent> changes) {
        for (PropertyChangeEvent evt : changes) {
            String name = evt.getPropertyName();
            Object newValue = evt.getNewValue();
            Preference pref = this.getPreference(name);
            if (pref == null) {
                System.err.println("PreferencesModel: Changed preference " + name + " not found");
                continue;
            }
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "preference " + name + " was " + pref.value.toString() + ", is now " + newValue.toString());
            }
            int scope = pref.getDefaultScope();
            this.setValue(src, scope, name, pref.cls, newValue);
        }
    }

    public Boolean getOrSet(String label, Boolean defaultValue) {
        Boolean currentValue = this.getBooleanValue(label);
        if (currentValue != null) {
            return currentValue;
        }
        this.setBooleanValue(label, defaultValue);
        return defaultValue;
    }

    String getLatestCategory() {
        return this.latestCategory;
    }

    void setLatestCategory(String nodeName) {
        this.latestCategory = nodeName;
    }

    private static void usageExit(String errMsg) {
        System.err.printf("PreferencesModel: %s. Usage:\n  %s -migrate [oldFile [newFile]]\nwhere--\n  oldFile is the migrate-from file, default %s;\n  newFile is the migrate-to file, default %s.\n", errMsg == null ? "" : errMsg, PreferencesModel.class.getName(), PREFERENCES_FILE, PREFERENCES_DIR + File.separator + PREFERENCES_FILE);
        System.exit(-1);
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!"-migrate".equalsIgnoreCase(args[i])) continue;
            PreferencesModel.migrate(++i < args.length ? args[i] : PREFERENCES_FILE, ++i < args.length ? args[i] : PREFERENCES_DIR + File.separator + PREFERENCES_FILE);
            return;
        }
        PreferencesModel.usageExit("unknown arguments " + args);
    }

    private static void migrate(String oldFile, String newFile) {
        File nf;
        Preference pdPref;
        File of = PreferencesModel.makePrefFile(oldFile, false);
        if (of == null || !of.exists()) {
            if (trace.getDebugCode("prefs")) {
                trace.err(String.format("PreferencesModel.migrate() file not found: %s\n", oldFile));
            }
            return;
        }
        PreferencesModel opm = new PreferencesModel(oldFile);
        if (trace.getDebugCode("prefs")) {
            for (int i = 0; i <= 3; ++i) {
                trace.out("prefs", String.format("opm scope[%d] nEntries %d", i, opm.tableList.get(i) == null ? -1 : opm.tableList.get(i).size()));
            }
        }
        if ((pdPref = opm.getPreference("Projects Directory")) == null) {
            if (trace.getDebugCode("prefs")) {
                trace.err("PreferencesModel.migrate() no Projects Directory in file " + oldFile);
            }
        } else {
            pdPref.name = "workspace";
            pdPref.cls = String.class;
        }
        if ((nf = PreferencesModel.makePrefFile(newFile, true)) != null) {
            opm.saveToDisk(newFile);
            try {
                of.renameTo(new File(oldFile + "-old"));
            }
            catch (Exception e) {
                System.err.printf("Error renaming \"%s\" to \"%s-old\": %s; cause %s\n", oldFile, oldFile, e.toString(), e.getCause());
            }
        }
    }

    static interface Node {
        public String getName();
    }

    class Preference
    implements Node {
        private String name;
        private Class cls;
        private Object value;
        private int defaultScope = -1;
        private String editorLabel = null;
        private String description = null;
        private String tooltip = null;

        private Preference(String name, Class cls, Object value) {
            this.name = name;
            this.cls = cls;
            this.value = value;
        }

        private Preference(String name, boolean value) {
            this(name, Boolean.class, new Boolean(value));
        }

        private Preference(String name, int value) {
            this(name, Integer.class, new Integer(value));
        }

        public Preference(String name, Enum value) {
            this(name, value.getClass(), value);
        }

        public String toString() {
            return this.name + ", \"" + this.value.toString() + "\"";
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Class getCls() {
            return this.cls;
        }

        public Object getValue() {
            return this.value;
        }

        public String getEditorLabel() {
            Preference p = PreferencesModel.this.getPreference(3, this.name);
            if (p == null || p.editorLabel == null) {
                return this.name;
            }
            return p.editorLabel;
        }

        public String getDescription() {
            Preference p = PreferencesModel.this.getPreference(3, this.name);
            if (p == null || p.description == null) {
                return "";
            }
            return p.description;
        }

        public String getTooltip() {
            Preference p = PreferencesModel.this.getPreference(3, this.name);
            if (p == null || p.tooltip == null) {
                return "";
            }
            return p.tooltip;
        }

        public int getDefaultScope() {
            Preference p = PreferencesModel.this.getPreference(3, this.name);
            if (p == null || p.defaultScope < 0) {
                return 0;
            }
            return p.defaultScope;
        }
    }
}

