/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Preferences;

import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.wizard.CTATWorkspaceConfigureDialog;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.Preferences.FileBrowser;
import edu.cmu.pact.Preferences.GroupNode;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class PreferencesWindow
extends AbstractCtatWindow
implements TreeSelectionListener,
PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = -1373883450671892925L;
    private static int serialNoGenerator = 0;
    private int serialNo = 0;
    private static final String HELP_ICON = "/pact/help_icon.png";
    private URL imgURL = this.getClass().getResource("/pact/help_icon.png");
    private static final int MARGIN = 10;
    private PreferencesModel model;
    private Element rootElement;
    private JSplitPane splitPane;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JTree jtree;
    private DefaultMutableTreeNode topNode;
    private JPanel rightPanel;
    private JTextField workspaceLocation = null;
    private JButton aShowWorkspaceConfig = null;
    private Map editors = null;
    private Map editorEvents = null;

    public static PreferencesWindow create(PreferencesModel model, CTAT_Launcher server) {
        model.checkForMaxScopeInstance();
        return new PreferencesWindow(model, server);
    }

    PreferencesWindow(PreferencesModel model_a, CTAT_Launcher server) throws HeadlessException {
        super(server);
        this.serialNo = ++serialNoGenerator;
        this.model = model_a;
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "model = " + this.model);
        }
        if (this.model != null) {
            this.topNode = this.getDisplayTree();
            this.model.addPropertyChangeListener(this);
        } else {
            this.loadXML();
        }
        this.editors = new HashMap();
        this.editorEvents = new LinkedHashMap();
        this.setDefaultCloseOperation(2);
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "PreferencesWindow() constructor: serialNo " + this.serialNo);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (!PreferencesWindow.this.editorEvents.isEmpty()) {
                    String warning = "There are uncommitted changes. Press\nYes to commit the changes, No to cancel them.";
                    int n = JOptionPane.showConfirmDialog(PreferencesWindow.this, warning, "Commit Changes", 0, 2);
                    if (n == 0 && PreferencesWindow.this.model != null) {
                        PreferencesWindow.this.model.fireEditorChanges(this, PreferencesWindow.this.editorEvents.values());
                    }
                    PreferencesWindow.this.editorEvents.clear();
                }
                if (PreferencesWindow.this.model != null) {
                    PreferencesWindow.this.model.removePropertyChangeListener(PreferencesWindow.this);
                }
                PreferencesWindow.this.clearNodeEditorPanels();
            }
        });
        this.setupWindow();
        this.setDockable(false);
    }

    private void setupWindow() {
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        topPanel.setLayout(new BorderLayout());
        Box stretchBox = new Box(0);
        stretchBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box labelBox = new Box(1);
        labelBox.setOpaque(true);
        labelBox.setMinimumSize(new Dimension(50, 80));
        labelBox.setMaximumSize(new Dimension(1600, 120));
        labelBox.setBackground(new Color(255, 255, 255));
        labelBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box a1Box = new Box(0);
        JLabel title = new JLabel("<html>CTAT Workspace &nbsp;<img src=\"" + this.imgURL + "\" ></html>");
        title.setFont(new Font("Dialog", 1, 12));
        a1Box.add(title);
        title.setToolTipText("<html>This is the current default folder for your tutor projects. You can change<br>the workspace to a different folder or create a new project folder.");
        a1Box.add(Box.createHorizontalGlue());
        labelBox.add(a1Box);
        Box a2Box = new Box(0);
        a2Box.add(Box.createHorizontalGlue());
        labelBox.add(a2Box);
        Box workspaceButtonBox = new Box(0);
        workspaceButtonBox.setBorder(new EmptyBorder(3, 20, 3, 3));
        JLabel workspaceLabel = new JLabel();
        workspaceLabel.setText("Workspace location:");
        workspaceLabel.setPreferredSize(new Dimension(120, 22));
        workspaceLabel.setFont(new Font("Dialog", 1, 9));
        workspaceButtonBox.add(workspaceLabel);
        this.workspaceLocation = new JTextField();
        this.workspaceLocation.setName("workspaceLocation");
        this.workspaceLocation.setFont(new Font("Dialog", 1, 9));
        this.workspaceLocation.setMinimumSize(new Dimension(150, 25));
        this.workspaceLocation.setMaximumSize(new Dimension(600, 25));
        this.workspaceLocation.setEditable(false);
        if (this.model.getStringValue("workspace") != null) {
            this.workspaceLocation.setText(this.model.getStringValue("workspace"));
        } else {
            this.workspaceLocation.setText(System.getProperty("user.home") + "/" + CTATLink.workspaceLocation);
        }
        workspaceButtonBox.add(this.workspaceLocation);
        this.aShowWorkspaceConfig = new JButton();
        this.aShowWorkspaceConfig.setText("Configure");
        this.aShowWorkspaceConfig.setFont(new Font("Dialog", 1, 9));
        this.aShowWorkspaceConfig.setPreferredSize(new Dimension(85, 20));
        this.aShowWorkspaceConfig.setActionCommand("aShowWorkspaceConfig");
        this.aShowWorkspaceConfig.addActionListener(this);
        workspaceButtonBox.add(this.aShowWorkspaceConfig);
        labelBox.add(workspaceButtonBox);
        stretchBox.add(labelBox);
        JPanel bottomPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        bottomPanel.add(this.okButton);
        bottomPanel.add(this.applyButton);
        bottomPanel.add(this.cancelButton);
        this.jtree = new JTree(this.topNode);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        this.jtree.setCellRenderer(renderer);
        this.jtree.putClientProperty("JTree.lineStyle", "Angled");
        this.jtree.addTreeSelectionListener(this);
        this.jtree.setMinimumSize(new Dimension(150, 50));
        for (int i = 0; i < this.jtree.getRowCount(); ++i) {
            this.jtree.expandRow(i);
        }
        this.rightPanel = new JPanel();
        this.splitPane = new JSplitPane(1, this.jtree, this.rightPanel);
        topPanel.add((Component)this.splitPane, "Center");
        this.splitPane.setSize(200, 100);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)stretchBox, "North");
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setSize(580, 480);
        this.setLocationRelativeTo(null);
        this.setTitle("CTAT Preferences");
        this.setName("Preferences Window");
        super.applyPreferences();
        super.storeLocation();
        super.storeSize();
        this.setCurrentPanel(this.model.getLatestCategory());
    }

    private void loadXML() {
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "reading xml");
        }
        URL xmlURL = ClassLoader.getSystemResource("pact/Preferences/PreferencesPanel.xml");
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(xmlURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.rootElement = doc.getRootElement();
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "root element = " + this.rootElement.getName());
        }
        this.topNode = new DefaultMutableTreeNode("Category");
        for (Element element2 : this.rootElement.getChild("NodeList").getChildren()) {
            String name = element2.getAttributeValue("id");
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "name = " + name);
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
            this.topNode.insert(node, this.topNode.getChildCount());
            for (Element childElement : element2.getChildren()) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(childElement.getAttributeValue("id"));
                node.add(childNode);
            }
        }
    }

    void setCurrentPanel(String panelName) {
        Enumeration<TreeNode> elements = this.topNode.breadthFirstEnumeration();
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "set current panel: panel name = " + panelName);
        }
        DefaultMutableTreeNode node = null;
        int count = 0;
        while (elements.hasMoreElements()) {
            node = (DefaultMutableTreeNode)elements.nextElement();
            String name = ((GroupNode)node.getUserObject()).getName();
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "name = " + name + " count = " + count);
            }
            if (name.equals(panelName)) break;
            ++count;
        }
        if (node == null) {
            return;
        }
        this.jtree.setSelectionPath(new TreePath(node.getPath()));
        this.setupRightPanel(node);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (trace.getDebugCode("pr")) {
            trace.out("pr", ((JButton)evt.getSource()).getText() + " button pressed, editorEvents.size() " + this.editorEvents.size() + ", .hashCode() " + this.editorEvents.hashCode() + ", serialNo " + this.serialNo + ", this.model " + this.model);
        }
        if (evt.getSource() == this.okButton || evt.getSource() == this.applyButton) {
            if (this.model != null) {
                this.model.fireEditorChanges(this, this.editorEvents.values());
            }
            this.editorEvents.clear();
        }
        if (evt.getSource() == this.aShowWorkspaceConfig) {
            CTATWorkspaceConfigureDialog configureDialog = new CTATWorkspaceConfigureDialog(this.model, false);
            configureDialog.show();
            this.workspaceLocation.setText(configureDialog.getWorkspacePath());
        }
        if (evt.getSource() == this.cancelButton) {
            for (Object obj : this.editorEvents.values()) {
                PropertyChangeEvent edEvt;
                String propName;
                EditorPanel editor;
                if (!(obj instanceof PropertyChangeEvent) || (editor = (EditorPanel)this.editors.get(propName = (edEvt = (PropertyChangeEvent)obj).getPropertyName())) == null || this.model == null) continue;
                editor.update(this.model.getValue(propName));
            }
            this.editorEvents.clear();
        }
        if (evt.getSource() == this.okButton || evt.getSource() == this.cancelButton) {
            if (this.model != null) {
                this.model.removePropertyChangeListener(this);
            }
            this.clearNodeEditorPanels();
            this.setVisible(false);
        }
    }

    void rereadModel() {
        this.clearNodeEditorPanels();
        this.rightPanel.removeAll();
        this.rightPanel.validate();
        this.setupRightPanel((DefaultMutableTreeNode)this.jtree.getLastSelectedPathComponent());
    }

    private void clearNodeEditorPanels() {
        if (this.topNode == null) {
            return;
        }
        Enumeration<TreeNode> en = this.topNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!(node.getUserObject() instanceof GroupNode)) continue;
            GroupNode gNode = (GroupNode)node.getUserObject();
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "about to null gNode.editorsPanel " + gNode.getEditorsPanel());
            }
            gNode.setEditorsPanel(null);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jtree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.setupRightPanel(node);
    }

    private void setupRightPanel(DefaultMutableTreeNode node) {
        String name;
        if (node == null) {
            return;
        }
        if (!(node.getUserObject() instanceof GroupNode)) {
            return;
        }
        if (!node.isLeaf()) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        GroupNode gNode = (GroupNode)node.getUserObject();
        String nameToShow = name = gNode.getName();
        String parentName = ((GroupNode)parentNode.getUserObject()).toString();
        this.model.setLatestCategory(name);
        if (!parentName.equals("Category")) {
            nameToShow = parentName + "--" + name;
        }
        TitledBorder titleB = BorderFactory.createTitledBorder("<html><b>" + nameToShow + "</b></html>");
        Border marginB = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.rightPanel.setBorder(titleB);
        this.rightPanel.removeAll();
        this.rightPanel.validate();
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
        String desc = gNode.getDescription();
        if (desc != null && !desc.isEmpty()) {
            JPanel descPanel = new JPanel();
            JLabel descLabel = new JLabel("<html><p>" + desc + "</p></html>");
            descLabel.setName("descLabel");
            descPanel.add(descLabel);
            descPanel.setLayout(new BoxLayout(descPanel, 0));
            descPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.rightPanel.add(descPanel);
        }
        JPanel editorsPanel = null;
        if (trace.getDebugCode("pr")) {
            trace.out("pr", "setupRightPanel() gNode " + gNode + " .editorsPanel " + (gNode == null || gNode.getEditorsPanel() == null ? null : Integer.valueOf(gNode.getEditorsPanel().hashCode())) + "; serialNo " + this.serialNo);
        }
        if (gNode.getEditorsPanel() instanceof JPanel) {
            editorsPanel = (JPanel)gNode.getEditorsPanel();
        } else {
            editorsPanel = new JPanel();
            editorsPanel.setLayout(new BoxLayout(editorsPanel, 1));
            for (PreferencesModel.Preference pref : gNode) {
                EditorPanel editor = new EditorPanel(pref, this);
                if (trace.getDebugCode("pr")) {
                    trace.out("pr", "editor panel min, pref, max size = " + editor.getMinimumSize() + ", " + editor.getPreferredSize() + ", " + editor.getMaximumSize());
                }
                editorsPanel.add(editor);
                Box paddingBox = new Box(0);
                paddingBox.setBorder(new EmptyBorder(3, 15, 3, 15));
                paddingBox.add(new JSeparator(0));
                editorsPanel.add(paddingBox);
                this.editors.put(pref.getName(), editor);
            }
            gNode.setEditorsPanel(editorsPanel);
        }
        JScrollPane sp = new JScrollPane(editorsPanel, 20, 30);
        this.rightPanel.add(sp);
        this.rightPanel.validate();
    }

    DefaultMutableTreeNode getDisplayTree() {
        GroupNode root = this.model.getDisplayRoot();
        if (root == null) {
            return null;
        }
        if (trace.getDebugCode("pr")) {
            trace.out("pr", root.prettyPrint());
        }
        return this.getDisplayTree(root, null);
    }

    private DefaultMutableTreeNode getDisplayTree(GroupNode node, DefaultMutableTreeNode outputParent) {
        DefaultMutableTreeNode outputNode = new DefaultMutableTreeNode(node);
        if (outputParent != null) {
            outputParent.insert(outputNode, outputParent.getChildCount());
        }
        for (Object child : node) {
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "getDisplayTree: parent " + outputParent + ", node " + node + ", child " + child);
            }
            if (!(child instanceof GroupNode)) continue;
            this.getDisplayTree((GroupNode)child, outputNode);
        }
        return outputNode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        EditorPanel editor;
        String propName = evt.getPropertyName();
        if (evt.getSource() instanceof EditorPanel) {
            PropertyChangeEvent oldEvt = this.editorEvents.put(propName, evt);
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "editorEvents.size() " + this.editorEvents.size() + ", .hashCode() " + this.editorEvents.hashCode() + ", serialNo " + this.serialNo + ", this.model " + this.model + ": changed " + propName + ", new value " + evt.getNewValue() + (oldEvt == null ? "" : ", prior change " + oldEvt.getNewValue()));
            }
        } else if (evt.getSource() != this && (editor = (EditorPanel)this.editors.get(propName)) != null) {
            editor.update(evt.getNewValue());
        }
    }

    private class EditorPanel
    extends JPanel
    implements ActionListener,
    DocumentListener {
        private static final long serialVersionUID = -1245568631165998269L;
        private final String name;
        private final Class cls;
        private final String editorLabel;
        private PropertyChangeListener externListener = null;
        private JLabel descriptionLabel = null;
        JComboBox comboBox = null;
        JCheckBox cb = null;
        JTextField tf = null;

        public EditorPanel(PreferencesModel.Preference pref, PropertyChangeListener externListener) {
            this.name = pref.getName();
            this.cls = pref.getCls();
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 19;
            c.fill = 2;
            c.gridx = 0;
            c.weighty = 1.0;
            c.weightx = 1.0;
            this.setLayout(new GridBagLayout());
            Border margin = BorderFactory.createEmptyBorder(5, 0, 5, 0);
            this.setBorder(margin);
            String description = pref.getDescription();
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "description = " + description);
            }
            this.descriptionLabel = description != null && description.length() > 0 ? new JLabel("<html><p>" + Utils.expandPropertyReferences(description) + "</p></html>") : new JLabel("<html><p>&nbsp;</p></html>");
            this.descriptionLabel.setName(this.name + " Description");
            String tooltip = pref.getTooltip();
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "tooltip = " + tooltip);
            }
            this.editorLabel = tooltip != null && tooltip.length() > 0 ? "<html><p>" + pref.getEditorLabel() + "&nbsp;&nbsp;<img src=\"" + PreferencesWindow.this.imgURL + "\" ></p></html>" : pref.getEditorLabel();
            this.externListener = externListener;
            if (pref.getCls().isEnum()) {
                JLabel title = new JLabel(this.editorLabel);
                title.setName(this.name + " Title");
                this.addTooltip(title, tooltip);
                this.comboBox = this.getEnumComboBox(pref);
                this.comboBox.setActionCommand(pref.getName());
                this.comboBox.addActionListener(this);
                this.add((Component)title, c);
                this.add((Component)this.comboBox, c);
            } else if (Boolean.class == pref.getCls()) {
                Boolean value = PreferencesWindow.this.model != null ? PreferencesWindow.this.model.getBooleanValue(this.name) : (Boolean)pref.getValue();
                this.cb = new JCheckBox(this.editorLabel, (boolean)value);
                this.addTooltip(this.cb, tooltip);
                this.cb.setIconTextGap(10);
                this.cb.setActionCommand(pref.getName());
                this.cb.addActionListener(this);
                this.add((Component)this.cb, c);
            } else if (FileBrowser.class == pref.getCls()) {
                Object value = PreferencesWindow.this.model != null ? PreferencesWindow.this.model.getValue(this.name) : pref.getValue();
                JLabel title = new JLabel(this.editorLabel);
                title.setName(this.name + " Title");
                this.addTooltip(title, tooltip);
                this.tf = new FixedHeightTextField(value.toString(), 20);
                FileBrowser browseButton = new FileBrowser(this.tf, this.name, this.editorLabel);
                this.tf.setEditable(true);
                this.tf.setActionCommand(pref.getName());
                this.tf.addActionListener(this);
                this.tf.getDocument().addDocumentListener(this);
                this.add((Component)title, c);
                browseButton.setActionCommand(pref.getName());
                browseButton.addActionListener(this);
                browseButton.setName(this.name + " Button");
                this.add((Component)this.tf, c);
                int anchor = c.anchor;
                int fill = c.fill;
                c.anchor = 22;
                c.fill = 0;
                this.add((Component)browseButton, c);
                c.fill = fill;
                c.anchor = anchor;
            } else {
                Object value = PreferencesWindow.this.model != null ? PreferencesWindow.this.model.getValue(this.name) : pref.getValue();
                JLabel title = new JLabel(this.editorLabel);
                title.setName(this.name + " Title");
                this.addTooltip(title, tooltip);
                this.tf = new FixedHeightTextField(value.toString(), 20);
                this.tf.setActionCommand(pref.getName());
                this.tf.addActionListener(this);
                this.tf.getDocument().addDocumentListener(this);
                this.add((Component)title, c);
                this.add((Component)this.tf, c);
            }
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "description max  size " + this.descriptionLabel.getMaximumSize());
            }
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "description pref size " + this.descriptionLabel.getPreferredSize());
            }
            c.weighty *= 3.0;
            c.fill = 1;
            this.add((Component)this.descriptionLabel, c);
        }

        public void addTooltip(JComponent c, String tooltip) {
            if (tooltip != null && tooltip.length() > 0) {
                if (trace.getDebugCode("pr")) {
                    trace.out("pr", "adding tooltip " + tooltip + "to " + c.getName());
                }
                c.setToolTipText("<html><p width=\"300\">" + Utils.expandPropertyReferences(tooltip) + "</p></html>");
            }
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(300, 240);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            Dimension max = this.getMaximumSize();
            return new Dimension(Math.min(pref.width, max.width), pref.height);
        }

        private JComboBox getEnumComboBox(PreferencesModel.Preference pref) {
            Class cls;
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "getEnumComboBox(" + pref + ")");
            }
            if (!(cls = pref.getCls()).isEnum()) {
                return null;
            }
            EnumSet enumSet = EnumSet.allOf(cls);
            this.comboBox = new FixedWidthComboBox(enumSet.toArray());
            Enum value = PreferencesWindow.this.model != null ? PreferencesWindow.this.model.getEnumValue(this.name) : (Enum)pref.getValue();
            this.comboBox.setSelectedItem(value);
            this.comboBox.setName(this.name + " ComboBox");
            return this.comboBox;
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            if (trace.getDebugCode("pr")) {
                trace.out("pr", "DocumentEvent on " + this.name + ": " + evt.getType() + ", text now " + this.tf.getText());
            }
            Object nv = this.tf.getText();
            if (null == (nv = this.checkText((String)nv))) {
                return;
            }
            PropertyChangeEvent extEvt = new PropertyChangeEvent(this, this.name, null, nv);
            this.externListener.propertyChange(extEvt);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object nv = null;
            Object source = evt.getSource();
            if (source instanceof JComboBox) {
                nv = ((JComboBox)source).getSelectedItem();
            } else if (source instanceof JCheckBox) {
                nv = new Boolean(((JCheckBox)source).isSelected());
            } else if (source instanceof JTextField) {
                nv = ((JTextField)source).getText();
                if (null == (nv = this.checkText((String)nv))) {
                    return;
                }
            } else if (source instanceof FileBrowser) {
                FileBrowser fb = (FileBrowser)source;
                String currentDir = this.getDirFromFileBrowser(fb);
                nv = fb.chooseDirectory(PreferencesWindow.this, currentDir);
                if (nv == null) {
                    return;
                }
                this.tf.setText((String)nv);
            } else {
                throw new IllegalArgumentException("Unknown source type " + evt.getSource().getClass().getName());
            }
            PropertyChangeEvent extEvt = new PropertyChangeEvent(this, this.name, null, nv);
            this.externListener.propertyChange(extEvt);
        }

        private String getDirFromFileBrowser(FileBrowser fb) {
            String currentDir;
            JTextField tf = fb.getTextField();
            String string = currentDir = tf == null ? null : tf.getText();
            if (currentDir != null && currentDir.length() > 0) {
                File d = new File(currentDir);
                if (!d.isAbsolute()) {
                    d = Utils.getFileAsResource(currentDir, this);
                }
                if (d != null) {
                    while (!d.exists() && d.getParentFile() != null) {
                        d = d.getParentFile();
                    }
                }
                currentDir = d != null && d.exists() ? d.getAbsolutePath() : null;
            }
            if (currentDir == null || currentDir.length() < 1) {
                currentDir = System.getProperty("user.dir");
            }
            return currentDir;
        }

        private Object checkText(String text) {
            Object result = text;
            if (Integer.class.equals((Object)this.cls)) {
                try {
                    if (text.length() < 1) {
                        text = "0";
                    }
                    int i = Integer.parseInt(text);
                    result = new Integer(i);
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this, "Value for \"" + this.editorLabel + "\" must be an integer", this.editorLabel, 0);
                    result = null;
                }
            }
            return result;
        }

        void update(Object newValue) {
            if (newValue == null) {
                return;
            }
            try {
                if (this.cls.isEnum()) {
                    this.comboBox.setSelectedItem(newValue);
                } else if (Boolean.class == this.cls) {
                    this.cb.setSelected((Boolean)newValue);
                } else {
                    this.tf.setText(newValue.toString());
                }
            }
            catch (ClassCastException cce) {
                cce.printStackTrace();
            }
        }

        private class FixedWidthComboBox
        extends JComboBox {
            private static final long serialVersionUID = 2382681863052680778L;

            FixedWidthComboBox(Object[] choices) {
                super(choices);
                this.setName(EditorPanel.this.name);
            }

            @Override
            public Dimension getMaximumSize() {
                int width = super.getPreferredSize().width;
                int height = super.getMaximumSize().height;
                return new Dimension(width, height);
            }
        }

        private class FixedHeightTextField
        extends JTextField {
            private static final long serialVersionUID = -472664190301771333L;

            FixedHeightTextField(String v, int cols) {
                super(v, cols);
                this.setName(EditorPanel.this.name);
            }

            @Override
            public Dimension getMaximumSize() {
                int width = super.getMaximumSize().width;
                int height = super.getPreferredSize().height;
                return new Dimension(width, height);
            }
        }
    }
}

