/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATHTTPSServer;
import edu.cmu.hcii.ctat.CTATHTTPServer;
import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.BehaviorRecorder.Controller.AuthorLauncherHandler;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.TutoringService.LauncherHandler;
import edu.cmu.pact.TutoringService.Monitor;
import edu.cmu.pact.TutoringService.ServiceRequest;
import edu.cmu.pact.TutoringService.SessionRequest;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.TutoringService.TransactionInfo;
import edu.cmu.pact.Utilities.NtpClient;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import pact.CommWidgets.RemoteToolProxy;

public class LauncherServer
extends TSLauncherServer
implements Runnable,
ExitableServer {
    private static final int MASTER_SOCKET_POLICY_PORT = 843;
    private final int commPort;
    private SessionKeeper sk = null;
    private NtpClient ntpClient = null;
    private Monitor ct = null;
    private volatile Date shutdownTime = null;
    private List<ExitableServer> otherServers = new LinkedList<ExitableServer>();
    private List<Integer> httpPorts;
    private List<Integer> httpsPorts;
    private List<Integer> tcpPorts;
    private List<Integer> wsPorts;
    private List<Integer> wssPorts;
    private List<Integer> jsonPorts;
    private volatile boolean nowExiting = false;

    public static void main(String[] args) {
        String[] stringArray;
        Locale.setDefault(new Locale("en", "US"));
        if (args.length > 0) {
            stringArray = args;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "-t";
            stringArray = stringArray2;
            stringArray2[1] = Integer.toString(1502);
        }
        LauncherServer.create(stringArray);
    }

    public static LauncherServer create(String[] args) {
        ArrayList<Integer> jsonPorts = new ArrayList<Integer>();
        ArrayList<Integer> wsPorts = new ArrayList<Integer>();
        ArrayList<Integer> wssPorts = new ArrayList<Integer>();
        ArrayList<Integer> httpPorts = new ArrayList<Integer>();
        ArrayList<Integer> httpsPorts = new ArrayList<Integer>();
        ArrayList<Integer> tcpPorts = new ArrayList<Integer>();
        Utils.setRuntime(true);
        LauncherServer.parseCmdLine(args, jsonPorts, wsPorts, wssPorts, httpPorts, httpsPorts, tcpPorts, "-t");
        CTATBase.debug("LauncherServer", "Listening on WS ports " + wsPorts + ", WSS ports " + wssPorts + ", HTTP ports " + httpPorts + ", HTTPS ports " + httpsPorts + ", TCP ports " + tcpPorts);
        String crossDomainPolicy = "<?xml version=\"1.0\"?>\n<!DOCTYPE cross-domain-policy SYSTEM \"http://www.macromedia.com/xml/dtds/cross-domain-policy.dtd\">\n<cross-domain-policy>\n<allow-access-from domain=\"*\" to-ports=\"*\" />\n</cross-domain-policy>\u0000";
        LauncherServer ls = new LauncherServer(jsonPorts, wsPorts, wssPorts, httpPorts, httpsPorts, tcpPorts, 1503, 1504, crossDomainPolicy, 843, SocketProxy.getSocketPolicyContent());
        Thread t = new Thread(new ThreadGroup("TutoringService"), ls, "LauncherServer");
        t.start();
        return ls;
    }

    public LauncherServer() {
        this(null, null, null, null, null, null, -1, -1, "", -1, "");
    }

    LauncherServer(List<Integer> jsonPorts, List<Integer> wsPorts, List<Integer> wssPorts, List<Integer> httpPorts, List<Integer> httpsPorts, List<Integer> tcpPorts, int commPort, int crossDomainPolicyPort, String crossDomainPolicyContent, int socketPolicyPort, String socketPolicyContent) {
        this.jsonPorts = jsonPorts;
        this.wsPorts = wsPorts;
        this.wssPorts = wssPorts;
        this.httpPorts = httpPorts;
        this.httpsPorts = httpsPorts;
        this.tcpPorts = tcpPorts;
        this.commPort = commPort;
        this.getPreferencesModel().setBooleanValue("Restore workspace", Boolean.FALSE);
    }

    public void sendIdentificationRequest(Socket sock) {
        String toSend = "<message><verb>NotePropertySet</verb><properties><MessageType>InterfaceIdentificationRequest</MessageType></properties></message>";
        System.out.println("Sending XML msg via remote port#" + sock.getPort() + " and local port# " + sock.getLocalPort() + ":\n" + toSend);
        try {
            PrintWriter pw = new PrintWriter(sock.getOutputStream());
            pw.write(toSend);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        System.out.println("LauncherServer : entered run");
        Thread lsThread = new Thread((Runnable)this.logServlet, "LogServlet");
        lsThread.start();
        this.otherServers.add(this.logServlet);
        this.sk = new SessionKeeper();
        this.sk.setName("SessionKeeper");
        this.sk.start();
        this.otherServers.add(this.sk);
        this.ntpClient = new NtpClient();
        this.ntpClient.setName("NtpClient");
        this.ntpClient.start();
        this.otherServers.add(this.ntpClient);
        try {
            this.shutdownTime = null;
            if (this.commPort > 0) {
                this.ct = new Monitor(this.commPort);
                this.ct.addRequestHandler("session", new SessionRequest(this));
                this.ct.addRequestHandler("service", new ServiceRequest(this));
                this.ct.setName("Monitor");
                this.ct.start();
                this.otherServers.add(this.ct);
            }
        }
        catch (Exception io) {
            trace.err("Fatal error from LauncherServer top-level thread: exception " + io + (io.getCause() == null ? "" : ";\ncause: " + io.getCause()));
            io.printStackTrace();
        }
        this.startWSHandler();
        this.startWSSHandler();
        this.startHTTPHandler();
        this.startHTTPSHandler();
        if (this.tcpPorts.isEmpty()) {
            this.tcpPorts.add(new Integer(1502));
        }
        int i = this.tcpPorts.size();
        Listener listener = null;
        while (0 < --i) {
            CTATBase.debug("LauncherServer", "Starting server on: " + this.tcpPorts.get(i));
            listener = new Listener(this.tcpPorts.get(i));
            this.otherServers.add(listener);
            listener.start();
        }
        CTATBase.debug("LauncherServer", "Starting server on: " + this.tcpPorts.get(i));
        listener = new Listener(this.tcpPorts.get(i));
        this.otherServers.add(listener);
        listener.run();
    }

    protected CTATHTTPServer startWSHandler() {
        if (trace.getDebugCode("ll")) {
            trace.outNT("ll", "LS.startWSHander() wsPorts " + this.wsPorts + ", jsonPorts " + this.jsonPorts);
        }
        CTATHTTPServer server = null;
        if (this.wsPorts == null) {
            this.wsPorts = new ArrayList<Integer>();
        }
        if (this.wsPorts.isEmpty()) {
            this.wsPorts.add(20080);
        }
        for (Integer wsPort : this.wsPorts) {
            AuthorLauncherHandler handler = new AuthorLauncherHandler(this);
            if (this.jsonPorts.contains(wsPort)) {
                handler.setOutputJSON(true);
            }
            server = new CTATHTTPServer(wsPort, null, null, handler);
            server.startWebServer();
        }
        return server;
    }

    protected CTATHTTPSServer startWSSHandler() {
        if (trace.getDebugCode("ll")) {
            trace.outNT("ll", "LS.startWSSHander() wssPorts " + this.wssPorts + ", jsonPorts " + this.jsonPorts);
        }
        CTATHTTPSServer server = null;
        if (this.wssPorts == null) {
            this.wssPorts = new ArrayList<Integer>();
        }
        if (this.wssPorts.isEmpty()) {
            this.wssPorts.add(20443);
        }
        for (Integer wssPort : this.wssPorts) {
            AuthorLauncherHandler handler = new AuthorLauncherHandler(this);
            if (this.jsonPorts.contains(wssPort)) {
                handler.setOutputJSON(true);
            }
            server = new CTATHTTPSServer(wssPort, null, null, handler);
            server.setKeystore(keystore);
            server.startWebServer();
        }
        return server;
    }

    protected CTATHTTPServer startHTTPHandler() {
        if (trace.getDebugCode("ll")) {
            trace.outNT("ll", "LS.startHTTPHander() httpPorts " + this.httpPorts + ", jsonPorts " + this.jsonPorts);
        }
        CTATHTTPServer server = null;
        if (this.httpPorts == null) {
            this.httpPorts = new ArrayList<Integer>();
        }
        if (this.httpPorts.isEmpty()) {
            this.httpPorts.add(12022);
        }
        for (Integer httpPort : this.httpPorts) {
            LauncherHandler handler = new LauncherHandler(this);
            if (this.jsonPorts.contains(httpPort)) {
                handler.setOutputJSON(true);
            }
            server = new CTATHTTPServer(httpPort, null, null, handler);
            server.startWebServer();
        }
        return server;
    }

    protected CTATHTTPSServer startHTTPSHandler() {
        if (trace.getDebugCode("ll")) {
            trace.outNT("ll", "LS.startHTTPSHander() httpsPorts " + this.httpsPorts + ", jsonPorts " + this.jsonPorts);
        }
        CTATHTTPSServer server = null;
        if (this.httpsPorts == null) {
            this.httpsPorts = new ArrayList<Integer>();
        }
        if (this.httpsPorts.isEmpty()) {
            this.httpsPorts.add(12043);
        }
        for (Integer httpsPort : this.httpsPorts) {
            LauncherHandler handler = new LauncherHandler(this);
            if (this.jsonPorts.contains(httpsPort)) {
                handler.setOutputJSON(true);
            }
            server = new CTATHTTPSServer(httpsPort, null, null, handler);
            server.setKeystore(keystore);
            server.startWebServer();
        }
        return server;
    }

    @Override
    public void shutdown() {
        this.startExiting();
        Utils.sleep(500L);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimeStamp(String guid) {
        String string = this.sessionsMutex;
        synchronized (string) {
            TSLauncherServer.Session s = (TSLauncherServer.Session)this.sessions.get(guid);
            if (s != null) {
                s.updateTimeStamp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSession(String guid) {
        TSLauncherServer.Session sess = null;
        Collaborators collabs = null;
        String string = this.sessionsMutex;
        synchronized (string) {
            sess = (TSLauncherServer.Session)this.sessions.remove(guid);
            if (sess != null) {
                collabs = this.allCollaborators.removeSession(sess);
                if (sess.getController() != null) {
                    sess.getController().disconnect(true);
                }
            }
            if (trace.getDebugCode("ls")) {
                trace.outln("ls", (sess != null ? "Removed" : "Found no") + " session for GUID: " + guid + ". Updated sessions.size: " + this.sessions.size() + ", collabs " + collabs + ", allCollaborators.size() " + this.allCollaborators.size());
            }
        }
        try {
            if (sess != null && sess.lSock != null) {
                sess.lSock.close();
            }
        }
        catch (Exception e) {
            trace.errStack("removeSession(): error closing socket for GUID " + guid, e);
        }
        return sess != null;
    }

    @Override
    public NtpClient getNtpClient() {
        return this.ntpClient;
    }

    @Override
    public TransactionInfo.Single createTransactionInfo(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        TSLauncherServer.Session session = this.getSession(sessionId);
        if (session != null) {
            return session.txInfo.create();
        }
        return null;
    }

    @Override
    public void updateTransactionInfo(String sessionId, Object info) {
        if (sessionId == null) {
            return;
        }
        TSLauncherServer.Session session = this.getSession(sessionId);
        if (session != null) {
            session.txInfo.update(info);
        }
    }

    @Override
    public synchronized boolean isExiting() {
        return this.nowExiting;
    }

    @Override
    public synchronized boolean startExiting() {
        boolean result = this.nowExiting;
        this.nowExiting = true;
        this.shutdownTime = new Date();
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "LauncherServer.startExiting() at " + this.shutdownTime);
        }
        for (ExitableServer es : this.otherServers) {
            es.startExiting();
        }
        return result;
    }

    @Override
    public boolean isAuthorMode() {
        return false;
    }

    @Override
    public int getWSPort() {
        return this.wsPorts == null || this.wsPorts.size() < 1 ? super.getWSPort() : this.wsPorts.get(0).intValue();
    }

    class PolicyThread
    extends Thread
    implements ExitableServer {
        private int policyPort;
        private String policyContent;
        private volatile boolean nowExiting = false;
        private ServerSocket policySocket = null;

        public PolicyThread(String policyContent, int policyPort) {
            this.policyContent = policyContent;
            this.policyPort = policyPort;
        }

        @Override
        public void run() {
            try {
                this.policySocket = new ServerSocket(this.policyPort);
                while (!this.nowExiting) {
                    System.out.println("waiting for a policy connection...");
                    Socket ps = this.policySocket.accept();
                    PolicyThreadConsumer ptc = new PolicyThreadConsumer(ps);
                    ptc.start();
                }
            }
            catch (IOException e) {
                System.out.println(e.getStackTrace());
            }
        }

        @Override
        public synchronized boolean isExiting() {
            return this.nowExiting;
        }

        @Override
        public synchronized boolean startExiting() {
            LauncherServer.this.shutdownTime = new Date();
            boolean result = this.nowExiting;
            this.nowExiting = true;
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "PolicyThread.startExiting() previous nowExiting " + result + ", server socket to close " + this.policySocket);
            }
            try {
                if (this.policySocket != null) {
                    this.policySocket.close();
                }
            }
            catch (Exception e) {
                trace.errStack("PolicyThread.startExiting() error closing server socket " + e + ";\n  cause " + e.getCause(), e);
            }
            this.policySocket = null;
            return result;
        }

        private class PolicyThreadConsumer
        extends Thread {
            Socket pSock;

            public PolicyThreadConsumer(Socket sock) {
                this.pSock = sock;
            }

            @Override
            public void run() {
                try {
                    System.out.println("Received a policy connection on " + this.pSock.getLocalPort() + "\n");
                    PrintWriter pw = new PrintWriter(this.pSock.getOutputStream());
                    pw.write(PolicyThread.this.policyContent);
                    pw.close();
                    this.pSock.close();
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getStackTrace());
                }
            }
        }
    }

    class Listener
    extends Thread
    implements ExitableServer {
        private ServerSocket ss;
        private volatile boolean nowExiting = false;
        private volatile Date shutdownTime = null;

        Listener(int port) {
            this.setName("LauncherServer.Listener_on_port_" + port);
            try {
                this.ss = new ServerSocket(port);
                if (trace.getDebugCode("ls")) {
                    trace.out("ls", "LauncherServer.Listener(" + port + ") created on local port " + this.ss.getLocalPort());
                }
            }
            catch (Exception e) {
                trace.err("Error opening server socket on port " + port + " in LauncherServer.Listener constructor: " + e + (e.getCause() == null ? "" : ";\n  cause: " + e.getCause()));
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "LauncherServer.Listener waiting on port " + this.ss.getLocalPort());
            }
            try {
                while (!this.nowExiting) {
                    Socket s = this.ss.accept();
                    TSLauncherServer.Session sess = new TSLauncherServer.Session(LauncherServer.this, s);
                    sess.setServerPort(this.ss.getLocalPort());
                    if (trace.getDebugCode("ls")) {
                        trace.out("ls", "LauncherServer.Listener accepted socket " + s.toString());
                    }
                    sess.start();
                }
            }
            catch (SocketException se) {
                trace.err("Shutdown Time " + this.shutdownTime + ", nowExiting " + this.nowExiting + "; exception " + se + (se.getCause() == null ? "" : ";\n  cause: " + se.getCause()));
            }
            catch (IOException io) {
                trace.err("Fatal I/O error from LauncherServer top-level thread: exception " + io + (io.getCause() == null ? "" : ";\ncause: " + io.getCause()));
                io.printStackTrace();
            }
        }

        @Override
        public synchronized boolean isExiting() {
            return this.nowExiting;
        }

        @Override
        public boolean startExiting() {
            boolean result = this.nowExiting;
            this.nowExiting = true;
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "LauncherServer.Listener.startExiting() server socket to close " + this.ss);
            }
            try {
                this.ss.close();
                this.ss = null;
            }
            catch (Exception e) {
                trace.errStack("LauncherServer.Listener.startExiting() error closing server socket " + e + ";\n  cause " + e.getCause(), e);
            }
            return result;
        }
    }

    private class SessionKeeper
    extends Thread
    implements ExitableServer {
        private long maxIdleTime = SocketProxy.getMaxIdleTime();
        private Thread myThread = null;
        private volatile boolean nowExiting = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myThread = Thread.currentThread();
            while (!this.nowExiting) {
                try {
                    Thread.sleep(this.maxIdleTime + 60000L);
                }
                catch (InterruptedException e) {
                    if (trace.getDebugCode("ls")) {
                        trace.out("ls", "SessionKeeper.run() nowExiting " + this.nowExiting + "; Thread.sleep() threw " + e);
                    }
                    e.printStackTrace();
                    if (this.nowExiting) break;
                }
                Long currTime = new Date().getTime();
                String string = LauncherServer.this.sessionsMutex;
                synchronized (string) {
                    Iterator sessionIterator = LauncherServer.this.sessions.keySet().iterator();
                    while (sessionIterator.hasNext()) {
                        TSLauncherServer.Session s;
                        String key = (String)sessionIterator.next();
                        if (key == null || (s = (TSLauncherServer.Session)LauncherServer.this.sessions.get(key)) == null || currTime - s.getTimeStamp().getTime() <= this.maxIdleTime) continue;
                        sessionIterator.remove();
                        RemoteToolProxy.sendInterfaceForceDisconnectMsg(s.controller);
                    }
                }
            }
        }

        @Override
        public boolean isExiting() {
            return this.nowExiting;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean startExiting() {
            boolean result = this.nowExiting;
            this.nowExiting = true;
            if (this.myThread != null) {
                this.myThread.interrupt();
            }
            if (trace.getDebugCode("ls")) {
                trace.out("ls", "SessionKeeper.startExiting() previous nowExiting " + result + ", interrupted " + this.myThread + "; nSessions to disconnect " + LauncherServer.this.sessions.size());
            }
            String string = LauncherServer.this.sessionsMutex;
            synchronized (string) {
                Iterator sessionIterator = LauncherServer.this.sessions.entrySet().iterator();
                while (sessionIterator.hasNext()) {
                    TSLauncherServer.Session s = (TSLauncherServer.Session)sessionIterator.next().getValue();
                    sessionIterator.remove();
                    s.controller.disconnect(false);
                }
            }
            return result;
        }
    }
}

